/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.tenant.loginmodule;

import java.security.Principal;
import java.security.acl.Group;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.ow2.jonas.lib.tenant.context.TenantContext;
import org.ow2.jonas.lib.tenant.context.TenantCurrent;

public class TenantIdLoginModule
implements LoginModule {
    private Subject subject = null;
    private String principalName = null;
    private List principalRoles = null;
    private final String PREFIX = "TenantId";
    private final String SUPER_ADMIN_ROLE = "super-admin";

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.subject = subject;
        this.principalRoles = new ArrayList();
    }

    @Override
    public boolean login() throws LoginException {
        return true;
    }

    @Override
    public boolean commit() throws LoginException {
        String string;
        Set<Principal> principals = this.subject.getPrincipals(Principal.class);
        for (Principal principal : principals) {
            if (principal instanceof Group) continue;
            this.principalName = principal.getName();
        }
        if (this.principalName == null) {
            throw new LoginException("There was no previous login module. This login module can only be used in addition to another module which perform the authentication.");
        }
        principals = this.subject.getPrincipals(Group.class);
        for (Group group : principals) {
            Enumeration e = group.members();
            while (e.hasMoreElements()) {
                Principal p = (Principal)e.nextElement();
                this.principalRoles.add(p.getName());
            }
        }
        Object var3_6 = null;
        try {
            string = this.getTenantId(this.principalRoles);
        }
        catch (Exception e) {
            throw new LoginException("Error when getting tenantId");
        }
        TenantContext ctx = new TenantContext(null, string);
        TenantCurrent.getCurrent().setTenantContext(ctx);
        return true;
    }

    @Override
    public boolean abort() throws LoginException {
        return true;
    }

    @Override
    public boolean logout() throws LoginException {
        TenantContext ctx = new TenantContext();
        TenantCurrent.getCurrent().setTenantContext(ctx);
        return true;
    }

    private String getTenantId(List principalRoles) throws Exception {
        String tenantId = null;
        for (Object role : principalRoles) {
            String roleName = (String)role;
            if ("super-admin".equals(roleName)) {
                return "T0";
            }
            if (!roleName.startsWith("TenantId")) continue;
            tenantId = roleName.substring(roleName.indexOf(91) + 1, roleName.indexOf(93));
        }
        if (tenantId == null) {
            throw new Exception("TenantId role missing");
        }
        return tenantId;
    }
}

