/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.dbm.internal.cm;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.jonas.dbm.internal.cm.JManagedConnection;
import org.ow2.jonas.lib.util.Log;

public class JStatement
implements PreparedStatement {
    private boolean changed = false;
    private boolean opened;
    private boolean closing = false;
    private PreparedStatement ps;
    private JManagedConnection mc;
    private int hashCode;
    private String sql;
    private Logger logger = Log.getLogger((String)"org.ow2.jonas.dbm.ps");

    public JStatement(PreparedStatement ps, JManagedConnection mc, String sql) {
        this.logger.log(BasicLevel.DEBUG, (Object)"constructor");
        this.ps = ps;
        this.mc = mc;
        this.sql = sql;
        this.hashCode = sql.hashCode();
        this.opened = true;
    }

    public String getSql() {
        return this.sql;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object stmt) {
        if (stmt == null) {
            return false;
        }
        if (this.hashCode != stmt.hashCode()) {
            return false;
        }
        if (!(stmt instanceof JStatement)) {
            this.logger.log(BasicLevel.WARN, (Object)("Bad class:" + stmt));
            return false;
        }
        JStatement psw = (JStatement)stmt;
        if (this.sql == null && psw.getSql() != null) {
            return false;
        }
        if (this.sql != null && !this.sql.equals(psw.getSql())) {
            return false;
        }
        try {
            if (psw.getResultSetType() != this.getResultSetType()) {
                return false;
            }
            if (psw.getResultSetConcurrency() != this.getResultSetConcurrency()) {
                return false;
            }
        }
        catch (SQLException e) {
            this.logger.log(BasicLevel.WARN, (Object)("Cannot compare statements:" + e));
            return false;
        }
        this.logger.log(BasicLevel.DEBUG, (Object)"Found");
        return true;
    }

    public boolean forceClose() {
        if (this.opened) {
            this.logger.log(BasicLevel.WARN, (Object)"Statements should be closed explicitly.");
            this.opened = false;
            return true;
        }
        return false;
    }

    public void reuse() throws SQLException {
        this.logger.log(BasicLevel.DEBUG, (Object)"");
        this.ps.clearParameters();
        this.ps.clearWarnings();
        this.opened = true;
        if (this.changed) {
            this.logger.log(BasicLevel.DEBUG, (Object)"changed");
            this.ps.clearBatch();
            this.ps.setFetchDirection(1000);
            this.ps.setMaxFieldSize(0);
            this.ps.setMaxRows(0);
            this.ps.setQueryTimeout(0);
            this.changed = false;
        }
    }

    @Override
    public boolean isClosed() {
        return !this.opened && !this.closing;
    }

    public void forget() {
        this.logger.log(BasicLevel.DEBUG, (Object)"");
        try {
            this.ps.close();
        }
        catch (SQLException e) {
            this.mc.notifyStatementError(this, e);
            this.logger.log(BasicLevel.ERROR, (Object)("Cannot close the PreparedStatement:" + e));
        }
    }

    @Override
    public int executeUpdate() throws SQLException {
        this.logger.log(BasicLevel.DEBUG, (Object)"");
        return this.ps.executeUpdate();
    }

    @Override
    public void addBatch() throws SQLException {
        this.logger.log(BasicLevel.DEBUG, (Object)"");
        this.changed = true;
        this.ps.addBatch();
    }

    @Override
    public void clearParameters() throws SQLException {
        this.logger.log(BasicLevel.DEBUG, (Object)"");
        this.ps.clearParameters();
    }

    @Override
    public boolean execute() throws SQLException {
        this.logger.log(BasicLevel.DEBUG, (Object)"");
        return this.ps.execute();
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.ps.setByte(parameterIndex, x);
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.ps.setDouble(parameterIndex, x);
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.ps.setFloat(parameterIndex, x);
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        this.ps.setInt(parameterIndex, x);
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.logger.log(BasicLevel.DEBUG, (Object)"");
        this.ps.setNull(parameterIndex, sqlType);
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        this.ps.setLong(parameterIndex, x);
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        this.ps.setShort(parameterIndex, x);
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.ps.setBoolean(parameterIndex, x);
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.ps.setBytes(parameterIndex, x);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.logger.log(BasicLevel.DEBUG, (Object)"");
        this.ps.setAsciiStream(parameterIndex, x, length);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.logger.log(BasicLevel.DEBUG, (Object)"");
        this.ps.setBinaryStream(parameterIndex, x, length);
    }

    @Override
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.logger.log(BasicLevel.DEBUG, (Object)"");
        this.ps.setUnicodeStream(parameterIndex, x, length);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        this.logger.log(BasicLevel.DEBUG, (Object)"");
        this.ps.setCharacterStream(parameterIndex, reader, length);
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        this.logger.log(BasicLevel.DEBUG, (Object)"");
        this.ps.setObject(parameterIndex, x);
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        this.logger.log(BasicLevel.DEBUG, (Object)"");
        this.ps.setObject(parameterIndex, x, targetSqlType);
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scale) throws SQLException {
        this.logger.log(BasicLevel.DEBUG, (Object)"");
        this.ps.setObject(parameterIndex, x, targetSqlType, scale);
    }

    @Override
    public void setNull(int paramIndex, int sqlType, String typeName) throws SQLException {
        this.logger.log(BasicLevel.DEBUG, (Object)"");
        this.ps.setNull(paramIndex, sqlType, typeName);
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        this.ps.setString(parameterIndex, x);
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.logger.log(BasicLevel.DEBUG, (Object)"");
        this.ps.setBigDecimal(parameterIndex, x);
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        this.logger.log(BasicLevel.DEBUG, (Object)"");
        this.ps.setURL(parameterIndex, x);
    }

    @Override
    public void setArray(int i, Array x) throws SQLException {
        this.logger.log(BasicLevel.DEBUG, (Object)"");
        this.ps.setArray(i, x);
    }

    @Override
    public void setBlob(int i, Blob x) throws SQLException {
        this.logger.log(BasicLevel.DEBUG, (Object)"");
        this.ps.setBlob(i, x);
    }

    @Override
    public void setClob(int i, Clob x) throws SQLException {
        this.logger.log(BasicLevel.DEBUG, (Object)"");
        this.ps.setClob(i, x);
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.logger.log(BasicLevel.DEBUG, (Object)"");
        this.ps.setDate(parameterIndex, x);
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        this.logger.log(BasicLevel.DEBUG, (Object)"");
        return this.ps.getParameterMetaData();
    }

    @Override
    public void setRef(int i, Ref x) throws SQLException {
        this.logger.log(BasicLevel.DEBUG, (Object)"");
        this.ps.setRef(i, x);
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        this.logger.log(BasicLevel.DEBUG, (Object)"");
        return this.ps.executeQuery();
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        this.logger.log(BasicLevel.DEBUG, (Object)"");
        return this.ps.getMetaData();
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.logger.log(BasicLevel.DEBUG, (Object)"");
        this.ps.setTime(parameterIndex, x);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.logger.log(BasicLevel.DEBUG, (Object)"");
        this.ps.setTimestamp(parameterIndex, x);
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        this.logger.log(BasicLevel.DEBUG, (Object)"");
        this.ps.setDate(parameterIndex, x, cal);
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        this.logger.log(BasicLevel.DEBUG, (Object)"");
        this.ps.setTime(parameterIndex, x, cal);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        this.logger.log(BasicLevel.DEBUG, (Object)"");
        this.ps.setTimestamp(parameterIndex, x, cal);
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return this.ps.getFetchDirection();
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.ps.getFetchSize();
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        return this.ps.getMaxFieldSize();
    }

    @Override
    public int getMaxRows() throws SQLException {
        return this.ps.getMaxRows();
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return this.ps.getQueryTimeout();
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        return this.ps.getResultSetConcurrency();
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return this.ps.getResultSetHoldability();
    }

    @Override
    public int getResultSetType() throws SQLException {
        return this.ps.getResultSetType();
    }

    @Override
    public int getUpdateCount() throws SQLException {
        return this.ps.getUpdateCount();
    }

    @Override
    public void cancel() throws SQLException {
        this.logger.log(BasicLevel.DEBUG, (Object)"");
        this.ps.cancel();
    }

    @Override
    public void clearBatch() throws SQLException {
        this.logger.log(BasicLevel.DEBUG, (Object)"");
        this.ps.clearBatch();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.logger.log(BasicLevel.DEBUG, (Object)"");
        this.ps.clearWarnings();
    }

    @Override
    public void close() throws SQLException {
        if (!this.opened) {
            this.logger.log(BasicLevel.DEBUG, (Object)"Statement already closed");
            return;
        }
        this.logger.log(BasicLevel.DEBUG, (Object)"");
        this.opened = false;
        this.closing = true;
        this.mc.notifyPsClose(this);
        this.closing = false;
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        this.logger.log(BasicLevel.DEBUG, (Object)"");
        return this.ps.getMoreResults();
    }

    @Override
    public int[] executeBatch() throws SQLException {
        this.logger.log(BasicLevel.DEBUG, (Object)"");
        return this.ps.executeBatch();
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.logger.log(BasicLevel.DEBUG, (Object)"");
        this.changed = true;
        this.ps.setFetchDirection(direction);
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.logger.log(BasicLevel.DEBUG, (Object)"");
        this.changed = true;
        this.ps.setFetchSize(rows);
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        this.logger.log(BasicLevel.DEBUG, (Object)"");
        this.changed = true;
        this.ps.setMaxFieldSize(max);
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        this.logger.log(BasicLevel.DEBUG, (Object)"");
        this.changed = true;
        this.ps.setMaxRows(max);
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        this.logger.log(BasicLevel.DEBUG, (Object)"");
        this.changed = true;
        this.ps.setQueryTimeout(seconds);
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        return this.ps.getMoreResults(current);
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.logger.log(BasicLevel.DEBUG, (Object)"");
        this.ps.setEscapeProcessing(enable);
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        this.logger.log(BasicLevel.DEBUG, (Object)sql);
        return this.ps.executeUpdate(sql);
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        this.logger.log(BasicLevel.DEBUG, (Object)sql);
        this.changed = true;
        this.ps.addBatch(sql);
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        this.logger.log(BasicLevel.DEBUG, (Object)name);
        this.ps.setCursorName(name);
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        this.logger.log(BasicLevel.DEBUG, (Object)sql);
        this.changed = true;
        return this.ps.execute(sql);
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        this.logger.log(BasicLevel.DEBUG, (Object)sql);
        this.changed = true;
        return this.ps.executeUpdate(sql, autoGeneratedKeys);
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        this.logger.log(BasicLevel.DEBUG, (Object)sql);
        this.changed = true;
        return this.ps.execute(sql, autoGeneratedKeys);
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        this.logger.log(BasicLevel.DEBUG, (Object)sql);
        this.changed = true;
        return this.ps.executeUpdate(sql, columnIndexes);
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        this.logger.log(BasicLevel.DEBUG, (Object)sql);
        this.changed = true;
        return this.ps.execute(sql, columnIndexes);
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.ps.getConnection();
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        return this.ps.getGeneratedKeys();
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        return this.ps.getResultSet();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.ps.getWarnings();
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        this.logger.log(BasicLevel.DEBUG, (Object)sql);
        return this.ps.executeUpdate(sql, columnNames);
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        this.logger.log(BasicLevel.DEBUG, (Object)sql);
        return this.ps.execute(sql, columnNames);
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        this.logger.log(BasicLevel.DEBUG, (Object)sql);
        return this.ps.executeQuery(sql);
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        this.ps.setRowId(parameterIndex, x);
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        this.ps.setNString(parameterIndex, value);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        this.ps.setNCharacterStream(parameterIndex, value, length);
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        this.ps.setNClob(parameterIndex, value);
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this.ps.setClob(parameterIndex, reader, length);
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        this.ps.setBlob(parameterIndex, inputStream, length);
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this.ps.setNClob(parameterIndex, reader, length);
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        this.ps.setSQLXML(parameterIndex, xmlObject);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        this.ps.setAsciiStream(parameterIndex, x, length);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        this.ps.setBinaryStream(parameterIndex, x, length);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        this.ps.setCharacterStream(parameterIndex, reader, length);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        this.ps.setAsciiStream(parameterIndex, x);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        this.ps.setBinaryStream(parameterIndex, x);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        this.ps.setCharacterStream(parameterIndex, reader);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        this.ps.setNCharacterStream(parameterIndex, value);
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        this.ps.setClob(parameterIndex, reader);
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        this.ps.setBlob(parameterIndex, inputStream);
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        this.ps.setNClob(parameterIndex, reader);
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        this.ps.setPoolable(poolable);
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return this.ps.isPoolable();
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.ps.isWrapperFor(iface);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this.ps.unwrap(iface);
    }
}

