/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.management.extensions.container;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.ow2.jonas.lib.management.extensions.base.BaseManagement;
import org.ow2.jonas.lib.management.extensions.base.JonasManagementRepr;
import org.ow2.jonas.lib.management.extensions.container.ejb.EjbItem;
import org.ow2.jonas.lib.management.extensions.container.ejb.EjbItemByNameComparator;
import org.ow2.jonas.lib.management.javaee.J2eeObjectName;
import org.ow2.jonas.management.extensions.container.api.IContainerManagement;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class ContainerManagement
implements IContainerManagement {
    protected static Log logger = LogFactory.getLog(ContainerManagement.class);
    private static ContainerManagement unique = null;

    public static IContainerManagement getInstance() {
        if (unique == null) {
            unique = new ContainerManagement();
        }
        return unique;
    }

    public ObjectName getEJBModuleObjectName(String ejbObjectName) throws MalformedObjectNameException {
        ObjectName o_ejbObjectName = new ObjectName(ejbObjectName);
        String domainName = o_ejbObjectName.getDomain();
        String moduleName = o_ejbObjectName.getKeyProperty("EJBModule");
        String serverName = o_ejbObjectName.getKeyProperty("J2EEServer");
        String appName = o_ejbObjectName.getKeyProperty("J2EEApplication");
        return J2eeObjectName.getEJBModule((String)domainName, (String)serverName, (String)appName, (String)moduleName);
    }

    public List<?> getEntityBeans(ObjectName pObjectName, String serverName) {
        ONameAttrib onAttr = new ONameAttrib(pObjectName);
        ObjectName on = J2eeObjectName.getEntityBeans((String)onAttr.getDomainName(), (String)onAttr.getModuleName(), (String)onAttr.getServerName(), (String)onAttr.getAppName());
        return this.beanItems(on, onAttr.getServerName());
    }

    public List<?> getStatelessSessionBeans(ObjectName pObjectName, String serverName) {
        ONameAttrib onAttr = new ONameAttrib(pObjectName);
        ObjectName on = J2eeObjectName.getStatelessSessionBeans((String)onAttr.getDomainName(), (String)onAttr.getModuleName(), (String)onAttr.getServerName(), (String)onAttr.getAppName());
        return this.beanItems(on, onAttr.getServerName());
    }

    public List<?> getStatefulSessionBeans(ObjectName pObjectName, String serverName) {
        ONameAttrib onAttr = new ONameAttrib(pObjectName);
        ObjectName on = J2eeObjectName.getStatefulSessionBeans((String)onAttr.getDomainName(), (String)onAttr.getModuleName(), (String)onAttr.getServerName(), (String)onAttr.getAppName());
        return this.beanItems(on, onAttr.getServerName());
    }

    public List<?> getMessageDrivenBeans(ObjectName pObjectName, String serverName) {
        ONameAttrib onAttr = new ONameAttrib(pObjectName);
        ObjectName on = J2eeObjectName.getMessageDrivenBeans((String)onAttr.getDomainName(), (String)onAttr.getModuleName(), (String)onAttr.getServerName(), (String)onAttr.getAppName());
        return this.beanItems(on, onAttr.getServerName());
    }

    private List<?> beanItems(ObjectName on, String serverName) {
        ArrayList<EjbItem> al = new ArrayList<EjbItem>();
        Iterator itNames = BaseManagement.getInstance().getListMbean(on, serverName).iterator();
        while (itNames.hasNext()) {
            try {
                al.add(new EjbItem(new ObjectName((String)itNames.next()), serverName));
            }
            catch (Exception e) {
                logger.debug((Object)"Exception in beanItems", new Object[]{e});
            }
        }
        Collections.sort(al, new EjbItemByNameComparator());
        return al;
    }

    public Map getTotalEJB(ObjectName moduleOn) {
        HashMap<String, Integer> table = new HashMap<String, Integer>();
        int nbStatefulSessionBean = 0;
        int nbStatelessSessionBean = 0;
        int nbEntityBean = 0;
        int nbMessageDrivenBean = 0;
        String serverName = moduleOn.getKeyProperty("J2EEServer");
        String[] ejbs = (String[])JonasManagementRepr.getAttribute(moduleOn, "ejbs", serverName);
        for (int i = 0; i < ejbs.length; ++i) {
            String ejbON = ejbs[i];
            try {
                ObjectName ejbOn = ObjectName.getInstance(ejbON);
                String ejbType = ejbOn.getKeyProperty("j2eeType");
                if ("StatefulSessionBean".equals(ejbType)) {
                    ++nbStatefulSessionBean;
                    continue;
                }
                if ("StatelessSessionBean".equals(ejbType)) {
                    ++nbStatelessSessionBean;
                    continue;
                }
                if ("EntityBean".equals(ejbType)) {
                    ++nbEntityBean;
                    continue;
                }
                if (!"MessageDrivenBean".equals(ejbType)) continue;
                ++nbMessageDrivenBean;
                continue;
            }
            catch (MalformedObjectNameException e) {
                e.printStackTrace();
                continue;
            }
            catch (NullPointerException e) {
                e.printStackTrace();
            }
        }
        table.put("StatefulSessionBean", nbStatefulSessionBean);
        table.put("StatelessSessionBean", nbStatelessSessionBean);
        table.put("EntityBean", nbEntityBean);
        table.put("MessageDrivenBean", nbMessageDrivenBean);
        return table;
    }

    private class ONameAttrib {
        private String domainName;
        private String serverName;
        private String appName;
        private String moduleName;

        public ONameAttrib() {
        }

        public ONameAttrib(ObjectName pObjectName) {
            this.domainName = pObjectName.getDomain();
            this.serverName = pObjectName.getKeyProperty("J2EEServer");
            this.moduleName = pObjectName.getKeyProperty("name");
            this.appName = pObjectName.getKeyProperty("J2EEApplication");
        }

        public String getDomainName() {
            return this.domainName;
        }

        public String getServerName() {
            return this.serverName;
        }

        public String getAppName() {
            return this.appName;
        }

        public String getModuleName() {
            return this.moduleName;
        }
    }
}

