/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.audit.internal.logger;

import java.io.File;
import java.io.IOException;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.jonas.audit.internal.logger.AuditComponentListener;
import org.ow2.jonas.audit.internal.logger.AuditLogJMXWaiter;
import org.ow2.jonas.audit.internal.logger.AuditLogServiceException;
import org.ow2.jonas.audit.internal.logger.NodeReport;
import org.ow2.jonas.audit.internal.logger.PatternEntry;
import org.ow2.jonas.audit.internal.logger.api.IAuditLogListener;
import org.ow2.jonas.audit.internal.logger.pool.DatedFileLogPool;
import org.ow2.jonas.audit.internal.logger.util.AuditLogReportHelper;
import org.ow2.jonas.jmx.JmxService;
import org.ow2.jonas.lib.bootstrap.JProp;
import org.ow2.util.auditreport.impl.GenericAuditReport;

public class AuditLogService
implements IAuditLogListener {
    private boolean useEjbAuditComponent = true;
    private boolean useWebAuditComponent = true;
    private boolean useJNDIAuditComponent = true;
    private boolean useJaxwsAuditComponent = true;
    private boolean consoleLogger = false;
    private boolean fileLogger = true;
    private String logDirectoryPath = DEFAULT_LOG_PATH;
    private String logFilenamePattern = "jonas-.log";
    private int insertDateIndex = 6;
    private int maxLogFiles = -1;
    private ObjectName jmxEjbComponentPatternName = null;
    private ObjectName jmxWebComponentPatternName = null;
    private ObjectName jmxJNDIComponentPatternName = null;
    private ObjectName jmxJaxwsEndpointComponentPatternName = null;
    private AuditComponentListener auditEjbListener = null;
    private AuditComponentListener auditWebListener = null;
    private AuditComponentListener auditJNDIListener = null;
    private AuditComponentListener auditJaxwsEndpointListener = null;
    private DatedFileLogPool logPool = null;
    private static final String DEFAULT_LOG_PATH = JProp.getJonasBase() + File.separator + "logs" + File.separator + "audit-logs";
    private static final String DEFAULT_LOG_FILENAME_PATTERN = "jonas-.log";
    private static final int DEFAULT_INSERT_DATE_INDEX = 6;
    private JmxService jmxService = null;
    private ObjectName objectName = null;
    private AuditLogJMXWaiter waiter = null;
    private LinkedList<NodeReport> nodeReports = new LinkedList();
    private static final long DEFAULT_MAX_NODE_MEMORY = 1000L;
    private long maxNodesInMemory = 1000L;

    public void start() throws AuditLogServiceException {
        if (this.maxLogFiles < 0) {
            this.maxLogFiles = -1;
        }
        if (this.insertDateIndex < 0 || this.insertDateIndex >= this.logFilenamePattern.length()) {
            this.insertDateIndex = 0;
        }
        try {
            this.logPool = new DatedFileLogPool(this.logDirectoryPath, AuditLogService.class.getName(), this.logFilenamePattern, this.insertDateIndex, "%m%n", this.maxLogFiles, this.fileLogger, this.consoleLogger);
        }
        catch (IOException e) {
            throw new AuditLogServiceException("Cannot create log file", e);
        }
        try {
            this.jmxEjbComponentPatternName = new ObjectName(this.jmxService.getDomainName() + ":type=Auditors,auditorType=ejb" + ",*");
        }
        catch (Exception e) {
            throw new AuditLogServiceException("Cannot build ObjectName", e);
        }
        try {
            this.jmxWebComponentPatternName = new ObjectName(this.jmxService.getDomainName() + ":type=Auditors,auditorType=web" + ",*");
        }
        catch (Exception e) {
            throw new AuditLogServiceException("Cannot build ObjectName", e);
        }
        try {
            this.jmxJNDIComponentPatternName = new ObjectName(this.jmxService.getDomainName() + ":type=Auditors,auditorType=jndi" + ",*");
        }
        catch (Exception e) {
            throw new AuditLogServiceException("Cannot build ObjectName", e);
        }
        try {
            this.jmxJaxwsEndpointComponentPatternName = new ObjectName(this.jmxService.getDomainName() + ":type=Auditors" + ",auditorType=wsendpoint,*");
        }
        catch (Exception e) {
            throw new AuditLogServiceException("Cannot build ObjectName", e);
        }
        this.auditEjbListener = new AuditComponentListener(this.jmxService.getJmxServer());
        this.auditEjbListener.addLogListener(this);
        this.auditWebListener = new AuditComponentListener(this.jmxService.getJmxServer());
        this.auditWebListener.addLogListener(this);
        this.auditJNDIListener = new AuditComponentListener(this.jmxService.getJmxServer());
        this.auditJNDIListener.addLogListener(this);
        this.auditJaxwsEndpointListener = new AuditComponentListener(this.jmxService.getJmxServer());
        this.auditJaxwsEndpointListener.addLogListener(this);
        try {
            this.objectName = new ObjectName(this.jmxService.getDomainName() + ":type=Auditors,auditorType=logger" + ",name=JOnAS");
        }
        catch (MalformedObjectNameException e) {
            throw new AuditLogServiceException("Cannot build the objectname", e);
        }
        catch (NullPointerException e) {
            throw new AuditLogServiceException("Cannot build the objectname", e);
        }
        this.jmxService.loadDescriptors(AuditLogService.class.getPackage().getName(), AuditLogService.class.getClassLoader());
        try {
            this.jmxService.registerModelMBean((Object)this, this.objectName);
        }
        catch (Exception e) {
            throw new AuditLogServiceException("Cannot register MBean", e);
        }
        this.waiter = new AuditLogJMXWaiter(this.jmxService.getJmxServer());
        this.waiter.addPatternEntry(new PatternEntry(this.auditEjbListener, this.jmxEjbComponentPatternName));
        this.waiter.addPatternEntry(new PatternEntry(this.auditWebListener, this.jmxWebComponentPatternName));
        this.waiter.addPatternEntry(new PatternEntry(this.auditJNDIListener, this.jmxJNDIComponentPatternName));
        this.waiter.addPatternEntry(new PatternEntry(this.auditJaxwsEndpointListener, this.jmxJaxwsEndpointComponentPatternName));
        new Thread(this.waiter).start();
    }

    private void manageEJBLogger(boolean enable) throws AuditLogServiceException {
        if (this.useEjbAuditComponent && !enable) {
            this.auditEjbListener.unregister();
        }
    }

    private void manageJNDILogger(boolean enable) throws AuditLogServiceException {
        if (this.useJNDIAuditComponent && !enable) {
            this.auditJNDIListener.unregister();
        }
    }

    private void manageWebLogger(boolean enable) throws AuditLogServiceException {
        if (this.useWebAuditComponent && !enable) {
            this.auditWebListener.unregister();
        }
    }

    private void manageJaxwsLogger(boolean enable) throws AuditLogServiceException {
        if (this.useJaxwsAuditComponent && !enable) {
            this.auditJaxwsEndpointListener.unregister();
        }
    }

    public void stop() throws AuditLogServiceException {
        this.waiter.end();
        this.jmxService.unregisterModelMBean(this.objectName);
        this.manageEJBLogger(false);
        this.manageWebLogger(false);
        this.manageJNDILogger(false);
        this.manageJaxwsLogger(false);
    }

    public void enableEJBLogger() throws AuditLogServiceException {
        this.useEjbAuditComponent = true;
        this.manageEJBLogger(true);
    }

    public void disableEJBLogger() throws AuditLogServiceException {
        this.manageEJBLogger(false);
        this.useEjbAuditComponent = false;
    }

    public void enableWebLogger() throws AuditLogServiceException {
        this.useWebAuditComponent = true;
        this.manageWebLogger(true);
    }

    public void disableWebLogger() throws AuditLogServiceException {
        this.manageWebLogger(false);
        this.useWebAuditComponent = false;
    }

    @Override
    public synchronized void onAuditReceived(String typeAudit, String encodedAuditReport) {
        Logger logger;
        if (typeAudit != null && typeAudit.startsWith("jmx.attribute")) {
            return;
        }
        GenericAuditReport report = AuditLogReportHelper.decodeAuditReport(typeAudit, encodedAuditReport);
        String formatedMessage = AuditLogReportHelper.getLogdecodeAuditReport(typeAudit, encodedAuditReport);
        String keyID = report.getKeyID();
        if (keyID != null) {
            if ((long)this.nodeReports.size() > this.maxNodesInMemory) {
                this.nodeReports.removeFirst();
            }
            String[] keyIDParts = keyID.split(":");
            String parentID = keyIDParts[0];
            String localID = keyIDParts[1];
            String parentIDHash = null;
            Integer parentIDCount = null;
            if (parentID != null && parentID.length() > 0) {
                String[] parentIDParts = parentID.split("/");
                parentIDHash = parentIDParts[0];
                parentIDCount = Integer.valueOf(parentIDParts[1]);
            }
            String[] localIDParts = localID.split("/");
            String localIDHash = localIDParts[0];
            Integer localIDCount = Integer.valueOf(localIDParts[1]);
            NodeReport reportNode = null;
            if (parentIDHash != null) {
                TreeMap<Integer, NodeReport> treeMap;
                NodeReport parentNode = this.search(parentIDHash, true);
                if (parentNode == null) {
                    parentNode = new NodeReport(parentIDHash, false);
                    parentNode.setMissingParent(true);
                    this.nodeReports.add(parentNode);
                }
                if ((reportNode = (treeMap = parentNode.getTreeMap()).get(parentIDCount)) == null) {
                    reportNode = new NodeReport(localIDHash, false);
                    treeMap.put(parentIDCount, reportNode);
                    NodeReport existingRootLevelNode = this.search(localIDHash, false);
                    if (existingRootLevelNode != null && existingRootLevelNode.isMissingParent()) {
                        TreeMap<Integer, NodeReport> map = existingRootLevelNode.getTreeMap();
                        for (Map.Entry<Integer, NodeReport> entry : map.entrySet()) {
                            reportNode.getTreeMap().put(entry.getKey(), entry.getValue());
                        }
                        this.nodeReports.remove(existingRootLevelNode);
                    }
                }
            } else {
                reportNode = this.searchOrBuild(localIDHash);
            }
            if (localIDCount == 0) {
                if (reportNode.isMissingParent()) {
                    reportNode.setMissingParent(false);
                }
                reportNode.setReport(report);
                reportNode.setDetails(formatedMessage);
            } else {
                NodeReport nodeChild = new NodeReport(report.getKeyID(), true);
                reportNode.getTreeMap().put(localIDCount, nodeChild);
            }
        }
        if ((logger = this.logPool.getLogger()) != null) {
            logger.log(BasicLevel.INFO, (Object)formatedMessage);
        }
    }

    private NodeReport searchOrBuild(String name) {
        NodeReport foundNode = this.search(name, true);
        if (foundNode == null) {
            foundNode = new NodeReport(name, false);
            this.nodeReports.add(foundNode);
        }
        return foundNode;
    }

    protected NodeReport search(String id, boolean inDepth) {
        Iterator itNode = this.nodeReports.iterator();
        NodeReport foundNode = null;
        while (itNode.hasNext() && foundNode == null) {
            if (inDepth) {
                foundNode = this.searchNode(id, (NodeReport)itNode.next());
                continue;
            }
            NodeReport tmpNode = (NodeReport)itNode.next();
            if (!id.equals(tmpNode.getID())) continue;
            foundNode = tmpNode;
        }
        return foundNode;
    }

    protected NodeReport searchNode(String id, NodeReport rootNode) {
        if (rootNode == null) {
            return null;
        }
        if (id.equals(rootNode.getID())) {
            return rootNode;
        }
        TreeMap<Integer, NodeReport> map = rootNode.getTreeMap();
        NodeReport matchingNode = null;
        Set<Map.Entry<Integer, NodeReport>> entries = map.entrySet();
        Iterator<Map.Entry<Integer, NodeReport>> iterator = entries.iterator();
        while (matchingNode == null && iterator.hasNext()) {
            Map.Entry<Integer, NodeReport> entry = iterator.next();
            matchingNode = this.searchNode(id, entry.getValue());
        }
        return matchingNode;
    }

    public int countLogFiles() {
        return this.logPool.countLogFiles();
    }

    public String[] getAuditReports(int year, int month, int day) {
        AuditLogReportHelper.EncodeResult result;
        File file = this.logPool.findFile(year, month, day);
        if (file != null && (result = AuditLogReportHelper.encodeLogMessages(file, 0)) != null) {
            return result.getEncodedAuditReports();
        }
        return null;
    }

    public String[] getLastAuditReports(int number) {
        File[] files;
        if (number > 0 && (files = this.logPool.listLogFiles()) != null) {
            LinkedList<String[]> listEncodedReports = new LinkedList<String[]>();
            int totalReports = 0;
            for (int i = files.length - 1; i >= 0 && totalReports < number; --i) {
                AuditLogReportHelper.EncodeResult encodeResult = AuditLogReportHelper.encodeLogMessages(files[i], number - totalReports);
                if (encodeResult == null) continue;
                String[] encodedReports = encodeResult.getEncodedAuditReports();
                totalReports += encodedReports.length;
                listEncodedReports.addFirst(encodedReports);
            }
            return this.collectAuditReports(listEncodedReports, totalReports);
        }
        return null;
    }

    private String[] collectAuditReports(LinkedList<String[]> listEncodedReports, int totalReports) {
        String[] encodedReports = new String[totalReports];
        int i = 0;
        Iterator i$ = listEncodedReports.iterator();
        while (i$.hasNext()) {
            String[] auditReports;
            for (String auditReport : auditReports = (String[])i$.next()) {
                encodedReports[i++] = auditReport;
            }
        }
        return encodedReports;
    }

    private String[] getAuditReports(int year, int month, int day, boolean old) {
        File[] files = this.logPool.listLogFiles(year, month, day, old, false);
        if (files != null) {
            LinkedList<String[]> listEncodedReports = new LinkedList<String[]>();
            int totalReports = 0;
            for (File file : files) {
                AuditLogReportHelper.EncodeResult encodeResult = AuditLogReportHelper.encodeLogMessages(file, 0);
                if (encodeResult == null) continue;
                String[] encodedReports = encodeResult.getEncodedAuditReports();
                totalReports += encodedReports.length;
                listEncodedReports.add(encodedReports);
            }
            return this.collectAuditReports(listEncodedReports, totalReports);
        }
        return null;
    }

    public String[] getOldAuditReports(int year, int month, int day) {
        return this.getAuditReports(year, month, day, true);
    }

    public String[] getRecentAuditReports(int year, int month, int day) {
        return this.getAuditReports(year, month, day, false);
    }

    private String[] getAuditReports(long timestamp, boolean old) {
        String[] encodedReports;
        AuditLogReportHelper.EncodeResult encodeResult;
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTimeInMillis(timestamp);
        int year = cal.get(1);
        int month = cal.get(2) + 1;
        int day = cal.get(5);
        File tsFile = this.logPool.findFile(year, month, day);
        if (tsFile == null) {
            return this.getAuditReports(year, month, day, old);
        }
        LinkedList<String[]> listEncodedReports = new LinkedList<String[]>();
        int totalReports = 0;
        File[] files = this.logPool.listLogFiles(year, month, day, old, false);
        if (files != null) {
            for (File file : files) {
                encodeResult = AuditLogReportHelper.encodeLogMessages(file, 0);
                if (encodeResult == null) continue;
                encodedReports = encodeResult.getEncodedAuditReports();
                totalReports += encodedReports.length;
                listEncodedReports.add(encodedReports);
            }
        }
        if ((encodeResult = AuditLogReportHelper.encodeLogMessages(tsFile, 0)) != null) {
            int i;
            encodedReports = encodeResult.getEncodedAuditReports();
            long[] timestamps = encodeResult.getAuditReportsTimestamp();
            int index = -1;
            int length = timestamps.length;
            for (i = 0; i < length; ++i) {
                if (timestamp >= timestamps[i]) continue;
                index = i;
                break;
            }
            if (index != -1) {
                if (old) {
                    if (index > 0) {
                        String[] tsEncodedReports = new String[index];
                        totalReports += index;
                        for (i = 0; i < index; ++i) {
                            tsEncodedReports[i] = encodedReports[i];
                        }
                        listEncodedReports.add(tsEncodedReports);
                    }
                } else if ((length -= index) > 0) {
                    String[] tsEncodedReports = new String[length];
                    totalReports += length;
                    for (i = 0; i < length; ++i) {
                        tsEncodedReports[i] = encodedReports[i + index];
                    }
                    listEncodedReports.addFirst(tsEncodedReports);
                }
            }
        }
        return this.collectAuditReports(listEncodedReports, totalReports);
    }

    public String[] getRecentAuditReports(long timestamp) {
        return this.getAuditReports(timestamp, false);
    }

    public String[] getOldAuditReports(long timestamp) {
        return this.getAuditReports(timestamp, true);
    }

    public void cleanLogPool() {
        this.logPool.cleanLogPool();
    }

    public void cleanLogFile(int year, int month, int day) {
        this.logPool.removeLogFile(year, month, day);
    }

    public void cleanOldLogFiles(int nbFiles) {
        this.logPool.cleanLogPool(nbFiles, true);
    }

    public void cleanRecentLogFiles(int nbFiles) {
        this.logPool.cleanLogPool(nbFiles, false);
    }

    public void cleanOldLogFiles(int year, int month, int day) {
        this.logPool.cleanLogPool(year, month, day, true);
    }

    public void cleanRecentLogFiles(int year, int month, int day) {
        this.logPool.cleanLogPool(year, month, day, false);
    }

    public void setConsoleLogger(boolean consoleLogger) {
        this.consoleLogger = consoleLogger;
    }

    public void setFileLogger(boolean fileLogger) {
        this.fileLogger = fileLogger;
    }

    public void setInsertDateIndex(int insertDateIndex) {
        this.insertDateIndex = insertDateIndex;
    }

    public void setLogDirectoryPath(String logDirectoryPath) {
        this.logDirectoryPath = logDirectoryPath;
    }

    public void setLogFilenamePattern(String logFilenamePattern) {
        this.logFilenamePattern = logFilenamePattern;
    }

    public void setMaxLogFiles(int maxLogFiles) {
        this.maxLogFiles = maxLogFiles;
    }

    public void setUseEjbAuditComponent(boolean useEjbAuditComponent) {
        this.useEjbAuditComponent = useEjbAuditComponent;
    }

    public void setUseWebAuditComponent(boolean useWebAuditComponent) {
        this.useWebAuditComponent = useWebAuditComponent;
    }

    public void setUseJndiAuditComponent(boolean useJNDIAuditComponent) {
        this.useJNDIAuditComponent = useJNDIAuditComponent;
    }

    public void setUseJaxwsAuditComponent(boolean useJaxwsAuditComponent) {
        this.useJaxwsAuditComponent = useJaxwsAuditComponent;
    }

    public void setJmxService(JmxService jmxService) {
        this.jmxService = jmxService;
    }

    public LinkedList<NodeReport> getNodeReports() {
        return this.nodeReports;
    }
}

