/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.audit.internal.logger.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ow2.util.auditreport.impl.GenericAuditReport;
import org.ow2.util.auditreport.impl.InvocationAuditReport;
import org.ow2.util.auditreport.impl.JNDIAuditReport;
import org.ow2.util.auditreport.impl.JaxwsAuditReport;
import org.ow2.util.auditreport.impl.WebInvocationAuditReport;
import org.ow2.util.auditreport.impl.util.ObjectEncoder;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public final class AuditLogReportHelper {
    private static Log logger = LogFactory.getLog(AuditLogReportHelper.class);
    private static final int BUFFER_SIZE = 4096;
    public static final String INDENT1 = "    ";
    public static final String INDENT2 = "        ";
    private static final String BEFORE_DATE = "[";
    private static final String AFTER_DATE = "] ";
    private static final String BEFORE_TYPE = " : ";
    private static final String NEW_LINE = "\r\n";
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yy/MM/dd HH:mm:ss");
    private static final String DATE_PATTERN = "[0-9]{2}/[0-1][0-9]/[0-3][0-9] [0-2][0-9]:[0-5][0-9]:[0-5][0-9]";
    private static final String HEADER_PATTERN = "\\[([0-9]{2}/[0-1][0-9]/[0-3][0-9] [0-2][0-9]:[0-5][0-9]:[0-5][0-9])\\] ([a-zA-Z0-9.]+) : (.*)\r\n";
    private static final Pattern MSG_PATTERN = Pattern.compile("\\[([0-9]{2}/[0-1][0-9]/[0-3][0-9] [0-2][0-9]:[0-5][0-9]:[0-5][0-9])\\] ([a-zA-Z0-9.]+) : (.*)\r\n((.+\r\n)*)(\r\n)+");
    private static final Pattern FIELDS_PATTERN = Pattern.compile("[ ]*(([\\w]+) = )?(.*)\r\n(\r\n$)?");
    private static final Calendar CALENDAR = new GregorianCalendar();

    private AuditLogReportHelper() {
    }

    public static synchronized GenericAuditReport decodeAuditReport(String typeMessage, String encodedAuditReport) {
        LinkedList paramNames = new LinkedList();
        LinkedList paramValues = new LinkedList();
        String className = ObjectEncoder.getClassName((String)encodedAuditReport);
        InvocationAuditReport report = null;
        if (InvocationAuditReport.class.getName().equals(typeMessage)) {
            InvocationAuditReport reportTmp;
            report = reportTmp = (InvocationAuditReport)ObjectEncoder.decodeToDisplayable((String)encodedAuditReport, InvocationAuditReport.class, paramNames, paramValues);
        } else if (WebInvocationAuditReport.class.getName().equals(typeMessage)) {
            WebInvocationAuditReport reportTmp = (WebInvocationAuditReport)ObjectEncoder.decodeToDisplayable((String)encodedAuditReport, WebInvocationAuditReport.class, paramNames, paramValues);
            report = reportTmp;
        } else if ("JNDI".equals(typeMessage)) {
            JNDIAuditReport reportTmp = (JNDIAuditReport)ObjectEncoder.decodeToDisplayable((String)encodedAuditReport, JNDIAuditReport.class, paramNames, paramValues);
            report = reportTmp;
        } else {
            report = JaxwsAuditReport.class.getName().equals(typeMessage) ? (GenericAuditReport)ObjectEncoder.decodeToDisplayable((String)encodedAuditReport, JaxwsAuditReport.class, paramNames, paramValues) : (GenericAuditReport)ObjectEncoder.decodeToDisplayable((String)encodedAuditReport, GenericAuditReport.class, paramNames, paramValues);
        }
        return report;
    }

    public static synchronized String getLogdecodeAuditReport(String typeMessage, String encodedAuditReport) {
        InvocationAuditReport reportTmp;
        LinkedList paramNames = new LinkedList();
        LinkedList paramValues = new LinkedList();
        String className = ObjectEncoder.getClassName((String)encodedAuditReport);
        Object report = null;
        report = InvocationAuditReport.class.getName().equals(typeMessage) ? (reportTmp = (InvocationAuditReport)ObjectEncoder.decodeToDisplayable((String)encodedAuditReport, InvocationAuditReport.class, paramNames, paramValues)) : ("JNDI".equals(typeMessage) ? (reportTmp = (JNDIAuditReport)ObjectEncoder.decodeToDisplayable((String)encodedAuditReport, JNDIAuditReport.class, paramNames, paramValues)) : (JaxwsAuditReport.class.getName().equals(typeMessage) ? (GenericAuditReport)ObjectEncoder.decodeToDisplayable((String)encodedAuditReport, JaxwsAuditReport.class, paramNames, paramValues) : (GenericAuditReport)ObjectEncoder.decodeToDisplayable((String)encodedAuditReport, GenericAuditReport.class, paramNames, paramValues)));
        CALENDAR.setTimeInMillis(report.getRequestTimeStamp());
        String date = DATE_FORMAT.format(CALENDAR.getTime());
        StringBuilder builder = new StringBuilder(BEFORE_DATE);
        builder.append(date);
        builder.append(AFTER_DATE);
        builder.append(className);
        builder.append(BEFORE_TYPE);
        builder.append(typeMessage);
        builder.append(NEW_LINE);
        Iterator itName = paramNames.iterator();
        Iterator itValue = paramValues.iterator();
        if (paramNames.size() == paramValues.size()) {
            while (itName.hasNext()) {
                String name = (String)itName.next();
                Object value = itValue.next();
                builder.append(INDENT1);
                builder.append(name);
                builder.append(" = ");
                if (value instanceof List) {
                    builder.append(NEW_LINE);
                    for (String str : (List)value) {
                        builder.append(INDENT2);
                        builder.append(str);
                        builder.append(NEW_LINE);
                    }
                    continue;
                }
                builder.append(value);
                builder.append(NEW_LINE);
            }
        }
        builder.append('\r');
        return builder.toString();
    }

    private static LinkedList<AuditReport> getAuditReports(String logMessages) {
        LinkedList<AuditReport> auditReports = new LinkedList<AuditReport>();
        Matcher m = MSG_PATTERN.matcher(logMessages);
        while (m.find()) {
            AuditReport auditReport = new AuditReport(m.group(1), m.group(2), m.group(3), m.group(4));
            auditReports.add(auditReport);
        }
        return auditReports;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static LinkedList<AuditReport> getAuditReports(File logFile) {
        StringBuilder builder = new StringBuilder();
        try {
            char[] buffer = new char[4096];
            BufferedReader reader = new BufferedReader(new FileReader(logFile));
            try {
                int length = reader.read(buffer);
                while (length > 0) {
                    builder.append(buffer, 0, length);
                    length = reader.read(buffer);
                }
            }
            finally {
                reader.close();
            }
        }
        catch (Exception ex) {
            return null;
        }
        return AuditLogReportHelper.getAuditReports(builder.toString());
    }

    private static void extractDisplayable(AuditReport report, List<String> fieldNames, List fieldValues) {
        Matcher m = FIELDS_PATTERN.matcher(report.message);
        LinkedList<String> values = null;
        if (m.find()) {
            String lastFieldName = m.group(2);
            String lastFieldValue = m.group(3);
            while (m.find()) {
                String fieldName = m.group(2);
                String fieldValue = m.group(3);
                if (fieldName != null) {
                    fieldNames.add(lastFieldName);
                    if (values == null) {
                        fieldValues.add(lastFieldValue);
                    } else {
                        fieldValues.add(values);
                        values = null;
                    }
                    lastFieldName = fieldName;
                    lastFieldValue = fieldValue;
                    continue;
                }
                if (values == null) {
                    values = new LinkedList<String>();
                    if (lastFieldValue.length() != 0) {
                        values.add(lastFieldValue);
                    }
                }
                if (fieldValue.length() == 0) continue;
                values.add(fieldValue);
            }
            fieldNames.add(lastFieldName);
            if (values == null) {
                fieldValues.add(lastFieldValue);
            } else {
                fieldValues.add(values);
            }
        }
    }

    public static EncodeResult encodeLogMessages(File logFile, int maxLogMessages) {
        LinkedList<AuditReport> auditReports = AuditLogReportHelper.getAuditReports(logFile);
        if (auditReports != null) {
            int nbAudits;
            int size = nbAudits = auditReports.size();
            ListIterator<AuditReport> it = auditReports.listIterator(nbAudits);
            if (maxLogMessages > 0 && maxLogMessages < nbAudits) {
                size = maxLogMessages;
            }
            String[] result = new String[size];
            long[] timestamps = new long[size];
            for (int i = size - 1; i >= 0; --i) {
                try {
                    LinkedList<String> fieldNames = new LinkedList<String>();
                    LinkedList fieldValues = new LinkedList();
                    AuditReport report = it.previous();
                    AuditLogReportHelper.extractDisplayable(report, fieldNames, fieldValues);
                    Class<?> classReport = Class.forName(report.className);
                    result[i] = ObjectEncoder.encodeFromDisplayable(classReport, fieldNames, fieldValues);
                    timestamps[i] = report.getTimestamp();
                    continue;
                }
                catch (ClassNotFoundException ex) {
                    result[i] = null;
                    timestamps[i] = 0L;
                    ex.printStackTrace();
                }
            }
            return new CodingResult(result, timestamps);
        }
        return null;
    }

    static class CodingResult
    implements EncodeResult {
        private String[] auditReports;
        private long[] timestamps;

        public CodingResult(String[] auditReports, long[] timestamps) {
            this.auditReports = auditReports;
            this.timestamps = timestamps;
        }

        @Override
        public String[] getEncodedAuditReports() {
            return this.auditReports;
        }

        @Override
        public long[] getAuditReportsTimestamp() {
            return this.timestamps;
        }
    }

    static class AuditReport {
        private String date;
        private String className;
        private String type;
        private String message;

        public AuditReport(String date, String className, String type, String message) {
            this.date = date;
            this.className = className;
            this.type = type;
            this.message = message;
        }

        public long getTimestamp() {
            long result;
            try {
                Date d = DATE_FORMAT.parse(this.date);
                result = d.getTime();
            }
            catch (ParseException ex) {
                return -1L;
            }
            return result;
        }
    }

    public static interface EncodeResult {
        public String[] getEncodedAuditReports();

        public long[] getAuditReportsTimestamp();
    }
}

