/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.Cache;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.FlushModeType;
import javax.persistence.PersistenceUnitUtil;
import javax.persistence.Query;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.metamodel.Metamodel;
import org.eclipse.persistence.config.PersistenceUnitProperties;
import org.eclipse.persistence.config.ReferenceMode;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.internal.jpa.CacheImpl;
import org.eclipse.persistence.internal.jpa.EntityManagerFactoryImpl;
import org.eclipse.persistence.internal.jpa.EntityManagerFactoryProvider;
import org.eclipse.persistence.internal.jpa.EntityManagerImpl;
import org.eclipse.persistence.internal.jpa.EntityManagerSetupImpl;
import org.eclipse.persistence.internal.jpa.deployment.SEPersistenceUnitInfo;
import org.eclipse.persistence.internal.jpa.querydef.CriteriaBuilderImpl;
import org.eclipse.persistence.internal.localization.ExceptionLocalization;
import org.eclipse.persistence.internal.sessions.DatabaseSessionImpl;
import org.eclipse.persistence.internal.sessions.PropertiesHandler;
import org.eclipse.persistence.jpa.JpaEntityManagerFactory;
import org.eclipse.persistence.sessions.broker.SessionBroker;
import org.eclipse.persistence.sessions.server.ServerSession;

public class EntityManagerFactoryDelegate
implements EntityManagerFactory,
PersistenceUnitUtil,
JpaEntityManagerFactory {
    protected Cache myCache;
    protected volatile DatabaseSessionImpl session;
    protected EntityManagerSetupImpl setupImpl;
    protected boolean isOpen = true;
    protected Map properties;
    protected static final Set<String> supportedNonServerSessionProperties = PersistenceUnitProperties.getSupportedNonServerSessionProperties();
    protected boolean beginEarlyTransaction;
    protected FlushModeType flushMode = FlushModeType.AUTO;
    protected ReferenceMode referenceMode = ReferenceMode.HARD;
    protected boolean closeOnCommit;
    protected boolean persistOnCommit = true;
    protected String flushClearCache = "DropInvalidate";
    protected boolean shouldValidateExistence;
    protected boolean shouldOrderUpdates = true;
    protected boolean commitWithoutPersistRules;
    protected JpaEntityManagerFactory owner = null;

    public EntityManagerFactoryDelegate(DatabaseSessionImpl databaseSession, JpaEntityManagerFactory owner) {
        this.session = databaseSession;
        this.owner = owner;
        this.processProperties(databaseSession.getProperties());
    }

    public EntityManagerFactoryDelegate(EntityManagerSetupImpl setupImpl, Map properties, JpaEntityManagerFactory owner) {
        this.setupImpl = setupImpl;
        this.owner = owner;
        this.properties = properties;
    }

    public EntityManagerFactoryDelegate(String persistenceUnitName, Map<String, Object> properties, List<ClassDescriptor> descriptors, JpaEntityManagerFactory owner) {
        this.properties = properties;
        this.owner = owner;
        SEPersistenceUnitInfo info = new SEPersistenceUnitInfo();
        info.setClassLoader((ClassLoader)properties.get("eclipselink.classloader"));
        info.setPersistenceUnitName(persistenceUnitName);
        info.getProperties().putAll(properties);
        this.setupImpl = new EntityManagerSetupImpl();
        this.setupImpl.predeploy(info, null);
        this.setupImpl.getSession().addDescriptors(descriptors);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DatabaseSessionImpl getDatabaseSession() {
        if (this.session == null) {
            EntityManagerFactoryDelegate entityManagerFactoryDelegate = this;
            synchronized (entityManagerFactoryDelegate) {
                if (this.session == null) {
                    ClassLoader realLoader = this.setupImpl.getPersistenceUnitInfo().getClassLoader();
                    Map[] splitProperties = EntityManagerFactoryProvider.splitSpecifiedProperties(this.properties, supportedNonServerSessionProperties);
                    Map serverSessionProperties = splitProperties[1];
                    DatabaseSessionImpl tempSession = this.setupImpl.deploy(realLoader, serverSessionProperties);
                    Map tempProperties = EntityManagerFactoryProvider.keepSpecifiedProperties(tempSession.getProperties(), supportedNonServerSessionProperties);
                    this.properties = splitProperties[0];
                    Map propertiesToProcess = EntityManagerFactoryProvider.mergeMaps(this.properties, tempProperties);
                    this.processProperties(propertiesToProcess);
                    this.session = tempSession;
                }
            }
        }
        return this.session;
    }

    public EntityManagerSetupImpl getSetupImpl() {
        return this.setupImpl;
    }

    @Override
    public ServerSession getServerSession() {
        return (ServerSession)this.getDatabaseSession();
    }

    @Override
    public SessionBroker getSessionBroker() {
        return (SessionBroker)this.getDatabaseSession();
    }

    public synchronized void close() {
        this.verifyOpen();
        this.isOpen = false;
        if (this.setupImpl != null) {
            this.setupImpl.undeploy();
        }
        this.owner = null;
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public EntityManager createEntityManager() {
        return this.createEntityManagerImpl(null);
    }

    public EntityManager createEntityManager(Map properties) {
        return this.createEntityManagerImpl(properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected EntityManagerImpl createEntityManagerImpl(Map properties) {
        this.verifyOpen();
        DatabaseSessionImpl session = this.getDatabaseSession();
        if (!session.isLoggedIn()) {
            DatabaseSessionImpl databaseSessionImpl = session;
            synchronized (databaseSessionImpl) {
                if (!session.isLoggedIn()) {
                    session.login();
                }
            }
        }
        return new EntityManagerImpl(this, properties);
    }

    @Override
    public EntityManagerFactoryDelegate unwrap() {
        return this;
    }

    protected void verifyOpen() {
        if (!this.isOpen) {
            throw new IllegalStateException(ExceptionLocalization.buildMessage("operation_on_closed_entity_manager_factory"));
        }
    }

    protected void finalize() throws Throwable {
        if (this.isOpen()) {
            this.close();
        }
    }

    public Object getProperty(String name) {
        Object value;
        if (name == null) {
            return null;
        }
        if (this.properties != null && (value = this.properties.get(name)) != null) {
            return value;
        }
        DatabaseSessionImpl tempSession = this.session;
        if (tempSession != null) {
            return tempSession.getProperty(name);
        }
        return null;
    }

    protected void processProperties(Map properties) {
        String flushClearCache;
        String shouldOrderUpdates;
        String shouldValidateExistence;
        String commitWithoutPersist;
        String persistOnCommit;
        String closeOnCommit;
        String flushMode;
        String referenceMode;
        String beginEarlyTransactionProperty = PropertiesHandler.getPropertyValueLogDebug("eclipselink.transaction.join-existing", properties, this.session, true);
        if (beginEarlyTransactionProperty != null) {
            this.beginEarlyTransaction = "true".equalsIgnoreCase(beginEarlyTransactionProperty);
        }
        if ((referenceMode = PropertiesHandler.getPropertyValueLogDebug("eclipselink.persistence-context.reference-mode", properties, this.session, true)) != null) {
            this.referenceMode = ReferenceMode.valueOf(referenceMode);
        }
        if ((flushMode = PropertiesHandler.getPropertyValueLogDebug("eclipselink.persistence-context.flush-mode", properties, this.session, true)) != null) {
            this.flushMode = FlushModeType.valueOf((String)flushMode);
        }
        if ((closeOnCommit = PropertiesHandler.getPropertyValueLogDebug("eclipselink.persistence-context.close-on-commit", properties, this.session, true)) != null) {
            this.closeOnCommit = "true".equalsIgnoreCase(closeOnCommit);
        }
        if ((persistOnCommit = PropertiesHandler.getPropertyValueLogDebug("eclipselink.persistence-context.persist-on-commit", properties, this.session, true)) != null) {
            this.persistOnCommit = "true".equalsIgnoreCase(persistOnCommit);
        }
        if ((commitWithoutPersist = PropertiesHandler.getPropertyValueLogDebug("eclipselink.persistence-context.commit-without-persist-rules", properties, this.session, true)) != null) {
            this.commitWithoutPersistRules = "true".equalsIgnoreCase(commitWithoutPersist);
        }
        if ((shouldValidateExistence = PropertiesHandler.getPropertyValueLogDebug("eclipselink.validate-existence", properties, this.session, true)) != null) {
            this.shouldValidateExistence = "true".equalsIgnoreCase(shouldValidateExistence);
        }
        if ((shouldOrderUpdates = PropertiesHandler.getPropertyValueLogDebug("eclipselink.order-updates", properties, this.session, true)) != null) {
            this.shouldOrderUpdates = "true".equalsIgnoreCase(shouldOrderUpdates);
        }
        if ((flushClearCache = PropertiesHandler.getPropertyValueLogDebug("eclipselink.flush-clear.cache", properties, this.session, true)) != null) {
            this.flushClearCache = flushClearCache;
        }
    }

    @Override
    public void refreshMetadata(Map properties) {
        throw new UnsupportedOperationException();
    }

    public boolean getBeginEarlyTransaction() {
        return this.beginEarlyTransaction;
    }

    public void setBeginEarlyTransaction(boolean beginEarlyTransaction) {
        this.beginEarlyTransaction = beginEarlyTransaction;
    }

    public FlushModeType getFlushMode() {
        return this.flushMode;
    }

    public void setFlushMode(FlushModeType flushMode) {
        this.flushMode = flushMode;
    }

    public ReferenceMode getReferenceMode() {
        return this.referenceMode;
    }

    public void setReferenceMode(ReferenceMode referenceMode) {
        this.referenceMode = referenceMode;
    }

    public boolean getCloseOnCommit() {
        return this.closeOnCommit;
    }

    public void setCloseOnCommit(boolean closeOnCommit) {
        this.closeOnCommit = closeOnCommit;
    }

    public boolean getPersistOnCommit() {
        return this.persistOnCommit;
    }

    public PersistenceUnitUtil getPersistenceUnitUtil() {
        return this;
    }

    public void setPersistOnCommit(boolean persistOnCommit) {
        this.persistOnCommit = persistOnCommit;
    }

    public boolean getCommitWithoutPersistRules() {
        return this.commitWithoutPersistRules;
    }

    public void setCommitWithoutPersistRules(boolean commitWithoutPersistRules) {
        this.commitWithoutPersistRules = commitWithoutPersistRules;
    }

    public String getFlushClearCache() {
        return this.flushClearCache;
    }

    public void setFlushClearCache(String flushClearCache) {
        this.flushClearCache = flushClearCache;
    }

    public boolean shouldValidateExistence() {
        return this.shouldValidateExistence;
    }

    public void setShouldValidateExistence(boolean shouldValidateExistence) {
        this.shouldValidateExistence = shouldValidateExistence;
    }

    public Cache getCache() {
        this.verifyOpen();
        if (this.myCache == null) {
            this.myCache = new CacheImpl(this);
        }
        return this.myCache;
    }

    public Map<String, Object> getProperties() {
        if (!this.isOpen()) {
            throw new IllegalStateException(ExceptionLocalization.buildMessage("operation_on_closed_entity_manager_factory"));
        }
        DatabaseSessionImpl tempSession = this.session;
        if (tempSession != null) {
            return Collections.unmodifiableMap(EntityManagerFactoryProvider.mergeMaps(this.properties, tempSession.getProperties()));
        }
        return Collections.unmodifiableMap(this.properties);
    }

    public CriteriaBuilder getCriteriaBuilder() {
        return new CriteriaBuilderImpl(this.getMetamodel());
    }

    public Metamodel getMetamodel() {
        if (!this.isOpen()) {
            throw new IllegalStateException(ExceptionLocalization.buildMessage("operation_on_closed_entity_manager_factory"));
        }
        this.getDatabaseSession();
        return this.setupImpl.getMetamodel();
    }

    public JpaEntityManagerFactory getOwner() {
        return this.owner;
    }

    public void setMetamodel(Metamodel aMetamodel) {
        if (!this.isOpen()) {
            throw new IllegalStateException(ExceptionLocalization.buildMessage("operation_on_closed_entity_manager_factory"));
        }
        this.setupImpl.setMetamodel(aMetamodel);
    }

    public boolean isLoaded(Object entity, String attributeName) {
        return EntityManagerFactoryImpl.isLoaded(entity, attributeName, this.session).equals(Boolean.TRUE);
    }

    public boolean isLoaded(Object entity) {
        return EntityManagerFactoryImpl.isLoaded(entity, this.session).equals(Boolean.TRUE);
    }

    public Object getIdentifier(Object entity) {
        return EntityManagerFactoryImpl.getIdentifier(entity, this.session);
    }

    public boolean shouldOrderUpdates() {
        return this.shouldOrderUpdates;
    }

    public void setShouldOrderUpdates(boolean shouldOrderUpdates) {
        this.shouldOrderUpdates = shouldOrderUpdates;
    }

    public void addNamedQuery(String name, Query query) {
        throw new RuntimeException("Not implemented ... WIP ...");
    }

    public <T> T unwrap(Class<T> cls) {
        throw new RuntimeException("Not implemented ... WIP ...");
    }
}

