/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.persistence.jpa.jpql.AbstractValidator;
import org.eclipse.persistence.jpa.jpql.Assert;
import org.eclipse.persistence.jpa.jpql.ExpressionTools;
import org.eclipse.persistence.jpa.jpql.LiteralType;
import org.eclipse.persistence.jpa.jpql.parser.AbsExpression;
import org.eclipse.persistence.jpa.jpql.parser.AbstractConditionalClause;
import org.eclipse.persistence.jpa.jpql.parser.AbstractDoubleEncapsulatedExpression;
import org.eclipse.persistence.jpa.jpql.parser.AbstractEncapsulatedExpression;
import org.eclipse.persistence.jpa.jpql.parser.AbstractExpressionVisitor;
import org.eclipse.persistence.jpa.jpql.parser.AbstractFromClause;
import org.eclipse.persistence.jpa.jpql.parser.AbstractPathExpression;
import org.eclipse.persistence.jpa.jpql.parser.AbstractSchemaName;
import org.eclipse.persistence.jpa.jpql.parser.AbstractSelectClause;
import org.eclipse.persistence.jpa.jpql.parser.AbstractSelectStatement;
import org.eclipse.persistence.jpa.jpql.parser.AbstractSingleEncapsulatedExpression;
import org.eclipse.persistence.jpa.jpql.parser.AbstractTripleEncapsulatedExpression;
import org.eclipse.persistence.jpa.jpql.parser.AdditionExpression;
import org.eclipse.persistence.jpa.jpql.parser.AggregateFunction;
import org.eclipse.persistence.jpa.jpql.parser.AllOrAnyExpression;
import org.eclipse.persistence.jpa.jpql.parser.AndExpression;
import org.eclipse.persistence.jpa.jpql.parser.ArithmeticExpression;
import org.eclipse.persistence.jpa.jpql.parser.ArithmeticFactor;
import org.eclipse.persistence.jpa.jpql.parser.AvgFunction;
import org.eclipse.persistence.jpa.jpql.parser.BadExpression;
import org.eclipse.persistence.jpa.jpql.parser.BetweenExpression;
import org.eclipse.persistence.jpa.jpql.parser.CaseExpression;
import org.eclipse.persistence.jpa.jpql.parser.CoalesceExpression;
import org.eclipse.persistence.jpa.jpql.parser.CollectionExpression;
import org.eclipse.persistence.jpa.jpql.parser.CollectionMemberDeclaration;
import org.eclipse.persistence.jpa.jpql.parser.CollectionMemberExpression;
import org.eclipse.persistence.jpa.jpql.parser.CollectionValuedPathExpression;
import org.eclipse.persistence.jpa.jpql.parser.ComparisonExpression;
import org.eclipse.persistence.jpa.jpql.parser.CompoundExpression;
import org.eclipse.persistence.jpa.jpql.parser.ConcatExpression;
import org.eclipse.persistence.jpa.jpql.parser.ConstructorExpression;
import org.eclipse.persistence.jpa.jpql.parser.CountFunction;
import org.eclipse.persistence.jpa.jpql.parser.DateTime;
import org.eclipse.persistence.jpa.jpql.parser.DeleteClause;
import org.eclipse.persistence.jpa.jpql.parser.DeleteStatement;
import org.eclipse.persistence.jpa.jpql.parser.DivisionExpression;
import org.eclipse.persistence.jpa.jpql.parser.EmptyCollectionComparisonExpression;
import org.eclipse.persistence.jpa.jpql.parser.EntityTypeLiteral;
import org.eclipse.persistence.jpa.jpql.parser.EntryExpression;
import org.eclipse.persistence.jpa.jpql.parser.ExistsExpression;
import org.eclipse.persistence.jpa.jpql.parser.Expression;
import org.eclipse.persistence.jpa.jpql.parser.FromClause;
import org.eclipse.persistence.jpa.jpql.parser.FunctionExpression;
import org.eclipse.persistence.jpa.jpql.parser.GroupByClause;
import org.eclipse.persistence.jpa.jpql.parser.HavingClause;
import org.eclipse.persistence.jpa.jpql.parser.IdentificationVariable;
import org.eclipse.persistence.jpa.jpql.parser.IdentificationVariableDeclaration;
import org.eclipse.persistence.jpa.jpql.parser.InExpression;
import org.eclipse.persistence.jpa.jpql.parser.IndexExpression;
import org.eclipse.persistence.jpa.jpql.parser.InputParameter;
import org.eclipse.persistence.jpa.jpql.parser.JPQLExpression;
import org.eclipse.persistence.jpa.jpql.parser.JPQLGrammar;
import org.eclipse.persistence.jpa.jpql.parser.JPQLQueryBNF;
import org.eclipse.persistence.jpa.jpql.parser.Join;
import org.eclipse.persistence.jpa.jpql.parser.KeyExpression;
import org.eclipse.persistence.jpa.jpql.parser.KeywordExpression;
import org.eclipse.persistence.jpa.jpql.parser.LengthExpression;
import org.eclipse.persistence.jpa.jpql.parser.LikeExpression;
import org.eclipse.persistence.jpa.jpql.parser.LocateExpression;
import org.eclipse.persistence.jpa.jpql.parser.LogicalExpression;
import org.eclipse.persistence.jpa.jpql.parser.LowerExpression;
import org.eclipse.persistence.jpa.jpql.parser.MaxFunction;
import org.eclipse.persistence.jpa.jpql.parser.MinFunction;
import org.eclipse.persistence.jpa.jpql.parser.ModExpression;
import org.eclipse.persistence.jpa.jpql.parser.MultiplicationExpression;
import org.eclipse.persistence.jpa.jpql.parser.NotExpression;
import org.eclipse.persistence.jpa.jpql.parser.NullComparisonExpression;
import org.eclipse.persistence.jpa.jpql.parser.NullExpression;
import org.eclipse.persistence.jpa.jpql.parser.NullIfExpression;
import org.eclipse.persistence.jpa.jpql.parser.NumericLiteral;
import org.eclipse.persistence.jpa.jpql.parser.ObjectExpression;
import org.eclipse.persistence.jpa.jpql.parser.OnClause;
import org.eclipse.persistence.jpa.jpql.parser.OrExpression;
import org.eclipse.persistence.jpa.jpql.parser.OrderByClause;
import org.eclipse.persistence.jpa.jpql.parser.OrderByItem;
import org.eclipse.persistence.jpa.jpql.parser.RangeVariableDeclaration;
import org.eclipse.persistence.jpa.jpql.parser.ResultVariable;
import org.eclipse.persistence.jpa.jpql.parser.SelectClause;
import org.eclipse.persistence.jpa.jpql.parser.SelectStatement;
import org.eclipse.persistence.jpa.jpql.parser.SimpleFromClause;
import org.eclipse.persistence.jpa.jpql.parser.SimpleSelectClause;
import org.eclipse.persistence.jpa.jpql.parser.SimpleSelectStatement;
import org.eclipse.persistence.jpa.jpql.parser.SizeExpression;
import org.eclipse.persistence.jpa.jpql.parser.SqrtExpression;
import org.eclipse.persistence.jpa.jpql.parser.StateFieldPathExpression;
import org.eclipse.persistence.jpa.jpql.parser.StringLiteral;
import org.eclipse.persistence.jpa.jpql.parser.SubExpression;
import org.eclipse.persistence.jpa.jpql.parser.SubstringExpression;
import org.eclipse.persistence.jpa.jpql.parser.SubtractionExpression;
import org.eclipse.persistence.jpa.jpql.parser.SumFunction;
import org.eclipse.persistence.jpa.jpql.parser.TreatExpression;
import org.eclipse.persistence.jpa.jpql.parser.TrimExpression;
import org.eclipse.persistence.jpa.jpql.parser.TypeExpression;
import org.eclipse.persistence.jpa.jpql.parser.UnknownExpression;
import org.eclipse.persistence.jpa.jpql.parser.UpdateClause;
import org.eclipse.persistence.jpa.jpql.parser.UpdateItem;
import org.eclipse.persistence.jpa.jpql.parser.UpdateStatement;
import org.eclipse.persistence.jpa.jpql.parser.UpperExpression;
import org.eclipse.persistence.jpa.jpql.parser.ValueExpression;
import org.eclipse.persistence.jpa.jpql.parser.WhenClause;
import org.eclipse.persistence.jpa.jpql.parser.WhereClause;
import org.eclipse.persistence.jpa.jpql.spi.JPAVersion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractGrammarValidator
extends AbstractValidator {
    private CollectionExpressionVisitor collectionExpressionVisitor;
    private CollectionSeparatedByCommaValidator collectionSeparatedByCommaValidator;
    private CollectionSeparatedBySpaceValidator collectionSeparatedBySpaceValidator;
    private ComparisonExpressionVisitor comparisonExpressionVisitor;
    private Map<String, Object> helpers;
    private Collection<InputParameter> inputParameters;
    private JPQLGrammar jpqlGrammar;

    protected AbstractGrammarValidator(JPQLGrammar jpqlGrammar) {
        Assert.isNotNull(jpqlGrammar, "The JPQLGrammar cannot be null");
        this.jpqlGrammar = jpqlGrammar;
    }

    protected AbstractSingleEncapsulatedExpressionHelper<AbsExpression> absExpressionHelper() {
        AbstractSingleEncapsulatedExpressionHelper<AbsExpression> helper = (AbstractSingleEncapsulatedExpressionHelper<AbsExpression>)this.getHelper("ABS");
        if (helper == null) {
            helper = this.buildAbsExpressionHelper();
            this.registerHelper("ABS", helper);
        }
        return helper;
    }

    protected AbstractSingleEncapsulatedExpressionHelper<AllOrAnyExpression> allOrAnyExpressionHelper() {
        AbstractSingleEncapsulatedExpressionHelper<AllOrAnyExpression> helper = (AbstractSingleEncapsulatedExpressionHelper<AllOrAnyExpression>)this.getHelper("ALL");
        if (helper == null) {
            helper = this.buildAllOrAnyExpressionHelper();
            this.registerHelper("ALL", helper);
        }
        return helper;
    }

    protected AbstractSingleEncapsulatedExpressionHelper<AvgFunction> avgFunctionHelper() {
        AbstractSingleEncapsulatedExpressionHelper<AvgFunction> helper = (AbstractSingleEncapsulatedExpressionHelper<AvgFunction>)this.getHelper("AVG");
        if (helper == null) {
            helper = this.buildAvgFunctionHelper();
            this.registerHelper("AVG", helper);
        }
        return helper;
    }

    protected AbstractSingleEncapsulatedExpressionHelper<AbsExpression> buildAbsExpressionHelper() {
        return new AbstractSingleEncapsulatedExpressionHelper<AbsExpression>(){

            @Override
            public String encapsulatedExpressionInvalidKey(AbsExpression expression) {
                return "ABS_EXPRESSION_INVALID_EXPRESSION";
            }

            @Override
            public String encapsulatedExpressionMissingKey(AbsExpression expression) {
                return "ABS_EXPRESSION_MISSING_EXPRESSION";
            }

            @Override
            public String leftParenthesisMissingKey(AbsExpression expression) {
                return "ABS_EXPRESSION_MISSING_LEFT_PARENTHESIS";
            }

            @Override
            public String rightParenthesisMissingKey(AbsExpression expression) {
                return "ABS_EXPRESSION_MISSING_RIGHT_PARENTHESIS";
            }
        };
    }

    protected AbstractSingleEncapsulatedExpressionHelper<AllOrAnyExpression> buildAllOrAnyExpressionHelper() {
        return new AbstractSingleEncapsulatedExpressionHelper<AllOrAnyExpression>(){

            @Override
            public String[] arguments(AllOrAnyExpression expression) {
                return new String[]{expression.getIdentifier()};
            }

            @Override
            public String encapsulatedExpressionInvalidKey(AllOrAnyExpression expression) {
                return "ALL_OR_ANY_EXPRESSION_INVALID_EXPRESSION";
            }

            @Override
            public String encapsulatedExpressionMissingKey(AllOrAnyExpression expression) {
                return "ALL_OR_ANY_EXPRESSION_MISSING_EXPRESSION";
            }

            @Override
            public String leftParenthesisMissingKey(AllOrAnyExpression expression) {
                return "ALL_OR_ANY_EXPRESSION_MISSING_LEFT_PARENTHESIS";
            }

            @Override
            public String rightParenthesisMissingKey(AllOrAnyExpression expression) {
                return "ALL_OR_ANY_EXPRESSION_MISSING_RIGHT_PARENTHESIS";
            }
        };
    }

    protected AbstractSingleEncapsulatedExpressionHelper<AvgFunction> buildAvgFunctionHelper() {
        return new AbstractSingleEncapsulatedExpressionHelper<AvgFunction>(){

            @Override
            public String encapsulatedExpressionInvalidKey(AvgFunction expression) {
                return "AVG_FUNCTION_INVALID_EXPRESSION";
            }

            @Override
            public String encapsulatedExpressionMissingKey(AvgFunction expression) {
                return "AVG_FUNCTION_MISSING_EXPRESSION";
            }

            @Override
            public String leftParenthesisMissingKey(AvgFunction expression) {
                return "AVG_FUNCTION_MISSING_LEFT_PARENTHESIS";
            }

            @Override
            public int lengthBeforeEncapsulatedExpression(AvgFunction expression) {
                return (expression.hasDistinct() ? 8 : 0) + (expression.hasSpaceAfterDistinct() ? 1 : 0);
            }

            @Override
            public String rightParenthesisMissingKey(AvgFunction expression) {
                return "AVG_FUNCTION_MISSING_RIGHT_PARENTHESIS";
            }
        };
    }

    protected AbstractSingleEncapsulatedExpressionHelper<CoalesceExpression> buildCoalesceExpressionHelper() {
        return new AbstractSingleEncapsulatedExpressionHelper<CoalesceExpression>(){

            @Override
            public String encapsulatedExpressionInvalidKey(CoalesceExpression expression) {
                return "COALESCE_EXPRESSION_INVALID_EXPRESSION";
            }

            @Override
            public String encapsulatedExpressionMissingKey(CoalesceExpression expression) {
                return "COALESCE_EXPRESSION_MISSING_EXPRESSION";
            }

            @Override
            protected boolean isEncapsulatedExpressionValid(CoalesceExpression expression) {
                return AbstractGrammarValidator.this.isValidWithChildCollectionBypass(expression.getExpression(), expression.encapsulatedExpressionBNF());
            }

            @Override
            public String leftParenthesisMissingKey(CoalesceExpression expression) {
                return "COALESCE_EXPRESSION_MISSING_LEFT_PARENTHESIS";
            }

            @Override
            public String rightParenthesisMissingKey(CoalesceExpression expression) {
                return "COALESCE_EXPRESSION_MISSING_RIGHT_PARENTHESIS";
            }
        };
    }

    protected CollectionExpressionVisitor buildCollectionExpressionVisitor() {
        return new CollectionExpressionVisitor();
    }

    protected AbstractSingleEncapsulatedExpressionHelper<ConcatExpression> buildConcatExpressionHelper() {
        return new AbstractSingleEncapsulatedExpressionHelper<ConcatExpression>(){

            @Override
            public String encapsulatedExpressionInvalidKey(ConcatExpression expression) {
                return "CONCAT_EXPRESSION_INVALID_EXPRESSION";
            }

            @Override
            public String encapsulatedExpressionMissingKey(ConcatExpression expression) {
                return "CONCAT_EXPRESSION_MISSING_EXPRESSION";
            }

            @Override
            public boolean isEncapsulatedExpressionValid(ConcatExpression expression) {
                return true;
            }

            @Override
            public String leftParenthesisMissingKey(ConcatExpression expression) {
                return "CONCAT_EXPRESSION_MISSING_LEFT_PARENTHESIS";
            }

            @Override
            public String rightParenthesisMissingKey(ConcatExpression expression) {
                return "CONCAT_EXPRESSION_MISSING_RIGHT_PARENTHESIS";
            }
        };
    }

    protected AbstractSingleEncapsulatedExpressionHelper<CountFunction> buildCountFunctionHelper() {
        return new AbstractSingleEncapsulatedExpressionHelper<CountFunction>(){

            @Override
            public String encapsulatedExpressionInvalidKey(CountFunction expression) {
                return "COUNT_FUNCTION_INVALID_EXPRESSION";
            }

            @Override
            public String encapsulatedExpressionMissingKey(CountFunction expression) {
                return "COUNT_FUNCTION_MISSING_EXPRESSION";
            }

            @Override
            public String leftParenthesisMissingKey(CountFunction expression) {
                return "COUNT_FUNCTION_MISSING_LEFT_PARENTHESIS";
            }

            @Override
            public int lengthBeforeEncapsulatedExpression(CountFunction expression) {
                return (expression.hasDistinct() ? 8 : 0) + (expression.hasSpaceAfterDistinct() ? 1 : 0);
            }

            @Override
            public String rightParenthesisMissingKey(CountFunction expression) {
                return "COUNT_FUNCTION_MISSING_RIGHT_PARENTHESIS";
            }
        };
    }

    protected DateTimeVisitor buildDateTimeVisitor() {
        return new DateTimeVisitor();
    }

    protected AbstractSingleEncapsulatedExpressionHelper<EntryExpression> buildEntryExpressionHelper() {
        return new AbstractSingleEncapsulatedExpressionHelper<EntryExpression>(){

            @Override
            public String encapsulatedExpressionInvalidKey(EntryExpression expression) {
                return "ENTRY_EXPRESSION_INVALID_EXPRESSION";
            }

            @Override
            public String encapsulatedExpressionMissingKey(EntryExpression expression) {
                return "ENTRY_EXPRESSION_MISSING_EXPRESSION";
            }

            @Override
            public boolean isEncapsulatedExpressionValid(EntryExpression expression) {
                return AbstractGrammarValidator.this.isValid(expression.getExpression(), "identification_variable");
            }

            @Override
            public String leftParenthesisMissingKey(EntryExpression expression) {
                return "ENTRY_EXPRESSION_MISSING_LEFT_PARENTHESIS";
            }

            @Override
            public String rightParenthesisMissingKey(EntryExpression expression) {
                return "ENTRY_EXPRESSION_MISSING_RIGHT_PARENTHESIS";
            }
        };
    }

    protected AbstractSingleEncapsulatedExpressionHelper<ExistsExpression> buildExistsExpressionHelper() {
        return new AbstractSingleEncapsulatedExpressionHelper<ExistsExpression>(){

            @Override
            public String encapsulatedExpressionInvalidKey(ExistsExpression expression) {
                return "EXISTS_EXPRESSION_INVALID_EXPRESSION";
            }

            @Override
            public String encapsulatedExpressionMissingKey(ExistsExpression expression) {
                return "EXISTS_EXPRESSION_MISSING_EXPRESSION";
            }

            @Override
            public String leftParenthesisMissingKey(ExistsExpression expression) {
                return "EXISTS_EXPRESSION_MISSING_LEFT_PARENTHESIS";
            }

            @Override
            public String rightParenthesisMissingKey(ExistsExpression expression) {
                return "EXISTS_EXPRESSION_MISSING_RIGHT_PARENTHESIS";
            }
        };
    }

    protected AbstractSingleEncapsulatedExpressionHelper<FunctionExpression> buildFunctionExpressionHelper() {
        return new AbstractSingleEncapsulatedExpressionHelper<FunctionExpression>(){

            @Override
            public String[] arguments(FunctionExpression expression) {
                return new String[]{expression.getIdentifier()};
            }

            @Override
            protected String encapsulatedExpressionInvalidKey(FunctionExpression expression) {
                switch (expression.getParameterCount()) {
                    case ONE: {
                        Expression children = expression.getExpression();
                        int childrenCount = AbstractGrammarValidator.this.getChildren(children).size();
                        if (childrenCount > 1) {
                            return "FUNCTION_EXPRESSION_MORE_THAN_ONE_EXPRESSION";
                        }
                    }
                    case ZERO: {
                        return "FUNCTION_EXPRESSION_HAS_EXPRESSION";
                    }
                }
                return "FUNCTION_EXPRESSION_INVALID_EXPRESSION";
            }

            @Override
            protected String encapsulatedExpressionMissingKey(FunctionExpression expression) {
                switch (expression.getParameterCount()) {
                    case ONE: {
                        Expression children = expression.getExpression();
                        int childrenCount = AbstractGrammarValidator.this.getChildren(children).size();
                        if (childrenCount != 0) break;
                        return "FUNCTION_EXPRESSION_MISSING_ONE_EXPRESSION";
                    }
                }
                return "FUNCTION_EXPRESSION_MISSING_EXPRESSION";
            }

            @Override
            protected boolean isEncapsulatedExpressionMissing(FunctionExpression expression) {
                switch (expression.getParameterCount()) {
                    case ONE: 
                    case ONE_OR_MANY: {
                        return !expression.hasExpression();
                    }
                }
                return false;
            }

            @Override
            protected boolean isEncapsulatedExpressionValid(FunctionExpression expression) {
                switch (expression.getParameterCount()) {
                    case ONE: {
                        return AbstractGrammarValidator.this.isValid(expression.getExpression(), expression.encapsulatedExpressionBNF());
                    }
                    case ONE_OR_MANY: {
                        return AbstractGrammarValidator.this.isValidWithChildCollectionBypass(expression.getExpression(), expression.encapsulatedExpressionBNF());
                    }
                    case ZERO_OR_ONE: {
                        return !expression.hasExpression() || AbstractGrammarValidator.this.isValid(expression.getExpression(), expression.encapsulatedExpressionBNF());
                    }
                }
                return true;
            }

            @Override
            public String leftParenthesisMissingKey(FunctionExpression expression) {
                return null;
            }

            @Override
            protected int lengthBeforeEncapsulatedExpression(FunctionExpression expression) {
                return expression.getFunctionName().length() + (expression.hasComma() ? 1 : 0) + (expression.hasSpaceAfterComma() ? 1 : 0);
            }

            @Override
            public String rightParenthesisMissingKey(FunctionExpression expression) {
                return "FUNCTION_EXPRESSION_MISSING_RIGHT_PARENTHESIS";
            }
        };
    }

    protected AbstractSingleEncapsulatedExpressionHelper<IndexExpression> buildIndexExpressionHelper() {
        return new AbstractSingleEncapsulatedExpressionHelper<IndexExpression>(){

            @Override
            public String encapsulatedExpressionInvalidKey(IndexExpression expression) {
                return "INDEX_EXPRESSION_INVALID_EXPRESSION";
            }

            @Override
            public String encapsulatedExpressionMissingKey(IndexExpression expression) {
                return "INDEX_EXPRESSION_MISSING_EXPRESSION";
            }

            @Override
            public boolean isEncapsulatedExpressionValid(IndexExpression expression) {
                return AbstractGrammarValidator.this.isValid(expression.getExpression(), "identification_variable");
            }

            @Override
            public String leftParenthesisMissingKey(IndexExpression expression) {
                return "INDEX_EXPRESSION_MISSING_LEFT_PARENTHESIS";
            }

            @Override
            public String rightParenthesisMissingKey(IndexExpression expression) {
                return "INDEX_EXPRESSION_MISSING_RIGHT_PARENTHESIS";
            }
        };
    }

    protected AbstractSingleEncapsulatedExpressionHelper<KeyExpression> buildKeyExpressionHelper() {
        return new AbstractSingleEncapsulatedExpressionHelper<KeyExpression>(){

            @Override
            public String encapsulatedExpressionInvalidKey(KeyExpression expression) {
                return "KEY_EXPRESSION_INVALID_EXPRESSION";
            }

            @Override
            public String encapsulatedExpressionMissingKey(KeyExpression expression) {
                return "KEY_EXPRESSION_MISSING_EXPRESSION";
            }

            @Override
            public boolean isEncapsulatedExpressionValid(KeyExpression expression) {
                return AbstractGrammarValidator.this.isValid(expression.getExpression(), "identification_variable");
            }

            @Override
            public String leftParenthesisMissingKey(KeyExpression expression) {
                return "KEY_EXPRESSION_MISSING_LEFT_PARENTHESIS";
            }

            @Override
            public String rightParenthesisMissingKey(KeyExpression expression) {
                return "KEY_EXPRESSION_MISSING_RIGHT_PARENTHESIS";
            }
        };
    }

    protected AbstractSingleEncapsulatedExpressionHelper<LengthExpression> buildLengthExpressionHelper() {
        return new AbstractSingleEncapsulatedExpressionHelper<LengthExpression>(){

            @Override
            public String encapsulatedExpressionInvalidKey(LengthExpression expression) {
                return "LENGTH_EXPRESSION_INVALID_EXPRESSION";
            }

            @Override
            public String encapsulatedExpressionMissingKey(LengthExpression expression) {
                return "LENGTH_EXPRESSION_MISSING_EXPRESSION";
            }

            @Override
            public String leftParenthesisMissingKey(LengthExpression expression) {
                return "LENGTH_EXPRESSION_MISSING_LEFT_PARENTHESIS";
            }

            @Override
            public String rightParenthesisMissingKey(LengthExpression expression) {
                return "LENGTH_EXPRESSION_MISSING_RIGHT_PARENTHESIS";
            }
        };
    }

    protected AbstractTripleEncapsulatedExpressionHelper<LocateExpression> buildLocateExpressionHelper() {
        return new AbstractTripleEncapsulatedExpressionHelper<LocateExpression>(){

            @Override
            protected String firstCommaMissingKey() {
                return "LOCATE_EXPRESSION_MISSING_FIRST_COMMA";
            }

            @Override
            protected String firstExpressionInvalidKey() {
                return "LOCATE_EXPRESSION_INVALID_FIRST_EXPRESSION";
            }

            @Override
            protected String firstExpressionMissingKey() {
                return "LOCATE_EXPRESSION_MISSING_FIRST_EXPRESSION";
            }

            @Override
            public String identifier(LocateExpression expression) {
                return "LOCATE";
            }

            @Override
            public String leftParenthesisMissingKey(LocateExpression expression) {
                return "LOCATE_EXPRESSION_MISSING_LEFT_PARENTHESIS";
            }

            @Override
            public String rightParenthesisMissingKey(LocateExpression expression) {
                return "LOCATE_EXPRESSION_MISSING_RIGHT_PARENTHESIS";
            }

            @Override
            protected String secondCommaMissingKey() {
                return "LOCATE_EXPRESSION_MISSING_SECOND_COMMA";
            }

            @Override
            protected String secondExpressionInvalidKey() {
                return "LOCATE_EXPRESSION_INVALID_SECOND_EXPRESSION";
            }

            @Override
            protected String secondExpressionMissingKey() {
                return "LOCATE_EXPRESSION_MISSING_SECOND_EXPRESSION";
            }

            @Override
            protected String thirdExpressionInvalidKey() {
                return "LOCATE_EXPRESSION_INVALID_THIRD_EXPRESSION";
            }

            @Override
            protected String thirdExpressionMissingKey() {
                return "LOCATE_EXPRESSION_MISSING_THIRD_EXPRESSION";
            }
        };
    }

    protected AbstractSingleEncapsulatedExpressionHelper<LowerExpression> buildLowerExpressionHelper() {
        return new AbstractSingleEncapsulatedExpressionHelper<LowerExpression>(){

            @Override
            public String encapsulatedExpressionInvalidKey(LowerExpression expression) {
                return "LOWER_EXPRESSION_INVALID_EXPRESSION";
            }

            @Override
            public String encapsulatedExpressionMissingKey(LowerExpression expression) {
                return "LOWER_EXPRESSION_MISSING_EXPRESSION";
            }

            @Override
            public String leftParenthesisMissingKey(LowerExpression expression) {
                return "LOWER_EXPRESSION_MISSING_LEFT_PARENTHESIS";
            }

            @Override
            public String rightParenthesisMissingKey(LowerExpression expression) {
                return "LOWER_EXPRESSION_MISSING_RIGHT_PARENTHESIS";
            }
        };
    }

    protected AbstractSingleEncapsulatedExpressionHelper<MaxFunction> buildMaxFunctionHelper() {
        return new AbstractSingleEncapsulatedExpressionHelper<MaxFunction>(){

            @Override
            public String encapsulatedExpressionInvalidKey(MaxFunction expression) {
                return "MAX_FUNCTION_INVALID_EXPRESSION";
            }

            @Override
            public String encapsulatedExpressionMissingKey(MaxFunction expression) {
                return "MAX_FUNCTION_MISSING_EXPRESSION";
            }

            @Override
            public String leftParenthesisMissingKey(MaxFunction expression) {
                return "MAX_FUNCTION_MISSING_LEFT_PARENTHESIS";
            }

            @Override
            public int lengthBeforeEncapsulatedExpression(MaxFunction expression) {
                return (expression.hasDistinct() ? 8 : 0) + (expression.hasSpaceAfterDistinct() ? 1 : 0);
            }

            @Override
            public String rightParenthesisMissingKey(MaxFunction expression) {
                return "MAX_FUNCTION_MISSING_RIGHT_PARENTHESIS";
            }
        };
    }

    protected AbstractSingleEncapsulatedExpressionHelper<MinFunction> buildMinFunctionHelper() {
        return new AbstractSingleEncapsulatedExpressionHelper<MinFunction>(){

            @Override
            public String encapsulatedExpressionInvalidKey(MinFunction expression) {
                return "MIN_FUNCTION_INVALID_EXPRESSION";
            }

            @Override
            public String encapsulatedExpressionMissingKey(MinFunction expression) {
                return "MIN_FUNCTION_MISSING_EXPRESSION";
            }

            @Override
            public String leftParenthesisMissingKey(MinFunction expression) {
                return "MIN_FUNCTION_MISSING_LEFT_PARENTHESIS";
            }

            @Override
            public int lengthBeforeEncapsulatedExpression(MinFunction expression) {
                return (expression.hasDistinct() ? 8 : 0) + (expression.hasSpaceAfterDistinct() ? 1 : 0);
            }

            @Override
            public String rightParenthesisMissingKey(MinFunction expression) {
                return "MIN_FUNCTION_MISSING_RIGHT_PARENTHESIS";
            }
        };
    }

    protected AbstractDoubleEncapsulatedExpressionHelper<ModExpression> buildModExpressionHelper() {
        return new AbstractDoubleEncapsulatedExpressionHelper<ModExpression>(){

            @Override
            protected String firstExpressionInvalidKey() {
                return "MOD_EXPRESSION_INVALID_FIRST_EXPRESSION";
            }

            @Override
            protected String firstExpressionMissingKey() {
                return "MOD_EXPRESSION_MISSING_FIRST_EXPRESSION";
            }

            @Override
            public String leftParenthesisMissingKey(ModExpression expression) {
                return "MOD_EXPRESSION_MISSING_LEFT_PARENTHESIS";
            }

            @Override
            protected String missingCommaKey() {
                return "MOD_EXPRESSION_MISSING_COMMA";
            }

            @Override
            public String rightParenthesisMissingKey(ModExpression expression) {
                return "MOD_EXPRESSION_MISSING_RIGHT_PARENTHESIS";
            }

            @Override
            protected String secondExpressionInvalidKey() {
                return "MOD_EXPRESSION_INVALID_SECOND_EXPRESSION";
            }

            @Override
            protected String secondExpressionMissingKey() {
                return "MOD_EXPRESSION_MISSING_SECOND_EXPRESSION";
            }
        };
    }

    protected NullExpressionVisitor buildNullExpressionVisitor() {
        return new NullExpressionVisitor();
    }

    protected AbstractDoubleEncapsulatedExpressionHelper<NullIfExpression> buildNullIfExpressionHelper() {
        return new AbstractDoubleEncapsulatedExpressionHelper<NullIfExpression>(){

            @Override
            public String firstExpressionInvalidKey() {
                return "NULLIF_EXPRESSION_INVALID_FIRST_EXPRESSION";
            }

            @Override
            public String firstExpressionMissingKey() {
                return "NULLIF_EXPRESSION_MISSING_FIRST_EXPRESSION";
            }

            @Override
            public String leftParenthesisMissingKey(NullIfExpression expression) {
                return "NULLIF_EXPRESSION_MISSING_LEFT_PARENTHESIS";
            }

            @Override
            public String missingCommaKey() {
                return "NULLIF_EXPRESSION_MISSING_COMMA";
            }

            @Override
            public String rightParenthesisMissingKey(NullIfExpression expression) {
                return "NULLIF_EXPRESSION_MISSING_RIGHT_PARENTHESIS";
            }

            @Override
            public String secondExpressionInvalidKey() {
                return "NULLIF_EXPRESSION_INVALID_SECOND_EXPRESSION";
            }

            @Override
            public String secondExpressionMissingKey() {
                return "NULLIF_EXPRESSION_MISSING_SECOND_EXPRESSION";
            }
        };
    }

    protected AbstractSingleEncapsulatedExpressionHelper<ObjectExpression> buildObjectExpressionHelper() {
        return new AbstractSingleEncapsulatedExpressionHelper<ObjectExpression>(){

            @Override
            public String encapsulatedExpressionInvalidKey(ObjectExpression expression) {
                return "OBJECT_EXPRESSION_INVALID_EXPRESSION";
            }

            @Override
            public String encapsulatedExpressionMissingKey(ObjectExpression expression) {
                return "OBJECT_EXPRESSION_MISSING_EXPRESSION";
            }

            @Override
            public boolean isEncapsulatedExpressionValid(ObjectExpression expression) {
                return AbstractGrammarValidator.this.isValid(expression.getExpression(), "identification_variable");
            }

            @Override
            public String leftParenthesisMissingKey(ObjectExpression expression) {
                return "OBJECT_EXPRESSION_MISSING_LEFT_PARENTHESIS";
            }

            @Override
            public String rightParenthesisMissingKey(ObjectExpression expression) {
                return "OBJECT_EXPRESSION_MISSING_RIGHT_PARENTHESIS";
            }
        };
    }

    protected AbstractSingleEncapsulatedExpressionHelper<SizeExpression> buildSizeExpressionHelper() {
        return new AbstractSingleEncapsulatedExpressionHelper<SizeExpression>(){

            @Override
            public String encapsulatedExpressionInvalidKey(SizeExpression expression) {
                return "SIZE_EXPRESSION_INVALID_EXPRESSION";
            }

            @Override
            public String encapsulatedExpressionMissingKey(SizeExpression expression) {
                return "SIZE_EXPRESSION_MISSING_EXPRESSION";
            }

            @Override
            public String leftParenthesisMissingKey(SizeExpression expression) {
                return "SIZE_EXPRESSION_MISSING_LEFT_PARENTHESIS";
            }

            @Override
            public String rightParenthesisMissingKey(SizeExpression expression) {
                return "SIZE_EXPRESSION_MISSING_RIGHT_PARENTHESIS";
            }
        };
    }

    protected AbstractSingleEncapsulatedExpressionHelper<SqrtExpression> buildSqrtExpressionHelper() {
        return new AbstractSingleEncapsulatedExpressionHelper<SqrtExpression>(){

            @Override
            public String encapsulatedExpressionInvalidKey(SqrtExpression expression) {
                return "SQRT_EXPRESSION_INVALID_EXPRESSION";
            }

            @Override
            public String encapsulatedExpressionMissingKey(SqrtExpression expression) {
                return "SQRT_EXPRESSION_MISSING_EXPRESSION";
            }

            @Override
            public String leftParenthesisMissingKey(SqrtExpression expression) {
                return "SQRT_EXPRESSION_MISSING_LEFT_PARENTHESIS";
            }

            @Override
            public String rightParenthesisMissingKey(SqrtExpression expression) {
                return "SQRT_EXPRESSION_MISSING_RIGHT_PARENTHESIS";
            }
        };
    }

    protected AbstractTripleEncapsulatedExpressionHelper<SubstringExpression> buildSubstringExpressionHelper() {
        return new AbstractTripleEncapsulatedExpressionHelper<SubstringExpression>(){

            @Override
            protected String firstCommaMissingKey() {
                return "SUBSTRING_EXPRESSION_MISSING_FIRST_COMMA";
            }

            @Override
            protected String firstExpressionInvalidKey() {
                return "SUBSTRING_EXPRESSION_INVALID_FIRST_EXPRESSION";
            }

            @Override
            protected String firstExpressionMissingKey() {
                return "SUBSTRING_EXPRESSION_MISSING_FIRST_EXPRESSION";
            }

            @Override
            public String identifier(SubstringExpression expression) {
                return "SUBSTRING";
            }

            @Override
            public String leftParenthesisMissingKey(SubstringExpression expression) {
                return "SUBSTRING_EXPRESSION_MISSING_LEFT_PARENTHESIS";
            }

            @Override
            public String rightParenthesisMissingKey(SubstringExpression expression) {
                return "SUBSTRING_EXPRESSION_MISSING_RIGHT_PARENTHESIS";
            }

            @Override
            protected String secondCommaMissingKey() {
                return "SUBSTRING_EXPRESSION_MISSING_SECOND_COMMA";
            }

            @Override
            protected String secondExpressionInvalidKey() {
                return "SUBSTRING_EXPRESSION_INVALID_SECOND_EXPRESSION";
            }

            @Override
            protected String secondExpressionMissingKey() {
                return "SUBSTRING_EXPRESSION_MISSING_SECOND_EXPRESSION";
            }

            @Override
            protected String thirdExpressionInvalidKey() {
                return "SUBSTRING_EXPRESSION_INVALID_THIRD_EXPRESSION";
            }

            @Override
            protected String thirdExpressionMissingKey() {
                return "SUBSTRING_EXPRESSION_MISSING_THIRD_EXPRESSION";
            }
        };
    }

    protected AbstractSingleEncapsulatedExpressionHelper<SumFunction> buildSumFunctionHelper() {
        return new AbstractSingleEncapsulatedExpressionHelper<SumFunction>(){

            @Override
            public String encapsulatedExpressionInvalidKey(SumFunction expression) {
                return "SUM_FUNCTION_INVALID_EXPRESSION";
            }

            @Override
            public String encapsulatedExpressionMissingKey(SumFunction expression) {
                return "SUM_FUNCTION_MISSING_EXPRESSION";
            }

            @Override
            public String leftParenthesisMissingKey(SumFunction expression) {
                return "SUM_FUNCTION_MISSING_LEFT_PARENTHESIS";
            }

            @Override
            public int lengthBeforeEncapsulatedExpression(SumFunction expression) {
                return (expression.hasDistinct() ? 8 : 0) + (expression.hasSpaceAfterDistinct() ? 1 : 0);
            }

            @Override
            public String rightParenthesisMissingKey(SumFunction expression) {
                return "SUM_FUNCTION_MISSING_RIGHT_PARENTHESIS";
            }
        };
    }

    protected AbstractSingleEncapsulatedExpressionHelper<TrimExpression> buildTrimExpressionHelper() {
        return new AbstractSingleEncapsulatedExpressionHelper<TrimExpression>(){

            @Override
            public String encapsulatedExpressionInvalidKey(TrimExpression expression) {
                return "TRIM_EXPRESSION_INVALID_EXPRESSION";
            }

            @Override
            public String encapsulatedExpressionMissingKey(TrimExpression expression) {
                return "TRIM_EXPRESSION_MISSING_EXPRESSION";
            }

            @Override
            public boolean isEncapsulatedExpressionMissing(TrimExpression expression) {
                return false;
            }

            @Override
            public boolean isEncapsulatedExpressionValid(TrimExpression expression) {
                return true;
            }

            @Override
            public String leftParenthesisMissingKey(TrimExpression expression) {
                return "TRIM_EXPRESSION_MISSING_LEFT_PARENTHESIS";
            }

            @Override
            public String rightParenthesisMissingKey(TrimExpression expression) {
                return "TRIM_EXPRESSION_MISSING_RIGHT_PARENTHESIS";
            }
        };
    }

    protected AbstractSingleEncapsulatedExpressionHelper<TypeExpression> buildTypeExpressionHelper() {
        return new AbstractSingleEncapsulatedExpressionHelper<TypeExpression>(){

            @Override
            public String encapsulatedExpressionInvalidKey(TypeExpression expression) {
                return "TYPE_EXPRESSION_INVALID_EXPRESSION";
            }

            @Override
            public String encapsulatedExpressionMissingKey(TypeExpression expression) {
                return "TYPE_EXPRESSION_MISSING_EXPRESSION";
            }

            @Override
            public String leftParenthesisMissingKey(TypeExpression expression) {
                return "TYPE_EXPRESSION_MISSING_LEFT_PARENTHESIS";
            }

            @Override
            public String rightParenthesisMissingKey(TypeExpression expression) {
                return "TYPE_EXPRESSION_MISSING_RIGHT_PARENTHESIS";
            }
        };
    }

    protected AbstractSingleEncapsulatedExpressionHelper<UpperExpression> buildUpperExpressionHelper() {
        return new AbstractSingleEncapsulatedExpressionHelper<UpperExpression>(){

            @Override
            public String encapsulatedExpressionInvalidKey(UpperExpression expression) {
                return "UPPER_EXPRESSION_INVALID_EXPRESSION";
            }

            @Override
            public String encapsulatedExpressionMissingKey(UpperExpression expression) {
                return "UPPER_EXPRESSION_MISSING_EXPRESSION";
            }

            @Override
            public String leftParenthesisMissingKey(UpperExpression expression) {
                return "UPPER_EXPRESSION_MISSING_LEFT_PARENTHESIS";
            }

            @Override
            public String rightParenthesisMissingKey(UpperExpression expression) {
                return "UPPER_EXPRESSION_MISSING_RIGHT_PARENTHESIS";
            }
        };
    }

    protected AbstractSingleEncapsulatedExpressionHelper<ValueExpression> buildValueExpressionHelper() {
        return new AbstractSingleEncapsulatedExpressionHelper<ValueExpression>(){

            @Override
            protected String encapsulatedExpressionInvalidKey(ValueExpression expression) {
                return "VALUE_EXPRESSION_INVALID_EXPRESSION";
            }

            @Override
            protected String encapsulatedExpressionMissingKey(ValueExpression expression) {
                return "VALUE_EXPRESSION_MISSING_EXPRESSION";
            }

            @Override
            protected boolean isEncapsulatedExpressionValid(ValueExpression expression) {
                return AbstractGrammarValidator.this.isValid(expression.getExpression(), "identification_variable");
            }

            @Override
            public String leftParenthesisMissingKey(ValueExpression expression) {
                return "VALUE_EXPRESSION_MISSING_LEFT_PARENTHESIS";
            }

            @Override
            public String rightParenthesisMissingKey(ValueExpression expression) {
                return "VALUE_EXPRESSION_MISSING_RIGHT_PARENTHESIS";
            }
        };
    }

    protected AbstractSingleEncapsulatedExpressionHelper<CoalesceExpression> coalesceExpressionHelper() {
        AbstractSingleEncapsulatedExpressionHelper<CoalesceExpression> helper = (AbstractSingleEncapsulatedExpressionHelper<CoalesceExpression>)this.getHelper("COALESCE");
        if (helper == null) {
            helper = this.buildCoalesceExpressionHelper();
            this.registerHelper("COALESCE", helper);
        }
        return helper;
    }

    protected CollectionSeparatedByCommaValidator collectionSeparatedByCommaValidator() {
        if (this.collectionSeparatedByCommaValidator == null) {
            this.collectionSeparatedByCommaValidator = new CollectionSeparatedByCommaValidator();
        }
        return this.collectionSeparatedByCommaValidator;
    }

    protected CollectionSeparatedBySpaceValidator collectionSeparatedBySpaceValidator() {
        if (this.collectionSeparatedBySpaceValidator == null) {
            this.collectionSeparatedBySpaceValidator = new CollectionSeparatedBySpaceValidator();
        }
        return this.collectionSeparatedBySpaceValidator;
    }

    protected ComparisonExpressionVisitor comparisonExpressionVisitor() {
        if (this.comparisonExpressionVisitor == null) {
            this.comparisonExpressionVisitor = new ComparisonExpressionVisitor();
        }
        return this.comparisonExpressionVisitor;
    }

    protected AbstractSingleEncapsulatedExpressionHelper<ConcatExpression> concatExpressionHelper() {
        AbstractSingleEncapsulatedExpressionHelper<ConcatExpression> helper = (AbstractSingleEncapsulatedExpressionHelper<ConcatExpression>)this.getHelper("CONCAT");
        if (helper == null) {
            helper = this.buildConcatExpressionHelper();
            this.registerHelper("CONCAT", helper);
        }
        return helper;
    }

    protected AbstractSingleEncapsulatedExpressionHelper<CountFunction> countFunctionHelper() {
        AbstractSingleEncapsulatedExpressionHelper<CountFunction> helper = (AbstractSingleEncapsulatedExpressionHelper<CountFunction>)this.getHelper("COUNT");
        if (helper == null) {
            helper = this.buildCountFunctionHelper();
            this.registerHelper("COUNT", helper);
        }
        return helper;
    }

    @Override
    public void dispose() {
        this.inputParameters.clear();
        super.dispose();
    }

    protected AbstractSingleEncapsulatedExpressionHelper<EntryExpression> entryExpressionHelper() {
        AbstractSingleEncapsulatedExpressionHelper<EntryExpression> helper = (AbstractSingleEncapsulatedExpressionHelper<EntryExpression>)this.getHelper("ENTRY");
        if (helper == null) {
            helper = this.buildEntryExpressionHelper();
            this.registerHelper("ENTRY", helper);
        }
        return helper;
    }

    protected AbstractSingleEncapsulatedExpressionHelper<ExistsExpression> existsExpressionHelper() {
        AbstractSingleEncapsulatedExpressionHelper<ExistsExpression> helper = (AbstractSingleEncapsulatedExpressionHelper<ExistsExpression>)this.getHelper("EXISTS");
        if (helper == null) {
            helper = this.buildExistsExpressionHelper();
            this.registerHelper("EXISTS", helper);
        }
        return helper;
    }

    protected AbstractSingleEncapsulatedExpressionHelper<FunctionExpression> functionExpressionHelper() {
        AbstractSingleEncapsulatedExpressionHelper<FunctionExpression> helper = (AbstractSingleEncapsulatedExpressionHelper<FunctionExpression>)this.getHelper("FUNCTION");
        if (helper == null) {
            helper = this.buildFunctionExpressionHelper();
            this.registerHelper("FUNCTION", helper);
        }
        return helper;
    }

    protected CollectionExpression getCollectionExpression(Expression expression) {
        CollectionExpressionVisitor visitor = this.getCollectionExpressionVisitor();
        try {
            expression.accept(visitor);
            CollectionExpression collectionExpression = visitor.expression;
            return collectionExpression;
        }
        finally {
            visitor.expression = null;
        }
    }

    protected CollectionExpressionVisitor getCollectionExpressionVisitor() {
        if (this.collectionExpressionVisitor == null) {
            this.collectionExpressionVisitor = this.buildCollectionExpressionVisitor();
        }
        return this.collectionExpressionVisitor;
    }

    protected DateTimeVisitor getDateTimeVisitor() {
        DateTimeVisitor visitor = (DateTimeVisitor)this.getHelper("CURRENT_TIMESTAMP");
        if (visitor == null) {
            visitor = this.buildDateTimeVisitor();
            this.registerHelper("CURRENT_TIMESTAMP", visitor);
        }
        return visitor;
    }

    @Override
    protected JPQLGrammar getGrammar() {
        return this.jpqlGrammar;
    }

    protected <T> T getHelper(String id) {
        return (T)this.helpers.get(id);
    }

    protected AbstractSingleEncapsulatedExpressionHelper<IndexExpression> indexExpressionHelper() {
        AbstractSingleEncapsulatedExpressionHelper<IndexExpression> helper = (AbstractSingleEncapsulatedExpressionHelper<IndexExpression>)this.getHelper("INDEX");
        if (helper == null) {
            helper = this.buildIndexExpressionHelper();
            this.registerHelper("INDEX", helper);
        }
        return helper;
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.helpers = new HashMap<String, Object>();
        this.inputParameters = new ArrayList<InputParameter>();
    }

    protected boolean isChildOfComparisonExpession(AllOrAnyExpression expression) {
        ComparisonExpressionVisitor visitor = this.comparisonExpressionVisitor();
        AbstractValidator.BypassParentSubExpressionVisitor bypassVisitor = this.getBypassParentSubExpressionVisitor();
        try {
            bypassVisitor.visitor = visitor;
            expression.getParent().accept(visitor);
            boolean bl = visitor.expression != null;
            return bl;
        }
        finally {
            bypassVisitor.visitor = null;
            visitor.expression = null;
        }
    }

    protected boolean isCollectionExpression(Expression expression) {
        return this.getCollectionExpression(expression) != null;
    }

    protected boolean isDateTimeConstant(Expression leftExpression) {
        DateTimeVisitor visitor = this.getDateTimeVisitor();
        try {
            leftExpression.accept(visitor);
            boolean bl = visitor.dateTime;
            return bl;
        }
        finally {
            visitor.dateTime = false;
        }
    }

    protected boolean isInputParameterInValidLocation(InputParameter expression) {
        AbstractValidator.OwningClauseVisitor visitor = this.getOwningClauseVisitor();
        try {
            expression.accept(visitor);
            boolean bl = visitor.whereClause != null || visitor.havingClause != null;
            return bl;
        }
        finally {
            visitor.dispose();
        }
    }

    protected abstract boolean isJoinFetchIdentifiable();

    protected boolean isJPA1_0() {
        return this.getJPAVersion() == JPAVersion.VERSION_1_0;
    }

    protected boolean isJPA2_0() {
        return this.getJPAVersion() == JPAVersion.VERSION_2_0;
    }

    protected boolean isJPA2_1() {
        return this.getJPAVersion() == JPAVersion.VERSION_2_1;
    }

    protected final boolean isNewerThan(JPAVersion version) {
        return this.getJPAVersion().isNewerThan(version);
    }

    protected final boolean isNewerThanOrEqual(JPAVersion version) {
        return this.getJPAVersion().isNewerThanOrEqual(version);
    }

    protected boolean isNumericLiteral(String text) {
        if (text.endsWith("l") || text.endsWith("L")) {
            text = text.substring(0, text.length() - 1);
        }
        try {
            Double.parseDouble(text);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected final boolean isOlderThan(JPAVersion version) {
        return this.getJPAVersion().isOlderThan(version);
    }

    protected final boolean isOlderThanOrEqual(JPAVersion version) {
        return this.getJPAVersion().isOlderThanOrEqual(version);
    }

    protected boolean isOwnedByConditionalClause(Expression expression) {
        AbstractValidator.OwningClauseVisitor visitor = this.getOwningClauseVisitor();
        try {
            expression.accept(visitor);
            boolean bl = visitor.whereClause != null || visitor.havingClause != null;
            return bl;
        }
        finally {
            visitor.dispose();
        }
    }

    protected boolean isOwnedByFromClause(Expression expression) {
        AbstractValidator.OwningClauseVisitor visitor = this.getOwningClauseVisitor();
        try {
            expression.accept(visitor);
            boolean bl = visitor.fromClause != null;
            return bl;
        }
        finally {
            visitor.dispose();
        }
    }

    protected boolean isOwnedBySubFromClause(Expression expression) {
        AbstractValidator.OwningClauseVisitor visitor = this.getOwningClauseVisitor();
        try {
            expression.accept(visitor);
            boolean bl = visitor.simpleFromClause != null;
            return bl;
        }
        finally {
            visitor.dispose();
        }
    }

    protected abstract boolean isSubqueryAllowedAnywhere();

    protected boolean isValidJavaIdentifier(String variable) {
        int index = 0;
        int count = variable.length();
        while (index < count) {
            char character = variable.charAt(index);
            if (index == 0 && !Character.isJavaIdentifierStart((int)character)) {
                return false;
            }
            if (index > 0 && !Character.isJavaIdentifierPart((int)character)) {
                return false;
            }
            ++index;
        }
        return true;
    }

    protected AbstractSingleEncapsulatedExpressionHelper<KeyExpression> keyExpressionHelper() {
        AbstractSingleEncapsulatedExpressionHelper<KeyExpression> helper = (AbstractSingleEncapsulatedExpressionHelper<KeyExpression>)this.getHelper("KEY");
        if (helper == null) {
            helper = this.buildKeyExpressionHelper();
            this.registerHelper("KEY", helper);
        }
        return helper;
    }

    protected AbstractSingleEncapsulatedExpressionHelper<LengthExpression> lengthExpressionHelper() {
        AbstractSingleEncapsulatedExpressionHelper<LengthExpression> helper = (AbstractSingleEncapsulatedExpressionHelper<LengthExpression>)this.getHelper("LENGTH");
        if (helper == null) {
            helper = this.buildLengthExpressionHelper();
            this.registerHelper("LENGTH", helper);
        }
        return helper;
    }

    protected AbstractTripleEncapsulatedExpressionHelper<LocateExpression> locateExpressionHelper() {
        AbstractTripleEncapsulatedExpressionHelper<LocateExpression> helper = (AbstractTripleEncapsulatedExpressionHelper<LocateExpression>)this.getHelper("LOCATE");
        if (helper == null) {
            helper = this.buildLocateExpressionHelper();
            this.registerHelper("LOCATE", helper);
        }
        return helper;
    }

    protected AbstractSingleEncapsulatedExpressionHelper<LowerExpression> lowerExpressionHelper() {
        AbstractSingleEncapsulatedExpressionHelper<LowerExpression> helper = (AbstractSingleEncapsulatedExpressionHelper<LowerExpression>)this.getHelper("LOWER");
        if (helper == null) {
            helper = this.buildLowerExpressionHelper();
            this.registerHelper("LOWER", helper);
        }
        return helper;
    }

    protected AbstractSingleEncapsulatedExpressionHelper<MaxFunction> maxFunctionHelper() {
        AbstractSingleEncapsulatedExpressionHelper<MaxFunction> helper = (AbstractSingleEncapsulatedExpressionHelper<MaxFunction>)this.getHelper("MAX");
        if (helper == null) {
            helper = this.buildMaxFunctionHelper();
            this.registerHelper("MAX", helper);
        }
        return helper;
    }

    protected AbstractSingleEncapsulatedExpressionHelper<MinFunction> minFunctionHelper() {
        AbstractSingleEncapsulatedExpressionHelper<MinFunction> helper = (AbstractSingleEncapsulatedExpressionHelper<MinFunction>)this.getHelper("MIN");
        if (helper == null) {
            helper = this.buildMinFunctionHelper();
            this.registerHelper("MIN", helper);
        }
        return helper;
    }

    protected AbstractDoubleEncapsulatedExpressionHelper<ModExpression> modExpressionHelper() {
        AbstractDoubleEncapsulatedExpressionHelper<ModExpression> helper = (AbstractDoubleEncapsulatedExpressionHelper<ModExpression>)this.getHelper("MOD");
        if (helper == null) {
            helper = this.buildModExpressionHelper();
            this.registerHelper("MOD", helper);
        }
        return helper;
    }

    protected AbstractDoubleEncapsulatedExpressionHelper<NullIfExpression> nullIfExpressionHelper() {
        AbstractDoubleEncapsulatedExpressionHelper<NullIfExpression> helper = (AbstractDoubleEncapsulatedExpressionHelper<NullIfExpression>)this.getHelper("NULLIF");
        if (helper == null) {
            helper = this.buildNullIfExpressionHelper();
            this.registerHelper("NULLIF", helper);
        }
        return helper;
    }

    protected AbstractSingleEncapsulatedExpressionHelper<ObjectExpression> objectExpressionHelper() {
        AbstractSingleEncapsulatedExpressionHelper<ObjectExpression> helper = (AbstractSingleEncapsulatedExpressionHelper<ObjectExpression>)this.getHelper("OBJECT");
        if (helper == null) {
            helper = this.buildObjectExpressionHelper();
            this.registerHelper("OBJECT", helper);
        }
        return helper;
    }

    protected int position(Expression expression, int ... extras) {
        int position = this.position(expression);
        int[] nArray = extras;
        int n = extras.length;
        int n2 = 0;
        while (n2 < n) {
            int extra = nArray[n2];
            position += extra;
            ++n2;
        }
        return position;
    }

    protected void registerHelper(String id, Object helper) {
        this.helpers.put(id, helper);
    }

    protected AbstractSingleEncapsulatedExpressionHelper<SizeExpression> sizeExpressionHelper() {
        AbstractSingleEncapsulatedExpressionHelper<SizeExpression> helper = (AbstractSingleEncapsulatedExpressionHelper<SizeExpression>)this.getHelper("SIZE");
        if (helper == null) {
            helper = this.buildSizeExpressionHelper();
            this.registerHelper("SIZE", helper);
        }
        return helper;
    }

    protected AbstractSingleEncapsulatedExpressionHelper<SqrtExpression> sqrtExpressionHelper() {
        AbstractSingleEncapsulatedExpressionHelper<SqrtExpression> helper = (AbstractSingleEncapsulatedExpressionHelper<SqrtExpression>)this.getHelper("SQRT");
        if (helper == null) {
            helper = this.buildSqrtExpressionHelper();
            this.registerHelper("SQRT", helper);
        }
        return helper;
    }

    protected AbstractTripleEncapsulatedExpressionHelper<SubstringExpression> substringExpressionHelper() {
        AbstractTripleEncapsulatedExpressionHelper<SubstringExpression> helper = (AbstractTripleEncapsulatedExpressionHelper<SubstringExpression>)this.getHelper("SUBSTRING");
        if (helper == null) {
            helper = this.buildSubstringExpressionHelper();
            this.registerHelper("SUBSTRING", helper);
        }
        return helper;
    }

    protected AbstractSingleEncapsulatedExpressionHelper<SumFunction> sumFunctionHelper() {
        AbstractSingleEncapsulatedExpressionHelper<SumFunction> helper = (AbstractSingleEncapsulatedExpressionHelper<SumFunction>)this.getHelper("SUM");
        if (helper == null) {
            helper = this.buildSumFunctionHelper();
            this.registerHelper("SUM", helper);
        }
        return helper;
    }

    protected AbstractSingleEncapsulatedExpressionHelper<TrimExpression> trimExpressionHelper() {
        AbstractSingleEncapsulatedExpressionHelper<TrimExpression> helper = (AbstractSingleEncapsulatedExpressionHelper<TrimExpression>)this.getHelper("TRIM");
        if (helper == null) {
            helper = this.buildTrimExpressionHelper();
            this.registerHelper("TRIM", helper);
        }
        return helper;
    }

    protected AbstractSingleEncapsulatedExpressionHelper<TypeExpression> typeExpressionHelper() {
        AbstractSingleEncapsulatedExpressionHelper<TypeExpression> helper = (AbstractSingleEncapsulatedExpressionHelper<TypeExpression>)this.getHelper("TYPE");
        if (helper == null) {
            helper = this.buildTypeExpressionHelper();
            this.registerHelper("TYPE", helper);
        }
        return helper;
    }

    protected AbstractSingleEncapsulatedExpressionHelper<UpperExpression> upperExpressionHelper() {
        AbstractSingleEncapsulatedExpressionHelper<UpperExpression> helper = (AbstractSingleEncapsulatedExpressionHelper<UpperExpression>)this.getHelper("UPPER");
        if (helper == null) {
            helper = this.buildUpperExpressionHelper();
            this.registerHelper("UPPER", helper);
        }
        return helper;
    }

    protected void validateAbstractConditionalClause(AbstractConditionalClause expression, String missingConditionalExpressionMessageKey, String invalidConditionalExpressionMessageKey) {
        if (!expression.hasConditionalExpression()) {
            int startPosition = this.position(expression);
            int endPosition = startPosition + expression.getIdentifier().length() + (expression.hasSpaceAfterIdentifier() ? 1 : 0);
            this.addProblem((Expression)expression, startPosition, endPosition, missingConditionalExpressionMessageKey, new String[0]);
        } else {
            Expression conditionalExpression = expression.getConditionalExpression();
            if (this.getChildren(conditionalExpression).size() > 1) {
                int startPosition = this.position(conditionalExpression);
                int endPosition = startPosition + this.length(conditionalExpression);
                this.addProblem((Expression)expression, startPosition, endPosition, invalidConditionalExpressionMessageKey, new String[0]);
            } else {
                if (!this.isValid(conditionalExpression, "conditional_expression")) {
                    int startPosition = this.position(conditionalExpression);
                    int endPosition = startPosition + this.length(conditionalExpression);
                    this.addProblem((Expression)expression, startPosition, endPosition, invalidConditionalExpressionMessageKey, new String[0]);
                }
                conditionalExpression.accept(this);
            }
        }
    }

    protected <T extends AbstractDoubleEncapsulatedExpression> void validateAbstractDoubleEncapsulatedExpression(T expression, AbstractDoubleEncapsulatedExpressionHelper<T> helper) {
        int startPosition;
        String identifier = helper.identifier(expression);
        if (!helper.hasLeftParenthesis(expression)) {
            startPosition = this.position(expression) + identifier.length();
            this.addProblem(expression, startPosition, helper.leftParenthesisMissingKey(expression), new String[0]);
        } else {
            int endPosition;
            if (!helper.hasFirstExpression(expression)) {
                startPosition = this.position(expression) + identifier.length() + 1;
                this.addProblem(expression, startPosition, helper.firstExpressionMissingKey(), new String[0]);
            } else if (!helper.isFirstExpressionValid(expression)) {
                startPosition = this.position(expression) + identifier.length() + 1;
                endPosition = startPosition + helper.firstExpressionLength(expression);
                this.addProblem(expression, startPosition, endPosition, helper.firstExpressionInvalidKey(), new String[0]);
            } else {
                expression.getFirstExpression().accept(this);
            }
            if (!helper.hasComma(expression)) {
                startPosition = this.position(expression) + identifier.length() + 1 + helper.firstExpressionLength(expression);
                this.addProblem(expression, startPosition, helper.missingCommaKey(), new String[0]);
            } else if (!helper.hasSecondExpression(expression)) {
                startPosition = this.position(expression) + identifier.length() + 1 + helper.firstExpressionLength(expression) + (expression.hasComma() ? 1 : 0) + (expression.hasSpaceAfterComma() ? 1 : 0);
                this.addProblem(expression, startPosition, helper.secondExpressionMissingKey(), new String[0]);
            } else if (!helper.isSecondExpressionValid(expression)) {
                startPosition = this.position(expression) + identifier.length() + 1 + helper.firstExpressionLength(expression) + (expression.hasComma() ? 1 : 0) + (expression.hasSpaceAfterComma() ? 1 : 0);
                endPosition = startPosition + helper.secondExpressionLength(expression);
                this.addProblem(expression, startPosition, endPosition, helper.secondExpressionInvalidKey(), new String[0]);
            } else {
                expression.getSecondExpression().accept(this);
            }
        }
        if (!helper.hasRightParenthesis(expression)) {
            startPosition = this.position(expression) + identifier.length() + 1 + helper.firstExpressionLength(expression) + (expression.hasComma() ? 1 : 0) + (expression.hasSpaceAfterComma() ? 1 : 0) + this.length(expression.getSecondExpression());
            this.addProblem(expression, startPosition, helper.rightParenthesisMissingKey(expression), new String[0]);
        }
    }

    protected void validateAbstractFromClause(AbstractFromClause expression) {
        if (!expression.hasDeclaration()) {
            int startPosition = this.position(expression) + 4 + (expression.hasSpaceAfterFrom() ? 1 : 0);
            this.addProblem((Expression)expression, startPosition, "ABSTRACT_FROM_CLAUSE_MISSING_IDENTIFICATION_VARIABLE_DECLARATION", new String[0]);
        } else {
            Expression declaration = expression.getDeclaration();
            this.validateCollectionSeparatedByComma(declaration, "ABSTRACT_FROM_CLAUSE_IDENTIFICATION_VARIABLE_DECLARATION_ENDS_WITH_COMMA", "ABSTRACT_FROM_CLAUSE_IDENTIFICATION_VARIABLE_DECLARATION_IS_MISSING_COMMA");
            declaration.accept(this);
        }
    }

    protected void validateAbstractSelectClause(AbstractSelectClause expression, boolean multipleSelectItemsAllowed) {
        if (!expression.hasSelectExpression()) {
            int startPosition = this.position(expression) + 6 + (expression.hasSpaceAfterSelect() ? 1 : 0) + (expression.hasDistinct() ? 8 : 0) + (expression.hasSpaceAfterDistinct() ? 1 : 0);
            this.addProblem((Expression)expression, startPosition, "ABSTRACT_SELECT_CLAUSE_MISSING_SELECT_EXPRESSION", new String[0]);
        } else {
            Expression selectExpression = expression.getSelectExpression();
            if (this.isCollectionExpression(selectExpression)) {
                if (!multipleSelectItemsAllowed) {
                    int startPosition = this.position(expression) + 6 + (expression.hasSpaceAfterSelect() ? 1 : 0) + (expression.hasDistinct() ? 8 : 0) + (expression.hasSpaceAfterDistinct() ? 1 : 0);
                    int endPosition = startPosition + this.length(selectExpression);
                    this.addProblem(selectExpression, startPosition, endPosition, "SIMPLE_SELECT_CLAUSE_NOT_SINGLE_EXPRESSION", new String[0]);
                } else {
                    selectExpression.accept(this);
                }
            } else if (!this.isValid(selectExpression, expression.selectItemBNF())) {
                int startPosition = this.position(expression) + 6 + (expression.hasSpaceAfterSelect() ? 1 : 0) + (expression.hasDistinct() ? 8 : 0) + (expression.hasSpaceAfterDistinct() ? 1 : 0);
                int endPosition = startPosition + this.length(selectExpression);
                this.addProblem((Expression)expression, startPosition, endPosition, "ABSTRACT_SELECT_CLAUSE_INVALID_SELECT_EXPRESSION", new String[0]);
            } else {
                selectExpression.accept(this);
            }
        }
    }

    protected void validateAbstractSelectStatement(AbstractSelectStatement expression) {
        if (!expression.hasFromClause()) {
            int startPosition = this.position(expression) + this.length(expression.getSelectClause()) + (expression.hasSpaceAfterSelect() ? 1 : 0);
            this.addProblem((Expression)expression, startPosition, "ABSTRACT_SELECT_STATEMENT_FROM_CLAUSE_MSSING", new String[0]);
        }
    }

    protected <T extends AbstractSingleEncapsulatedExpression> void validateAbstractSingleEncapsulatedExpression(T expression, AbstractSingleEncapsulatedExpressionHelper<T> helper) {
        int startPosition;
        String identifier = helper.identifier(expression);
        if (!helper.hasLeftParenthesis(expression)) {
            startPosition = this.position(expression) + identifier.length();
            this.addProblem(expression, startPosition, helper.leftParenthesisMissingKey(expression), helper.arguments(expression));
        } else if (helper.isEncapsulatedExpressionMissing(expression)) {
            startPosition = this.position(expression) + identifier.length() + 1 + helper.lengthBeforeEncapsulatedExpression(expression);
            this.addProblem(expression, startPosition, helper.encapsulatedExpressionMissingKey(expression), helper.arguments(expression));
        } else if (!helper.isEncapsulatedExpressionValid(expression)) {
            startPosition = this.position(expression) + identifier.length() + 1 + helper.lengthBeforeEncapsulatedExpression(expression);
            int endPosition = startPosition + helper.encapsulatedExpressionLength(expression);
            this.addProblem(expression, startPosition, endPosition, helper.encapsulatedExpressionInvalidKey(expression), helper.arguments(expression));
        } else {
            super.visit(expression);
        }
        if (!helper.hasRightParenthesis(expression)) {
            startPosition = this.position(expression) + this.length(expression);
            this.addProblem(expression, startPosition, helper.rightParenthesisMissingKey(expression), helper.arguments(expression));
        }
    }

    protected <T extends AbstractTripleEncapsulatedExpression> void validateAbstractTripleEncapsulatedExpression(T expression, AbstractTripleEncapsulatedExpressionHelper<T> helper) {
        int startPosition;
        String identifier = helper.identifier(expression);
        if (!helper.hasLeftParenthesis(expression)) {
            startPosition = this.position(expression) + identifier.length();
            this.addProblem(expression, startPosition, helper.leftParenthesisMissingKey(expression), new String[0]);
        } else {
            int endPosition;
            if (!helper.hasFirstExpression(expression)) {
                startPosition = this.position(expression) + identifier.length() + 1;
                this.addProblem(expression, startPosition, helper.firstExpressionMissingKey(), new String[0]);
            } else if (!helper.isFirstExpressionValid(expression)) {
                startPosition = this.position(expression) + identifier.length() + 1;
                endPosition = startPosition + helper.firstExpressionLength(expression);
                this.addProblem(expression, startPosition, endPosition, helper.firstExpressionInvalidKey(), new String[0]);
            } else {
                expression.getFirstExpression().accept(this);
            }
            if (helper.hasFirstExpression(expression) && !expression.hasFirstComma()) {
                startPosition = this.position(expression) + identifier.length() + 1 + helper.firstExpressionLength(expression);
                this.addProblem(expression, startPosition, helper.firstCommaMissingKey(), new String[0]);
            }
            if (expression.hasFirstComma()) {
                if (!helper.hasSecondExpression(expression)) {
                    startPosition = this.position(expression) + identifier.length() + 1 + helper.firstExpressionLength(expression) + (expression.hasFirstComma() ? 1 : 0) + (expression.hasSpaceAfterFirstComma() ? 1 : 0);
                    this.addProblem(expression, startPosition, helper.secondExpressionMissingKey(), new String[0]);
                } else if (!helper.isSecondExpressionValid(expression)) {
                    startPosition = this.position(expression) + identifier.length() + 1 + helper.firstExpressionLength(expression) + (expression.hasFirstComma() ? 1 : 0) + (expression.hasSpaceAfterFirstComma() ? 1 : 0);
                    endPosition = startPosition + helper.secondExpressionLength(expression);
                    this.addProblem(expression, startPosition, endPosition, helper.secondExpressionInvalidKey(), new String[0]);
                } else {
                    expression.getSecondExpression().accept(this);
                }
            }
            if (helper.hasSecondExpression(expression) && !expression.hasSecondComma() && helper.hasThirdExpression(expression)) {
                startPosition = this.position(expression) + identifier.length() + 1 + helper.firstExpressionLength(expression) + (expression.hasFirstComma() ? 1 : 0) + (expression.hasSpaceAfterFirstComma() ? 1 : 0) + helper.secondExpressionLength(expression);
                this.addProblem(expression, startPosition, helper.secondCommaMissingKey(), new String[0]);
            }
            if (expression.hasSecondComma()) {
                if (!helper.hasThirdExpression(expression)) {
                    startPosition = this.position(expression) + identifier.length() + 1 + helper.firstExpressionLength(expression) + (expression.hasFirstComma() ? 1 : 0) + (expression.hasSpaceAfterFirstComma() ? 1 : 0) + helper.secondExpressionLength(expression) + (expression.hasSecondComma() ? 1 : 0) + (expression.hasSpaceAfterSecondComma() ? 1 : 0);
                    this.addProblem(expression, startPosition, helper.thirdExpressionMissingKey(), new String[0]);
                } else if (!helper.isThirdExpressionValid(expression)) {
                    startPosition = this.position(expression) + identifier.length() + 1 + helper.firstExpressionLength(expression) + (expression.hasFirstComma() ? 1 : 0) + (expression.hasSpaceAfterFirstComma() ? 1 : 0) + helper.secondExpressionLength(expression) + (expression.hasSecondComma() ? 1 : 0) + (expression.hasSpaceAfterSecondComma() ? 1 : 0);
                    endPosition = startPosition + helper.thirdExpressionLength(expression);
                    this.addProblem(expression, startPosition, endPosition, helper.thirdExpressionInvalidKey(), new String[0]);
                } else {
                    expression.getThirdExpression().accept(this);
                }
            }
        }
        if (!helper.hasRightParenthesis(expression)) {
            startPosition = this.position(expression) + identifier.length() + 1 + helper.firstExpressionLength(expression) + (expression.hasFirstComma() ? 1 : 0) + (expression.hasSpaceAfterFirstComma() ? 1 : 0) + helper.secondExpressionLength(expression) + (expression.hasSecondComma() ? 1 : 0) + (expression.hasSpaceAfterSecondComma() ? 1 : 0) + helper.thirdExpressionLength(expression);
            this.addProblem(expression, startPosition, helper.rightParenthesisMissingKey(expression), new String[0]);
        }
    }

    protected <T extends AggregateFunction> void validateAggregateFunctionLocation(T expression, AbstractSingleEncapsulatedExpressionHelper<T> helper) {
        AbstractValidator.OwningClauseVisitor visitor = this.getOwningClauseVisitor();
        boolean valid = true;
        try {
            expression.accept(visitor);
            valid = visitor.selectClause != null || visitor.simpleSelectClause != null || visitor.groupByClause != null || visitor.orderByClause != null || visitor.havingClause != null;
        }
        finally {
            visitor.dispose();
        }
        if (!valid) {
            int startPosition = this.position(expression);
            int endPosition = startPosition + this.length(expression);
            this.addProblem(expression, startPosition, endPosition, "AGGREGATE_FUNCTION_WRONG_CLAUSE", expression.getIdentifier());
        } else {
            this.validateAbstractSingleEncapsulatedExpression(expression, helper);
        }
    }

    protected void validateArithmeticExpression(ArithmeticExpression expression) {
        this.validateCompoundExpression(expression, expression.getArithmeticSign(), "ARITHMETIC_EXPRESSION_MISSING_LEFT_EXPRESSION", "ARITHMETIC_EXPRESSION_INVALID_LEFT_EXPRESSION", "ARITHMETIC_EXPRESSION_MISSING_RIGHT_EXPRESSION", "ARITHMETIC_EXPRESSION_INVALID_RIGHT_EXPRESSION", "arithmetic_expression", "arithmetic_term");
    }

    protected void validateCollectionSeparatedByComma(Expression expression, String endsWithCommaProblemKey, String missingCommaProblemKey) {
        CollectionSeparatedByCommaValidator validator = this.collectionSeparatedByCommaValidator();
        try {
            validator.endsWithCommaProblemKey = endsWithCommaProblemKey;
            validator.wrongSeparatorProblemKey = missingCommaProblemKey;
            expression.accept(validator);
        }
        finally {
            validator.endsWithCommaProblemKey = null;
            validator.wrongSeparatorProblemKey = null;
        }
    }

    protected void validateCollectionSeparatedBySpace(Expression expression, String endsWithCommaProblemKey, String hasCommaProblemKey) {
        CollectionSeparatedBySpaceValidator validator = this.collectionSeparatedBySpaceValidator();
        try {
            validator.endsWithCommaProblemKey = endsWithCommaProblemKey;
            validator.wrongSeparatorProblemKey = hasCommaProblemKey;
            expression.accept(validator);
        }
        finally {
            validator.endsWithCommaProblemKey = null;
            validator.wrongSeparatorProblemKey = null;
        }
    }

    protected void validateCompoundExpression(CompoundExpression expression, String identifier, String missingLeftExpression, String invalidLeftExpression, String missingRightExpression, String invalidRightExpression, String leftExpressionQueryBNF, String rightExpressionQueryBNF) {
        int endPosition;
        int startPosition;
        int startPosition2;
        if (!expression.hasLeftExpression()) {
            startPosition2 = this.position(expression);
            this.addProblem((Expression)expression, startPosition2, missingLeftExpression, new String[0]);
        } else {
            Expression leftExpression = expression.getLeftExpression();
            if (!this.isValid(leftExpression, leftExpressionQueryBNF)) {
                startPosition = this.position(expression);
                endPosition = startPosition + this.length(leftExpression);
                this.addProblem((Expression)expression, startPosition, endPosition, invalidLeftExpression, new String[0]);
            } else {
                leftExpression.accept(this);
            }
        }
        if (!expression.hasRightExpression()) {
            startPosition2 = this.position(expression) + this.length(expression.getLeftExpression()) + (expression.hasLeftExpression() ? 1 : 0) + identifier.length() + (expression.hasSpaceAfterIdentifier() ? 1 : 0);
            this.addProblem((Expression)expression, startPosition2, missingRightExpression, new String[0]);
        } else {
            Expression rightExpression = expression.getRightExpression();
            if (!this.isValid(rightExpression, rightExpressionQueryBNF)) {
                startPosition = this.position(expression) + this.length(expression.getLeftExpression()) + (expression.hasLeftExpression() ? 1 : 0) + identifier.length() + (expression.hasSpaceAfterIdentifier() ? 1 : 0);
                endPosition = startPosition + this.length(rightExpression);
                this.addProblem((Expression)expression, startPosition, endPosition, invalidRightExpression, new String[0]);
            } else {
                rightExpression.accept(this);
            }
        }
    }

    protected void validateIdentificationVariableDeclaration(IdentificationVariableDeclaration expression) {
        if (!expression.hasRangeVariableDeclaration()) {
            this.addProblem((Expression)expression, this.position(expression), "IDENTIFICATION_VARIABLE_DECLARATION_MISSING_RANGE_VARIABLE_DECLARATION", new String[0]);
        } else {
            expression.getRangeVariableDeclaration().accept(this);
        }
        this.validateJoins(expression);
    }

    protected void validateIdentifier(Expression expression, String variableName, int variableLength, String reservedWordProblemKey, String invalidJavaIdentifierProblemKey) {
        if (this.getExpressionRegistry().isIdentifier(variableName)) {
            int startPosition = this.position(expression);
            int endPosition = startPosition + variableLength;
            this.addProblem(expression, startPosition, endPosition, reservedWordProblemKey, variableName);
        } else if (!this.isValidJavaIdentifier(variableName)) {
            int startPosition = this.position(expression);
            int endPosition = startPosition + variableLength;
            this.addProblem(expression, startPosition, endPosition, invalidJavaIdentifierProblemKey, variableName);
        }
    }

    protected void validateInputParameters(JPQLExpression expression) {
        int positionalCount = 0;
        int namedCount = 0;
        for (InputParameter inputParameter : this.inputParameters) {
            if (inputParameter.isNamed()) {
                ++namedCount;
                continue;
            }
            if (!inputParameter.isPositional()) continue;
            ++positionalCount;
        }
        if (positionalCount > 0 && namedCount > 0) {
            for (InputParameter parameter : this.inputParameters) {
                this.addProblem(parameter, "INPUT_PARAMETER_MIXTURE");
            }
        }
    }

    protected void validateJoins(IdentificationVariableDeclaration expression) {
        if (expression.hasJoins()) {
            Expression joins = expression.getJoins();
            List<Expression> children = this.getChildren(joins);
            if (children.size() > 1) {
                this.validateCollectionSeparatedBySpace(joins, "IDENTIFICATION_VARIABLE_DECLARATION_JOINS_END_WITH_COMMA", "IDENTIFICATION_VARIABLE_DECLARATION_JOINS_HAS_COMMA");
                int index = children.size();
                while (--index >= 0) {
                    Expression child = children.get(index);
                    child.accept(this);
                }
            } else {
                joins.accept(this);
            }
        }
    }

    protected void validateLikeExpressionEscapeCharacter(LikeExpression expression) {
        Expression escapeCharacter = expression.getEscapeCharacter();
        String character = this.literal(escapeCharacter, LiteralType.STRING_LITERAL);
        if (character.length() > 0 && ExpressionTools.isQuote(character.charAt(0))) {
            if ((character = ExpressionTools.unquote(character)).length() != 1) {
                int startPosition = this.position(expression) + this.length(expression.getStringExpression()) + (expression.hasSpaceAfterStringExpression() ? 1 : 0) + (expression.hasNot() ? 4 : 0) + 4 + (expression.hasSpaceAfterLike() ? 1 : 0) + this.length(expression.getPatternValue()) + (expression.hasSpaceAfterPatternValue() ? 1 : 0) + 6 + (expression.hasSpaceAfterEscape() ? 1 : 0);
                int endPosition = startPosition + this.length(escapeCharacter);
                this.addProblem((Expression)expression, startPosition, endPosition, "LIKE_EXPRESSION_INVALID_ESCAPE_CHARACTER", escapeCharacter.toActualText());
            }
        } else {
            character = this.literal(escapeCharacter, LiteralType.INPUT_PARAMETER);
            if (character.length() == 0 && !this.isValid(escapeCharacter, "like_escape")) {
                int startPosition = this.position(expression) + this.length(expression.getStringExpression()) + 4 + (expression.hasSpaceAfterStringExpression() ? 1 : 0) + (expression.hasNot() ? 1 : 0) + (expression.hasSpaceAfterLike() ? 1 : 0) + this.length(expression.getPatternValue()) + (expression.hasSpaceAfterPatternValue() ? 1 : 0) + 6 + (expression.hasSpaceAfterEscape() ? 1 : 0);
                int endPosition = startPosition + this.length(escapeCharacter);
                this.addProblem((Expression)expression, startPosition, endPosition, "LIKE_EXPRESSION_INVALID_ESCAPE_CHARACTER", escapeCharacter.toActualText());
            }
        }
    }

    protected void validateLogicalExpression(LogicalExpression expression, String leftExpressionQueryBNF, String rightExpressionQueryBNF) {
        this.validateCompoundExpression(expression, expression.getIdentifier(), "LOGICAL_EXPRESSION_MISSING_LEFT_EXPRESSION", "LOGICAL_EXPRESSION_INVALID_LEFT_EXPRESSION", "LOGICAL_EXPRESSION_MISSING_RIGHT_EXPRESSION", "LOGICAL_EXPRESSION_INVALID_RIGHT_EXPRESSION", leftExpressionQueryBNF, rightExpressionQueryBNF);
    }

    protected void validateOwningClause(InputParameter expression, String parameter) {
        if (!this.isInputParameterInValidLocation(expression)) {
            int startPosition = this.position(expression);
            int endPosition = startPosition + parameter.length();
            this.addProblem((Expression)expression, startPosition, endPosition, "INPUT_PARAMETER_WRONG_CLAUSE_DECLARATION", new String[0]);
        }
    }

    protected void validatePathExpression(AbstractPathExpression expression) {
        if (!expression.hasIdentificationVariable() && !expression.hasVirtualIdentificationVariable()) {
            this.addProblem(expression, "ABSTRACT_PATH_EXPRESSION_MISSING_IDENTIFICATION_VARIABLE");
        } else {
            expression.getIdentificationVariable().accept(this);
        }
        if (expression.endsWithDot()) {
            this.addProblem(expression, "ABSTRACT_PATH_EXPRESSION_CANNOT_END_WITH_COMMA");
        }
    }

    protected void validateSimpleSelectStatement(SimpleSelectStatement expression) {
        this.validateAbstractSelectStatement(expression);
    }

    protected AbstractSingleEncapsulatedExpressionHelper<ValueExpression> valueExpressionHelper() {
        AbstractSingleEncapsulatedExpressionHelper<ValueExpression> helper = (AbstractSingleEncapsulatedExpressionHelper<ValueExpression>)this.getHelper("VALUE");
        if (helper == null) {
            helper = this.buildValueExpressionHelper();
            this.registerHelper("VALUE", helper);
        }
        return helper;
    }

    @Override
    public void visit(AbsExpression expression) {
        this.validateAbstractSingleEncapsulatedExpression(expression, this.absExpressionHelper());
    }

    @Override
    public void visit(AbstractSchemaName expression) {
        super.visit(expression);
    }

    @Override
    public void visit(AdditionExpression expression) {
        this.validateArithmeticExpression(expression);
    }

    @Override
    public void visit(AllOrAnyExpression expression) {
        this.validateAbstractSingleEncapsulatedExpression(expression, this.allOrAnyExpressionHelper());
        if (!this.isChildOfComparisonExpession(expression)) {
            this.addProblem(expression, "ALL_OR_ANY_EXPRESSION_NOT_PART_OF_COMPARISON_EXPRESSION");
        }
    }

    @Override
    public void visit(AndExpression expression) {
        this.validateLogicalExpression(expression, "conditional_expression", "conditional_expression");
    }

    @Override
    public void visit(ArithmeticFactor expression) {
        if (!expression.hasExpression()) {
            int startPosition = this.position(expression) + 1;
            this.addProblem((Expression)expression, startPosition, "ARITHMETIC_FACTOR_MISSING_EXPRESSION", new String[0]);
        } else {
            Expression arithmeticExpression = expression.getExpression();
            if (!this.isValid(arithmeticExpression, "arithmetic_primary")) {
                int startIndex;
                int endIndex = startIndex = this.position(expression) + 1;
                this.addProblem((Expression)expression, startIndex, endIndex, "ARITHMETIC_FACTOR_INVALID_EXPRESSION", new String[0]);
            } else {
                arithmeticExpression.accept(this);
            }
        }
    }

    @Override
    public void visit(AvgFunction expression) {
        this.validateAggregateFunctionLocation(expression, this.avgFunctionHelper());
    }

    @Override
    public void visit(BadExpression expression) {
        int startPosition = this.position(expression);
        int endPosition = startPosition + this.length(expression);
        this.addProblem((Expression)expression, startPosition, endPosition, "BAD_EXPRESSION_INVALID_EXPRESSION", new String[0]);
    }

    @Override
    public void visit(BetweenExpression expression) {
        int startPosition;
        if (!expression.hasExpression()) {
            startPosition = this.position(expression);
            this.addProblem((Expression)expression, startPosition, "BETWEEN_EXPRESSION_MISSING_EXPRESSION", new String[0]);
        }
        if (!expression.hasLowerBoundExpression()) {
            startPosition = this.position(expression) + this.length(expression.getExpression()) + (expression.hasExpression() ? 1 : 0) + (expression.hasNot() ? 11 : 7) + (expression.hasSpaceAfterBetween() ? 1 : 0);
            this.addProblem((Expression)expression, startPosition, "BETWEEN_EXPRESSION_MISSING_LOWER_BOUND_EXPRESSION", new String[0]);
        } else if (!expression.hasAnd()) {
            startPosition = this.position(expression) + this.length(expression.getExpression()) + (expression.hasExpression() ? 1 : 0) + (expression.hasNot() ? 11 : 7) + (expression.hasSpaceAfterBetween() ? 1 : 0) + this.length(expression.getLowerBoundExpression()) + (expression.hasSpaceAfterLowerBound() ? 1 : 0);
            this.addProblem((Expression)expression, startPosition, "BETWEEN_EXPRESSION_MISSING_AND", new String[0]);
        } else if (!expression.hasUpperBoundExpression()) {
            startPosition = this.position(expression) + this.length(expression.getExpression()) + (expression.hasExpression() ? 1 : 0) + (expression.hasNot() ? 11 : 7) + (expression.hasSpaceAfterBetween() ? 1 : 0) + this.length(expression.getLowerBoundExpression()) + (expression.hasSpaceAfterLowerBound() ? 1 : 0) + 3 + (expression.hasSpaceAfterAnd() ? 1 : 0);
            this.addProblem((Expression)expression, startPosition, "BETWEEN_EXPRESSION_MISSING_UPPER_BOUND_EXPRESSION", new String[0]);
        }
        super.visit(expression);
    }

    @Override
    public void visit(CaseExpression expression) {
        if (this.isJPA1_0()) {
            this.addProblem(expression, "CASE_EXPRESSION_INVALID_JPA_VERSION");
        } else {
            int startPosition;
            if (expression.hasWhenClauses()) {
                this.validateCollectionSeparatedBySpace(expression.getWhenClauses(), "CASE_EXPRESSION_WHEN_CLAUSES_END_WITH_COMMA", "CASE_EXPRESSION_WHEN_CLAUSES_HAS_COMMA");
            } else {
                startPosition = this.position(expression) + 4 + (expression.hasSpaceAfterCase() ? 1 : 0) + this.length(expression.getCaseOperand()) + (expression.hasSpaceAfterCaseOperand() ? 1 : 0);
                this.addProblem((Expression)expression, startPosition, "CASE_EXPRESSION_MISSING_WHEN_CLAUSE", new String[0]);
            }
            if (expression.hasWhenClauses() && !expression.hasElse()) {
                startPosition = this.position(expression) + 4 + (expression.hasSpaceAfterCase() ? 1 : 0) + this.length(expression.getCaseOperand()) + (expression.hasSpaceAfterCaseOperand() ? 1 : 0) + this.length(expression.getWhenClauses()) + (expression.hasSpaceAfterWhenClauses() ? 1 : 0);
                this.addProblem((Expression)expression, startPosition, "CASE_EXPRESSION_MISSING_ELSE_IDENTIFIER", new String[0]);
            } else if (expression.hasElse() && !expression.hasElseExpression()) {
                startPosition = this.position(expression) + 4 + (expression.hasSpaceAfterCase() ? 1 : 0) + this.length(expression.getCaseOperand()) + (expression.hasSpaceAfterCaseOperand() ? 1 : 0) + this.length(expression.getWhenClauses()) + (expression.hasSpaceAfterWhenClauses() ? 1 : 0) + 4 + (expression.hasSpaceAfterElse() ? 1 : 0);
                this.addProblem((Expression)expression, startPosition, "CASE_EXPRESSION_MISSING_ELSE_EXPRESSION", new String[0]);
            } else if (expression.hasElseExpression() && !expression.hasEnd()) {
                startPosition = this.position(expression) + 4 + (expression.hasSpaceAfterCase() ? 1 : 0) + this.length(expression.getCaseOperand()) + (expression.hasSpaceAfterCaseOperand() ? 1 : 0) + this.length(expression.getWhenClauses()) + (expression.hasSpaceAfterWhenClauses() ? 1 : 0) + 4 + (expression.hasSpaceAfterElse() ? 1 : 0) + this.length(expression.getElseExpression()) + (expression.hasSpaceAfterElseExpression() ? 1 : 0);
                this.addProblem((Expression)expression, startPosition, "CASE_EXPRESSION_MISSING_END_IDENTIFIER", new String[0]);
            }
            super.visit(expression);
        }
    }

    @Override
    public void visit(CoalesceExpression expression) {
        if (this.isJPA1_0()) {
            this.addProblem(expression, "COALESCE_EXPRESSION_INVALID_JPA_VERSION");
        } else {
            this.validateAbstractSingleEncapsulatedExpression(expression, this.coalesceExpressionHelper());
        }
    }

    @Override
    public void visit(CollectionExpression expression) {
        super.visit(expression);
    }

    @Override
    public void visit(CollectionMemberDeclaration expression) {
        if (this.isOwnedByFromClause(expression)) {
            int startPosition;
            if (!expression.hasLeftParenthesis()) {
                startPosition = this.position(expression) + 2;
                this.addProblem((Expression)expression, startPosition, "COLLECTION_MEMBER_DECLARATION_MISSING_LEFT_PARENTHESIS", new String[0]);
            } else if (!expression.hasCollectionValuedPathExpression()) {
                startPosition = this.position(expression) + 3;
                this.addProblem((Expression)expression, startPosition, "COLLECTION_MEMBER_DECLARATION_MISSING_COLLECTION_VALUED_PATH_EXPRESSION", new String[0]);
            } else if (!expression.hasRightParenthesis()) {
                startPosition = this.position(expression) + 2 + (expression.hasLeftParenthesis() ? 1 : 0) + (expression.hasSpaceAfterIn() ? 1 : 0) + this.length(expression.getCollectionValuedPathExpression());
                this.addProblem((Expression)expression, startPosition, "COLLECTION_MEMBER_DECLARATION_MISSING_RIGHT_PARENTHESIS", new String[0]);
            }
            if (expression.hasRightParenthesis() && !expression.hasIdentificationVariable()) {
                startPosition = this.position(expression) + 2 + (expression.hasLeftParenthesis() ? 1 : 0) + (expression.hasSpaceAfterIn() ? 1 : 0) + this.length(expression.getCollectionValuedPathExpression()) + 1 + (expression.hasSpaceAfterRightParenthesis() ? 1 : 0) + (expression.hasAs() ? 2 : 0) + (expression.hasSpaceAfterAs() ? 1 : 0);
                this.addProblem((Expression)expression, startPosition, "COLLECTION_MEMBER_DECLARATION_MISSING_IDENTIFICATION_VARIABLE", new String[0]);
            }
        } else {
            int startPosition;
            if (!expression.hasLeftParenthesis() && expression.hasRightParenthesis()) {
                startPosition = this.position(expression) + 2;
                this.addProblem((Expression)expression, startPosition, "COLLECTION_MEMBER_DECLARATION_MISSING_LEFT_PARENTHESIS", new String[0]);
            } else if (!expression.hasCollectionValuedPathExpression()) {
                startPosition = this.position(expression) + 2 + (expression.hasSpaceAfterIn() ? 1 : 0);
                this.addProblem((Expression)expression, startPosition, "COLLECTION_MEMBER_DECLARATION_MISSING_COLLECTION_VALUED_PATH_EXPRESSION", new String[0]);
            } else if (expression.hasLeftParenthesis() && !expression.hasRightParenthesis()) {
                startPosition = this.position(expression) + 2 + (expression.hasLeftParenthesis() ? 1 : 0) + (expression.hasSpaceAfterIn() ? 1 : 0) + this.length(expression.getCollectionValuedPathExpression());
                this.addProblem((Expression)expression, startPosition, "COLLECTION_MEMBER_DECLARATION_MISSING_RIGHT_PARENTHESIS", new String[0]);
            }
            if (expression.hasRightParenthesis() && !expression.hasIdentificationVariable()) {
                startPosition = this.position(expression) + 2 + (expression.hasLeftParenthesis() ? 1 : 0) + (expression.hasSpaceAfterIn() ? 1 : 0) + this.length(expression.getCollectionValuedPathExpression()) + 1 + (expression.hasSpaceAfterRightParenthesis() ? 1 : 0) + (expression.hasAs() ? 2 : 0) + (expression.hasSpaceAfterAs() ? 1 : 0);
                this.addProblem((Expression)expression, startPosition, "COLLECTION_MEMBER_DECLARATION_MISSING_IDENTIFICATION_VARIABLE", new String[0]);
            }
        }
        super.visit(expression);
    }

    @Override
    public void visit(CollectionMemberExpression expression) {
        int startPosition;
        if (!expression.hasEntityExpression()) {
            startPosition = this.position(expression);
            this.addProblem((Expression)expression, startPosition, "COLLECTION_MEMBER_EXPRESSION_MISSING_ENTITY_EXPRESSION", new String[0]);
        }
        if (!expression.hasCollectionValuedPathExpression()) {
            startPosition = this.position(expression) + this.length(expression.getEntityExpression()) + (expression.hasEntityExpression() ? 1 : 0) + (expression.hasNot() ? 4 : 0) + 6 + (expression.hasSpaceAfterMember() ? 1 : 0) + (expression.hasOf() ? 2 : 0) + (expression.hasSpaceAfterOf() ? 1 : 0);
            this.addProblem((Expression)expression, startPosition, "COLLECTION_MEMBER_EXPRESSION_MISSING_COLLECTION_VALUED_PATH_EXPRESSION", new String[0]);
        } else {
            Expression pathExpression = expression.getCollectionValuedPathExpression();
            if (!this.isValid(pathExpression, "collection_valued_path_expression")) {
                int startPosition2 = this.position(expression) + this.length(expression.getEntityExpression()) + (expression.hasEntityExpression() ? 1 : 0) + (expression.hasNot() ? 4 : 0) + 6 + (expression.hasSpaceAfterMember() ? 1 : 0) + (expression.hasOf() ? 2 : 0) + (expression.hasSpaceAfterOf() ? 1 : 0);
                int endPosition = startPosition2 + this.length(pathExpression);
                this.addProblem((Expression)expression, startPosition2, endPosition, "COLLECTION_VALUED_PATH_EXPRESSION_NOT_COLLECTION_TYPE", expression.toParsedText());
            }
        }
        super.visit(expression);
    }

    @Override
    public void visit(CollectionValuedPathExpression expression) {
        this.validatePathExpression(expression);
    }

    @Override
    public void visit(ComparisonExpression expression) {
        int startPosition;
        if (!expression.hasLeftExpression()) {
            startPosition = this.position(expression);
            this.addProblem((Expression)expression, startPosition, "COMPARISON_EXPRESSION_MISSING_LEFT_EXPRESSION", new String[0]);
        }
        if (!expression.hasRightExpression()) {
            startPosition = this.position(expression) + (expression.hasLeftExpression() ? 1 : 0) + this.length(expression.getLeftExpression()) + expression.getComparisonOperator().length() + (expression.hasSpaceAfterIdentifier() ? 1 : 0);
            this.addProblem((Expression)expression, startPosition, "COMPARISON_EXPRESSION_MISSING_RIGHT_EXPRESSION", new String[0]);
        }
        super.visit(expression);
    }

    @Override
    public void visit(ConcatExpression expression) {
        this.validateAbstractSingleEncapsulatedExpression(expression, this.concatExpressionHelper());
        if (expression.hasLeftParenthesis() && expression.hasExpression()) {
            CollectionExpression collectionExpression = this.getCollectionExpression(expression.getExpression());
            if (collectionExpression == null) {
                this.addProblem(expression, "CONCAT_EXPRESSION_MISSING_EXPRESSION");
            } else {
                for (Expression child : collectionExpression.children()) {
                    if (this.isValid(child, expression.encapsulatedExpressionBNF())) continue;
                    this.addProblem(child, "CONCAT_EXPRESSION_INVALID_EXPRESSION", child.toParsedText());
                }
            }
        }
    }

    @Override
    public void visit(ConstructorExpression expression) {
        String className = expression.getClassName();
        if (className.length() == 0) {
            int startPosition = this.position(expression) + 3 + (expression.hasSpaceAfterNew() ? 1 : 0);
            this.addProblem((Expression)expression, startPosition, "CONSTRUCTOR_EXPRESSION_MISSING_CONSTRUCTOR_NAME", new String[0]);
        } else if (!expression.hasLeftParenthesis()) {
            int startPosition = this.position(expression) + 3 + (expression.hasSpaceAfterNew() ? 1 : 0) + className.length();
            this.addProblem((Expression)expression, startPosition, "CONSTRUCTOR_EXPRESSION_MISSING_LEFT_PARENTHESIS", new String[0]);
        } else {
            if (!expression.hasConstructorItems()) {
                int startPosition = this.position(expression) + 3 + (expression.hasSpaceAfterNew() ? 1 : 0) + className.length() + 1;
                this.addProblem((Expression)expression, startPosition, "CONSTRUCTOR_EXPRESSION_MISSING_CONSTRUCTOR_ITEM", new String[0]);
            } else {
                this.validateCollectionSeparatedByComma(expression.getConstructorItems(), "CONSTRUCTOR_EXPRESSION_CONSTRUCTOR_ITEM_ENDS_WITH_COMMA", "CONSTRUCTOR_EXPRESSION_CONSTRUCTOR_ITEM_IS_MISSING_COMMA");
                if (expression.hasLeftParenthesis() && expression.hasConstructorItems() && !expression.hasRightParenthesis()) {
                    int startPosition = this.position(expression) + 3 + (expression.hasSpaceAfterNew() ? 1 : 0) + className.length() + 1 + this.length(expression.getConstructorItems());
                    this.addProblem((Expression)expression, startPosition, "CONSTRUCTOR_EXPRESSION_MISSING_RIGHT_PARENTHESIS", new String[0]);
                }
            }
            super.visit(expression);
        }
    }

    @Override
    public void visit(CountFunction expression) {
        this.validateAggregateFunctionLocation(expression, this.countFunctionHelper());
    }

    @Override
    public void visit(DateTime expression) {
        String dateTime = expression.getText();
        if (dateTime.startsWith("{")) {
            int startPosition;
            int length = dateTime.length();
            if (!(dateTime.startsWith("{d ") || dateTime.startsWith("{t ") || dateTime.startsWith("{ts "))) {
                int endPosition = startPosition = this.position(expression) + 1;
                int index = 1;
                while (index < length) {
                    if (Character.isWhitespace(dateTime.charAt(index))) break;
                    ++endPosition;
                    ++index;
                }
                this.addProblem((Expression)expression, startPosition, endPosition, "DATE_TIME_JDBC_ESCAPE_FORMAT_INVALID_SPECIFICATION", new String[0]);
            } else if (!(dateTime.startsWith("{d '") || dateTime.startsWith("{t '") || dateTime.startsWith("{ts '"))) {
                startPosition = this.position(expression) + 1;
                int index = 1;
                while (index < length) {
                    ++startPosition;
                    if (Character.isWhitespace(dateTime.charAt(index))) break;
                    ++index;
                }
                this.addProblem((Expression)expression, startPosition, "DATE_TIME_JDBC_ESCAPE_FORMAT_MISSING_OPEN_QUOTE", new String[0]);
            }
            if (length > 1 && dateTime.charAt(length - (dateTime.endsWith("}") ? 2 : 1)) != '\'') {
                startPosition = this.position(expression) + length;
                if (dateTime.endsWith("}")) {
                    --startPosition;
                }
                this.addProblem((Expression)expression, startPosition, "DATE_TIME_JDBC_ESCAPE_FORMAT_MISSING_CLOSE_QUOTE", new String[0]);
            } else if (!dateTime.endsWith("}")) {
                startPosition = this.position(expression) + length;
                this.addProblem((Expression)expression, startPosition, "DATE_TIME_JDBC_ESCAPE_FORMAT_MISSING_RIGHT_CURLY_BRACE", new String[0]);
            }
        }
    }

    @Override
    public void visit(DeleteClause expression) {
        int startPosition;
        if (!expression.hasFrom()) {
            startPosition = 6 + (expression.hasSpaceAfterDelete() ? 1 : 0);
            this.addProblem((Expression)expression, startPosition, "DELETE_CLAUSE_FROM_MISSING", new String[0]);
        } else if (!expression.hasRangeVariableDeclaration()) {
            startPosition = 12;
            this.addProblem((Expression)expression, startPosition, "DELETE_CLAUSE_RANGE_VARIABLE_DECLARATION_MISSING", new String[0]);
        }
        if (expression.hasRangeVariableDeclaration()) {
            CollectionExpression collectionExpression = this.getCollectionExpression(expression.getRangeVariableDeclaration());
            if (collectionExpression != null) {
                Expression firstChild = collectionExpression.getChild(0);
                int startPosition2 = this.position(firstChild) + this.length(firstChild);
                int endPosition = this.position(collectionExpression) + this.length(collectionExpression);
                boolean malformed = false;
                int index = collectionExpression.childrenSize() - 1;
                while (--index >= 0) {
                    if (collectionExpression.hasComma(index)) continue;
                    malformed = true;
                }
                if (collectionExpression.toActualText().endsWith(" ")) {
                    --endPosition;
                }
                this.addProblem((Expression)expression, startPosition2, endPosition, malformed ? "DELETE_CLAUSE_RANGE_VARIABLE_DECLARATION_MALFORMED" : "DELETE_CLAUSE_MULTIPLE_RANGE_VARIABLE_DECLARATION", new String[0]);
            } else {
                super.visit(expression);
            }
        }
    }

    @Override
    public void visit(DeleteStatement expression) {
        super.visit(expression);
    }

    @Override
    public void visit(DivisionExpression expression) {
        this.validateArithmeticExpression(expression);
    }

    @Override
    public void visit(EmptyCollectionComparisonExpression expression) {
        if (!expression.hasExpression()) {
            int startPosition = this.position(expression);
            this.addProblem((Expression)expression, startPosition, "EMPTY_COLLECTION_COMPARISON_EXPRESSION_MISSING_EXPRESSION", new String[0]);
        } else {
            Expression pathExpression = expression.getExpression();
            if (!this.isValid(pathExpression, "collection_valued_path_expression")) {
                int startPosition = this.position(expression);
                int endPosition = startPosition + this.length(pathExpression);
                this.addProblem((Expression)expression, startPosition, endPosition, "COLLECTION_VALUED_PATH_EXPRESSION_NOT_COLLECTION_TYPE", expression.toParsedText());
            } else {
                super.visit(expression);
            }
        }
    }

    @Override
    public void visit(EntityTypeLiteral expression) {
        if (this.isJPA1_0()) {
            this.addProblem(expression, "ENTITY_TYPE_LITERAL_INVALID_JPA_VERSION");
        }
    }

    @Override
    public void visit(EntryExpression expression) {
        if (this.isJPA1_0()) {
            this.addProblem(expression, "ENTRY_EXPRESSION_INVALID_JPA_VERSION");
        } else {
            this.validateAbstractSingleEncapsulatedExpression(expression, this.entryExpressionHelper());
        }
    }

    @Override
    public void visit(ExistsExpression expression) {
        this.validateAbstractSingleEncapsulatedExpression(expression, this.existsExpressionHelper());
    }

    @Override
    public void visit(FromClause expression) {
        this.validateAbstractFromClause(expression);
    }

    @Override
    public void visit(FunctionExpression expression) {
        boolean validFunction;
        JPQLQueryBNF queryBNF = this.getQueryBNF(expression.getQueryBNF().getId());
        boolean bl = validFunction = queryBNF != null && queryBNF.hasIdentifier(expression.getIdentifier());
        if (!this.isJPA2_1() || !validFunction) {
            this.addProblem(expression, "FUNCTION_EXPRESSION_INVALID_JPA_VERSION");
        } else {
            String functionName;
            this.validateAbstractSingleEncapsulatedExpression(expression, this.functionExpressionHelper());
            if (expression.hasLeftParenthesis() && ExpressionTools.stringIsEmpty(functionName = expression.getUnquotedFunctionName())) {
                int startPosition = this.position(expression) + expression.getIdentifier().length() + (expression.hasLeftParenthesis() ? 1 : 0);
                this.addProblem((Expression)expression, startPosition, "FUNCTION_EXPRESSION_MISSING_FUNCTION_NAME", new String[0]);
            }
        }
    }

    @Override
    public void visit(GroupByClause expression) {
        if (!expression.hasGroupByItems()) {
            int startPosition = this.position(expression) + 8 + (expression.hasSpaceAfterGroupBy() ? 1 : 0);
            this.addProblem((Expression)expression, startPosition, "GROUP_BY_CLAUSE_GROUP_BY_ITEM_MISSING", new String[0]);
        } else {
            this.validateCollectionSeparatedByComma(expression.getGroupByItems(), "GROUP_BY_CLAUSE_GROUP_BY_ITEM_ENDS_WITH_COMMA", "GROUP_BY_CLAUSE_GROUP_BY_ITEM_IS_MISSING_COMMA");
            super.visit(expression);
        }
    }

    @Override
    public void visit(HavingClause expression) {
        this.validateAbstractConditionalClause(expression, "HAVING_CLAUSE_MISSING_CONDITIONAL_EXPRESSION", "HAVING_CLAUSE_INVALID_CONDITIONAL_EXPRESSION");
    }

    @Override
    public void visit(IdentificationVariable expression) {
        if (!expression.isVirtual()) {
            String variable = expression.getText();
            this.validateIdentifier(expression, variable, variable.length(), "IDENTIFICATION_VARIABLE_INVALID_RESERVED_WORD", "IDENTIFICATION_VARIABLE_INVALID_JAVA_IDENTIFIER");
        }
    }

    @Override
    public void visit(IdentificationVariableDeclaration expression) {
        this.validateIdentificationVariableDeclaration(expression);
    }

    @Override
    public void visit(IndexExpression expression) {
        if (this.isJPA1_0()) {
            this.addProblem(expression, "INDEX_EXPRESSION_INVALID_JPA_VERSION");
        } else {
            this.validateAbstractSingleEncapsulatedExpression(expression, this.indexExpressionHelper());
        }
    }

    @Override
    public void visit(InExpression expression) {
        boolean singleInputParameter;
        int startPosition;
        if (!expression.hasExpression()) {
            int startPosition2 = this.position(expression);
            this.addProblem((Expression)expression, startPosition2, "IN_EXPRESSION_MISSING_EXPRESSION", new String[0]);
        } else {
            Expression leftExpression = expression.getExpression();
            if (!this.isValid(leftExpression, expression.getExpressionExpressionBNF()) || this.isDateTimeConstant(leftExpression)) {
                startPosition = this.position(expression);
                int endPosition = startPosition + this.length(leftExpression);
                this.addProblem((Expression)expression, startPosition, endPosition, "IN_EXPRESSION_MALFORMED_EXPRESSION", new String[0]);
            } else {
                leftExpression.accept(this);
            }
        }
        boolean bl = singleInputParameter = this.isNewerThanOrEqual(JPAVersion.VERSION_2_0) && expression.isSingleInputParameter();
        if (!expression.hasLeftParenthesis() && !singleInputParameter) {
            startPosition = this.position(expression) + this.length(expression.getExpression()) + (expression.hasExpression() ? 1 : 0) + (expression.hasNot() ? 4 : 0) + 2;
            this.addProblem((Expression)expression, startPosition, "IN_EXPRESSION_MISSING_LEFT_PARENTHESIS", new String[0]);
        } else if (!expression.hasInItems()) {
            startPosition = this.position(expression) + this.length(expression.getExpression()) + (expression.hasExpression() ? 1 : 0) + (expression.hasNot() ? 4 : 0) + 2 + (expression.hasSpaceAfterIn() ? 1 : 0) + (expression.hasLeftParenthesis() ? 1 : 0);
            this.addProblem((Expression)expression, startPosition, "IN_EXPRESSION_MISSING_IN_ITEMS", new String[0]);
        } else if (!singleInputParameter) {
            this.validateCollectionSeparatedByComma(expression.getInItems(), "IN_EXPRESSION_IN_ITEM_ENDS_WITH_COMMA", "IN_EXPRESSION_IN_ITEM_IS_MISSING_COMMA");
        }
        if (!singleInputParameter && expression.hasInItems() && !expression.hasRightParenthesis()) {
            startPosition = this.position(expression) + this.length(expression.getExpression()) + (expression.hasExpression() ? 1 : 0) + (expression.hasNot() ? 4 : 0) + 2 + (expression.hasSpaceAfterIn() ? 1 : 0) + (expression.hasLeftParenthesis() ? 1 : 0) + this.length(expression.getInItems());
            this.addProblem((Expression)expression, startPosition, "IN_EXPRESSION_MISSING_RIGHT_PARENTHESIS", new String[0]);
        }
        super.visit(expression);
    }

    @Override
    public void visit(InputParameter expression) {
        this.inputParameters.add(expression);
        String parameter = expression.getParameter();
        if (parameter.length() == 1) {
            int startPosition = this.position(expression);
            this.addProblem((Expression)expression, startPosition, startPosition + 1, "INPUT_PARAMETER_MISSING_PARAMETER", new String[0]);
        } else if (expression.isNamed()) {
            if (!this.isValidJavaIdentifier(parameter.substring(1))) {
                int startPosition = this.position(expression);
                int endPosition = startPosition + parameter.length();
                this.addProblem((Expression)expression, startPosition, endPosition, "INPUT_PARAMETER_JAVA_IDENTIFIER", new String[0]);
            }
        } else {
            Integer value;
            boolean valid = true;
            int index = parameter.length();
            while (--index > 0) {
                char character = parameter.charAt(index);
                if (Character.isDigit(character)) continue;
                int startPosition = this.position(expression);
                int endPosition = startPosition + parameter.length();
                this.addProblem((Expression)expression, startPosition, endPosition, "INPUT_PARAMETER_NOT_INTEGER", new String[0]);
                valid = false;
                break;
            }
            if (valid && (value = Integer.valueOf(parameter.substring(1))) < 1) {
                int startPosition = this.position(expression);
                int endPosition = startPosition + parameter.length();
                this.addProblem((Expression)expression, startPosition, endPosition, "INPUT_PARAMETER_SMALLER_THAN_ONE", new String[0]);
            }
        }
        this.validateOwningClause(expression, parameter);
    }

    @Override
    public void visit(Join expression) {
        int endPosition;
        int startPosition;
        boolean joinFetch = expression.hasFetch();
        if (!expression.hasJoinAssociationPath()) {
            startPosition = this.position(expression) + expression.getIdentifier().length() + (expression.hasSpaceAfterJoin() ? 1 : 0);
            this.addProblem((Expression)expression, startPosition, joinFetch ? "JOIN_FETCH_MISSING_JOIN_ASSOCIATION_PATH" : "JOIN_MISSING_JOIN_ASSOCIATION_PATH", new String[0]);
        } else {
            Expression joinAssociationPath = expression.getJoinAssociationPath();
            if (!this.isValid(joinAssociationPath, "join_association_path_expression*")) {
                int startPosition2 = this.position(joinAssociationPath);
                int endPosition2 = startPosition2 + this.length(joinAssociationPath);
                this.addProblem((Expression)expression, startPosition2, endPosition2, "JOIN_INVALID_JOIN_ASSOCIATION_PATH", new String[0]);
            } else {
                joinAssociationPath.accept(this);
            }
        }
        if (expression.hasJoinAssociationPath() && !expression.hasIdentificationVariable() && (!joinFetch || expression.hasAs() && this.isJoinFetchIdentifiable())) {
            startPosition = this.position(expression) + expression.getIdentifier().length() + (expression.hasSpaceAfterJoin() ? 1 : 0) + this.length(expression.getJoinAssociationPath()) + (expression.hasSpaceAfterJoinAssociation() ? 1 : 0) + (expression.hasAs() ? 2 : 0) + (expression.hasSpaceAfterAs() ? 1 : 0);
            this.addProblem((Expression)expression, startPosition, joinFetch ? "JOIN_FETCH_MISSING_IDENTIFICATION_VARIABLE" : "JOIN_MISSING_IDENTIFICATION_VARIABLE", new String[0]);
        } else if (joinFetch && !this.isJoinFetchIdentifiable() && (expression.hasAs() || expression.hasIdentificationVariable())) {
            startPosition = this.position(expression) + expression.getIdentifier().length() + (expression.hasSpaceAfterJoin() ? 1 : 0) + this.length(expression.getJoinAssociationPath()) + (expression.hasSpaceAfterJoinAssociation() ? 1 : 0);
            endPosition = startPosition + (expression.hasAs() ? 2 : 0) + (expression.hasSpaceAfterAs() ? 1 : 0) + this.length(expression.getIdentificationVariable());
            this.addProblem((Expression)expression, startPosition, endPosition, "JOIN_FETCH_INVALID_IDENTIFICATION", new String[0]);
        } else {
            expression.getIdentificationVariable().accept(this);
        }
        if (joinFetch && this.isOwnedBySubFromClause(expression)) {
            startPosition = this.position(expression);
            endPosition = startPosition + this.length(expression);
            this.addProblem((Expression)expression, startPosition, endPosition, "JOIN_FETCH_WRONG_CLAUSE_DECLARATION", new String[0]);
        }
        expression.getOnClause().accept(this);
    }

    @Override
    public void visit(JPQLExpression expression) {
        if (expression.hasQueryStatement()) {
            expression.getQueryStatement().accept(this);
            this.validateInputParameters(expression);
            if (expression.hasUnknownEndingStatement()) {
                String unknownStatement = expression.getUnknownEndingStatement().toActualText();
                if (ExpressionTools.stringIsNotEmpty(unknownStatement)) {
                    int startPosition = this.length(expression.getQueryStatement());
                    int endPosition = startPosition + this.length(expression.getUnknownEndingStatement());
                    this.addProblem((Expression)expression, startPosition, endPosition, "JPQL_EXPRESSION_UNKNOWN_ENDING", new String[0]);
                } else if (!expression.hasQueryStatement()) {
                    this.addProblem((Expression)expression, 0, this.length(expression), "JPQL_EXPRESSION_INVALID_QUERY", new String[0]);
                }
            }
        } else {
            this.addProblem((Expression)expression, 0, this.length(expression), "JPQL_EXPRESSION_INVALID_QUERY", new String[0]);
        }
    }

    @Override
    public void visit(KeyExpression expression) {
        if (this.isJPA1_0()) {
            this.addProblem(expression, "KEY_EXPRESSION_INVALID_JPA_VERSION");
        } else {
            this.validateAbstractSingleEncapsulatedExpression(expression, this.keyExpressionHelper());
        }
    }

    @Override
    public void visit(KeywordExpression expression) {
    }

    @Override
    public void visit(LengthExpression expression) {
        this.validateAbstractSingleEncapsulatedExpression(expression, this.lengthExpressionHelper());
    }

    @Override
    public void visit(LikeExpression expression) {
        int startPosition;
        if (!expression.hasStringExpression()) {
            startPosition = this.position(expression);
            this.addProblem((Expression)expression, startPosition, "LIKE_EXPRESSION_MISSING_STRING_EXPRESSION", new String[0]);
        }
        if (!expression.hasPatternValue()) {
            startPosition = this.position(expression) + this.length(expression.getStringExpression()) + 4 + (expression.hasSpaceAfterStringExpression() ? 1 : 0) + (expression.hasNot() ? 1 : 0) + (expression.hasSpaceAfterLike() ? 1 : 0);
            this.addProblem((Expression)expression, startPosition, "LIKE_EXPRESSION_MISSING_PATTERN_VALUE", new String[0]);
        }
        if (expression.hasEscape()) {
            if (!expression.hasEscapeCharacter()) {
                startPosition = this.position(expression) + this.length(expression.getStringExpression()) + 4 + (expression.hasSpaceAfterStringExpression() ? 1 : 0) + (expression.hasNot() ? 1 : 0) + (expression.hasSpaceAfterLike() ? 1 : 0) + this.length(expression.getPatternValue()) + (expression.hasSpaceAfterPatternValue() ? 1 : 0) + 6 + (expression.hasSpaceAfterEscape() ? 1 : 0);
                this.addProblem((Expression)expression, startPosition, "LIKE_EXPRESSION_MISSING_ESCAPE_CHARACTER", new String[0]);
            } else {
                this.validateLikeExpressionEscapeCharacter(expression);
            }
        }
        super.visit(expression);
    }

    @Override
    public void visit(LocateExpression expression) {
        this.validateAbstractTripleEncapsulatedExpression(expression, this.locateExpressionHelper());
    }

    @Override
    public void visit(LowerExpression expression) {
        this.validateAbstractSingleEncapsulatedExpression(expression, this.lowerExpressionHelper());
    }

    @Override
    public void visit(MaxFunction expression) {
        this.validateAggregateFunctionLocation(expression, this.maxFunctionHelper());
    }

    @Override
    public void visit(MinFunction expression) {
        this.validateAggregateFunctionLocation(expression, this.minFunctionHelper());
    }

    @Override
    public void visit(ModExpression expression) {
        this.validateAbstractDoubleEncapsulatedExpression(expression, this.modExpressionHelper());
    }

    @Override
    public void visit(MultiplicationExpression expression) {
        this.validateArithmeticExpression(expression);
    }

    @Override
    public void visit(NotExpression expression) {
        if (!expression.hasExpression()) {
            int startPosition = this.position(expression) + 3 + (expression.hasSpaceAfterNot() ? 1 : 0);
            this.addProblem((Expression)expression, startPosition, "NOT_EXPRESSION_MISSING_EXPRESSION", new String[0]);
        } else {
            super.visit(expression);
        }
    }

    @Override
    public void visit(NullComparisonExpression expression) {
        if (!expression.hasExpression()) {
            int startPosition = this.position(expression);
            this.addProblem((Expression)expression, startPosition, "NULL_COMPARISON_EXPRESSION_MISSING_EXPRESSION", new String[0]);
        } else {
            super.visit(expression);
        }
    }

    @Override
    public void visit(NullExpression expression) {
    }

    @Override
    public void visit(NullIfExpression expression) {
        if (this.isJPA1_0()) {
            this.addProblem(expression, "NULLIF_EXPRESSION_INVALID_JPA_VERSION");
        } else {
            this.validateAbstractDoubleEncapsulatedExpression(expression, this.nullIfExpressionHelper());
        }
    }

    @Override
    public void visit(NumericLiteral expression) {
        String text = expression.getText();
        if (!this.isNumericLiteral(text)) {
            int startPosition = this.position(expression);
            int endPosition = startPosition + text.length();
            this.addProblem((Expression)expression, startPosition, endPosition, "NUMERIC_LITERAL_INVALID", text);
        }
    }

    @Override
    public void visit(ObjectExpression expression) {
        this.validateAbstractSingleEncapsulatedExpression(expression, this.objectExpressionHelper());
    }

    @Override
    public void visit(OnClause expression) {
        if (!expression.hasConditionalExpression()) {
            int startPosition = this.position(expression) + 2 + (expression.hasSpaceAfterIdentifier() ? 1 : 0);
            this.addProblem((Expression)expression, startPosition, "ON_CLAUSE_MISSING_CONDITIONAL_EXPRESSION", new String[0]);
        } else {
            Expression conditionalExpression = expression.getConditionalExpression();
            if (!this.isValid(conditionalExpression, "conditional_expression")) {
                int startPosition = this.position(expression) + 2 + (expression.hasSpaceAfterIdentifier() ? 1 : 0);
                int endPosition = startPosition + this.length(conditionalExpression);
                this.addProblem((Expression)expression, startPosition, endPosition, "ON_CLAUSE_INVALID_CONDITIONAL_EXPRESSION", new String[0]);
            } else {
                conditionalExpression.accept(this);
            }
        }
    }

    @Override
    public void visit(OrderByClause expression) {
        if (!expression.hasOrderByItems()) {
            int startPosition;
            int endPosition = startPosition = this.position(expression.getOrderByItems());
            this.addProblem((Expression)expression, startPosition, endPosition, "ORDER_BY_CLAUSE_ORDER_BY_ITEM_MISSING", new String[0]);
        } else {
            this.validateCollectionSeparatedByComma(expression.getOrderByItems(), "ORDER_BY_CLAUSE_ORDER_BY_ITEM_ENDS_WITH_COMMA", "ORDER_BY_CLAUSE_ORDER_BY_ITEM_IS_MISSING_COMMA");
        }
        super.visit(expression);
    }

    @Override
    public void visit(OrderByItem expression) {
        if (!expression.hasExpression()) {
            int startPosition = this.position(expression);
            this.addProblem((Expression)expression, startPosition, "ORDER_BY_ITEM_MISSING_STATE_FIELD_PATH_EXPRESSION", new String[0]);
        } else {
            super.visit(expression);
        }
    }

    @Override
    public void visit(OrExpression expression) {
        this.validateLogicalExpression(expression, "conditional_expression", "conditional_expression");
    }

    @Override
    public void visit(RangeVariableDeclaration expression) {
        int startPosition;
        if (!expression.hasRootObject()) {
            startPosition = this.position(expression);
            this.addProblem((Expression)expression, startPosition, "RANGE_VARIABLE_DECLARATION_MISSING_ROOT_OBJECT", new String[0]);
        } else {
            Expression rootObject = expression.getRootObject();
            if (!this.isValid(rootObject, "range_declaration")) {
                int startPosition2 = this.position(rootObject);
                int endPosition = startPosition2 + this.length(rootObject);
                this.addProblem((Expression)expression, startPosition2, endPosition, "RANGE_VARIABLE_DECLARATION_INVALID_ROOT_OBJECT", new String[0]);
            } else {
                rootObject.accept(this);
            }
        }
        if (!expression.hasIdentificationVariable() && !expression.hasVirtualIdentificationVariable()) {
            startPosition = this.position(expression) + this.length(expression.getRootObject()) + (expression.hasSpaceAfterRootObject() ? 1 : 0) + (expression.hasAs() ? 2 : 0) + (expression.hasSpaceAfterAs() ? 1 : 0);
            this.addProblem((Expression)expression, startPosition, "RANGE_VARIABLE_DECLARATION_MISSING_IDENTIFICATION_VARIABLE", new String[0]);
        } else {
            expression.getIdentificationVariable().accept(this);
        }
    }

    @Override
    public void visit(ResultVariable expression) {
        if (this.isJPA1_0()) {
            int startPosition = this.position(expression) + this.length(expression.getSelectExpression()) + (expression.hasSelectExpression() ? 1 : 0);
            int endPosition = startPosition + (expression.hasAs() ? 2 : 0) + (expression.hasSpaceAfterAs() ? 1 : 0) + this.length(expression.getResultVariable());
            this.addProblem((Expression)expression, startPosition, endPosition, "RESULT_VARIABLE_INVALID_JPA_VERSION", new String[0]);
        } else {
            int startPosition;
            if (!expression.hasSelectExpression()) {
                startPosition = this.position(expression);
                this.addProblem((Expression)expression, startPosition, "RESULT_VARIABLE_MISSING_SELECT_EXPRESSION", new String[0]);
            } else {
                expression.getSelectExpression().accept(this);
            }
            if (!expression.hasResultVariable()) {
                startPosition = this.position(expression) + this.length(expression.getSelectExpression()) + (expression.hasSelectExpression() ? 1 : 0) + (expression.hasAs() ? 2 : 0) + (expression.hasSpaceAfterAs() ? 1 : 0);
                this.addProblem((Expression)expression, startPosition, "RESULT_VARIABLE_MISSING_RESULT_VARIABLE", new String[0]);
            } else {
                expression.getResultVariable().accept(this);
            }
        }
    }

    @Override
    public void visit(SelectClause expression) {
        this.validateAbstractSelectClause(expression, true);
        if (expression.hasSelectExpression()) {
            this.validateCollectionSeparatedByComma(expression.getSelectExpression(), "ABSTRACT_SELECT_CLAUSE_SELECT_EXPRESSION_ENDS_WITH_COMMA", "ABSTRACT_SELECT_CLAUSE_SELECT_EXPRESSION_IS_MISSING_COMMA");
        }
    }

    @Override
    public void visit(SelectStatement expression) {
        this.validateAbstractSelectStatement(expression);
        super.visit(expression);
    }

    @Override
    public void visit(SimpleFromClause expression) {
        this.validateAbstractFromClause(expression);
    }

    @Override
    public void visit(SimpleSelectClause expression) {
        this.validateAbstractSelectClause(expression, false);
    }

    @Override
    public void visit(SimpleSelectStatement expression) {
        this.validateSimpleSelectStatement(expression);
        super.visit(expression);
    }

    @Override
    public void visit(SizeExpression expression) {
        this.validateAbstractSingleEncapsulatedExpression(expression, this.sizeExpressionHelper());
    }

    @Override
    public void visit(SqrtExpression expression) {
        this.validateAbstractSingleEncapsulatedExpression(expression, this.sqrtExpressionHelper());
    }

    @Override
    public void visit(StateFieldPathExpression expression) {
        this.validatePathExpression(expression);
    }

    @Override
    public void visit(StringLiteral expression) {
        if (!expression.hasCloseQuote()) {
            this.addProblem(expression, "STRING_LITERAL_MISSING_CLOSING_QUOTE");
        }
    }

    @Override
    public void visit(SubExpression expression) {
        if (!expression.hasExpression()) {
            int startPosition = this.position(expression) + 1;
            this.addProblem((Expression)expression, startPosition, "SUB_EXPRESSION_MISSING_EXPRESSION", new String[0]);
        } else {
            if (!expression.hasRightParenthesis()) {
                int startPosition = this.position(expression) + 1 + this.length(expression.getExpression());
                this.addProblem((Expression)expression, startPosition, "SUB_EXPRESSION_MISSING_RIGHT_PARENTHESIS", new String[0]);
            }
            super.visit(expression);
        }
    }

    @Override
    public void visit(SubstringExpression expression) {
        this.validateAbstractTripleEncapsulatedExpression(expression, this.substringExpressionHelper());
    }

    @Override
    public void visit(SubtractionExpression expression) {
        this.validateArithmeticExpression(expression);
    }

    @Override
    public void visit(SumFunction expression) {
        this.validateAggregateFunctionLocation(expression, this.sumFunctionHelper());
    }

    @Override
    public void visit(TreatExpression expression) {
        if (this.isJPA1_0()) {
            this.addProblem(expression, "TREAT_EXPRESSION_INVALID_JPA_PLATFORM");
        } else {
            super.visit(expression);
        }
    }

    @Override
    public void visit(TrimExpression expression) {
        Expression trimCharacter;
        String inputParameter;
        int startPosition;
        this.validateAbstractSingleEncapsulatedExpression(expression, this.trimExpressionHelper());
        if (!expression.hasExpression()) {
            startPosition = this.position(expression) + 4 + (expression.hasLeftParenthesis() ? 1 : 0) + expression.getSpecification().getValue().length() + (expression.hasSpaceAfterSpecification() ? 1 : 0) + this.length(expression.getTrimCharacter()) + (expression.hasSpaceAfterTrimCharacter() ? 1 : 0) + (expression.hasFrom() ? 4 : 0) + (expression.hasSpaceAfterFrom() ? 1 : 0);
            this.addProblem((Expression)expression, startPosition, "TRIM_EXPRESSION_MISSING_EXPRESSION", new String[0]);
        } else if (!this.isValid(expression.getExpression(), expression.encapsulatedExpressionBNF())) {
            startPosition = this.position(expression) + 4 + (expression.hasLeftParenthesis() ? 1 : 0) + expression.getSpecification().getValue().length() + (expression.hasSpaceAfterSpecification() ? 1 : 0) + this.length(expression.getTrimCharacter()) + (expression.hasSpaceAfterTrimCharacter() ? 1 : 0) + (expression.hasFrom() ? 4 : 0) + (expression.hasSpaceAfterFrom() ? 1 : 0);
            int endPosition = startPosition + this.length(expression.getExpression());
            this.addProblem((Expression)expression, startPosition, endPosition, "TRIM_EXPRESSION_INVALID_EXPRESSION", new String[0]);
        }
        if (expression.hasTrimCharacter() && ExpressionTools.stringIsEmpty(inputParameter = this.literal(trimCharacter = expression.getTrimCharacter(), LiteralType.INPUT_PARAMETER))) {
            String stringLiteral = this.literal(trimCharacter, LiteralType.STRING_LITERAL);
            int startPosition2 = this.position(expression) + 4 + (expression.hasLeftParenthesis() ? 1 : 0) + expression.getSpecification().getValue().length() + (expression.hasSpaceAfterSpecification() ? 1 : 0);
            int endPosition = startPosition2 + this.length(trimCharacter);
            if (ExpressionTools.stringIsEmpty(stringLiteral)) {
                this.addProblem(trimCharacter, startPosition2, endPosition, "TRIM_EXPRESSION_INVALID_TRIM_CHARACTER", new String[0]);
            } else if ((stringLiteral = stringLiteral.substring(1, stringLiteral.length() - (stringLiteral.endsWith("'") ? 1 : 0))).length() != 1) {
                this.addProblem(trimCharacter, startPosition2, endPosition, "TRIM_EXPRESSION_NOT_SINGLE_STRING_LITERAL", new String[0]);
            }
        }
    }

    @Override
    public void visit(TypeExpression expression) {
        if (this.isJPA1_0()) {
            this.addProblem(expression, "TYPE_EXPRESSION_INVALID_JPA_VERSION");
        } else {
            this.validateAbstractSingleEncapsulatedExpression(expression, this.typeExpressionHelper());
        }
    }

    @Override
    public void visit(UnknownExpression expression) {
    }

    @Override
    public void visit(UpdateClause expression) {
        if (!expression.hasRangeVariableDeclaration()) {
            int startPosition = this.position(expression) + 6 + (expression.hasSpaceAfterUpdate() ? 1 : 0);
            this.addProblem((Expression)expression, startPosition, "UPDATE_CLAUSE_MISSING_RANGE_VARIABLE_DECLARATION", new String[0]);
        } else if (!expression.hasSet()) {
            int startPosition = this.position(expression) + 6 + (expression.hasSpaceAfterUpdate() ? 1 : 0) + this.length(expression.getRangeVariableDeclaration()) + (expression.hasSpaceAfterRangeVariableDeclaration() ? 1 : 0);
            this.addProblem((Expression)expression, startPosition, "UPDATE_CLAUSE_MISSING_SET", new String[0]);
        } else if (!expression.hasUpdateItems()) {
            int startPosition = this.position(expression) + 6 + (expression.hasSpaceAfterUpdate() ? 1 : 0) + this.length(expression.getRangeVariableDeclaration()) + (expression.hasSpaceAfterRangeVariableDeclaration() ? 1 : 0) + 3 + (expression.hasSpaceAfterSet() ? 1 : 0);
            this.addProblem((Expression)expression, startPosition, "UPDATE_CLAUSE_MISSING_UPDATE_ITEMS", new String[0]);
        } else {
            this.validateCollectionSeparatedByComma(expression.getUpdateItems(), "UPDATE_CLAUSE_UPDATE_ITEM_ENDS_WITH_COMMA", "UPDATE_CLAUSE_UPDATE_ITEM_IS_MISSING_COMMA");
        }
        super.visit(expression);
    }

    @Override
    public void visit(UpdateItem expression) {
        int startPosition;
        if (!expression.hasStateFieldPathExpression()) {
            startPosition = this.position(expression);
            this.addProblem((Expression)expression, startPosition, "UPDATE_ITEM_MISSING_STATE_FIELD_PATH_EXPRESSION", new String[0]);
        }
        if (expression.hasStateFieldPathExpression() && !expression.hasEqualSign()) {
            startPosition = this.position(expression) + this.length(expression.getStateFieldPathExpression()) + (expression.hasSpaceAfterStateFieldPathExpression() ? 1 : 0);
            this.addProblem((Expression)expression, startPosition, "UPDATE_ITEM_MISSING_EQUAL_SIGN", new String[0]);
        } else if (expression.hasEqualSign() && !expression.hasNewValue()) {
            startPosition = this.position(expression) + this.length(expression.getStateFieldPathExpression()) + (expression.hasSpaceAfterStateFieldPathExpression() ? 1 : 0) + 1 + (expression.hasSpaceAfterEqualSign() ? 1 : 0);
            this.addProblem((Expression)expression, startPosition, "UPDATE_ITEM_MISSING_NEW_VALUE", new String[0]);
        }
        super.visit(expression);
    }

    @Override
    public void visit(UpdateStatement expression) {
        super.visit(expression);
    }

    @Override
    public void visit(UpperExpression expression) {
        this.validateAbstractSingleEncapsulatedExpression(expression, this.upperExpressionHelper());
    }

    @Override
    public void visit(ValueExpression expression) {
        if (this.isJPA1_0()) {
            this.addProblem(expression, "VALUE_EXPRESSION_INVALID_JPA_VERSION");
        } else {
            this.validateAbstractSingleEncapsulatedExpression(expression, this.valueExpressionHelper());
        }
    }

    @Override
    public void visit(WhenClause expression) {
        int startPosition;
        if (!expression.hasWhenExpression()) {
            startPosition = this.position(expression) + 4 + (expression.hasSpaceAfterWhen() ? 1 : 0);
            this.addProblem((Expression)expression, startPosition, "WHEN_CLAUSE_MISSING_WHEN_EXPRESSION", new String[0]);
        }
        if (expression.hasWhenExpression() && !expression.hasThen()) {
            startPosition = this.position(expression) + 4 + (expression.hasSpaceAfterWhen() ? 1 : 0) + this.length(expression.getWhenExpression()) + (expression.hasSpaceAfterWhenExpression() ? 1 : 0);
            this.addProblem((Expression)expression, startPosition, "WHEN_CLAUSE_MISSING_THEN_IDENTIFIER", new String[0]);
        }
        if (expression.hasThen() && !expression.hasThenExpression()) {
            startPosition = this.position(expression) + 4 + (expression.hasSpaceAfterWhen() ? 1 : 0) + this.length(expression.getWhenExpression()) + (expression.hasSpaceAfterWhenExpression() ? 1 : 0) + 4 + (expression.hasSpaceAfterThen() ? 1 : 0);
            this.addProblem((Expression)expression, startPosition, "WHEN_CLAUSE_MISSING_THEN_EXPRESSION", new String[0]);
        }
        super.visit(expression);
    }

    @Override
    public void visit(WhereClause expression) {
        this.validateAbstractConditionalClause(expression, "WHERE_CLAUSE_MISSING_CONDITIONAL_EXPRESSION", "WHERE_CLAUSE_INVALID_CONDITIONAL_EXPRESSION");
    }

    protected abstract class AbstractCollectionValidator
    extends AbstractExpressionVisitor {
        String endsWithCommaProblemKey;
        boolean validateOnly;
        String wrongSeparatorProblemKey;

        protected AbstractCollectionValidator() {
        }

        protected void validateEndsWithComma(CollectionExpression expression) {
            if (expression.endsWithComma()) {
                int lastIndex = expression.childrenSize() - 1;
                int length = expression.toParsedText(lastIndex).length();
                int startPosition = AbstractGrammarValidator.this.position(expression) + length - 1;
                if (expression.endsWithSpace()) {
                    --startPosition;
                }
                int endPosition = startPosition + 1;
                if (!this.validateOnly) {
                    AbstractGrammarValidator.this.addProblem((Expression)expression, startPosition, endPosition, this.endsWithCommaProblemKey, new String[0]);
                }
            }
        }

        protected void validateSeparation(CollectionExpression expression) {
            int index = 0;
            int count = expression.childrenSize();
            while (index + 1 < count) {
                Expression expression1 = expression.getChild(index);
                if (AbstractGrammarValidator.this.length(expression1) == 0) {
                    int startPosition;
                    int endPosition = startPosition = AbstractGrammarValidator.this.position(expression1);
                    AbstractGrammarValidator.this.addProblem((Expression)expression, startPosition, endPosition, "COLLECTION_EXPRESSION_MISSING_EXPRESSION", String.valueOf(index + 1));
                }
                if (!this.validateSeparator(expression, index)) {
                    Expression expression2 = expression.getChild(index + 1);
                    int startPosition = AbstractGrammarValidator.this.position(expression1) + AbstractGrammarValidator.this.length(expression1);
                    int endPosition = AbstractGrammarValidator.this.position(expression2);
                    if (!expression.hasSpace(index)) {
                        --startPosition;
                    }
                    if (!this.validateOnly) {
                        AbstractGrammarValidator.this.addProblem((Expression)expression, startPosition, endPosition, this.wrongSeparatorProblemKey, expression1.toParsedText(), expression2.toParsedText());
                    }
                }
                ++index;
            }
        }

        abstract boolean validateSeparator(CollectionExpression var1, int var2);

        public void visit(CollectionExpression expression) {
            this.validateSeparation(expression);
            this.validateEndsWithComma(expression);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected abstract class AbstractDoubleEncapsulatedExpressionHelper<T extends AbstractDoubleEncapsulatedExpression>
    implements AbstractEncapsulatedExpressionHelper<T> {
        protected AbstractDoubleEncapsulatedExpressionHelper() {
        }

        @Override
        public String[] arguments(T expression) {
            return ExpressionTools.EMPTY_STRING_ARRAY;
        }

        protected abstract String firstExpressionInvalidKey();

        protected int firstExpressionLength(T expression) {
            return AbstractGrammarValidator.this.length(((AbstractDoubleEncapsulatedExpression)expression).getFirstExpression());
        }

        protected abstract String firstExpressionMissingKey();

        protected boolean hasComma(T expression) {
            return !this.hasFirstExpression(expression) || ((AbstractDoubleEncapsulatedExpression)expression).hasComma();
        }

        protected boolean hasFirstExpression(T expression) {
            return ((AbstractDoubleEncapsulatedExpression)expression).hasFirstExpression();
        }

        @Override
        public boolean hasLeftParenthesis(T expression) {
            return ((AbstractEncapsulatedExpression)expression).hasLeftParenthesis();
        }

        @Override
        public boolean hasRightParenthesis(T expression) {
            return !((AbstractDoubleEncapsulatedExpression)expression).hasSecondExpression() || ((AbstractEncapsulatedExpression)expression).hasRightParenthesis();
        }

        protected boolean hasSecondExpression(T expression) {
            return !((AbstractDoubleEncapsulatedExpression)expression).hasComma() || ((AbstractDoubleEncapsulatedExpression)expression).hasSecondExpression();
        }

        @Override
        public String identifier(T expression) {
            return ((AbstractEncapsulatedExpression)expression).getIdentifier();
        }

        protected final boolean isFirstExpressionValid(T expression) {
            return AbstractGrammarValidator.this.isValid(((AbstractDoubleEncapsulatedExpression)expression).getFirstExpression(), ((AbstractDoubleEncapsulatedExpression)expression).parameterExpressionBNF(0));
        }

        protected final boolean isSecondExpressionValid(T expression) {
            return AbstractGrammarValidator.this.isValid(((AbstractDoubleEncapsulatedExpression)expression).getSecondExpression(), ((AbstractDoubleEncapsulatedExpression)expression).parameterExpressionBNF(1));
        }

        protected abstract String missingCommaKey();

        protected abstract String secondExpressionInvalidKey();

        protected int secondExpressionLength(T expression) {
            return AbstractGrammarValidator.this.length(((AbstractDoubleEncapsulatedExpression)expression).getSecondExpression());
        }

        protected abstract String secondExpressionMissingKey();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static interface AbstractEncapsulatedExpressionHelper<T extends AbstractEncapsulatedExpression> {
        public String[] arguments(T var1);

        public boolean hasLeftParenthesis(T var1);

        public boolean hasRightParenthesis(T var1);

        public String identifier(T var1);

        public String leftParenthesisMissingKey(T var1);

        public String rightParenthesisMissingKey(T var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected abstract class AbstractSingleEncapsulatedExpressionHelper<T extends AbstractSingleEncapsulatedExpression>
    implements AbstractEncapsulatedExpressionHelper<T> {
        protected AbstractSingleEncapsulatedExpressionHelper() {
        }

        @Override
        public String[] arguments(T expression) {
            return ExpressionTools.EMPTY_STRING_ARRAY;
        }

        protected abstract String encapsulatedExpressionInvalidKey(T var1);

        protected int encapsulatedExpressionLength(T expression) {
            return AbstractGrammarValidator.this.length(((AbstractSingleEncapsulatedExpression)expression).getExpression());
        }

        protected abstract String encapsulatedExpressionMissingKey(T var1);

        @Override
        public boolean hasLeftParenthesis(T expression) {
            return ((AbstractEncapsulatedExpression)expression).hasLeftParenthesis();
        }

        @Override
        public boolean hasRightParenthesis(T expression) {
            return !((AbstractSingleEncapsulatedExpression)expression).hasEncapsulatedExpression() || ((AbstractEncapsulatedExpression)expression).hasRightParenthesis();
        }

        @Override
        public final String identifier(T expression) {
            return ((AbstractEncapsulatedExpression)expression).getIdentifier();
        }

        protected boolean isEncapsulatedExpressionMissing(T expression) {
            return !((AbstractSingleEncapsulatedExpression)expression).hasExpression();
        }

        protected boolean isEncapsulatedExpressionValid(T expression) {
            return AbstractGrammarValidator.this.isValid(((AbstractSingleEncapsulatedExpression)expression).getExpression(), ((AbstractSingleEncapsulatedExpression)expression).encapsulatedExpressionBNF());
        }

        protected int lengthBeforeEncapsulatedExpression(T expression) {
            return 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected abstract class AbstractTripleEncapsulatedExpressionHelper<T extends AbstractTripleEncapsulatedExpression>
    implements AbstractEncapsulatedExpressionHelper<T> {
        protected AbstractTripleEncapsulatedExpressionHelper() {
        }

        @Override
        public String[] arguments(T expression) {
            return ExpressionTools.EMPTY_STRING_ARRAY;
        }

        protected abstract String firstCommaMissingKey();

        protected abstract String firstExpressionInvalidKey();

        protected int firstExpressionLength(T expression) {
            return AbstractGrammarValidator.this.length(((AbstractTripleEncapsulatedExpression)expression).getFirstExpression());
        }

        protected abstract String firstExpressionMissingKey();

        protected boolean hasFirstExpression(T expression) {
            return ((AbstractTripleEncapsulatedExpression)expression).hasFirstExpression();
        }

        @Override
        public boolean hasLeftParenthesis(T expression) {
            return ((AbstractEncapsulatedExpression)expression).hasLeftParenthesis();
        }

        @Override
        public boolean hasRightParenthesis(T expression) {
            return !this.isRightParenthesisMissing(expression);
        }

        protected boolean hasSecondExpression(T expression) {
            return ((AbstractTripleEncapsulatedExpression)expression).hasSecondExpression();
        }

        protected boolean hasThirdExpression(T expression) {
            return ((AbstractTripleEncapsulatedExpression)expression).hasThirdExpression();
        }

        protected boolean isFirstExpressionValid(T expression) {
            return AbstractGrammarValidator.this.isValid(((AbstractTripleEncapsulatedExpression)expression).getFirstExpression(), ((AbstractTripleEncapsulatedExpression)expression).parameterExpressionBNF(0));
        }

        protected boolean isRightParenthesisMissing(T expression) {
            if (!((AbstractEncapsulatedExpression)expression).hasLeftParenthesis() || !((AbstractTripleEncapsulatedExpression)expression).hasFirstExpression() || ((AbstractEncapsulatedExpression)expression).hasRightParenthesis()) {
                return false;
            }
            if (!(!((AbstractTripleEncapsulatedExpression)expression).hasFirstExpression() || ((AbstractTripleEncapsulatedExpression)expression).hasFirstComma() || ((AbstractTripleEncapsulatedExpression)expression).hasSecondExpression() || ((AbstractTripleEncapsulatedExpression)expression).hasSecondComma() || ((AbstractTripleEncapsulatedExpression)expression).hasThirdExpression())) {
                return false;
            }
            if (((AbstractTripleEncapsulatedExpression)expression).hasFirstComma() && !((AbstractTripleEncapsulatedExpression)expression).hasSecondExpression() && !((AbstractTripleEncapsulatedExpression)expression).hasSecondComma() && !((AbstractTripleEncapsulatedExpression)expression).hasThirdExpression()) {
                return false;
            }
            return !((AbstractTripleEncapsulatedExpression)expression).hasSecondExpression() || !((AbstractTripleEncapsulatedExpression)expression).hasSecondComma() || ((AbstractTripleEncapsulatedExpression)expression).hasThirdExpression();
        }

        protected boolean isSecondExpressionValid(T expression) {
            return AbstractGrammarValidator.this.isValid(((AbstractTripleEncapsulatedExpression)expression).getSecondExpression(), ((AbstractTripleEncapsulatedExpression)expression).parameterExpressionBNF(1));
        }

        protected boolean isThirdExpressionValid(T expression) {
            return AbstractGrammarValidator.this.isValid(((AbstractTripleEncapsulatedExpression)expression).getThirdExpression(), ((AbstractTripleEncapsulatedExpression)expression).parameterExpressionBNF(2));
        }

        protected abstract String secondCommaMissingKey();

        protected abstract String secondExpressionInvalidKey();

        protected int secondExpressionLength(T expression) {
            return AbstractGrammarValidator.this.length(((AbstractTripleEncapsulatedExpression)expression).getSecondExpression());
        }

        protected abstract String secondExpressionMissingKey();

        protected abstract String thirdExpressionInvalidKey();

        protected int thirdExpressionLength(T expression) {
            return AbstractGrammarValidator.this.length(((AbstractTripleEncapsulatedExpression)expression).getThirdExpression());
        }

        protected abstract String thirdExpressionMissingKey();
    }

    protected static class CollectionExpressionVisitor
    extends AbstractExpressionVisitor {
        protected CollectionExpression expression;

        protected CollectionExpressionVisitor() {
        }

        public void visit(CollectionExpression expression) {
            this.expression = expression;
        }
    }

    protected class CollectionSeparatedByCommaValidator
    extends AbstractCollectionValidator {
        protected CollectionSeparatedByCommaValidator() {
        }

        boolean validateSeparator(CollectionExpression expression, int index) {
            return expression.hasComma(index);
        }
    }

    protected class CollectionSeparatedBySpaceValidator
    extends AbstractCollectionValidator {
        protected CollectionSeparatedBySpaceValidator() {
        }

        boolean validateSeparator(CollectionExpression expression, int index) {
            return !expression.hasComma(index);
        }
    }

    protected static class ComparisonExpressionVisitor
    extends AbstractExpressionVisitor {
        ComparisonExpression expression;

        protected ComparisonExpressionVisitor() {
        }

        public void visit(ComparisonExpression expression) {
            this.expression = expression;
        }
    }

    protected class DateTimeVisitor
    extends AbstractExpressionVisitor {
        public boolean dateTime;

        protected DateTimeVisitor() {
        }

        public void visit(DateTime expression) {
            this.dateTime = true;
        }
    }

    protected static class NullExpressionVisitor
    extends AbstractExpressionVisitor {
        protected NullExpression expression;

        protected NullExpressionVisitor() {
        }

        public void visit(NullExpression expression) {
            this.expression = expression;
        }
    }
}

