/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.persistence.eclipselink.deployment;

import java.io.File;
import java.io.FileFilter;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import org.eclipse.persistence.internal.jpa.deployment.DirectoryArchive;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EasyBeansDirectoryArchive
extends DirectoryArchive {
    private static final String WEBINF_CLASSES = "WEB-INF/classes";
    private File directory = null;
    private final List<String> entries = new ArrayList<String>();

    public EasyBeansDirectoryArchive(File directory, String descriptorLocation) throws MalformedURLException {
        this(directory, descriptorLocation, Logger.global);
    }

    public EasyBeansDirectoryArchive(File directory, String descriptorLocation, Logger logger) throws MalformedURLException {
        super(directory, descriptorLocation, logger);
        this.directory = directory;
        this.init(directory, directory);
    }

    @Override
    public Iterator<String> getEntries() {
        return this.entries.iterator();
    }

    private boolean isWar() {
        return this.directory.getName().endsWith(".war");
    }

    private void init(File top, File directory) {
        File[] subDirs;
        File[] dirFiles;
        for (File file : dirFiles = directory.listFiles()) {
            if (file.isDirectory()) continue;
            String entryName = file.getPath().replace(File.separator, "/").substring(top.getPath().length() + 1);
            if (this.isWar() && entryName.endsWith(".class") && entryName.startsWith(WEBINF_CLASSES)) {
                entryName = entryName.substring(WEBINF_CLASSES.length() + 1);
            }
            this.entries.add(entryName);
        }
        for (File subDir : subDirs = directory.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.isDirectory();
            }
        })) {
            this.init(top, subDir);
        }
    }
}

