/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.mom.dest;

import fr.dyade.aaa.agent.AgentId;
import fr.dyade.aaa.agent.BagSerializer;
import fr.dyade.aaa.agent.Channel;
import fr.dyade.aaa.agent.DeleteNot;
import fr.dyade.aaa.agent.ExpiredNot;
import fr.dyade.aaa.agent.Notification;
import fr.dyade.aaa.agent.UnknownAgent;
import fr.dyade.aaa.common.Debug;
import fr.dyade.aaa.common.stream.Properties;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;
import org.objectweb.joram.mom.dest.Destination;
import org.objectweb.joram.mom.dest.QueueMBean;
import org.objectweb.joram.mom.messages.MessageJMXWrapper;
import org.objectweb.joram.mom.notifications.AbortReceiveRequest;
import org.objectweb.joram.mom.notifications.AbstractRequestNot;
import org.objectweb.joram.mom.notifications.AcknowledgeRequest;
import org.objectweb.joram.mom.notifications.BrowseReply;
import org.objectweb.joram.mom.notifications.BrowseRequest;
import org.objectweb.joram.mom.notifications.ClientMessages;
import org.objectweb.joram.mom.notifications.DenyRequest;
import org.objectweb.joram.mom.notifications.ExceptionReply;
import org.objectweb.joram.mom.notifications.FwdAdminRequestNot;
import org.objectweb.joram.mom.notifications.QueueMsgReply;
import org.objectweb.joram.mom.notifications.ReceiveRequest;
import org.objectweb.joram.mom.notifications.TopicMsgsReply;
import org.objectweb.joram.mom.notifications.WakeUpNot;
import org.objectweb.joram.mom.util.DMQManager;
import org.objectweb.joram.shared.admin.AdminReply;
import org.objectweb.joram.shared.admin.AdminRequest;
import org.objectweb.joram.shared.admin.ClearQueue;
import org.objectweb.joram.shared.admin.DeleteQueueMessage;
import org.objectweb.joram.shared.admin.GetDMQSettingsReply;
import org.objectweb.joram.shared.admin.GetDMQSettingsRequest;
import org.objectweb.joram.shared.admin.GetDeliveredMessages;
import org.objectweb.joram.shared.admin.GetNbMaxMsgRequest;
import org.objectweb.joram.shared.admin.GetNumberReply;
import org.objectweb.joram.shared.admin.GetPendingMessages;
import org.objectweb.joram.shared.admin.GetPendingRequests;
import org.objectweb.joram.shared.admin.GetQueueMessage;
import org.objectweb.joram.shared.admin.GetQueueMessageIds;
import org.objectweb.joram.shared.admin.GetQueueMessageIdsRep;
import org.objectweb.joram.shared.admin.GetQueueMessageRep;
import org.objectweb.joram.shared.admin.SetNbMaxMsgRequest;
import org.objectweb.joram.shared.admin.SetSyncExceptionOnFullDestRequest;
import org.objectweb.joram.shared.admin.SetThresholdRequest;
import org.objectweb.joram.shared.excepts.AccessException;
import org.objectweb.joram.shared.excepts.DestinationException;
import org.objectweb.joram.shared.excepts.MomException;
import org.objectweb.joram.shared.messages.Message;
import org.objectweb.joram.shared.selectors.Selector;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public class Queue
extends Destination
implements QueueMBean,
BagSerializer {
    private static final long serialVersionUID = 1L;
    public static Logger logger = Debug.getLogger((String)Queue.class.getName());
    static AgentId defaultDMQId = null;
    private int threshold = -1;
    static int defaultThreshold = -1;
    private boolean samePriorities;
    private int priority;
    protected Map consumers = new Hashtable();
    protected Map contexts = new Hashtable();
    protected long arrivalsCounter = 0L;
    protected List requests = new Vector();
    protected transient boolean receiving = false;
    protected transient List messages;
    protected transient Map deliveredMsgs;
    protected int nbMaxMsg = -1;
    transient StringBuffer msgTxPrefix = null;
    transient int msgTxPrefixLength = 0;
    private boolean syncExceptionOnFullDest = false;

    public int getThreshold() {
        return this.threshold;
    }

    public void setThreshold(int threshold) {
        this.threshold = threshold;
    }

    public static int getDefaultThreshold() {
        return defaultThreshold;
    }

    public static AgentId getDefaultDMQId() {
        return defaultDMQId;
    }

    public void react(AgentId from, Notification not) throws Exception {
        block16: {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("Queue.react(" + from + ',' + not + ')'));
            }
            this.setNoSave();
            try {
                if (not instanceof ReceiveRequest) {
                    this.receiveRequest(from, (ReceiveRequest)not);
                } else if (not instanceof BrowseRequest) {
                    this.browseRequest(from, (BrowseRequest)not);
                } else if (not instanceof AcknowledgeRequest) {
                    this.acknowledgeRequest((AcknowledgeRequest)not);
                } else if (not instanceof DenyRequest) {
                    this.denyRequest(from, (DenyRequest)not);
                } else if (not instanceof AbortReceiveRequest) {
                    this.abortReceiveRequest(from, (AbortReceiveRequest)not);
                } else if (not instanceof ExpiredNot) {
                    this.handleExpiredNot(from, (ExpiredNot)not);
                } else {
                    super.react(from, not);
                }
            }
            catch (MomException exc) {
                if (logger.isLoggable(BasicLevel.WARN)) {
                    logger.log(BasicLevel.WARN, (Object)exc);
                }
                if (!(not instanceof AbstractRequestNot)) break block16;
                AbstractRequestNot req = (AbstractRequestNot)not;
                Channel.sendTo((AgentId)from, (Notification)new ExceptionReply(req, exc));
            }
        }
    }

    public void cleanWaitingRequest() {
        this.cleanWaitingRequest(System.currentTimeMillis());
    }

    protected void cleanWaitingRequest(long currentTime) {
        int index = 0;
        while (index < this.requests.size()) {
            if (!((ReceiveRequest)((Object)this.requests.get(index))).isValid(currentTime)) {
                this.requests.remove(index);
                continue;
            }
            ++index;
        }
    }

    public final int getWaitingRequestCount() {
        if (this.requests != null) {
            this.cleanWaitingRequest(System.currentTimeMillis());
            return this.requests.size();
        }
        return 0;
    }

    public void cleanPendingMessage() {
        this.cleanPendingMessage(System.currentTimeMillis());
    }

    public byte getType() {
        return 2;
    }

    protected DMQManager cleanPendingMessage(long currentTime) {
        int index = 0;
        DMQManager dmqManager = null;
        org.objectweb.joram.mom.messages.Message message = null;
        while (index < this.messages.size()) {
            message = (org.objectweb.joram.mom.messages.Message)this.messages.get(index);
            if (!message.isValid(currentTime)) {
                this.messages.remove(index);
                if (dmqManager == null) {
                    dmqManager = new DMQManager(this.dmqId, this.getId());
                }
                ++this.nbMsgsSentToDMQSinceCreation;
                message.delete();
                dmqManager.addDeadMessage(message.getFullMessage(), (short)0);
                if (!logger.isLoggable(BasicLevel.DEBUG)) continue;
                logger.log(BasicLevel.DEBUG, (Object)("Removes expired message " + message.getId()), (Throwable)new Exception());
                continue;
            }
            ++index;
        }
        return dmqManager;
    }

    public final int getPendingMessageCount() {
        if (this.messages != null) {
            return this.messages.size();
        }
        return 0;
    }

    public final int getDeliveredMessageCount() {
        if (this.deliveredMsgs != null) {
            return this.deliveredMsgs.size();
        }
        return 0;
    }

    public final long getNbMsgsReceiveSinceCreation() {
        return this.nbMsgsSentToDMQSinceCreation + this.nbMsgsDeliverSinceCreation + (long)this.getPendingMessageCount();
    }

    public final int getNbMaxMsg() {
        return this.nbMaxMsg;
    }

    public void setNbMaxMsg(int nbMaxMsg) {
        this.setSave();
        this.nbMaxMsg = nbMaxMsg;
    }

    protected void initialize(boolean firstTime) {
        this.cleanWaitingRequest(System.currentTimeMillis());
        this.receiving = false;
        this.messages = new Vector();
        this.deliveredMsgs = new Hashtable();
        if (firstTime) {
            return;
        }
        Vector persistedMsgs = org.objectweb.joram.mom.messages.Message.loadAll(this.getMsgTxPrefix().toString());
        if (persistedMsgs != null) {
            while (!persistedMsgs.isEmpty()) {
                org.objectweb.joram.mom.messages.Message persistedMsg = (org.objectweb.joram.mom.messages.Message)persistedMsgs.remove(0);
                AgentId consId = (AgentId)this.consumers.get(persistedMsg.getId());
                try {
                    if (consId == null) {
                        if (this.addMessage(persistedMsg, false)) continue;
                        persistedMsg.delete();
                        continue;
                    }
                    if (this.isLocal(consId)) {
                        if (logger.isLoggable(BasicLevel.DEBUG)) {
                            logger.log(BasicLevel.DEBUG, (Object)(" -> deny " + persistedMsg.getId()));
                        }
                        this.consumers.remove(persistedMsg.getId());
                        this.contexts.remove(persistedMsg.getId());
                        if (this.addMessage(persistedMsg, false)) continue;
                        persistedMsg.delete();
                        continue;
                    }
                    this.deliveredMsgs.put(persistedMsg.getId(), persistedMsg);
                }
                catch (AccessException e) {}
            }
        }
    }

    protected void finalize(boolean lastTime) {
    }

    public String toString() {
        return "Queue:" + this.getId().toString();
    }

    public void wakeUpNot(WakeUpNot not) {
        long current = System.currentTimeMillis();
        this.cleanWaitingRequest(current);
        DMQManager dmqManager = this.cleanPendingMessage(current);
        if (dmqManager != null) {
            dmqManager.sendToDMQ();
        }
    }

    protected boolean isValidJMXAttribute(String attrName) {
        if ("Messages".equals(attrName)) {
            return false;
        }
        return super.isValidJMXAttribute(attrName);
    }

    protected void receiveRequest(AgentId from, ReceiveRequest not) throws AccessException {
        if (!this.isReader(from)) {
            throw new AccessException("READ right not granted");
        }
        String[] toAck = not.getMessageIds();
        if (toAck != null) {
            for (int i = 0; i < toAck.length; ++i) {
                this.acknowledge(toAck[i]);
            }
        }
        long current = System.currentTimeMillis();
        this.cleanWaitingRequest(current);
        not.requester = from;
        not.setExpiration(current);
        if (not.isPersistent()) {
            this.setSave();
        }
        this.requests.add(not);
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)(" -> requests count = " + this.requests.size()));
        }
        int reqIndex = this.requests.size() - 1;
        this.deliverMessages(reqIndex);
        if (this.requests.size() - 1 == reqIndex && not.getTimeOut() == -1L) {
            this.requests.remove(reqIndex);
            QueueMsgReply reply = new QueueMsgReply(not);
            if (this.isLocal(from)) {
                reply.setPersistent(false);
            }
            this.forward(from, reply);
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)"Receive answered by a null.");
            }
        }
    }

    protected void browseRequest(AgentId from, BrowseRequest not) throws AccessException {
        if (!this.isReader(from)) {
            throw new AccessException("READ right not granted");
        }
        BrowseReply rep = new BrowseReply(not);
        DMQManager dmqManager = this.cleanPendingMessage(System.currentTimeMillis());
        for (int i = 0; i < this.messages.size(); ++i) {
            org.objectweb.joram.mom.messages.Message message = (org.objectweb.joram.mom.messages.Message)this.messages.get(i);
            if (!Selector.matches((Message)message.getHeaderMessage(), (String)not.getSelector())) continue;
            rep.addMessage(message.getFullMessage());
        }
        if (dmqManager != null) {
            dmqManager.sendToDMQ();
        }
        this.forward(from, rep);
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)"Request answered.");
        }
    }

    protected void acknowledgeRequest(AcknowledgeRequest not) {
        Enumeration ids = not.getIds();
        while (ids.hasMoreElements()) {
            String msgId = (String)ids.nextElement();
            this.acknowledge(msgId);
        }
    }

    private void acknowledge(String msgId) {
        org.objectweb.joram.mom.messages.Message msg = (org.objectweb.joram.mom.messages.Message)this.deliveredMsgs.remove(msgId);
        if (msg != null && msg.isPersistent()) {
            this.setSave();
        }
        this.consumers.remove(msgId);
        this.contexts.remove(msgId);
        if (msg != null) {
            msg.delete();
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("Message " + msgId + " acknowledged."));
            }
        } else if (logger.isLoggable(BasicLevel.WARN)) {
            logger.log(BasicLevel.WARN, (Object)("Message " + msgId + " not found for acknowledgement."));
        }
    }

    protected void denyRequest(AgentId from, DenyRequest not) {
        org.objectweb.joram.mom.messages.Message message;
        String msgId;
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("Queue.DenyRequest(" + from + ',' + (Object)((Object)not) + ')'));
        }
        Enumeration ids = not.getIds();
        DMQManager dmqManager = null;
        if (!ids.hasMoreElements()) {
            Iterator entries = this.deliveredMsgs.entrySet().iterator();
            while (entries.hasNext()) {
                Map.Entry entry = entries.next();
                msgId = (String)entry.getKey();
                message = (org.objectweb.joram.mom.messages.Message)entry.getValue();
                AgentId consId = (AgentId)this.consumers.get(msgId);
                int consCtx = (Integer)this.contexts.get(msgId);
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, (Object)(" -> deny msg " + msgId + "(consId = " + consId + ')'));
                }
                if (!consId.equals((Object)from) || consCtx != not.getClientContext()) continue;
                this.setSave();
                this.consumers.remove(msgId);
                this.contexts.remove(msgId);
                entries.remove();
                if (not.isRedelivered()) {
                    message.setRedelivered();
                } else {
                    message.setDeliveryCount(message.getDeliveryCount() - 1);
                }
                if (this.isUndeliverable(message)) {
                    message.delete();
                    if (dmqManager == null) {
                        dmqManager = new DMQManager(this.dmqId, this.getId());
                    }
                    ++this.nbMsgsSentToDMQSinceCreation;
                    dmqManager.addDeadMessage(message.getFullMessage(), (short)2);
                } else {
                    try {
                        this.storeMessageHeader(message, false);
                    }
                    catch (AccessException e) {
                        // empty catch block
                    }
                }
                if (!logger.isLoggable(BasicLevel.DEBUG)) continue;
                logger.log(BasicLevel.DEBUG, (Object)("Message " + msgId + " denied."));
            }
        }
        ids = not.getIds();
        while (ids.hasMoreElements()) {
            msgId = (String)ids.nextElement();
            message = (org.objectweb.joram.mom.messages.Message)this.deliveredMsgs.remove(msgId);
            if (message == null) {
                if (!logger.isLoggable(BasicLevel.ERROR)) break;
                logger.log(BasicLevel.ERROR, (Object)(" -> already denied message " + msgId));
                break;
            }
            if (not.isRedelivered()) {
                message.setRedelivered();
            } else {
                message.setDeliveryCount(message.getDeliveryCount() - 1);
            }
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)(" -> deny " + msgId));
            }
            this.setSave();
            this.consumers.remove(msgId);
            this.contexts.remove(msgId);
            if (this.isUndeliverable(message)) {
                message.delete();
                if (dmqManager == null) {
                    dmqManager = new DMQManager(this.dmqId, this.getId());
                }
                ++this.nbMsgsSentToDMQSinceCreation;
                dmqManager.addDeadMessage(message.getFullMessage(), (short)2);
            } else {
                try {
                    this.storeMessageHeader(message, false);
                }
                catch (AccessException e) {
                    // empty catch block
                }
            }
            if (!logger.isLoggable(BasicLevel.DEBUG)) continue;
            logger.log(BasicLevel.DEBUG, (Object)("Message " + msgId + " denied."));
        }
        if (dmqManager != null) {
            dmqManager.sendToDMQ();
        }
        this.deliverMessages(0);
    }

    protected void abortReceiveRequest(AgentId from, AbortReceiveRequest not) {
        for (int i = 0; i < this.requests.size(); ++i) {
            ReceiveRequest request = (ReceiveRequest)((Object)this.requests.get(i));
            if (!request.requester.equals((Object)from) || request.getClientContext() != not.getClientContext() || request.getRequestId() != not.getAbortedRequestId()) continue;
            if (not.isPersistent()) {
                this.setSave();
            }
            this.requests.remove(i);
            break;
        }
    }

    public void handleAdminRequestNot(AgentId from, FwdAdminRequestNot not) {
        AdminRequest adminRequest = not.getRequest();
        if (adminRequest instanceof GetQueueMessageIds) {
            this.getQueueMessageIds(not.getReplyTo(), not.getRequestMsgId(), not.getReplyMsgId());
        } else if (adminRequest instanceof GetQueueMessage) {
            this.getQueueMessage((GetQueueMessage)adminRequest, not.getReplyTo(), not.getRequestMsgId(), not.getReplyMsgId());
        } else if (adminRequest instanceof DeleteQueueMessage) {
            this.deleteQueueMessage((DeleteQueueMessage)adminRequest, not.getReplyTo(), not.getRequestMsgId(), not.getReplyMsgId());
        } else if (adminRequest instanceof ClearQueue) {
            this.clearQueue(not.getReplyTo(), not.getRequestMsgId(), not.getReplyMsgId());
        } else if (adminRequest instanceof GetNbMaxMsgRequest) {
            this.replyToTopic((AdminReply)new GetNumberReply(this.getNbMaxMsg()), not.getReplyTo(), not.getRequestMsgId(), not.getReplyMsgId());
        } else if (adminRequest instanceof GetPendingMessages) {
            DMQManager dmqManager = this.cleanPendingMessage(System.currentTimeMillis());
            if (dmqManager != null) {
                dmqManager.sendToDMQ();
            }
            this.replyToTopic((AdminReply)new GetNumberReply(this.getPendingMessageCount()), not.getReplyTo(), not.getRequestMsgId(), not.getReplyMsgId());
        } else if (adminRequest instanceof GetPendingRequests) {
            this.cleanWaitingRequest(System.currentTimeMillis());
            this.replyToTopic((AdminReply)new GetNumberReply(this.getWaitingRequestCount()), not.getReplyTo(), not.getRequestMsgId(), not.getReplyMsgId());
        } else if (adminRequest instanceof GetDMQSettingsRequest) {
            this.replyToTopic((AdminReply)new GetDMQSettingsReply(this.dmqId != null ? this.dmqId.toString() : null, this.threshold), not.getReplyTo(), not.getRequestMsgId(), not.getReplyMsgId());
        } else if (adminRequest instanceof SetThresholdRequest) {
            this.setSave();
            this.threshold = ((SetThresholdRequest)adminRequest).getThreshold();
            this.replyToTopic(new AdminReply(true, null), not.getReplyTo(), not.getRequestMsgId(), not.getReplyMsgId());
        } else if (adminRequest instanceof SetNbMaxMsgRequest) {
            this.setSave();
            this.nbMaxMsg = ((SetNbMaxMsgRequest)adminRequest).getNbMaxMsg();
            this.replyToTopic(new AdminReply(true, null), not.getReplyTo(), not.getRequestMsgId(), not.getReplyMsgId());
        } else if (adminRequest instanceof SetSyncExceptionOnFullDestRequest) {
            this.setSave();
            this.syncExceptionOnFullDest = ((SetSyncExceptionOnFullDestRequest)adminRequest).isSyncExceptionOnFullDest();
            this.replyToTopic(new AdminReply(true, null), not.getReplyTo(), not.getRequestMsgId(), not.getReplyMsgId());
        } else if (adminRequest instanceof GetDeliveredMessages) {
            this.replyToTopic((AdminReply)new GetNumberReply((int)this.nbMsgsDeliverSinceCreation), not.getReplyTo(), not.getRequestMsgId(), not.getReplyMsgId());
        } else {
            super.handleAdminRequestNot(from, not);
        }
    }

    private void getQueueMessageIds(AgentId replyTo, String requestMsgId, String replyMsgId) {
        String[] res = new String[this.messages.size()];
        for (int i = 0; i < this.messages.size(); ++i) {
            org.objectweb.joram.mom.messages.Message msg = (org.objectweb.joram.mom.messages.Message)this.messages.get(i);
            res[i] = msg.getId();
        }
        this.replyToTopic((AdminReply)new GetQueueMessageIdsRep(res), replyTo, requestMsgId, replyMsgId);
    }

    private void getQueueMessage(GetQueueMessage request, AgentId replyTo, String requestMsgId, String replyMsgId) {
        org.objectweb.joram.mom.messages.Message message = null;
        for (int i = 0; i < this.messages.size() && !(message = (org.objectweb.joram.mom.messages.Message)this.messages.get(i)).getId().equals(request.getMessageId()); ++i) {
            message = null;
        }
        if (message != null) {
            GetQueueMessageRep reply = null;
            reply = request.getFullMessage() ? new GetQueueMessageRep(message.getFullMessage()) : new GetQueueMessageRep(message.getHeaderMessage());
            this.replyToTopic((AdminReply)reply, replyTo, requestMsgId, replyMsgId);
        } else {
            this.replyToTopic(new AdminReply(false, "Unknown message " + request.getMessageId()), replyTo, requestMsgId, replyMsgId);
        }
    }

    private void deleteQueueMessage(DeleteQueueMessage request, AgentId replyTo, String requestMsgId, String replyMsgId) {
        for (int i = 0; i < this.messages.size(); ++i) {
            org.objectweb.joram.mom.messages.Message message = (org.objectweb.joram.mom.messages.Message)this.messages.get(i);
            if (!message.getId().equals(request.getMessageId())) continue;
            this.messages.remove(i);
            message.delete();
            DMQManager dmqManager = new DMQManager(this.dmqId, this.getId());
            ++this.nbMsgsSentToDMQSinceCreation;
            dmqManager.addDeadMessage(message.getFullMessage(), (short)3);
            dmqManager.sendToDMQ();
            break;
        }
        this.replyToTopic(new AdminReply(true, null), replyTo, requestMsgId, replyMsgId);
    }

    private void clearQueue(AgentId replyTo, String requestMsgId, String replyMsgId) {
        if (this.messages.size() > 0) {
            DMQManager dmqManager = new DMQManager(this.dmqId, this.getId());
            for (int i = 0; i < this.messages.size(); ++i) {
                org.objectweb.joram.mom.messages.Message message = (org.objectweb.joram.mom.messages.Message)this.messages.get(i);
                message.delete();
                ++this.nbMsgsSentToDMQSinceCreation;
                dmqManager.addDeadMessage(message.getFullMessage(), (short)3);
            }
            dmqManager.sendToDMQ();
            this.messages.clear();
        }
        this.replyToTopic(new AdminReply(true, null), replyTo, requestMsgId, replyMsgId);
    }

    protected void doRightRequest(AgentId user, int right) {
        if (right != -READ) {
            return;
        }
        if (user == null) {
            for (int i = 0; i < this.requests.size(); ++i) {
                ReceiveRequest request = (ReceiveRequest)((Object)this.requests.get(i));
                if (this.isReader(request.requester)) continue;
                this.forward(request.requester, new ExceptionReply(request, (MomException)((Object)new AccessException("Free READ access removed"))));
                this.setSave();
                this.requests.remove(i);
                --i;
            }
        } else {
            for (int i = 0; i < this.requests.size(); ++i) {
                ReceiveRequest request = (ReceiveRequest)((Object)this.requests.get(i));
                if (!user.equals((Object)request.requester)) continue;
                this.forward(request.requester, new ExceptionReply(request, (MomException)((Object)new AccessException("READ right removed"))));
                this.setSave();
                this.requests.remove(i);
                --i;
            }
        }
    }

    protected void doClientMessages(AgentId from, ClientMessages not, boolean throwsExceptionOnFullDest) throws AccessException {
        ClientMessages clientMsgs;
        this.receiving = true;
        ClientMessages cm = null;
        if (this.interceptorsAvailable()) {
            cm = new ClientMessages(not.getClientContext(), not.getRequestId());
            cm.setAsyncSend(not.getAsyncSend());
            cm.setDMQId(not.getDMQId());
            for (Message message : not.getMessages()) {
                message.setProperty("JoramDestinationName", (Object)this.getName());
                Message m = this.processInterceptors(message);
                if (m == null) {
                    DMQManager dmqManager = new DMQManager(this.dmqId, this.getId());
                    ++this.nbMsgsSentToDMQSinceCreation;
                    dmqManager.addDeadMessage(message, (short)7);
                    dmqManager.sendToDMQ();
                    new org.objectweb.joram.mom.messages.Message(message).releaseFullMessage();
                    continue;
                }
                cm.addMessage(m);
            }
            if (cm.getMessageCount() == 0) {
                this.receiving = false;
                return;
            }
        } else {
            cm = not;
        }
        if ((clientMsgs = this.preProcess(from, cm)) != null) {
            Iterator msgs = clientMsgs.getMessages().iterator();
            while (msgs.hasNext()) {
                org.objectweb.joram.mom.messages.Message msg = new org.objectweb.joram.mom.messages.Message((Message)msgs.next());
                ++this.arrivalsCounter;
                msg.order = msg.order;
                this.storeMessage(msg, throwsExceptionOnFullDest);
                if (!msg.isPersistent()) continue;
                this.setSave();
            }
        }
        this.deliverMessages(0);
        if (clientMsgs != null) {
            this.postProcess(clientMsgs);
        }
        this.receiving = false;
    }

    protected void doUnknownAgent(UnknownAgent uA) {
        AgentId client = uA.agent;
        Notification not = uA.not;
        if (!(not instanceof QueueMsgReply)) {
            return;
        }
        DMQManager dmqManager = null;
        Iterator entries = this.deliveredMsgs.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry entry = entries.next();
            String msgId = (String)entry.getKey();
            org.objectweb.joram.mom.messages.Message message = (org.objectweb.joram.mom.messages.Message)entry.getValue();
            AgentId consId = (AgentId)this.consumers.get(msgId);
            if (!consId.equals((Object)client)) continue;
            entries.remove();
            message.setRedelivered();
            this.setSave();
            this.consumers.remove(msgId);
            this.contexts.remove(msgId);
            if (this.isUndeliverable(message)) {
                message.delete();
                if (dmqManager == null) {
                    dmqManager = new DMQManager(this.dmqId, this.getId());
                }
                ++this.nbMsgsSentToDMQSinceCreation;
                dmqManager.addDeadMessage(message.getFullMessage(), (short)2);
            } else {
                try {
                    this.storeMessageHeader(message, false);
                }
                catch (AccessException e) {
                    // empty catch block
                }
            }
            if (!logger.isLoggable(BasicLevel.WARN)) continue;
            logger.log(BasicLevel.WARN, (Object)("Message " + message.getId() + " denied."));
        }
        if (dmqManager != null) {
            dmqManager.sendToDMQ();
        }
        this.deliverMessages(0);
    }

    protected void doDeleteNot(DeleteNot not) {
        DestinationException exc = new DestinationException("Queue " + this.getId() + " is deleted.");
        this.cleanWaitingRequest(System.currentTimeMillis());
        for (int i = 0; i < this.requests.size(); ++i) {
            ReceiveRequest rec = (ReceiveRequest)((Object)this.requests.get(i));
            ExceptionReply excRep = new ExceptionReply(rec, (MomException)exc);
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("Requester " + rec.requester + " notified of the queue deletion."));
            }
            this.forward(rec.requester, excRep);
        }
        if (!this.messages.isEmpty()) {
            DMQManager dmqManager = new DMQManager(this.dmqId, this.getId());
            while (!this.messages.isEmpty()) {
                org.objectweb.joram.mom.messages.Message message = (org.objectweb.joram.mom.messages.Message)this.messages.remove(0);
                message.delete();
                ++this.nbMsgsSentToDMQSinceCreation;
                dmqManager.addDeadMessage(message.getFullMessage(), (short)4);
            }
            dmqManager.sendToDMQ();
        }
        org.objectweb.joram.mom.messages.Message.deleteAll(this.getMsgTxPrefix().toString());
    }

    protected final StringBuffer getMsgTxPrefix() {
        if (this.msgTxPrefix == null) {
            this.msgTxPrefix = new StringBuffer(18).append('M').append(this.getId().toString()).append('_');
            this.msgTxPrefixLength = this.msgTxPrefix.length();
        }
        return this.msgTxPrefix;
    }

    protected final void setMsgTxName(org.objectweb.joram.mom.messages.Message msg) {
        if (msg.getTxName() == null) {
            msg.setTxName(this.getMsgTxPrefix().append(msg.order).toString());
            this.msgTxPrefix.setLength(this.msgTxPrefixLength);
        }
    }

    protected final synchronized void storeMessage(org.objectweb.joram.mom.messages.Message msg, boolean throwsExceptionOnFullDest) throws AccessException {
        if (this.addMessage(msg, throwsExceptionOnFullDest)) {
            this.setMsgTxName(msg);
            msg.save();
            msg.releaseFullMessage();
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("Message " + msg.getId() + " stored."));
            }
        }
    }

    protected final synchronized void storeMessageHeader(org.objectweb.joram.mom.messages.Message message, boolean throwsExceptionOnFullDest) throws AccessException {
        if (this.addMessage(message, throwsExceptionOnFullDest)) {
            message.saveHeader();
            message.releaseFullMessage();
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("Message " + message.getId() + " stored."));
            }
        }
    }

    public boolean isSyncExceptionOnFullDest() {
        return this.syncExceptionOnFullDest;
    }

    public void setSyncExceptionOnFullDest(boolean syncExceptionOnFullDest) {
        this.syncExceptionOnFullDest = syncExceptionOnFullDest;
    }

    protected final synchronized boolean addMessage(org.objectweb.joram.mom.messages.Message message, boolean throwsExceptionOnFullDest) throws AccessException {
        if (this.nbMaxMsg > -1 && this.nbMaxMsg <= this.messages.size() + this.deliveredMsgs.size()) {
            if (throwsExceptionOnFullDest && this.isSyncExceptionOnFullDest()) {
                if (logger.isLoggable(BasicLevel.INFO)) {
                    logger.log(BasicLevel.INFO, (Object)("addMessage " + message.getId() + " throws Exception: The queue \"" + this.getName() + "\" is full (syncExceptionOnFullDest)."));
                }
                throw new AccessException("The queue \"" + this.getName() + "\" is full.");
            }
            DMQManager dmqManager = new DMQManager(this.dmqId, this.getId());
            ++this.nbMsgsSentToDMQSinceCreation;
            dmqManager.addDeadMessage(message.getFullMessage(), (short)5);
            dmqManager.sendToDMQ();
            return false;
        }
        if (this.messages.isEmpty()) {
            this.samePriorities = true;
            this.priority = message.getPriority();
        } else if (this.samePriorities && this.priority != message.getPriority()) {
            this.samePriorities = false;
        }
        if (this.samePriorities) {
            if (this.receiving) {
                this.messages.add(message);
            } else {
                long currentO;
                int i = 0;
                Iterator ite = this.messages.iterator();
                while (ite.hasNext() && (currentO = ((org.objectweb.joram.mom.messages.Message)ite.next()).order) <= message.order) {
                    ++i;
                }
                this.messages.add(i, message);
            }
        } else {
            int i = 0;
            for (org.objectweb.joram.mom.messages.Message currentMsg : this.messages) {
                int currentP = currentMsg.getPriority();
                long currentO = currentMsg.order;
                if (!this.receiving && currentP == message.getPriority() ? currentO > message.order : currentP < message.getPriority()) break;
                ++i;
            }
            this.messages.add(i, message);
        }
        return true;
    }

    protected ClientMessages getClientMessages(int nb, String selector, boolean remove) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("Queue.getClientMessages(" + nb + ',' + selector + ',' + remove + ')'));
        }
        ClientMessages cm = null;
        List lsMessages = this.getMessages(nb, selector, remove);
        if (lsMessages.size() > 0) {
            cm = new ClientMessages();
        }
        org.objectweb.joram.mom.messages.Message message2 = null;
        for (org.objectweb.joram.mom.messages.Message message2 : lsMessages) {
            cm.addMessage(message2.getFullMessage());
        }
        return cm;
    }

    protected void removeMessages(List msgIds) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("Queue.removeMessages(" + msgIds + ')'));
        }
        String id2 = null;
        block0: for (String id2 : msgIds) {
            int i = 0;
            org.objectweb.joram.mom.messages.Message message = null;
            while (i < this.messages.size()) {
                message = (org.objectweb.joram.mom.messages.Message)this.messages.get(i);
                if (!id2.equals(message.getId())) continue;
                this.messages.remove(i);
                if (!logger.isLoggable(BasicLevel.DEBUG)) continue block0;
                logger.log(BasicLevel.DEBUG, (Object)("Queue.removeMessages msgId = " + id2));
                continue block0;
            }
        }
    }

    private List getMessages(int nb, String selector, boolean remove) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("Queue.getMessages(" + nb + ',' + selector + ',' + remove + ')'));
        }
        ArrayList<org.objectweb.joram.mom.messages.Message> lsMessages = new ArrayList<org.objectweb.joram.mom.messages.Message>();
        int j = 0;
        while ((lsMessages.size() < nb || nb == -1) && j < this.messages.size()) {
            org.objectweb.joram.mom.messages.Message message = (org.objectweb.joram.mom.messages.Message)this.messages.get(j);
            if (Selector.matches((Message)message.getHeaderMessage(), (String)selector) && this.checkDelivery(message.getHeaderMessage())) {
                message.incDeliveryCount();
                ++this.nbMsgsDeliverSinceCreation;
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, (Object)("Queue.getMessages() -> " + j + ',' + message.getId()));
                }
                this.messageDelivered(message.getId());
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, (Object)("Message " + message.getId()));
                }
                lsMessages.add(message);
                if (remove) {
                    this.messages.remove(message);
                    message.delete();
                    continue;
                }
                ++j;
                continue;
            }
            ++j;
        }
        return lsMessages;
    }

    private org.objectweb.joram.mom.messages.Message getMomMessage(String msgId) {
        org.objectweb.joram.mom.messages.Message msg2 = null;
        for (org.objectweb.joram.mom.messages.Message msg2 : this.messages) {
            if (!msgId.equals(msg2.getId())) continue;
            return msg2;
        }
        return msg2;
    }

    protected org.objectweb.joram.mom.messages.Message getQueueMessage(String msgId, boolean remove) {
        org.objectweb.joram.mom.messages.Message message;
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("Queue.getMessage(" + msgId + ',' + remove + ')'));
        }
        if (this.checkDelivery((message = this.getMomMessage(msgId)).getHeaderMessage())) {
            message.incDeliveryCount();
            ++this.nbMsgsDeliverSinceCreation;
            this.messageDelivered(message.getId());
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("Message " + msgId));
            }
            if (remove) {
                this.messages.remove(message);
                message.delete();
            }
        }
        return message;
    }

    public CompositeData getMessage(String msgId) throws Exception {
        org.objectweb.joram.mom.messages.Message msg = this.getQueueMessage(msgId, false);
        if (msg == null) {
            return null;
        }
        return MessageJMXWrapper.createCompositeDataSupport(msg);
    }

    public TabularData getMessages() throws Exception {
        return MessageJMXWrapper.createTabularDataSupport(this.messages);
    }

    public List getMessagesView() {
        return this.messages;
    }

    protected void deliverMessages(int index) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("Queue.deliverMessages(" + index + ')'));
        }
        ReceiveRequest notRec = null;
        List lsMessages = null;
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)(" -> requests = " + this.requests + ')'));
        }
        long current = System.currentTimeMillis();
        this.cleanWaitingRequest(current);
        DMQManager dmqManager = this.cleanPendingMessage(current);
        while (!this.messages.isEmpty() && index < this.requests.size()) {
            notRec = (ReceiveRequest)((Object)this.requests.get(index));
            QueueMsgReply notMsg = new QueueMsgReply(notRec);
            lsMessages = this.getMessages(notRec.getMessageCount(), notRec.getSelector(), notRec.getAutoAck());
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("Queue.deliverMessages: notRec.getAutoAck() = " + notRec.getAutoAck() + ", lsMessages = " + lsMessages));
            }
            for (org.objectweb.joram.mom.messages.Message message : lsMessages) {
                notMsg.addMessage(message.getFullMessage());
                if (!notRec.getAutoAck()) {
                    this.consumers.put(message.getId(), notRec.requester);
                    this.contexts.put(message.getId(), new Integer(notRec.getClientContext()));
                    this.deliveredMsgs.put(message.getId(), message);
                    this.messages.remove(message);
                }
                if (!logger.isLoggable(BasicLevel.DEBUG)) continue;
                logger.log(BasicLevel.DEBUG, (Object)("Message " + message.getId() + " to " + notRec.requester + " as reply to " + notRec.getRequestId()));
            }
            if (this.isLocal(notRec.requester)) {
                notMsg.setPersistent(false);
            }
            if (notMsg.isPersistent() && !notRec.getAutoAck()) {
                this.setSave();
            }
            if (notMsg.getSize() > 0) {
                this.requests.remove(index);
                this.forward(notRec.requester, notMsg);
                continue;
            }
            ++index;
        }
        if (dmqManager != null) {
            dmqManager.sendToDMQ();
        }
    }

    protected boolean checkDelivery(Message msg) {
        return true;
    }

    protected void messageDelivered(String msgId) {
    }

    protected void messageRemoved(String msgId) {
    }

    protected boolean isUndeliverable(org.objectweb.joram.mom.messages.Message message) {
        if (this.threshold == 0) {
            return false;
        }
        if (this.threshold > 0) {
            return message.getDeliveryCount() >= this.threshold;
        }
        if (Queue.getDefaultThreshold() > 0) {
            return message.getDeliveryCount() >= Queue.getDefaultThreshold();
        }
        return false;
    }

    public void addClientMessages(ClientMessages clientMsgs, boolean throwsExceptionOnFullDest) throws AccessException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("Queue.addClientMessage(" + (Object)((Object)clientMsgs) + ')'));
        }
        if (clientMsgs != null) {
            Iterator msgs = clientMsgs.getMessages().iterator();
            while (msgs.hasNext()) {
                org.objectweb.joram.mom.messages.Message msg = new org.objectweb.joram.mom.messages.Message((Message)msgs.next());
                ++this.arrivalsCounter;
                msg.order = msg.order;
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, (Object)("Queue.addClientMessage() -> " + msg.getId() + ',' + msg.order));
                }
                if (this.interceptorsAvailable()) {
                    Message message = msg.getFullMessage();
                    message.setProperty("JoramDestinationName", (Object)this.getName());
                    Message m = this.processInterceptors(message);
                    if (m == null) {
                        DMQManager dmqManager = new DMQManager(this.dmqId, this.getId());
                        ++this.nbMsgsSentToDMQSinceCreation;
                        dmqManager.addDeadMessage(msg.getFullMessage(), (short)7);
                        dmqManager.sendToDMQ();
                        msg.releaseFullMessage();
                        continue;
                    }
                    msg = new org.objectweb.joram.mom.messages.Message(m);
                }
                this.storeMessage(msg, throwsExceptionOnFullDest);
            }
        }
        this.deliverMessages(0);
    }

    public void readBag(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.receiving = in.readBoolean();
        this.messages = (List)in.readObject();
        this.deliveredMsgs = (Map)in.readObject();
        for (int i = 0; i < this.messages.size(); ++i) {
            org.objectweb.joram.mom.messages.Message message = (org.objectweb.joram.mom.messages.Message)this.messages.get(i);
            this.setMsgTxName(message);
            message.save();
        }
    }

    public void writeBag(ObjectOutputStream out) throws IOException {
        out.writeBoolean(this.receiving);
        out.writeObject(this.messages);
        out.writeObject(this.deliveredMsgs);
    }

    protected void handleExpiredNot(AgentId from, ExpiredNot not) {
        List messages;
        Notification expiredNot = not.getExpiredNot();
        if (expiredNot instanceof ClientMessages) {
            messages = ((ClientMessages)expiredNot).getMessages();
        } else if (expiredNot instanceof TopicMsgsReply) {
            messages = ((TopicMsgsReply)expiredNot).getMessages();
        } else {
            if (logger.isLoggable(BasicLevel.ERROR)) {
                logger.log(BasicLevel.ERROR, (Object)("Expired notification holds an unknown notification: " + expiredNot.getClass().getName()));
            }
            return;
        }
        DMQManager dmqManager = new DMQManager(this.getId(), null);
        Iterator iterator = messages.iterator();
        while (iterator.hasNext()) {
            dmqManager.addDeadMessage((Message)iterator.next(), (short)0);
        }
        dmqManager.sendToDMQ();
    }

    public String getTxName(String msgId) {
        org.objectweb.joram.mom.messages.Message momMsg = this.getMomMessage(msgId);
        if (momMsg != null) {
            return momMsg.getTxName();
        }
        return null;
    }

    protected Properties getStats() {
        Properties stats = new Properties();
        stats.put("NbMsgsDeliverSinceCreation", (Object)this.nbMsgsDeliverSinceCreation);
        stats.put("PendingMessageCount", (Object)this.getPendingMessageCount());
        return stats;
    }
}

