/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.ejb2.internal;

import org.ow2.jonas.ejb2.EJBService;
import org.ow2.util.ee.deploy.api.deployable.EJB21Deployable;
import org.ow2.util.ee.deploy.api.deployable.IDeployable;
import org.ow2.util.ee.deploy.api.deployer.DeployerException;
import org.ow2.util.ee.deploy.impl.deployer.AbsDeployer;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class EJB21Deployer
extends AbsDeployer<EJB21Deployable> {
    private Log logger = LogFactory.getLog(EJB21Deployer.class);
    private EJBService ejb21Service = null;

    public void doUndeploy(IDeployable<EJB21Deployable> deployable) throws DeployerException {
        this.logger.info((Object)"Undeploying {0}", new Object[]{deployable.getShortName()});
        try {
            this.ejb21Service.removeContainer(this.getFile(deployable).getAbsolutePath());
        }
        catch (Exception e) {
            throw new DeployerException("Cannot deploy the EJB 2.1 deployable '" + deployable + "'.", (Throwable)e);
        }
    }

    public void doDeploy(IDeployable<EJB21Deployable> deployable) throws DeployerException {
        this.logger.info((Object)"Deploying {0}", new Object[]{deployable.getShortName()});
        try {
            this.ejb21Service.createContainer(this.getFile(deployable).getAbsolutePath());
        }
        catch (Exception e) {
            throw new DeployerException("Cannot deploy the EJB 2.1 deployable '" + deployable + "'.", (Throwable)e);
        }
    }

    public boolean supports(IDeployable<?> deployable) {
        return EJB21Deployable.class.isInstance(deployable);
    }

    public void setEjb21Service(EJBService ejb21Service) {
        this.ejb21Service = ejb21Service;
    }
}

