/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.ejb2.internal.mbean;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Set;
import javax.jms.Queue;
import javax.jms.Topic;
import javax.mail.Session;
import javax.mail.internet.MimePartDataSource;
import javax.management.BadAttributeValueExpException;
import javax.management.BadBinaryOpValueExpException;
import javax.management.BadStringOperationException;
import javax.management.InvalidApplicationException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.Query;
import javax.management.QueryEval;
import javax.management.QueryExp;
import org.ow2.jonas.deployment.api.IResourceEnvRefDesc;
import org.ow2.jonas.deployment.api.IResourceRefDesc;
import org.ow2.jonas.deployment.ejb.BeanDesc;
import org.ow2.jonas.deployment.ejb.EntityJdbcCmp1Desc;
import org.ow2.jonas.deployment.ejb.EntityJdbcCmp2Desc;
import org.ow2.jonas.jmx.JmxService;
import org.ow2.jonas.lib.ejb21.JFactory;
import org.ow2.jonas.lib.management.javaee.J2EEManagedObject;
import org.ow2.jonas.lib.management.javaee.J2eeObjectName;

public class EJB
extends J2EEManagedObject {
    protected JFactory ejbToManage = null;
    protected BeanDesc desc = null;
    protected String fileName = null;
    MBeanServer mbeanServer = null;

    public EJB(String objectName, JFactory ejbToManage, JmxService jmx) {
        super(objectName);
        this.ejbToManage = ejbToManage;
        this.fileName = ejbToManage.getContainer().getExternalFileName();
        this.desc = ejbToManage.getDeploymentDescriptor();
        this.mbeanServer = jmx.getJmxServer();
    }

    public String getName() {
        return this.desc.getEjbName();
    }

    public String getFileName() {
        return this.fileName;
    }

    public Hashtable getAllJdbcResourceAdapterName() {
        Hashtable<String, ObjectName> result = new Hashtable<String, ObjectName>();
        ArrayList jdbcResourceRefJndiNames = this.getAllJdbcResourceRefJndiNames();
        if (jdbcResourceRefJndiNames.isEmpty()) {
            return result;
        }
        for (int i = 0; i < jdbcResourceRefJndiNames.size(); ++i) {
            String jndiName = (String)jdbcResourceRefJndiNames.get(i);
            QueryExp match = Query.match(Query.attr("jndiName"), Query.value(jndiName));
            QueryExp query = Query.and(match, new DataSourcePropertiesQueryExp());
            Set<ObjectName> objectNames = this.mbeanServer.queryNames(J2eeObjectName.getResourceAdapters((String)"*", null), query);
            if (objectNames.isEmpty()) continue;
            result.put(jndiName, objectNames.iterator().next());
        }
        return result;
    }

    public Hashtable getAllDataSourceName() {
        Hashtable<String, String> result = new Hashtable<String, String>();
        ArrayList jdbcResourceRefJndiNames = this.getAllJdbcResourceRefJndiNames();
        if (jdbcResourceRefJndiNames.isEmpty()) {
            return result;
        }
        for (String jndiName : jdbcResourceRefJndiNames) {
            QueryExp match = Query.match(Query.attr("jndiName"), Query.value(jndiName));
            Set<ObjectName> objectNames = this.mbeanServer.queryNames(J2eeObjectName.getJDBCDataSources((String)"*", null), match);
            if (objectNames.isEmpty()) continue;
            ObjectName on = objectNames.iterator().next();
            result.put(jndiName, on.getKeyProperty("name"));
        }
        return result;
    }

    private ArrayList getAllJdbcResourceRefJndiNames() {
        ArrayList<String> jndiNames = new ArrayList<String>();
        String jndiName = null;
        IResourceRefDesc[] rrDesc = this.desc.getResourceRefDesc();
        for (int i = 0; i < rrDesc.length; ++i) {
            if (!rrDesc[i].isJdbc()) continue;
            jndiName = rrDesc[i].getJndiName();
            jndiNames.add(jndiName);
        }
        if (this.desc instanceof EntityJdbcCmp1Desc) {
            EntityJdbcCmp1Desc jdbcCmp1Desc = (EntityJdbcCmp1Desc)this.desc;
            jndiName = jdbcCmp1Desc.getDatasourceJndiName();
            jndiNames.add(jndiName);
        } else if (this.desc instanceof EntityJdbcCmp2Desc) {
            EntityJdbcCmp2Desc jdbcCmp2Desc = (EntityJdbcCmp2Desc)this.desc;
            jndiName = jdbcCmp2Desc.getDatasourceJndiName();
            jndiNames.add(jndiName);
        }
        return jndiNames;
    }

    public Set getAllJMSConnectionFactoryName() {
        HashSet<String> result = new HashSet<String>();
        IResourceRefDesc[] rrDesc = this.desc.getResourceRefDesc();
        for (int i = 0; i < rrDesc.length; ++i) {
            if (!"javax.jms.TopicConnectionFactory".equals(rrDesc[i].getTypeName()) && !"javax.jms.QueueConnectionFactory".equals(rrDesc[i].getTypeName()) && !"javax.jms.ConnectionFactory".equals(rrDesc[i].getTypeName())) continue;
            result.add(rrDesc[i].getJndiName());
        }
        return result;
    }

    public Hashtable getAllMailFactorySName() {
        return this.getAllMailFactoryName(Session.class.getName());
    }

    public Hashtable getAllMailFactoryMName() {
        return this.getAllMailFactoryName(MimePartDataSource.class.getName());
    }

    private Hashtable getAllMailFactoryName(String type) {
        Hashtable<String, String> result = new Hashtable<String, String>();
        IResourceRefDesc[] rrDesc = this.desc.getResourceRefDesc();
        for (int i = 0; i < rrDesc.length; ++i) {
            if (!type.equals(rrDesc[i].getTypeName())) continue;
            String jndiName = rrDesc[i].getJndiName();
            QueryExp match = Query.match(Query.attr("Name"), Query.value(jndiName));
            Set<ObjectName> objectNames = this.mbeanServer.queryNames(J2eeObjectName.JavaMailResources((String)"*", null, (String)type), match);
            if (!objectNames.isEmpty()) {
                ObjectName on = objectNames.iterator().next();
                String factoryName = null;
                try {
                    factoryName = (String)this.mbeanServer.getAttribute(on, "FactoryName");
                }
                catch (Exception e) {
                    factoryName = "";
                }
                result.put(jndiName, factoryName);
                continue;
            }
            result.put(jndiName, "");
        }
        return result;
    }

    public Set getAllJMSDestinationName() {
        HashSet<String> result = new HashSet<String>();
        IResourceEnvRefDesc[] rrDesc = this.desc.getResourceEnvRefDesc();
        for (int i = 0; i < rrDesc.length; ++i) {
            if (rrDesc[i].getType() != Topic.class && rrDesc[i].getType() != Queue.class) continue;
            result.add(rrDesc[i].getJndiName());
        }
        return result;
    }

    public Set getAllURLs() {
        HashSet<String> result = new HashSet<String>();
        IResourceRefDesc[] rrDesc = this.desc.getResourceRefDesc();
        for (int i = 0; i < rrDesc.length; ++i) {
            if (!"java.net.URL".equals(rrDesc[i].getTypeName())) continue;
            result.add(rrDesc[i].getJndiName());
        }
        return result;
    }

    public int getPoolSize() {
        return this.ejbToManage.getPoolSize();
    }

    public int getMinPoolSize() {
        return this.ejbToManage.getMinPoolSize();
    }

    public int getMaxCacheSize() {
        return this.ejbToManage.getMaxCacheSize();
    }

    public int getCacheSize() {
        return this.ejbToManage.getCacheSize();
    }

    public void reduceCacheSize() {
        this.ejbToManage.reduceCache();
    }

    public String getEjbClass() {
        return this.desc.getEjbClass().getName();
    }

    public String getDisplayName() {
        if (this.desc.getDisplayName() != null) {
            return this.desc.getDisplayName();
        }
        return this.desc.getEjbName();
    }

    public String getJndiName() {
        return this.desc.getJndiName();
    }

    public String getHomeClass() {
        if (this.desc.getHomeClass() != null) {
            return this.desc.getHomeClass().getName();
        }
        return null;
    }

    public String getRemoteClass() {
        if (this.desc.getRemoteClass() != null) {
            return this.desc.getRemoteClass().getName();
        }
        return null;
    }

    public String getLocalHomeClass() {
        if (this.desc.getLocalHomeClass() != null) {
            return this.desc.getLocalHomeClass().getName();
        }
        return null;
    }

    public String getLocalClass() {
        if (this.desc.getLocalClass() != null) {
            return this.desc.getLocalClass().getName();
        }
        return null;
    }

    private class DataSourcePropertiesQueryExp
    extends QueryEval
    implements QueryExp {
        private static final long serialVersionUID = 4843312566830083622L;

        private DataSourcePropertiesQueryExp() {
        }

        @Override
        public boolean apply(ObjectName name) throws BadStringOperationException, BadBinaryOpValueExpException, BadAttributeValueExpException, InvalidApplicationException {
            Properties properties = null;
            try {
                properties = (Properties)DataSourcePropertiesQueryExp.getMBeanServer().getAttribute(name, "properties");
            }
            catch (Exception e) {
                return false;
            }
            String dsClassValue = properties.getProperty("dsClass");
            String urlValue = properties.getProperty("URL");
            return dsClassValue != null && dsClassValue.length() != 0 && urlValue != null && urlValue.length() != 0;
        }
    }
}

