/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.resources;

import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import org.jboss.weld.resources.spi.ResourceLoader;
import org.jboss.weld.resources.spi.ResourceLoadingException;
import org.jboss.weld.util.collections.EnumerationList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultResourceLoader
implements ResourceLoader {
    public static DefaultResourceLoader INSTANCE = new DefaultResourceLoader();

    protected DefaultResourceLoader() {
    }

    @Override
    public Class<?> classForName(String name) {
        try {
            ClassLoader tccl = Thread.currentThread().getContextClassLoader();
            if (tccl != null) {
                return tccl.loadClass(name);
            }
            return Class.forName(name);
        }
        catch (ClassNotFoundException e) {
            throw new ResourceLoadingException("Error loading class " + name, e);
        }
        catch (NoClassDefFoundError e) {
            throw new ResourceLoadingException("Error loading class " + name, e);
        }
        catch (TypeNotPresentException e) {
            throw new ResourceLoadingException("Error loading class " + name, e);
        }
    }

    @Override
    public URL getResource(String name) {
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        if (tccl != null) {
            return tccl.getResource(name);
        }
        return this.getClass().getResource(name);
    }

    @Override
    public Collection<URL> getResources(String name) {
        try {
            ClassLoader tccl = Thread.currentThread().getContextClassLoader();
            if (tccl != null) {
                return new EnumerationList<URL>(tccl.getResources(name));
            }
            return new EnumerationList<URL>(this.getClass().getClassLoader().getResources(name));
        }
        catch (IOException e) {
            throw new ResourceLoadingException("Error loading resource " + name, e);
        }
    }

    @Override
    public void cleanup() {
    }
}

