/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.document;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class DateTools {
    private static final ThreadLocal<DateFormats> FORMATS = new ThreadLocal<DateFormats>(){

        @Override
        protected DateFormats initialValue() {
            return new DateFormats();
        }
    };

    private DateTools() {
    }

    public static String dateToString(Date date, Resolution resolution) {
        return DateTools.timeToString(date.getTime(), resolution);
    }

    public static String timeToString(long time, Resolution resolution) {
        DateFormats formats = FORMATS.get();
        formats.calInstance.setTimeInMillis(DateTools.round(time, resolution));
        Date date = formats.calInstance.getTime();
        switch (resolution) {
            case YEAR: {
                return formats.YEAR_FORMAT.format(date);
            }
            case MONTH: {
                return formats.MONTH_FORMAT.format(date);
            }
            case DAY: {
                return formats.DAY_FORMAT.format(date);
            }
            case HOUR: {
                return formats.HOUR_FORMAT.format(date);
            }
            case MINUTE: {
                return formats.MINUTE_FORMAT.format(date);
            }
            case SECOND: {
                return formats.SECOND_FORMAT.format(date);
            }
            case MILLISECOND: {
                return formats.MILLISECOND_FORMAT.format(date);
            }
        }
        throw new IllegalArgumentException("unknown resolution " + (Object)((Object)resolution));
    }

    public static long stringToTime(String dateString) throws ParseException {
        return DateTools.stringToDate(dateString).getTime();
    }

    public static Date stringToDate(String dateString) throws ParseException {
        DateFormats formats = FORMATS.get();
        if (dateString.length() == 4) {
            return formats.YEAR_FORMAT.parse(dateString);
        }
        if (dateString.length() == 6) {
            return formats.MONTH_FORMAT.parse(dateString);
        }
        if (dateString.length() == 8) {
            return formats.DAY_FORMAT.parse(dateString);
        }
        if (dateString.length() == 10) {
            return formats.HOUR_FORMAT.parse(dateString);
        }
        if (dateString.length() == 12) {
            return formats.MINUTE_FORMAT.parse(dateString);
        }
        if (dateString.length() == 14) {
            return formats.SECOND_FORMAT.parse(dateString);
        }
        if (dateString.length() == 17) {
            return formats.MILLISECOND_FORMAT.parse(dateString);
        }
        throw new ParseException("Input is not valid date string: " + dateString, 0);
    }

    public static Date round(Date date, Resolution resolution) {
        return new Date(DateTools.round(date.getTime(), resolution));
    }

    public static long round(long time, Resolution resolution) {
        Calendar calInstance = DateTools.FORMATS.get().calInstance;
        calInstance.setTimeInMillis(time);
        switch (resolution) {
            case YEAR: {
                calInstance.set(2, 0);
                calInstance.set(5, 1);
                calInstance.set(11, 0);
                calInstance.set(12, 0);
                calInstance.set(13, 0);
                calInstance.set(14, 0);
                break;
            }
            case MONTH: {
                calInstance.set(5, 1);
                calInstance.set(11, 0);
                calInstance.set(12, 0);
                calInstance.set(13, 0);
                calInstance.set(14, 0);
                break;
            }
            case DAY: {
                calInstance.set(11, 0);
                calInstance.set(12, 0);
                calInstance.set(13, 0);
                calInstance.set(14, 0);
                break;
            }
            case HOUR: {
                calInstance.set(12, 0);
                calInstance.set(13, 0);
                calInstance.set(14, 0);
                break;
            }
            case MINUTE: {
                calInstance.set(13, 0);
                calInstance.set(14, 0);
                break;
            }
            case SECOND: {
                calInstance.set(14, 0);
                break;
            }
            case MILLISECOND: {
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown resolution " + (Object)((Object)resolution));
            }
        }
        return calInstance.getTimeInMillis();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Resolution {
        YEAR,
        MONTH,
        DAY,
        HOUR,
        MINUTE,
        SECOND,
        MILLISECOND;


        public String toString() {
            return super.toString().toLowerCase(Locale.ENGLISH);
        }
    }

    private static final class DateFormats {
        static final TimeZone GMT = TimeZone.getTimeZone("GMT");
        final SimpleDateFormat YEAR_FORMAT = new SimpleDateFormat("yyyy", Locale.US);
        final SimpleDateFormat MONTH_FORMAT = new SimpleDateFormat("yyyyMM", Locale.US);
        final SimpleDateFormat DAY_FORMAT = new SimpleDateFormat("yyyyMMdd", Locale.US);
        final SimpleDateFormat HOUR_FORMAT = new SimpleDateFormat("yyyyMMddHH", Locale.US);
        final SimpleDateFormat MINUTE_FORMAT = new SimpleDateFormat("yyyyMMddHHmm", Locale.US);
        final SimpleDateFormat SECOND_FORMAT = new SimpleDateFormat("yyyyMMddHHmmss", Locale.US);
        final SimpleDateFormat MILLISECOND_FORMAT = new SimpleDateFormat("yyyyMMddHHmmssSSS", Locale.US);
        final Calendar calInstance;

        private DateFormats() {
            this.YEAR_FORMAT.setTimeZone(GMT);
            this.MONTH_FORMAT.setTimeZone(GMT);
            this.DAY_FORMAT.setTimeZone(GMT);
            this.HOUR_FORMAT.setTimeZone(GMT);
            this.MINUTE_FORMAT.setTimeZone(GMT);
            this.SECOND_FORMAT.setTimeZone(GMT);
            this.MILLISECOND_FORMAT.setTimeZone(GMT);
            this.calInstance = Calendar.getInstance(GMT, Locale.US);
        }
    }
}

