/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.filter;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.util.DocIdBitSet;
import org.apache.lucene.util.OpenBitSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterOptimizationHelper {
    public static List<DocIdSet> mergeByBitAnds(List<DocIdSet> docIdSets) {
        int size = docIdSets.size();
        ArrayList<OpenBitSet> openBitSets = new ArrayList<OpenBitSet>(size);
        ArrayList<DocIdBitSet> docIdBitSets = new ArrayList<DocIdBitSet>(size);
        ArrayList<DocIdSet> nonMergeAble = new ArrayList<DocIdSet>(size);
        for (DocIdSet set : docIdSets) {
            if (set instanceof OpenBitSet) {
                openBitSets.add((OpenBitSet)set);
                continue;
            }
            if (set instanceof DocIdBitSet) {
                docIdBitSets.add((DocIdBitSet)set);
                continue;
            }
            nonMergeAble.add(set);
        }
        if (openBitSets.size() <= 1 && docIdBitSets.size() <= 1) {
            return docIdSets;
        }
        if (openBitSets.size() > 0) {
            nonMergeAble.add(FilterOptimizationHelper.mergeByBitAndsForOpenBitSet(openBitSets));
        }
        if (docIdBitSets.size() > 0) {
            nonMergeAble.add(FilterOptimizationHelper.mergeByBitAndsForDocIdBitSet(docIdBitSets));
        }
        return nonMergeAble;
    }

    private static DocIdBitSet mergeByBitAndsForDocIdBitSet(List<DocIdBitSet> docIdBitSets) {
        int listSize = docIdBitSets.size();
        if (listSize == 1) {
            return docIdBitSets.get(0);
        }
        BitSet result = (BitSet)docIdBitSets.get(0).getBitSet().clone();
        for (int i = 1; i < listSize; ++i) {
            BitSet bitSet = docIdBitSets.get(i).getBitSet();
            result.and(bitSet);
        }
        return new DocIdBitSet(result);
    }

    private static OpenBitSet mergeByBitAndsForOpenBitSet(List<OpenBitSet> openBitSets) {
        int listSize = openBitSets.size();
        if (listSize == 1) {
            return openBitSets.get(0);
        }
        OpenBitSet result = (OpenBitSet)openBitSets.get(0).clone();
        for (int i = 1; i < listSize; ++i) {
            OpenBitSet openSet = openBitSets.get(i);
            result.intersect(openSet);
        }
        return result;
    }
}

