/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.dsl.impl;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.TermAttribute;
import org.hibernate.annotations.common.AssertionFailure;
import org.hibernate.search.SearchException;
import org.hibernate.search.engine.DocumentBuilderIndexedEntity;
import org.hibernate.search.engine.SearchFactoryImplementor;
import org.hibernate.search.query.dsl.impl.FieldContext;
import org.hibernate.search.query.dsl.impl.QueryBuildingContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Helper {
    Helper() {
    }

    static String getAnalyzedTerm(String fieldName, String value, String name, Analyzer queryAnalyzer, FieldContext fieldContext) {
        if (fieldContext.isIgnoreAnalyzer()) {
            return value;
        }
        try {
            List<String> termsFromText = Helper.getAllTermsFromText(fieldName, value.toString(), queryAnalyzer);
            if (termsFromText.size() > 1) {
                StringBuilder error = new StringBuilder("The ").append(name).append(" parameter leads to several terms when analyzed: ");
                for (String term : termsFromText) {
                    error.append(term).append(", ");
                }
                int length = error.length();
                throw new SearchException(error.delete(length - 1, length).toString());
            }
            return termsFromText.size() == 0 ? null : termsFromText.get(0);
        }
        catch (IOException e) {
            throw new AssertionFailure("IO exception while reading String stream??", e);
        }
    }

    static List<String> getAllTermsFromText(String fieldName, String localText, Analyzer analyzer) throws IOException {
        ArrayList<String> terms = new ArrayList<String>();
        if (localText == null) {
            throw new SearchException("Search parameter on field " + fieldName + " could not be converted. " + "Are the parameter and the field of the same type?" + "Alternatively, apply the ignoreFieldBridge() option to " + "pass String parameters");
        }
        StringReader reader = new StringReader(localText);
        TokenStream stream = analyzer.reusableTokenStream(fieldName, reader);
        TermAttribute attribute = stream.addAttribute(TermAttribute.class);
        stream.reset();
        while (stream.incrementToken()) {
            if (attribute.termLength() <= 0) continue;
            String term = attribute.term();
            terms.add(term);
        }
        stream.end();
        stream.close();
        return terms;
    }

    static DocumentBuilderIndexedEntity<?> getDocumentBuilder(QueryBuildingContext queryContext) {
        Class<?> type;
        SearchFactoryImplementor factory = queryContext.getFactory();
        DocumentBuilderIndexedEntity<?> builder = factory.getDocumentBuilderIndexedEntity(type = queryContext.getEntityType());
        if (builder == null) {
            throw new AssertionFailure("Class in not indexed: " + type);
        }
        return builder;
    }
}

