/*
 * Decompiled with CFR 0.152.
 */
package fr.dyade.aaa.agent;

import fr.dyade.aaa.agent.AgentId;
import fr.dyade.aaa.agent.AgentServer;
import fr.dyade.aaa.agent.BufferedMessageInputStream;
import fr.dyade.aaa.agent.BufferedMessageOutputStream;
import fr.dyade.aaa.agent.Channel;
import fr.dyade.aaa.agent.ExpiredNot;
import fr.dyade.aaa.agent.Message;
import fr.dyade.aaa.agent.MessageSoftList;
import fr.dyade.aaa.agent.NetSessionWrapper;
import fr.dyade.aaa.agent.PoolNetworkMBean;
import fr.dyade.aaa.agent.ServerDesc;
import fr.dyade.aaa.agent.StreamNetwork;
import fr.dyade.aaa.agent.UnknownServerException;
import fr.dyade.aaa.common.Daemon;
import fr.dyade.aaa.util.management.MXWrapper;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.OptionalDataException;
import java.io.OutputStream;
import java.io.StreamCorruptedException;
import java.net.ConnectException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Vector;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public class PoolNetwork
extends StreamNetwork
implements PoolNetworkMBean {
    public static final byte[] magic = new byte[]{80, 111, 111, 108, 78, 101, 116, 0};
    WakeOnConnection wakeOnConnection = null;
    NetSession[] sessions = null;
    Dispatcher dispatcher = null;
    WatchDog watchDog = null;
    List<NetSession> activeSessions;
    boolean compressedFlows = false;
    int nbMaxCnx;
    long IdleTimeout = 60000L;
    int defaultMaxMessageInFlow = -1;

    public boolean getCompressedFlows() {
        return this.compressedFlows;
    }

    public int getNbMaxActiveSession() {
        return this.nbMaxCnx;
    }

    public int getNbActiveSession() {
        return this.activeSessions.size();
    }

    public long getIdleTimeout() {
        return this.IdleTimeout;
    }

    public void setIdleTimeout(long idleTimeout) {
        if (idleTimeout > 1000L) {
            this.IdleTimeout = idleTimeout;
        }
    }

    public void init(String name, int port, short[] servers) throws Exception {
        super.init(name, port, servers);
        this.sessions = new NetSession[servers.length];
        for (int i = 0; i < this.sessions.length; ++i) {
            if (servers[i] == AgentServer.getServerId()) continue;
            this.sessions[i] = new NetSession(this.getName(), servers[i]);
        }
        this.wakeOnConnection = new WakeOnConnection(this.getName(), this.logmon);
        this.dispatcher = new Dispatcher(this.getName(), this.logmon);
        this.watchDog = new WatchDog(this.getName(), this.logmon);
    }

    public void setProperties() throws Exception {
        if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
            this.logmon.log(BasicLevel.DEBUG, (Object)(this.domain + ", PoolNetwork.setProperties()"));
        }
        super.setProperties();
        try {
            this.nbMaxCnx = AgentServer.getInteger(this.domain + ".nbMaxCnx");
        }
        catch (Exception exc) {
            try {
                this.nbMaxCnx = AgentServer.getInteger("PoolNetwork.nbMaxCnx");
            }
            catch (Exception exc2) {
                this.nbMaxCnx = -1;
            }
        }
        this.IdleTimeout = AgentServer.getLong("PoolNetwork.IdleTimeout", this.IdleTimeout);
        this.IdleTimeout = AgentServer.getLong(this.domain + ".IdleTimeout", this.IdleTimeout);
        if (this.IdleTimeout < 1000L) {
            this.IdleTimeout = 5000L;
        }
        this.defaultMaxMessageInFlow = AgentServer.getInteger("PoolNetwork.maxMessageInFlow", this.defaultMaxMessageInFlow);
        this.defaultMaxMessageInFlow = AgentServer.getInteger(this.domain + ".maxMessageInFlow", this.defaultMaxMessageInFlow);
        String value = AgentServer.getProperty(this.domain + ".compressedFlows");
        if (value == null) {
            value = AgentServer.getProperty("PoolNetwork.compressedFlows");
        }
        this.compressedFlows = Boolean.valueOf(value);
        if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
            StringBuffer strbuf = new StringBuffer();
            strbuf.append(" setProperties(");
            strbuf.append("nbMaxCnx=").append(this.nbMaxCnx);
            strbuf.append(", IdleTimeout=").append(this.IdleTimeout);
            strbuf.append(", defaultMaxMessageInFlow=").append(this.defaultMaxMessageInFlow);
            strbuf.append(", compressedFlows=").append(this.compressedFlows);
            strbuf.append(')');
            this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + strbuf.toString()));
        }
    }

    public synchronized void addServer(short id) throws Exception {
        int i;
        if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
            StringBuffer strbuf = new StringBuffer();
            strbuf.append(this.getName()).append(" before addServer(").append(id).append("):");
            for (i = 0; i < this.servers.length; ++i) {
                strbuf.append("\n\tserver#" + this.servers[i] + " -> " + this.sessions[i]);
            }
            this.logmon.log(BasicLevel.DEBUG, (Object)strbuf.toString());
        }
        if (this.index(id) >= 0) {
            return;
        }
        try {
            super.addServer(id);
            if (this.sessions.length == this.servers.length) {
                return;
            }
            NetSession[] newSessions = new NetSession[this.servers.length];
            for (i = 0; i < this.sessions.length; ++i) {
                if (this.sessions[i] == null || this.sessions[i].sid == AgentServer.getServerId()) continue;
                newSessions[this.index((short)((NetSession)this.sessions[i]).sid)] = this.sessions[i];
                this.sessions[i] = null;
            }
            this.sessions = newSessions;
            int idx = this.index(id);
            this.sessions[idx] = new NetSession(this.getName(), id);
            this.sessions[idx].init();
            try {
                MXWrapper.registerMBean((Object)new NetSessionWrapper(this, id), (String)"AgentServer", (String)this.getMBeanName(id));
            }
            catch (Exception exc) {
                this.logmon.log(BasicLevel.WARN, (Object)(this.getName() + ".addServer - jmx failed: " + this.getMBeanName(id)), (Throwable)exc);
            }
            if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
                StringBuffer strbuf = new StringBuffer();
                strbuf.append(this.getName()).append(" after addServer:");
                for (int i2 = 0; i2 < this.servers.length; ++i2) {
                    strbuf.append("\n\tserver#" + this.servers[i2] + " -> " + this.sessions[i2]);
                }
                this.logmon.log(BasicLevel.DEBUG, (Object)strbuf.toString());
            }
        }
        catch (Exception exc) {
            this.logmon.log(BasicLevel.ERROR, (Object)(this.getName() + ", addServer failed"), (Throwable)exc);
        }
        if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
            this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", addServer ok"));
        }
    }

    public synchronized void delServer(short id) throws Exception {
        if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
            StringBuffer strbuf = new StringBuffer();
            strbuf.append(this.getName()).append(" before delServer(").append(id).append("):");
            for (int i = 0; i < this.servers.length; ++i) {
                strbuf.append("\n\tserver#" + this.servers[i] + " -> " + this.sessions[i]);
            }
            this.logmon.log(BasicLevel.DEBUG, (Object)strbuf.toString());
        }
        if (this.index(id) < 0) {
            return;
        }
        try {
            MXWrapper.unregisterMBean((String)"AgentServer", (String)this.getMBeanName(id));
        }
        catch (Exception exc) {
            this.logmon.log(BasicLevel.WARN, (Object)(this.getName() + ".delServer - jmx failed: " + this.getMBeanName(id)), (Throwable)exc);
        }
        try {
            super.delServer(id);
            NetSession[] newSessions = new NetSession[this.servers.length];
            int j = 0;
            for (int i = 0; i < this.sessions.length; ++i) {
                if (this.sessions[i] == null) {
                    ++j;
                    continue;
                }
                if (this.sessions[i].sid == id) continue;
                newSessions[j++] = this.sessions[i];
                this.sessions[i] = null;
            }
            this.sessions = newSessions;
            if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
                StringBuffer strbuf = new StringBuffer();
                strbuf.append(this.getName()).append(" after delServer:");
                for (int i = 0; i < this.servers.length; ++i) {
                    strbuf.append("\n\tserver#" + this.servers[i] + " -> " + this.sessions[i]);
                }
                this.logmon.log(BasicLevel.DEBUG, (Object)strbuf.toString());
            }
        }
        catch (Exception exc) {
            this.logmon.log(BasicLevel.ERROR, (Object)(this.getName() + " delServer failed"), (Throwable)exc);
        }
        if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
            this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + " delServer ok"));
        }
    }

    private String getMBeanName(short sid) {
        return new StringBuffer().append("server=").append(AgentServer.getName()).append(",cons=").append(this.name).append(",session=netSession#").append(sid).toString();
    }

    public void start() throws Exception {
        if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
            this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", starting"));
        }
        try {
            if (this.isRunning()) {
                throw new IOException("Consumer already running.");
            }
            for (int i = 0; i < this.sessions.length; ++i) {
                if (this.sessions[i] == null) continue;
                this.sessions[i].init();
                try {
                    MXWrapper.registerMBean((Object)new NetSessionWrapper(this, this.servers[i]), (String)"AgentServer", (String)this.getMBeanName(this.servers[i]));
                    continue;
                }
                catch (Exception exc) {
                    this.logmon.log(BasicLevel.WARN, (Object)(this.getName() + ".start - jmx failed: " + this.getMBeanName(this.servers[i])), (Throwable)exc);
                }
            }
            this.activeSessions = this.nbMaxCnx != -1 ? new Vector<NetSession>(this.nbMaxCnx) : new Vector<NetSession>(this.servers.length - 1);
            this.wakeOnConnection.start();
            this.dispatcher.start();
            this.watchDog.start();
        }
        catch (Exception exc) {
            this.logmon.log(BasicLevel.ERROR, (Object)(this.getName() + ", can't start"), (Throwable)exc);
            throw exc;
        }
        if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
            this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", started"));
        }
    }

    public void wakeup() {
        if (this.watchDog != null) {
            this.watchDog.wakeup();
        }
    }

    public void stop() {
        if (this.wakeOnConnection != null) {
            this.wakeOnConnection.stop();
        }
        if (this.dispatcher != null) {
            this.dispatcher.stop();
        }
        if (this.watchDog != null) {
            this.watchDog.stop();
        }
        for (int i = 0; i < this.sessions.length; ++i) {
            if (this.sessions[i] == null) continue;
            try {
                MXWrapper.unregisterMBean((String)"AgentServer", (String)this.getMBeanName(this.sessions[i].sid));
            }
            catch (Exception exc) {
                this.logmon.log(BasicLevel.WARN, (Object)(this.getName() + ".stop - jmx failed: " + this.getMBeanName(this.sessions[i].sid)), (Throwable)exc);
            }
            if (!this.sessions[i].isRunning()) continue;
            this.sessions[i].stop();
        }
        this.activeSessions.clear();
        if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
            this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", stopped"));
        }
    }

    public boolean isRunning() {
        return this.wakeOnConnection != null && this.wakeOnConnection.isRunning() && this.dispatcher != null && this.dispatcher.isRunning() && this.watchDog != null && this.watchDog.isRunning();
    }

    final NetSession getSession(short sid) throws UnknownServerException {
        try {
            return this.sessions[this.index(sid)];
        }
        catch (ArrayIndexOutOfBoundsException exc) {
            throw new UnknownServerException("Server#" + sid + " is undefined");
        }
    }

    final boolean isSessionRunning(short sid) {
        return this.sessions[this.index(sid)].isRunning();
    }

    final int getMaxMessageInFlow(short sid) {
        return this.sessions[this.index(sid)].getMaxMessageInFlow();
    }

    void setMaxMessageInFlow(short sid, int maxMessageInFlow) {
        this.sessions[this.index(sid)].setMaxMessageInFlow(maxMessageInFlow);
    }

    final int getSessionNbWaitingMessages(short sid) {
        return this.sessions[this.index(sid)].getNbWaitingMessages();
    }

    final int getNbMessageSent(short sid) {
        return this.sessions[this.index(sid)].getNbMessageSent();
    }

    final int getNbMessageReceived(short sid) {
        return this.sessions[this.index(sid)].getNbMessageReceived();
    }

    final int getNbAckSent(short sid) {
        return this.sessions[this.index(sid)].getNbAckSent();
    }

    final long getLastReceived(short sid) {
        return this.sessions[this.index(sid)].getLastReceived();
    }

    final int getNbBufferingMessageToSent(short sid) {
        return this.sessions[this.index(sid)].getNbBufferingMessageToSent();
    }

    public int getNbWaitingMessages() {
        int waitingMessages = 0;
        for (int i = 0; i < this.sessions.length; ++i) {
            if (this.servers[i] == AgentServer.getServerId()) continue;
            waitingMessages += this.sessions[i].getNbBufferingMessageToSent();
        }
        return waitingMessages;
    }

    public String toString() {
        StringBuffer strbuf = new StringBuffer();
        strbuf.append(super.toString()).append("\n\t");
        if (this.wakeOnConnection != null) {
            strbuf.append(this.wakeOnConnection.toString()).append("\n\t");
        }
        if (this.dispatcher != null) {
            strbuf.append(this.dispatcher.toString()).append("\n\t");
        }
        if (this.watchDog != null) {
            strbuf.append(this.watchDog.toString()).append("\n\t");
        }
        for (int i = 0; i < this.sessions.length; ++i) {
            if (this.sessions[i] == null) continue;
            strbuf.append(this.sessions[i].toString()).append("\n\t");
        }
        return strbuf.toString();
    }

    final void writeBoot(OutputStream out) throws IOException {
        if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
            this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", writeMagic -> " + new String(magic, 0, 7) + magic[7]));
        }
        out.write(magic);
        if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
            this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", writeBoot: " + this.getBootTS()));
        }
        byte[] iobuf = new byte[]{(byte)(AgentServer.getServerId() >>> 8), (byte)(AgentServer.getServerId() >>> 0), (byte)(this.getBootTS() >>> 24), (byte)(this.getBootTS() >>> 16), (byte)(this.getBootTS() >>> 8), (byte)(this.getBootTS() >>> 0)};
        out.write(iobuf);
        out.flush();
    }

    final void readFully(InputStream is, byte[] iobuf) throws IOException {
        int count;
        int n = 0;
        do {
            if ((count = is.read(iobuf, n, iobuf.length - n)) >= 0) continue;
            throw new EOFException();
        } while ((n += count) < iobuf.length);
    }

    final Boot readBoot(InputStream in) throws IOException {
        Boot boot = new Boot();
        byte[] magicRead = new byte[8];
        this.readFully(in, magicRead);
        for (int i = 0; i < 8; ++i) {
            if (magicRead[i] == magic[i]) continue;
            throw new IOException("Bad magic number:" + new String(magicRead, 0, 7) + magicRead[7] + " instead of " + new String(magic, 0, 7) + magic[7]);
        }
        if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
            this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", readMagic from #" + boot.sid + " -> " + new String(magicRead, 0, 7) + magicRead[7]));
        }
        byte[] iobuf = new byte[6];
        this.readFully(in, iobuf);
        boot.sid = (short)(((iobuf[0] & 0xFF) << 8) + (iobuf[1] & 0xFF));
        boot.boot = ((iobuf[2] & 0xFF) << 24) + ((iobuf[3] & 0xFF) << 16) + ((iobuf[4] & 0xFF) << 8) + ((iobuf[5] & 0xFF) << 0);
        if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
            this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", readBoot from #" + boot.sid + " -> " + boot.boot));
        }
        return boot;
    }

    final void writeAck(OutputStream out) throws IOException {
        if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
            this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", writeMagicAck -> " + new String(magic, 0, 7) + magic[7]));
        }
        out.write(magic);
        if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
            this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", writeAck: " + this.getBootTS()));
        }
        byte[] iobuf = new byte[]{(byte)(this.getBootTS() >>> 24), (byte)(this.getBootTS() >>> 16), (byte)(this.getBootTS() >>> 8), (byte)(this.getBootTS() >>> 0)};
        out.write(iobuf);
        out.flush();
    }

    final int readAck(InputStream in) throws IOException {
        byte[] magicRead = new byte[8];
        this.readFully(in, magicRead);
        for (int i = 0; i < 8; ++i) {
            if (magicRead[i] == magic[i]) continue;
            throw new IOException("Bad magic number:" + new String(magicRead, 0, 7) + magicRead[7] + " instead of " + new String(magic, 0, 7) + magic[7]);
        }
        if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
            this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", readMagicAck -> " + new String(magicRead, 0, 7) + magicRead[7]));
        }
        byte[] iobuf = new byte[4];
        this.readFully(in, iobuf);
        int boot = ((iobuf[0] & 0xFF) << 24) + ((iobuf[1] & 0xFF) << 16) + ((iobuf[2] & 0xFF) << 8) + ((iobuf[3] & 0xFF) << 0);
        if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
            this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", readAck:" + boot));
        }
        return boot;
    }

    static final class Boot {
        transient short sid;
        transient int boot;

        Boot() {
        }
    }

    final class NetSession
    implements Runnable {
        private short sid;
        private volatile boolean running = false;
        private boolean canStop = false;
        private Thread thread = null;
        private String name = null;
        private volatile boolean local = false;
        private ServerDesc server;
        private volatile Socket sock = null;
        Sender sender;
        int maxMessageInFlow = -1;
        NetworkInputStream nis = null;
        NetworkOutputStream nos = null;
        MessageSoftList sendList;
        private long last = 0L;
        int nbMessageSent = 0;
        int nbMessageReceived = 0;
        int nbAckSent = 0;
        long lastReceived = 0L;

        int getMaxMessageInFlow() {
            return this.maxMessageInFlow;
        }

        void setMaxMessageInFlow(int maxMessageInFlow) {
            this.maxMessageInFlow = maxMessageInFlow;
        }

        public String toString() {
            return this.toString(new StringBuffer()).toString();
        }

        public StringBuffer toString(StringBuffer strbuf) {
            strbuf.append("[sid=").append(this.sid);
            strbuf.append(",running=").append(this.running);
            strbuf.append(",name=").append(this.name).append("]");
            return strbuf;
        }

        NetSession(String name, short sid) {
            this.sid = sid;
            this.name = name + ".netSession#" + sid;
            if (PoolNetwork.this.logmon.isLoggable(BasicLevel.DEBUG)) {
                PoolNetwork.this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", created"));
            }
            this.running = false;
            this.canStop = false;
            this.thread = null;
            this.maxMessageInFlow = AgentServer.getInteger("PoolNetwork.maxMessageInFlow_" + sid, PoolNetwork.this.defaultMaxMessageInFlow);
            this.maxMessageInFlow = AgentServer.getInteger(PoolNetwork.this.domain + ".maxMessageInFlow_" + sid, this.maxMessageInFlow);
            this.sendList = new MessageSoftList(this.getName(), AgentServer.getTransaction().isPersistent());
            this.sender = new Sender(this, name + '_' + sid, PoolNetwork.this.logmon);
        }

        void init() throws UnknownServerException {
            this.server = AgentServer.getServerDesc(this.sid);
        }

        public final String getName() {
            return this.name;
        }

        public short getRemoteSID() {
            return this.sid;
        }

        public boolean isRunning() {
            return this.running;
        }

        int getNbWaitingMessages() {
            return this.sendList.sentSize();
        }

        int getNbMessageSent() {
            return this.nbMessageSent;
        }

        int getNbMessageReceived() {
            return this.nbMessageReceived;
        }

        int getNbAckSent() {
            return this.nbAckSent;
        }

        long getLastReceived() {
            return this.lastReceived;
        }

        int getNbBufferingMessageToSent() {
            return this.sendList.toSendSize();
        }

        void start(long currentTimeMillis) {
            if (PoolNetwork.this.logmon.isLoggable(BasicLevel.DEBUG)) {
                PoolNetwork.this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", starting"));
            }
            if (this.server.retry < PoolNetwork.this.WDNbRetryLevel1 && this.server.last + PoolNetwork.this.WDRetryPeriod1 < currentTimeMillis || this.server.retry < PoolNetwork.this.WDNbRetryLevel2 && this.server.last + PoolNetwork.this.WDRetryPeriod2 < currentTimeMillis || this.server.last + PoolNetwork.this.WDRetryPeriod3 < currentTimeMillis) {
                if (this.localStart()) {
                    this.startEnd();
                } else {
                    this.server.last = currentTimeMillis;
                    ++this.server.retry;
                }
            }
        }

        void start(Socket sock, int boot) {
            if (PoolNetwork.this.logmon.isLoggable(BasicLevel.DEBUG)) {
                PoolNetwork.this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", remotely started"));
            }
            if (this.remoteStart(sock, boot)) {
                this.startEnd();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean localStart() {
            NetSession netSession = this;
            synchronized (netSession) {
                if (this.sock != null || this.local) {
                    if (PoolNetwork.this.logmon.isLoggable(BasicLevel.WARN)) {
                        PoolNetwork.this.logmon.log(BasicLevel.WARN, (Object)(this.getName() + ", connection refused"));
                    }
                    return false;
                }
                this.sendList.reset();
                this.local = true;
            }
            Socket sock = null;
            try {
                sock = PoolNetwork.this.createSocket(this.server);
                PoolNetwork.this.setSocketOption(sock);
                PoolNetwork.this.writeBoot(sock.getOutputStream());
                int boot = PoolNetwork.this.readAck(sock.getInputStream());
                AgentServer.getTransaction().begin();
                PoolNetwork.this.testBootTS(this.sid, boot);
                AgentServer.getTransaction().commit(true);
                this.nis = new NetworkInputStream(sock.getInputStream());
                this.nos = new NetworkOutputStream(sock.getOutputStream());
                if (PoolNetwork.this.logmon.isLoggable(BasicLevel.DEBUG)) {
                    PoolNetwork.this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", connection done"));
                }
            }
            catch (Exception exc) {
                if (PoolNetwork.this.logmon.isLoggable(BasicLevel.DEBUG)) {
                    PoolNetwork.this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", connection aborted"), (Throwable)exc);
                }
                try {
                    sock.getOutputStream().close();
                }
                catch (Exception exc2) {
                    // empty catch block
                }
                try {
                    sock.getInputStream().close();
                }
                catch (Exception exc2) {
                    // empty catch block
                }
                try {
                    sock.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.local = false;
                return false;
            }
            this.sock = sock;
            this.local = false;
            return true;
        }

        synchronized boolean remoteStart(Socket sock, int boot) {
            if (PoolNetwork.this.logmon.isLoggable(BasicLevel.DEBUG)) {
                PoolNetwork.this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", remoteStart"));
            }
            try {
                if (this.sock != null || this.local && this.server.sid > AgentServer.getServerId()) {
                    throw new ConnectException("Already connected");
                }
                if (PoolNetwork.this.logmon.isLoggable(BasicLevel.DEBUG)) {
                    PoolNetwork.this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", send AckStatus"));
                }
                PoolNetwork.this.writeAck(sock.getOutputStream());
                this.sendList.reset();
                AgentServer.getTransaction().begin();
                PoolNetwork.this.testBootTS(this.sid, boot);
                AgentServer.getTransaction().commit(true);
                this.nis = new NetworkInputStream(sock.getInputStream());
                this.nos = new NetworkOutputStream(sock.getOutputStream());
                this.sock = sock;
                return true;
            }
            catch (Exception exc) {
                if (PoolNetwork.this.logmon.isLoggable(BasicLevel.WARN)) {
                    PoolNetwork.this.logmon.log(BasicLevel.WARN, (Object)(this.getName() + ", connection refused"), (Throwable)exc);
                }
                try {
                    sock.getOutputStream().close();
                }
                catch (Exception exc2) {
                    // empty catch block
                }
                try {
                    sock.getInputStream().close();
                }
                catch (Exception exc2) {
                    // empty catch block
                }
                try {
                    sock.close();
                }
                catch (Exception exc2) {
                    // empty catch block
                }
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void startEnd() {
            this.server.active = true;
            this.server.retry = 0;
            List<NetSession> list = PoolNetwork.this.activeSessions;
            synchronized (list) {
                for (int i = PoolNetwork.this.activeSessions.size() - 1; i >= 0; --i) {
                    NetSession session = PoolNetwork.this.activeSessions.get(i);
                    if (session.running) continue;
                    PoolNetwork.this.activeSessions.remove(i);
                }
            }
            if (PoolNetwork.this.nbMaxCnx == -1 || PoolNetwork.this.activeSessions.size() < PoolNetwork.this.nbMaxCnx) {
                PoolNetwork.this.activeSessions.add(this);
            } else {
                long min = Long.MAX_VALUE;
                int idx = -1;
                NetSession oldestSession = null;
                List<NetSession> list2 = PoolNetwork.this.activeSessions;
                synchronized (list2) {
                    do {
                        for (int i = 0; i < PoolNetwork.this.activeSessions.size(); ++i) {
                            NetSession session = PoolNetwork.this.activeSessions.get(i);
                            if (session.last >= min) continue;
                            idx = i;
                            min = session.last;
                            oldestSession = session;
                        }
                    } while (oldestSession == null);
                    if (PoolNetwork.this.logmon.isLoggable(BasicLevel.DEBUG)) {
                        PoolNetwork.this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", Kill session " + oldestSession + ",  and insert new one."));
                    }
                    oldestSession.stop();
                    PoolNetwork.this.activeSessions.set(idx, this);
                }
            }
            this.last = System.currentTimeMillis();
            this.thread = new Thread((Runnable)this, this.getName());
            this.thread.setDaemon(false);
            this.running = true;
            this.canStop = true;
            this.thread.start();
            this.sender.start();
            if (PoolNetwork.this.logmon.isLoggable(BasicLevel.DEBUG)) {
                PoolNetwork.this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", connection started"));
            }
        }

        void stop() {
            this.running = false;
            if (PoolNetwork.this.logmon.isLoggable(BasicLevel.DEBUG)) {
                PoolNetwork.this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", stops."));
            }
            if (Thread.currentThread() == this.thread) {
                return;
            }
            while (this.thread != null && this.thread.isAlive()) {
                if (this.canStop) {
                    if (this.thread.isAlive()) {
                        this.thread.interrupt();
                    }
                    this.shutdown();
                }
                try {
                    this.thread.join(1000L);
                }
                catch (InterruptedException exc) {
                    continue;
                }
                this.thread = null;
            }
        }

        public void shutdown() {
            this.close();
        }

        synchronized void close() {
            if (PoolNetwork.this.logmon.isLoggable(BasicLevel.DEBUG)) {
                PoolNetwork.this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", closed."));
            }
            Socket sock = this.sock;
            this.sock = null;
            this.sender.stop();
            try {
                sock.getInputStream().close();
            }
            catch (Exception exc) {
                // empty catch block
            }
            try {
                sock.getOutputStream().close();
            }
            catch (Exception exc) {
                // empty catch block
            }
            try {
                sock.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.nis = null;
            this.nos = null;
        }

        private final void doAck(int ack) throws Exception {
            if (PoolNetwork.this.logmon.isLoggable(BasicLevel.DEBUG)) {
                PoolNetwork.this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", ack received #" + ack));
            }
            try {
                this.sendList.deleteMessagesUpTo(ack);
            }
            catch (NoSuchElementException exc) {
                if (PoolNetwork.this.logmon.isLoggable(BasicLevel.WARN)) {
                    PoolNetwork.this.logmon.log(BasicLevel.WARN, (Object)(this.getName() + ", can't ack, unknown msg#" + ack));
                }
            }
            catch (Exception e) {
                if (PoolNetwork.this.logmon.isLoggable(BasicLevel.WARN)) {
                    PoolNetwork.this.logmon.log(BasicLevel.WARN, (Object)(this.getName() + ", exception during doAck : msg#" + ack));
                }
                throw e;
            }
        }

        final void send() {
            block21: {
                if (this.sock != null) {
                    Message ack = null;
                    long currentTimeMillis = System.currentTimeMillis();
                    if (this.maxMessageInFlow > 0) {
                        ack = this.sendList.getAck();
                        while (this.sock != null && ack == null && this.sendList.sentSize() > this.maxMessageInFlow) {
                            try {
                                if (PoolNetwork.this.logmon.isLoggable(BasicLevel.DEBUG)) {
                                    PoolNetwork.this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", transmit waits -> sendList.size=" + this.sendList.sentSize()));
                                }
                                Thread.sleep(100L);
                            }
                            catch (InterruptedException exc) {
                                // empty catch block
                            }
                            ack = this.sendList.getAck();
                        }
                    }
                    if (this.sock == null) {
                        return;
                    }
                    Message msg = this.sendList.getFirst();
                    if (msg == null) {
                        return;
                    }
                    if (PoolNetwork.this.logmon.isLoggable(BasicLevel.DEBUG)) {
                        if (msg.not != null) {
                            PoolNetwork.this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", send msg#" + msg.getStamp()));
                        } else {
                            PoolNetwork.this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", send ack#" + msg.getStamp()));
                        }
                    }
                    if (msg.not != null) {
                        ++this.nbMessageSent;
                    } else {
                        ++this.nbAckSent;
                    }
                    if (PoolNetwork.this.logmon.isLoggable(BasicLevel.DEBUG)) {
                        if (msg.not != null) {
                            PoolNetwork.this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", transmit(msg#" + msg.stamp + ", " + currentTimeMillis + ')'));
                        } else {
                            PoolNetwork.this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", transmit(ack#" + msg.stamp + ", " + currentTimeMillis + ')'));
                        }
                    }
                    this.last = currentTimeMillis;
                    try {
                        this.nos.writeMessage(msg, currentTimeMillis);
                        if (msg.not != null) {
                            this.sendList.setSent(msg);
                        }
                    }
                    catch (IOException exc) {
                        if (PoolNetwork.this.logmon.isLoggable(BasicLevel.WARN)) {
                            PoolNetwork.this.logmon.log(BasicLevel.WARN, (Object)(this.getName() + ", exception in sending message " + msg), (Throwable)exc);
                        }
                    }
                    catch (NullPointerException exc) {
                        if (!PoolNetwork.this.logmon.isLoggable(BasicLevel.WARN)) break block21;
                        PoolNetwork.this.logmon.log(BasicLevel.WARN, (Object)(this.getName() + ", exception in sending message " + msg), (Throwable)exc);
                    }
                }
            }
        }

        private final void ack(int stamp) throws Exception {
            if (PoolNetwork.this.logmon.isLoggable(BasicLevel.DEBUG)) {
                PoolNetwork.this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", set ack msg#" + stamp));
            }
            Message ack = Message.alloc(AgentId.localId, AgentId.localId(this.server.sid), null);
            ack.source = AgentServer.getServerId();
            ack.dest = AgentServer.getServerDesc((short)this.server.sid).gateway;
            ack.stamp = stamp;
            PoolNetwork.this.qout.push(ack);
            PoolNetwork.this.qout.validate();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                try {
                    while (this.running) {
                        Message msg;
                        this.canStop = true;
                        if (PoolNetwork.this.logmon.isLoggable(BasicLevel.DEBUG)) {
                            PoolNetwork.this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", waiting message"));
                        }
                        try {
                            msg = this.nis.readMessage();
                        }
                        catch (ClassNotFoundException exc) {
                            PoolNetwork.this.logmon.log(BasicLevel.ERROR, (Object)(this.getName() + ", error during waiting message"), (Throwable)exc);
                            continue;
                        }
                        catch (InvalidClassException exc) {
                            PoolNetwork.this.logmon.log(BasicLevel.ERROR, (Object)(this.getName() + ", error during waiting message"), (Throwable)exc);
                            continue;
                        }
                        catch (StreamCorruptedException exc) {
                            PoolNetwork.this.logmon.log(BasicLevel.ERROR, (Object)(this.getName() + ", error during waiting message"), (Throwable)exc);
                            break;
                        }
                        catch (OptionalDataException exc) {
                            PoolNetwork.this.logmon.log(BasicLevel.ERROR, (Object)(this.getName() + ", error during waiting message"), (Throwable)exc);
                            break;
                        }
                        catch (NullPointerException exc) {
                            break;
                        }
                        this.canStop = false;
                        if (PoolNetwork.this.logmon.isLoggable(BasicLevel.DEBUG)) {
                            PoolNetwork.this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", receives: " + msg));
                        }
                        this.last = this.lastReceived = System.currentTimeMillis();
                        int stamp = msg.getStamp();
                        if (msg.not != null) {
                            ++this.nbMessageReceived;
                            PoolNetwork.this.deliver(msg);
                            this.ack(stamp);
                        } else {
                            this.doAck(stamp);
                        }
                        Thread.yield();
                    }
                    Object var4_11 = null;
                }
                catch (EOFException exc) {
                    if (this.running) {
                        PoolNetwork.this.logmon.log(BasicLevel.WARN, (Object)(this.getName() + ", connection closed"), (Throwable)exc);
                    }
                    Object var4_12 = null;
                    if (PoolNetwork.this.logmon.isLoggable(BasicLevel.DEBUG)) {
                        PoolNetwork.this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", ends"));
                    }
                    this.running = false;
                    this.close();
                    return;
                }
                catch (SocketException exc) {
                    if (this.running) {
                        PoolNetwork.this.logmon.log(BasicLevel.WARN, (Object)(this.getName() + ", connection closed"), (Throwable)exc);
                    }
                    Object var4_13 = null;
                    if (PoolNetwork.this.logmon.isLoggable(BasicLevel.DEBUG)) {
                        PoolNetwork.this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", ends"));
                    }
                    this.running = false;
                    this.close();
                    return;
                }
                catch (Exception exc) {
                    PoolNetwork.this.logmon.log(BasicLevel.ERROR, (Object)(this.getName() + ", exited"), (Throwable)exc);
                    Object var4_14 = null;
                    if (PoolNetwork.this.logmon.isLoggable(BasicLevel.DEBUG)) {
                        PoolNetwork.this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", ends"));
                    }
                    this.running = false;
                    this.close();
                    return;
                }
                if (PoolNetwork.this.logmon.isLoggable(BasicLevel.DEBUG)) {
                    PoolNetwork.this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", ends"));
                }
                this.running = false;
                this.close();
                return;
            }
            catch (Throwable throwable) {
                Object var4_15 = null;
                if (PoolNetwork.this.logmon.isLoggable(BasicLevel.DEBUG)) {
                    PoolNetwork.this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", ends"));
                }
                this.running = false;
                this.close();
                throw throwable;
            }
        }

        final class NetworkOutputStream
        extends BufferedMessageOutputStream {
            OutputStream os = null;

            NetworkOutputStream(OutputStream os) throws IOException {
                this.out = os;
                this.compressedFlows = PoolNetwork.this.getCompressedFlows();
            }

            protected void writeHeader() throws IOException {
            }
        }

        final class NetworkInputStream
        extends BufferedMessageInputStream {
            NetworkInputStream(InputStream is) {
                this.in = is;
                this.compressedFlows = PoolNetwork.this.getCompressedFlows();
            }

            protected void readHeader() throws IOException {
            }
        }
    }

    final class Sender
    extends Daemon {
        NetSession session;

        Sender(NetSession session, String name, Logger logmon) {
            super(name + ".sender", logmon);
            this.session = null;
            this.logmon = logmon;
            this.session = session;
        }

        protected void close() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void shutdown() {
            if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
                this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", shutdown."));
            }
            Sender sender = this;
            synchronized (sender) {
                if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
                    this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", shutdown - 1."));
                }
                ((Object)((Object)this)).notify();
                try {
                    ((Object)((Object)this)).wait(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }

        synchronized void send(Message msg) {
            if (msg != null) {
                if (msg.not == null) {
                    this.session.sendList.setAck(msg);
                } else {
                    this.session.sendList.addMessage(msg);
                }
            }
            if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
                this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", send [" + this.session.sid + "] notify run, msgToSend=" + this.session.sendList));
            }
            ((Object)((Object)this)).notify();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                try {}
                catch (Exception exc) {
                    this.logmon.log(BasicLevel.ERROR, (Object)this.getName(), (Throwable)exc);
                    Object var5_5 = null;
                    if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
                        this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", ends"));
                    }
                    this.finish();
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
                    this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", ends"));
                }
                this.finish();
                throw throwable;
            }
            while (this.running) {
                block16: {
                    this.canStop = true;
                    Sender sender = this;
                    synchronized (sender) {
                        try {
                            if (this.session.sendList.toSendSize() != 0) break block16;
                            if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
                                this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", waits message."));
                            }
                            ((Object)((Object)this)).wait();
                            if (!this.logmon.isLoggable(BasicLevel.DEBUG)) break block16;
                            this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", wait finished cleanly. Go on."));
                        }
                        catch (InterruptedException e) {
                            if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
                                this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", wait interrupted. Continue waiting if running."));
                            }
                            continue;
                        }
                    }
                }
                this.canStop = false;
                if (!this.running) break;
                if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
                    this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", send(" + this.session.sendList + ')'));
                }
                if (this.session.sendList.toSendSize() <= 0) continue;
                this.session.send();
            }
            Object var5_4 = null;
            if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
                this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", ends"));
            }
            this.finish();
        }
    }

    final class WatchDog
    extends Daemon {
        private Object lock;

        WatchDog(String name, Logger logmon) {
            super(name + ".watchdog", logmon);
            this.lock = new Object();
            this.logmon = logmon;
        }

        protected void close() {
        }

        protected void shutdown() {
            this.wakeup();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void wakeup() {
            Object object = this.lock;
            synchronized (object) {
                this.lock.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                Object object = this.lock;
                synchronized (object) {
                    while (this.running) {
                        block13: {
                            try {
                                this.lock.wait(PoolNetwork.this.WDActivationPeriod);
                                if (!this.logmon.isLoggable(BasicLevel.DEBUG)) break block13;
                                this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", activated"));
                            }
                            catch (InterruptedException exc) {
                                continue;
                            }
                        }
                        if (!this.running) break;
                        long currentTimeMillis = System.currentTimeMillis();
                        try {
                            for (int sid = 0; sid < PoolNetwork.this.sessions.length; ++sid) {
                                if (PoolNetwork.this.sessions[sid] == null) continue;
                                if (!(PoolNetwork.this.sessions[sid].running || PoolNetwork.this.sessions[sid].sendList.toSendSize() <= 0 && PoolNetwork.this.sessions[sid].sendList.sentSize() <= 0)) {
                                    PoolNetwork.this.sessions[sid].start(currentTimeMillis);
                                    continue;
                                }
                                if (PoolNetwork.this.IdleTimeout <= 0L || !PoolNetwork.this.sessions[sid].running || currentTimeMillis <= PoolNetwork.this.sessions[sid].last + PoolNetwork.this.IdleTimeout) continue;
                                PoolNetwork.this.sessions[sid].stop();
                            }
                        }
                        catch (Exception exc) {
                            this.logmon.log(BasicLevel.ERROR, (Object)this.getName(), (Throwable)exc);
                        }
                    }
                }
                Object var7_6 = null;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
                    this.logmon.log(BasicLevel.WARN, (Object)(this.getName() + ", ended"));
                }
                this.finish();
                throw throwable;
            }
            if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
                this.logmon.log(BasicLevel.WARN, (Object)(this.getName() + ", ended"));
            }
            this.finish();
        }
    }

    final class Dispatcher
    extends Daemon {
        Dispatcher(String name, Logger logmon) {
            super(name + ".dispatcher", logmon);
            this.logmon = logmon;
        }

        protected void close() {
        }

        protected void shutdown() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Message msg = null;
            try {
                while (this.running) {
                    this.canStop = true;
                    if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
                        this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", waiting message"));
                    }
                    do {
                        if ((msg = PoolNetwork.this.qout.removeExpired(System.currentTimeMillis())) == null) continue;
                        if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
                            this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", Handles expired message: " + msg));
                        }
                        if (msg.not.deadNotificationAgentId != null) {
                            ExpiredNot expiredNot = new ExpiredNot(msg.not, msg.from, msg.to);
                            try {
                                AgentServer.getTransaction().begin();
                                Channel.post(Message.alloc(AgentId.localId, msg.not.deadNotificationAgentId, expiredNot));
                                Channel.validate();
                                AgentServer.getTransaction().commit(true);
                            }
                            catch (Exception e) {
                                this.logmon.log(BasicLevel.ERROR, (Object)(this.getName() + ", cannot post ExpireNotification"), (Throwable)e);
                                continue;
                            }
                        }
                        msg.delete();
                        msg.free();
                    } while (msg != null);
                    try {
                        msg = PoolNetwork.this.qout.get();
                    }
                    catch (InterruptedException exc) {
                        if (!this.logmon.isLoggable(BasicLevel.DEBUG)) continue;
                        this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", interrupted"));
                        continue;
                    }
                    this.canStop = false;
                    if (!this.running) break;
                    try {
                        NetSession session = PoolNetwork.this.getSession(msg.getDest());
                        session.sender.send(msg);
                        if (!session.running && PoolNetwork.this.activeSessions.size() < PoolNetwork.this.nbMaxCnx) {
                            PoolNetwork.this.wakeup();
                        }
                    }
                    catch (UnknownServerException exc) {
                        this.logmon.log(BasicLevel.ERROR, (Object)(this.getName() + ", Cannot send message to unknown server"), (Throwable)exc);
                    }
                    PoolNetwork.this.qout.pop();
                    Thread.yield();
                }
                Object var5_6 = null;
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                this.finish();
                throw throwable;
            }
            this.finish();
        }
    }

    final class WakeOnConnection
    extends Daemon {
        ServerSocket listen;

        WakeOnConnection(String name, Logger logmon) throws IOException {
            super(name + ".wakeOnConnection", logmon);
            this.listen = null;
            this.listen = PoolNetwork.this.createServerSocket();
            this.logmon = logmon;
        }

        protected void close() {
            try {
                this.listen.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.listen = null;
        }

        protected void shutdown() {
            this.close();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            Socket sock = null;
            try {
                try {
                    if (this.listen == null) {
                        this.listen = PoolNetwork.this.createServerSocket();
                    }
                    while (this.running) {
                        try {
                            this.canStop = true;
                            try {
                                if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
                                    this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", waiting connection"));
                                }
                                sock = this.listen.accept();
                            }
                            catch (IOException exc) {
                                if (!this.running) continue;
                                this.logmon.log(BasicLevel.ERROR, (Object)(this.getName() + ", error during waiting connection"), (Throwable)exc);
                                continue;
                            }
                            this.canStop = false;
                            PoolNetwork.this.setSocketOption(sock);
                            Boot boot = PoolNetwork.this.readBoot(sock.getInputStream());
                            if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
                                this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", connection setup from #" + boot.sid));
                            }
                            PoolNetwork.this.getSession(boot.sid).start(sock, boot.boot);
                        }
                        catch (Exception exc) {
                            this.logmon.log(BasicLevel.ERROR, (Object)(this.getName() + ", bad connection setup"), (Throwable)exc);
                            sock.close();
                        }
                    }
                    Object var4_6 = null;
                }
                catch (IOException exc) {
                    this.logmon.log(BasicLevel.ERROR, (Object)(this.getName() + ", bad socket initialization"), (Throwable)exc);
                    Object var4_7 = null;
                    this.finish();
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var4_8 = null;
                this.finish();
                throw throwable;
            }
            this.finish();
        }
    }
}

