/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.generators.wsgen.generator.ews.wsdltoj2ee.writer;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Operation;
import javax.wsdl.OperationType;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.extensions.UnknownExtensibilityElement;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.xml.namespace.QName;
import org.apache.axis.constants.Scope;
import org.apache.axis.constants.Style;
import org.apache.axis.constants.Use;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.utils.Messages;
import org.apache.axis.wsdl.symbolTable.BindingEntry;
import org.apache.axis.wsdl.symbolTable.Parameter;
import org.apache.axis.wsdl.symbolTable.Parameters;
import org.apache.axis.wsdl.symbolTable.SymbolTable;
import org.apache.axis.wsdl.toJava.Emitter;
import org.apache.axis.wsdl.toJava.Utils;
import org.ow2.jonas.deployment.common.HandlerDesc;
import org.ow2.jonas.deployment.ws.PortComponentDesc;
import org.ow2.jonas.deployment.ws.SSBPortComponentDesc;
import org.ow2.jonas.deployment.ws.ServiceDesc;
import org.ow2.jonas.generators.wsgen.generator.ews.wsdltoj2ee.writer.JOnASDeployWriter;

public class J2EEServerDeployWriter
extends JOnASDeployWriter {
    private static final String WSDD_PREFIX = "deploy-server-";
    private static final String SERVICE_ENDPOINT_INTERFACE_NAME = "serviceEndpointInterfaceName";
    private static final String SERVICE_ENDPOINT_JNDI_NAME = "serviceEndpointJndiName";

    public J2EEServerDeployWriter(Emitter emitter, Definition definition, SymbolTable symbolTable) {
        super(emitter, definition, symbolTable);
    }

    @Override
    protected void writeDeployServices(PrintWriter pw) throws IOException {
        Map serviceMap = this.getDefinition().getServices();
        ServiceDesc desc = this.getJonasWSContext().getServiceDesc();
        for (Service myService : serviceMap.values()) {
            pw.println();
            pw.println("  <!-- " + Messages.getMessage((String)"wsdlService00", (String)myService.getQName().getLocalPart()) + " -->");
            pw.println();
            for (Port myPort : myService.getPorts().values()) {
                PortComponentDesc portDesc;
                BindingEntry bEntry = this.getSymbolTable().getBindingEntry(myPort.getBinding().getQName());
                if (bEntry.getBindingType() != 0 || (portDesc = J2EEServerDeployWriter.findPortComponentDesc(desc, myPort)) == null) continue;
                this.writeDeployPort(pw, myService, bEntry, portDesc);
            }
        }
    }

    private static PortComponentDesc findPortComponentDesc(ServiceDesc desc, Port myPort) {
        PortComponentDesc port = null;
        List ports = desc.getPortComponents();
        Iterator i = ports.iterator();
        while (i.hasNext() && port == null) {
            PortComponentDesc pcd = (PortComponentDesc)i.next();
            if (!pcd.getQName().getLocalPart().equals(myPort.getName())) continue;
            port = pcd;
        }
        return port;
    }

    protected void writeDeployPort(PrintWriter pw, Service service, BindingEntry bEntry, PortComponentDesc portComponentDesc) throws IOException {
        String serviceName = portComponentDesc.getServiceName();
        boolean hasLiteral = bEntry.hasLiteral();
        boolean hasMIME = Utils.hasMIME((BindingEntry)bEntry);
        String prefix = "java";
        String styleStr = "";
        for (Object obj : bEntry.getBinding().getExtensibilityElements()) {
            UnknownExtensibilityElement unkElement;
            QName name;
            if (obj instanceof SOAPBinding) {
                this.use = Use.ENCODED;
                continue;
            }
            if (!(obj instanceof UnknownExtensibilityElement) || !(name = (unkElement = (UnknownExtensibilityElement)obj).getElementType()).getNamespaceURI().equals("http://schemas.xmlsoap.org/wsdl/soap12/") || !name.getLocalPart().equals("binding")) continue;
            this.use = Use.ENCODED;
        }
        if (this.getSymbolTable().isWrapped()) {
            styleStr = " style=\"" + Style.WRAPPED + "\"";
            this.use = Use.LITERAL;
        } else {
            styleStr = " style=\"" + bEntry.getBindingStyle().getName() + "\"";
            if (hasLiteral) {
                this.use = Use.LITERAL;
            }
        }
        String useStr = " use=\"" + this.use + "\"";
        if (portComponentDesc.hasBeanImpl()) {
            pw.println("  <service name=\"" + serviceName + "\" provider=\"" + prefix + ":JOnASEJB\"" + styleStr + useStr + ">");
            SSBPortComponentDesc ssbPCD = (SSBPortComponentDesc)portComponentDesc;
            pw.println("      <parameter name=\"serviceEndpointInterfaceName\" value=\"" + ssbPCD.getServiceEndpointInterface().getName() + "\"/>");
            pw.println("      <parameter name=\"serviceEndpointJndiName\" value=\"" + ssbPCD.getSessionStatelessDesc().getJndiServiceEndpointName() + "\"/>");
        } else {
            pw.println("  <service name=\"" + serviceName + "\" provider=\"" + prefix + ":RPC\"" + styleStr + useStr + ">");
            pw.println("      <parameter name=\"className\" value=\"" + portComponentDesc.getSIBClassname() + "\"/>");
        }
        pw.println("      <parameter name=\"wsdlTargetNamespace\" value=\"" + service.getQName().getNamespaceURI() + "\"/>");
        pw.println("      <parameter name=\"wsdlServiceElement\" value=\"" + service.getQName().getLocalPart() + "\"/>");
        pw.println("      <parameter name=\"wsdlServicePort\" value=\"" + serviceName + "\"/>");
        if (hasMIME) {
            pw.println("      <parameter name=\"sendMultiRefs\" value=\"false\"/>");
        }
        this.writeDeployBinding(pw, bEntry);
        this.writeDeployTypes(pw, bEntry.getBinding(), hasLiteral, hasMIME, this.use);
        List handlers = portComponentDesc.getHandlers();
        if (!handlers.isEmpty()) {
            pw.println("    <handlerInfoChain>");
            Iterator i = handlers.iterator();
            while (i.hasNext()) {
                this.writeHandler(pw, (HandlerDesc)i.next());
            }
            pw.println("    </handlerInfoChain>");
        }
        pw.println("  </service>");
    }

    protected void writeDeployBinding(PrintWriter pw, BindingEntry bEntry) throws IOException {
        Binding binding = bEntry.getBinding();
        pw.println("      <parameter name=\"wsdlPortType\" value=\"" + binding.getPortType().getQName().getLocalPart() + "\"/>");
        pw.println("      <parameter name=\"typeMappingVersion\" value=\"" + this.emitter.getTypeMappingVersion() + "\"/>");
        HashSet<String> allowedMethods = new HashSet<String>();
        if (!this.emitter.isSkeletonWanted()) {
            for (BindingOperation bindingOper : binding.getBindingOperations()) {
                Operation operation = bindingOper.getOperation();
                OperationType type = operation.getStyle();
                String javaOperName = JavaUtils.xmlNameToJava((String)operation.getName());
                if (type == OperationType.NOTIFICATION || type == OperationType.SOLICIT_RESPONSE) continue;
                allowedMethods.add(javaOperName);
                Parameters params = this.getSymbolTable().getOperationParameters(operation, "", bEntry);
                if (params == null) continue;
                QName elementQName = Utils.getOperationQName((BindingOperation)bindingOper, (BindingEntry)bEntry, (SymbolTable)this.getSymbolTable());
                QName returnQName = null;
                QName returnType = null;
                if (params.returnParam != null) {
                    returnQName = params.returnParam.getQName();
                    returnType = Utils.getXSIType((Parameter)params.returnParam);
                }
                HashMap faultMap = bEntry.getFaults();
                ArrayList faults = null;
                if (faultMap != null) {
                    faults = (ArrayList)faultMap.get(bindingOper);
                }
                String soapAction = Utils.getOperationSOAPAction((BindingOperation)bindingOper);
                this.writeOperation(pw, javaOperName, elementQName, returnQName, returnType, params, faults, soapAction);
            }
        }
        pw.print("      <parameter name=\"allowedMethods\" value=\"");
        if (allowedMethods.isEmpty()) {
            pw.println("*\"/>");
        } else {
            boolean first = true;
            for (String method : allowedMethods) {
                if (first) {
                    pw.print(method);
                    first = false;
                    continue;
                }
                pw.print(" " + method);
            }
            pw.println("\"/>");
        }
        Scope scope = this.emitter.getScope();
        if (scope != null) {
            pw.println("      <parameter name=\"scope\" value=\"" + scope.getName() + "\"/>");
        }
    }

    protected void writeHandler(PrintWriter pw, HandlerDesc handler) {
        pw.println("      <handlerInfo classname=\"" + handler.getHandlerClassName() + "\">");
        Properties params = handler.getInitParams();
        for (String pName : params.keySet()) {
            pw.println("        <parameter name=\"" + pName + "\" value=\"" + params.get(pName) + "\"/>");
        }
        List headers = handler.getSOAPHeaders();
        for (QName sh : headers) {
            pw.println("        <header xmlns:ns=\"" + sh.getNamespaceURI() + "\" qname=\"ns:" + sh.getLocalPart() + "\"/>");
        }
        pw.println("      </handlerInfo>");
        List roles = handler.getSOAPRoles();
        for (String role : roles) {
            pw.println("      <role soapActorName=\"" + role + "\"/>");
        }
    }

    @Override
    protected String getPrefix() {
        return WSDD_PREFIX;
    }
}

