/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.ee.deploy.impl.deployable.metadata;

import java.util.HashMap;
import java.util.Map;
import org.ow2.util.ee.deploy.api.deployable.IDeployable;
import org.ow2.util.ee.deploy.api.deployable.metadata.DeployableMetadataException;
import org.ow2.util.ee.deploy.api.deployable.metadata.DeployableMetadataManager;
import org.ow2.util.ee.deploy.api.deployable.metadata.IDeployableMetadata;
import org.ow2.util.ee.deploy.api.deployable.metadata.IDeployableMetadataFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeployableMetadataManagerImpl
extends DeployableMetadataManager {
    private Map<Class<?>, Map<Class<?>, IDeployableMetadataFactory<?, ?>>> factoryMap = new HashMap();

    @Override
    public <T extends IDeployable<T>, Z extends IDeployableMetadata<T>> Z createDeployableMetadata(T deployable, Class<Z> deployableMetadataClass) throws DeployableMetadataException {
        Map<Class<?>, IDeployableMetadataFactory<?, ?>> map = this.factoryMap.get(deployableMetadataClass);
        IDeployableMetadataFactory<?, ?> factory = null;
        for (Class<?> clazz : deployable.getClass().getInterfaces()) {
            IDeployableMetadataFactory<?, ?> factoryTmp = map.get(clazz);
            if (factoryTmp == null) continue;
            factory = factoryTmp;
            break;
        }
        if (factory == null) {
            throw new DeployableMetadataException("No factory found for the type '" + deployableMetadataClass + "'.");
        }
        return factory.createDeployableMetadata(deployable);
    }

    @Override
    public <T extends IDeployable<T>, Z extends IDeployableMetadata<T>> boolean addDeployableMetadataFactory(Class<T> clazz, IDeployableMetadataFactory<T, Z> deployableMetadataFactory) {
        Class<Z> deployableMetadataClass = deployableMetadataFactory.getDeployableMetadataClass();
        Map<Class<?>, IDeployableMetadataFactory<?, ?>> map = this.factoryMap.get(deployableMetadataClass);
        if (map == null) {
            map = new HashMap();
            this.factoryMap.put(deployableMetadataClass, map);
        }
        if (!map.containsKey(deployableMetadataClass)) {
            map.put(clazz, deployableMetadataFactory);
            return true;
        }
        return false;
    }

    @Override
    public <T extends IDeployable<T>, Z extends IDeployableMetadata<T>> void removeDeployableMetadataFactory(Class<T> clazz, IDeployableMetadataFactory<T, Z> deployableMetadataFactory) {
        Class<Z> deployableMetadataClass = deployableMetadataFactory.getDeployableMetadataClass();
        Map<Class<?>, IDeployableMetadataFactory<?, ?>> map = this.factoryMap.get(deployableMetadataClass);
        if (map == null) {
            return;
        }
        IDeployableMetadataFactory<?, ?> factory = map.get(clazz);
        if (factory.equals(deployableMetadataFactory)) {
            this.factoryMap.remove(deployableMetadataClass);
        }
    }
}

