/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.auth;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.jgroups.Message;
import org.jgroups.annotations.Property;
import org.jgroups.auth.AuthToken;
import org.jgroups.util.Util;

public class MD5Token
extends AuthToken {
    @Property
    private String auth_value = null;
    @Property(name="token_hash")
    private String hash_type = "MD5";
    private static final long serialVersionUID = -5787154335375249191L;

    public MD5Token() {
    }

    public MD5Token(String authvalue) {
        this.auth_value = this.hash(authvalue);
    }

    public MD5Token(String authvalue, String hash_type) {
        this.auth_value = this.hash(authvalue);
        this.hash_type = hash_type;
    }

    public String getHashType() {
        return this.hash_type;
    }

    public void setHashType(String hash_type) {
        this.hash_type = hash_type;
    }

    public String getAuthValue() {
        return this.auth_value;
    }

    public void setAuthValue(String auth_value) {
        this.auth_value = auth_value;
    }

    @Override
    public String getName() {
        return "org.jgroups.auth.MD5Token";
    }

    private String hash(String token) {
        String hashedToken = null;
        hashedToken = this.hash_type.equalsIgnoreCase("SHA") ? Util.sha(token) : Util.md5(token);
        if (hashedToken == null) {
            if (this.log.isWarnEnabled()) {
                this.log.warn("Failed to hash token - sending in clear text");
            }
            return token;
        }
        return hashedToken;
    }

    @Override
    public boolean authenticate(AuthToken token, Message msg) {
        if (token != null && token instanceof MD5Token) {
            MD5Token serverToken = (MD5Token)token;
            if (this.auth_value != null && serverToken.auth_value != null && this.auth_value.equalsIgnoreCase(serverToken.auth_value)) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("MD5Token match");
                }
                return true;
            }
            return false;
        }
        if (this.log.isWarnEnabled()) {
            this.log.warn("Invalid AuthToken instance - wrong type or null");
        }
        return false;
    }

    @Override
    public void writeTo(DataOutputStream out) throws IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("MD5Token writeTo()");
        }
        Util.writeString(this.auth_value, out);
    }

    @Override
    public void readFrom(DataInputStream in) throws IOException, IllegalAccessException, InstantiationException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("MD5Token readFrom()");
        }
        this.auth_value = Util.readString(in);
    }
}

