/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.blocks;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class LazyRemovalSet<V> {
    private final Set<Entry<V>> set = new HashSet<Entry<V>>();
    private final int max_elements;
    private final long max_age;

    public LazyRemovalSet() {
        this(200, 5000L);
    }

    public LazyRemovalSet(int max_elements, long max_age) {
        this.max_elements = max_elements;
        this.max_age = max_age;
    }

    public void add(V val) {
        if (val != null) {
            Entry<V> entry = new Entry<V>(val);
            if (this.set.contains(entry)) {
                this.set.remove(entry);
            }
            this.set.add(entry);
        }
        this.checkMaxSizeExceeded();
    }

    public void add(V ... vals) {
        this.add((Collection<V>)Arrays.asList(vals));
    }

    public void add(Collection<V> vals) {
        if (vals == null || vals.isEmpty()) {
            return;
        }
        for (V val : vals) {
            Entry<V> entry = this.find(val);
            if (entry != null) {
                this.set.remove(entry);
            }
            this.set.add(new Entry<V>(val));
        }
        this.checkMaxSizeExceeded();
    }

    public boolean contains(V val) {
        if (val == null) {
            return false;
        }
        Entry<V> entry = new Entry<V>(val);
        return this.set.contains(entry);
    }

    public void remove(V val) {
        this.remove(val, false);
    }

    public void remove(V val, boolean force) {
        if (val == null) {
            return;
        }
        Entry<V> entry = new Entry<V>(val);
        if (force) {
            this.set.remove(entry);
        } else {
            entry = this.find(val);
            if (entry != null) {
                entry.removable = true;
            }
        }
        this.checkMaxSizeExceeded();
    }

    public void removeAll(Collection<V> values) {
        this.removeAll(values, false);
    }

    public void removeAll(Collection<V> values, boolean force) {
        if (values == null || values.isEmpty()) {
            return;
        }
        if (force) {
            this.set.removeAll(values);
        } else {
            for (Entry<V> entry : this.set) {
                if (!values.contains(entry.val)) continue;
                entry.removable = true;
            }
        }
        this.checkMaxSizeExceeded();
    }

    public void clear(boolean force) {
        if (force) {
            this.set.clear();
        } else {
            for (Entry<V> entry : this.set) {
                if (entry.val == null) continue;
                entry.removable = true;
            }
        }
    }

    public void retainAll(Collection<V> values) {
        this.retainAll(values, false);
    }

    public void retainAll(Collection<V> values, boolean force) {
        if (values == null || values.isEmpty()) {
            return;
        }
        if (force) {
            this.set.retainAll(values);
        } else {
            for (Entry<V> entry : this.set) {
                if (values.contains(entry.val)) continue;
                entry.removable = true;
            }
        }
        for (Entry<V> val : values) {
            Entry<Entry<V>> entry = this.find(val);
            if (entry == null) continue;
            entry.removable = false;
        }
        this.checkMaxSizeExceeded();
    }

    public Set<V> values() {
        HashSet retval = new HashSet();
        for (Entry<V> entry : this.set) {
            retval.add(entry.val);
        }
        return retval;
    }

    public Set<V> nonRemovedValues() {
        HashSet retval = new HashSet();
        for (Entry<V> entry : this.set) {
            if (entry.removable) continue;
            retval.add(entry.val);
        }
        return retval;
    }

    public int size() {
        return this.set.size();
    }

    public String printCache() {
        StringBuilder sb = new StringBuilder();
        for (Entry<V> entry : this.set) {
            sb.append(entry).append("\n");
        }
        return sb.toString();
    }

    public String printCache(Printable<V> print_function) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Entry<V> entry : this.set) {
            Object val = entry.val;
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(print_function.print(val));
        }
        return sb.toString();
    }

    public String toString() {
        return this.printCache();
    }

    private void checkMaxSizeExceeded() {
        if (this.set.size() > this.max_elements) {
            this.removeMarkedElements();
        }
    }

    protected Entry<V> find(V val) {
        if (val == null) {
            return null;
        }
        for (Entry<V> entry : this.set) {
            if (!val.equals(entry.val)) continue;
            return entry;
        }
        return null;
    }

    public void removeMarkedElements(boolean force) {
        long curr_time = System.currentTimeMillis();
        Iterator<Entry<V>> it = this.set.iterator();
        while (it.hasNext()) {
            Entry<V> entry = it.next();
            if (entry == null || (!entry.removable || curr_time - entry.timestamp < this.max_age) && !force) continue;
            it.remove();
        }
    }

    public void removeMarkedElements() {
        this.removeMarkedElements(false);
    }

    protected static class Entry<V> {
        protected final V val;
        protected final long timestamp = System.currentTimeMillis();
        protected boolean removable = false;

        public Entry(V val) {
            this.val = val;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Entry) {
                return this.val.equals(((Entry)obj).val);
            }
            return this.val.equals(obj);
        }

        public int hashCode() {
            return this.val.hashCode();
        }

        public String toString() {
            return this.val + " (" + (System.currentTimeMillis() - this.timestamp) + "ms old" + (this.removable ? ", removable" : "") + ")";
        }
    }

    public static interface Printable<V> {
        public String print(V var1);
    }
}

