/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.jgroups.Address;

public class SingletonAddress
implements Address {
    protected final String cluster_name;
    protected final Address addr;
    private static final long serialVersionUID = -7139682546627602986L;

    public SingletonAddress(String cluster_name, Address addr) {
        this.cluster_name = cluster_name;
        this.addr = addr;
        if (cluster_name == null) {
            throw new NullPointerException("cluster_name must not be null");
        }
    }

    public SingletonAddress() {
        this.cluster_name = null;
        this.addr = null;
    }

    public Address getAddress() {
        return this.addr;
    }

    public String getClusterName() {
        return this.cluster_name;
    }

    @Override
    public boolean isMulticastAddress() {
        return false;
    }

    @Override
    public int size() {
        return 0;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeTo(DataOutputStream out) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void readFrom(DataInputStream in) throws IOException, IllegalAccessException, InstantiationException {
        throw new UnsupportedOperationException();
    }

    public int hashCode() {
        int retval = 0;
        if (this.cluster_name != null) {
            retval += this.cluster_name.hashCode();
        }
        if (this.addr != null) {
            retval += this.addr.hashCode();
        }
        return retval;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Address)) {
            throw new IllegalArgumentException("argument is " + obj.getClass());
        }
        return this.compareTo((Address)obj) == 0;
    }

    @Override
    public int compareTo(Address o) {
        SingletonAddress other = (SingletonAddress)o;
        if (this == other) {
            return 0;
        }
        if (other == null) {
            return 1;
        }
        int rc = this.cluster_name.compareTo(other.cluster_name);
        if (rc != 0) {
            return rc;
        }
        if (this.addr == null && other.addr == null) {
            return 0;
        }
        if (this.addr == null && other.addr != null) {
            return -1;
        }
        if (this.addr != null && other.addr == null) {
            return 1;
        }
        assert (this.addr != null);
        return this.addr.compareTo(other.addr);
    }

    public String toString() {
        return this.cluster_name + (this.addr != null ? ":" + this.addr.toString() : "");
    }
}

