/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.ant.cluster;

import java.io.File;
import org.apache.tools.ant.BuildException;
import org.ow2.jonas.ant.cluster.ClusterTasks;
import org.ow2.jonas.ant.jonasbase.BaseTaskItf;
import org.ow2.jonas.ant.jonasbase.Discovery;

public class DiscoveryCluster
extends ClusterTasks {
    private static final String INFO = "[DiscoveryCluster] ";
    private String[] greetingPortRange = null;
    private String[] sourcePortRange = null;
    private String mcastPort = null;
    private String mcastAddr = null;
    private int masterNode = -1;
    private String jonasRoot = null;
    private String domainName = null;
    private String protocol = null;
    private String[] carolPortRange = null;
    private String domainDesc = null;
    private String clusterName = null;
    private String clusterDesc = null;
    private String clusterNodesName = null;
    private String cdName = null;
    private String cdProtocol = null;
    private String cdPort = null;

    public void setMasterNode(int masterNode) {
        this.masterNode = masterNode;
    }

    public void setMcastPort(String mcastPort) {
        this.mcastPort = mcastPort;
    }

    public void setMcastAddr(String mcastAddr) {
        this.mcastAddr = mcastAddr;
    }

    public void setGreetingPortRange(String portRange) {
        this.greetingPortRange = portRange.split(",");
    }

    public void setSourcePortRange(String portRange) {
        this.sourcePortRange = portRange.split(",");
    }

    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    public void setDomainDesc(String domainDesc) {
        this.domainDesc = domainDesc;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public void setClusterDesc(String clusterDesc) {
        this.clusterDesc = clusterDesc;
    }

    @Override
    public void generatesTasks() {
        int portInd = 0;
        for (int i = this.getDestDirSuffixIndFirst(); i <= this.getDestDirSuffixIndLast(); ++i) {
            String destDir = DiscoveryCluster.getDestDir(this.getDestDirPrefix(), i);
            this.log("[DiscoveryCluster] tasks generation for " + destDir);
            Discovery discovery = new Discovery();
            if (i == this.masterNode) {
                discovery.setJonasRoot(this.jonasRoot);
                discovery.setSourcePort(this.sourcePortRange[portInd]);
                discovery.setDomainDesc(this.domainDesc);
            }
            discovery.setGreetingPort(this.greetingPortRange[portInd]);
            discovery.setMcastPort(this.mcastPort);
            discovery.setMcastAddr(this.mcastAddr);
            for (BaseTaskItf baseTaskItf : discovery.getTasks()) {
                baseTaskItf.setDestDir(new File(destDir));
            }
            this.addTasks(discovery);
            ++portInd;
        }
    }

    public void setClusterNodesName(String clusterNodesName) {
        this.clusterNodesName = clusterNodesName;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public void setCdName(String cdName) {
        this.cdName = cdName;
    }

    public void setCdProtocol(String cdProtocol) {
        this.cdProtocol = cdProtocol;
    }

    public void setCdPort(String cdPort) {
        this.cdPort = cdPort;
    }

    public String getCdUrl() {
        String scheme;
        if (this.cdProtocol.equals("jrmp") || this.cdProtocol.equals("irmi")) {
            scheme = "rmi";
        } else if (this.cdProtocol.equals("iiop")) {
            scheme = "iiop";
        } else {
            throw new BuildException("[DiscoveryCluster] Unknown protocol for cluster daemon: " + this.cdProtocol);
        }
        String url = "service:jmx:" + scheme + "://localhost/jndi/" + scheme + "://localhost:" + this.cdPort + "/" + this.cdProtocol + "connector_" + this.cdName;
        return url;
    }

    public void setCarolPortRange(String carolPortRange) {
        this.carolPortRange = carolPortRange.split(",");
    }

    public void setJonasRoot(String jonasRoot) {
        this.jonasRoot = jonasRoot;
    }
}

