/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.ant.jonasbase;

import java.io.File;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.apache.tools.ant.BuildException;
import org.ow2.jonas.ant.PropertyStatement;
import org.ow2.jonas.ant.jonasbase.BaseTaskItf;
import org.ow2.jonas.ant.jonasbase.JTask;

public class PropertyTask
extends JTask
implements BaseTaskItf {
    private static final String INFO = "[PropertyTask] ";
    private Hashtable<String, List<PropertyStatement>> properties4file = new Hashtable();

    public void addPropertyStatement(String fileName, String propertyName, String propertyValue, boolean add) {
        this.addPropertyStatement(fileName, new PropertyStatement(propertyName, propertyValue, add));
    }

    public void addPropertyStatement(String fileName, PropertyStatement statement) {
        List<PropertyStatement> statements = this.properties4file.get(fileName);
        if (statements == null) {
            statements = new ArrayList<PropertyStatement>();
            this.properties4file.put(fileName, statements);
        }
        statements.add(statement);
    }

    public void addPropertyStatements(String fileName, List<PropertyStatement> vstatements) {
        List<PropertyStatement> statements = this.properties4file.get(fileName);
        if (statements == null) {
            statements = new ArrayList<PropertyStatement>();
            this.properties4file.put(fileName, statements);
        }
        statements.addAll(vstatements);
    }

    @Override
    public void execute() throws BuildException {
        super.execute();
        String jBaseConf = this.getDestDir().getPath() + File.separator + "conf";
        for (Map.Entry<String, List<PropertyStatement>> entry : this.properties4file.entrySet()) {
            String fileName = entry.getKey();
            this.log("[PropertyTask] : Replace statements " + entry.getValue() + " in '" + this.getDestDir().getPath() + File.separator + fileName + "'");
            for (PropertyStatement statement : entry.getValue()) {
                this.changeValueForKey(INFO, jBaseConf, fileName, statement.getName(), statement.getValue(), statement.isAdd());
            }
        }
    }
}

