/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.ant.jonasbase.web;

import org.apache.tools.ant.Task;
import org.ow2.jonas.ant.jonasbase.JReplace;
import org.ow2.jonas.ant.jonasbase.Tasks;
import org.ow2.jonas.ant.jonasbase.web.Ajp;
import org.ow2.jonas.ant.jonasbase.web.Cluster;
import org.ow2.jonas.ant.jonasbase.web.Director;
import org.ow2.jonas.ant.jonasbase.web.Http;
import org.ow2.jonas.ant.jonasbase.web.Https;

public class Tomcat
extends Tasks {
    private static final String INFO = "[Tomcat] ";
    private static final String AJP_CONNECTOR_TOKEN = "<!-- Define an AJP";
    private static final String HTTPS_CONNECTOR_TOKEN = "<!-- Define a SSL Coyote HTTP/1.1";
    private static final String DIRECTOR_CONNECTOR_TOKEN = "<!-- Define a Proxied HTTP/1.1";
    private static final String JVM_ROUTE_TOKEN = "<Engine name=\"JOnAS\" defaultHost=\"localhost\">";
    private boolean httpConfigured = false;

    public void addConfiguredHttp(Http http) {
        this.httpConfigured = true;
        JReplace propertyReplace = new JReplace();
        propertyReplace.setConfigurationFile("tomcat7-server.xml");
        propertyReplace.setToken("9000");
        propertyReplace.setValue(http.getPort());
        propertyReplace.setLogInfo("[Tomcat] Setting HTTP port number to : " + http.getPort());
        this.addTask((Task)propertyReplace);
    }

    public void addConfiguredHttps(Https https) {
        JReplace propertyReplace = new JReplace();
        propertyReplace.setConfigurationFile("tomcat7-server.xml");
        propertyReplace.setToken(HTTPS_CONNECTOR_TOKEN);
        StringBuffer value = new StringBuffer();
        value.append("<!-- Define a SSL Coyote HTTP/1.1 Connector on port " + https.getPort() + " -->\n");
        value.append("    <Connector port=\"" + https.getPort() + "\" maxHttpHeaderSize=\"8192\"\n");
        value.append("               maxThreads=\"150\" minSpareThreads=\"25\" maxSpareThreads=\"75\"\n");
        value.append("               enableLookups=\"false\" disableUploadTimeout=\"true\"\n");
        value.append("               acceptCount=\"100\" scheme=\"https\" secure=\"true\"\n");
        value.append("               clientAuth=\"false\" sslProtocol=\"TLS\"\n");
        if (https.getKeystoreFile() != null) {
            value.append("               keystoreFile=\"" + https.getKeystoreFile() + "\"\n");
        }
        if (https.getKeystorePass() != null) {
            value.append("               keystorePass=\"" + https.getKeystorePass() + "\"\n");
        }
        value.append("               />\n\n");
        value.append("    <!-- Define a SSL Coyote HTTP/1.1");
        propertyReplace.setValue(value.toString());
        propertyReplace.setLogInfo("[Tomcat] Setting HTTPS Connector to : " + https.getPort());
        this.addTask((Task)propertyReplace);
        propertyReplace = new JReplace();
        propertyReplace.setConfigurationFile("tomcat7-server.xml");
        propertyReplace.setToken(" redirectPort=\"9043\" ");
        propertyReplace.setValue(" redirectPort=\"" + https.getPort() + "\" ");
        propertyReplace.setLogInfo("[Tomcat] Fix HTTP redirect port number to : " + https.getPort());
        this.addTask((Task)propertyReplace);
    }

    public void addConfiguredAjp(Ajp ajp) {
        JReplace propertyReplace = new JReplace();
        propertyReplace.setConfigurationFile("tomcat7-server.xml");
        propertyReplace.setToken(AJP_CONNECTOR_TOKEN);
        StringBuffer value = new StringBuffer();
        value.append(" <!-- Define an AJP 1.3 Connector on port " + ajp.getPort() + " -->\n");
        value.append("    <Connector port=\"" + ajp.getPort() + "\" enableLookups=\"false\"\n");
        value.append("               redirectPort=\"9043\" protocol=\"AJP/1.3\" />\n\n");
        value.append("    <!-- Define an AJP");
        propertyReplace.setValue(value.toString());
        propertyReplace.setLogInfo("[Tomcat] Setting AJP Connector to : " + ajp.getPort());
        this.addTask((Task)propertyReplace);
    }

    public void setJvmRoute(String jvmRoute) {
        JReplace propertyReplace = new JReplace();
        propertyReplace.setConfigurationFile("tomcat7-server.xml");
        propertyReplace.setToken(JVM_ROUTE_TOKEN);
        StringBuffer value = new StringBuffer();
        value.append("<Engine name=\"JOnAS\" defaultHost=\"localhost\" jvmRoute=\"" + jvmRoute + "\">");
        propertyReplace.setValue(value.toString());
        propertyReplace.setLogInfo("[Tomcat] Setting the jvmRoute to : " + jvmRoute);
        this.addTask((Task)propertyReplace);
    }

    public void addConfiguredDirector(Director dir) {
        JReplace propertyReplace = new JReplace();
        propertyReplace.setConfigurationFile("tomcat7-server.xml");
        propertyReplace.setToken(DIRECTOR_CONNECTOR_TOKEN);
        StringBuffer value = new StringBuffer();
        value.append("<!--  Define a Director Connector on port " + dir.getPort() + " -->\n");
        value.append("    <Connector protocol=\"org.enhydra.servlet.connectionMethods.EnhydraDirector.DirectorProtocol\"\n");
        value.append("               port=\"" + dir.getPort() + "\"\n");
        value.append("               threadTimeout = \"300\"\n");
        value.append("               clientTimeout = \"30\"\n");
        value.append("               sessionAffinity = \"false\"\n");
        value.append("               queueSize = \"400\"\n");
        value.append("               numThreads = \"200\"\n");
        value.append("               bindAddress = \"(All Interfaces)\"\n");
        value.append("               authKey = \"(Unauthenticated)\"\n");
        value.append("               />\n\n");
        value.append("    <!-- Define a Proxied HTTP/1.1");
        propertyReplace.setValue(value.toString());
        propertyReplace.setLogInfo("[Tomcat] Setting Director Connector to : " + dir.getPort());
        this.addTask((Task)propertyReplace);
    }

    public void addConfiguredCluster(Cluster cluster) {
        this.setCluster();
        JReplace propertyReplace = new JReplace();
        propertyReplace.setConfigurationFile("tomcat7-server.xml");
        propertyReplace.setToken("myTomcatCluster");
        propertyReplace.setValue(cluster.getName());
        propertyReplace.setLogInfo("[Tomcat] Setting Cluster name : " + cluster.getName());
        this.addTask((Task)propertyReplace);
        propertyReplace = new JReplace();
        propertyReplace.setConfigurationFile("tomcat7-server.xml");
        propertyReplace.setToken("4001");
        propertyReplace.setValue(cluster.getListenPort());
        propertyReplace.setLogInfo("[Tomcat] Setting Cluster listen port : " + cluster.getListenPort());
        this.addTask((Task)propertyReplace);
        propertyReplace = new JReplace();
        propertyReplace.setConfigurationFile("tomcat7-server.xml");
        propertyReplace.setToken("228.0.0.4");
        propertyReplace.setValue(cluster.getMcastAddr());
        propertyReplace.setLogInfo("[Tomcat] Setting Cluster multicast addr : " + cluster.getMcastAddr());
        this.addTask((Task)propertyReplace);
        propertyReplace = new JReplace();
        propertyReplace.setConfigurationFile("tomcat7-server.xml");
        propertyReplace.setToken("45564");
        propertyReplace.setValue(cluster.getMcastPort());
        propertyReplace.setLogInfo("[Tomcat] Setting Cluster multicast port : " + cluster.getMcastPort());
        this.addTask((Task)propertyReplace);
    }

    private void setCluster() {
        JReplace propertyReplace = new JReplace();
        propertyReplace.setConfigurationFile("tomcat7-server.xml");
        propertyReplace.setToken("</Host>");
        StringBuffer value = new StringBuffer("\n");
        value.append("        <Cluster className=\"org.apache.catalina.ha.tcp.SimpleTcpCluster\"\n");
        value.append("            channelSendOptions=\"8\">\n");
        value.append("            <Manager className=\"org.apache.catalina.ha.session.DeltaManager\"\n");
        value.append("                expireSessionsOnShutdown=\"false\"\n");
        value.append("                notifyListenersOnReplication=\"true\"/>\n");
        value.append("            <Channel className=\"org.apache.catalina.tribes.group.GroupChannel\">\n");
        value.append("                <Membership\n");
        value.append("                    className=\"org.apache.catalina.tribes.membership.McastService\"\n");
        value.append("                    addr=\"228.0.0.4\"\n");
        value.append("                    port=\"45564\"\n");
        value.append("                    frequency=\"500\"\n");
        value.append("                    dropTime=\"3000\" />\n");
        value.append("                <Receiver\n");
        value.append("                    className=\"org.apache.catalina.tribes.transport.nio.NioReceiver\"\n");
        value.append("                    address=\"auto\"\n");
        value.append("                    port=\"4001\"\n");
        value.append("                    autoBind=\"100\"\n");
        value.append("                    selectorTimeout=\"100\"\n");
        value.append("                    maxThread=\"6\" />\n");
        value.append("                <Sender\n");
        value.append("                    className=\"org.apache.catalina.tribes.transport.ReplicationTransmitter\">\n");
        value.append("                    <Transport\n");
        value.append("                        className=\"org.apache.catalina.tribes.transport.nio.PooledParallelSender\"/>\n");
        value.append("                </Sender>\n");
        value.append("                <Interceptor className=\"org.apache.catalina.tribes.group.interceptors.TcpFailureDetector\"/>\n");
        value.append("                <Interceptor className=\"org.apache.catalina.tribes.group.interceptors.MessageDispatch15Interceptor\"/>\n");
        value.append("            </Channel>\n");
        value.append("            <Valve className=\"org.apache.catalina.ha.tcp.ReplicationValve\"\n");
        value.append("                 filter=\".*\\.gif;.*\\.js;.*\\.jpg;.*\\.png;.*\\.htm;.*\\.html;.*\\.css;.*\\.txt;\" />\n");
        value.append("            <Valve className=\"org.apache.catalina.ha.session.JvmRouteBinderValve\"/>\n");
        value.append("            <ClusterListener className=\"org.apache.catalina.ha.session.JvmRouteSessionIDBinderListener\"/>\n");
        value.append("            <ClusterListener className=\"org.apache.catalina.ha.session.ClusterSessionListener\"/>\n");
        value.append("        </Cluster>\n");
        value.append("      </Host>");
        propertyReplace.setValue(value.toString());
        propertyReplace.setLogInfo("[Tomcat] Setting Cluster");
        this.addTask((Task)propertyReplace);
    }

    public boolean isHttpConfigured() {
        return this.httpConfigured;
    }
}

