/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.carol.jndi.spi;

import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.spi.InitialContextFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ow2.carol.jndi.spi.VirtualJNDILookup;

public class VirtualJNDIContextFactory
implements InitialContextFactory {
    private static Log logger = LogFactory.getLog(VirtualJNDIContextFactory.class);
    public static final String PARENT_INITIAL_CONTEXT_FACTORY = VirtualJNDIContextFactory.class.getName() + "_PARENT_" + "java.naming.factory.initial";

    @Override
    public Context getInitialContext(Hashtable<?, ?> env) throws NamingException {
        InitialContextFactory parentFactory;
        String parent = System.getProperty(PARENT_INITIAL_CONTEXT_FACTORY);
        if (parent == null) {
            throw new IllegalStateException("The parent InitialContextFactory is null!");
        }
        boolean selfAlreadyInStack = false;
        for (StackTraceElement ste : Thread.currentThread().getStackTrace()) {
            if (!this.getClass().getName().equals(ste.getClassName())) continue;
            selfAlreadyInStack = true;
            break;
        }
        Hashtable<Object, Object> environment = new Hashtable<Object, Object>();
        if (env != null) {
            environment.putAll(env);
        }
        if (selfAlreadyInStack || environment.get("java.naming.factory.initial") == null) {
            environment.put("java.naming.factory.initial", parent);
        }
        try {
            Class<?> parentClass = Thread.currentThread().getContextClassLoader().loadClass(parent);
            parentFactory = (InitialContextFactory)parentClass.newInstance();
        }
        catch (Exception e) {
            throw new NamingException("Cannot load parent initial context (" + parent + "): " + e);
        }
        logger.debug((Object)("Getting initial context with parent factory " + parentFactory));
        return new VirtualJNDILookup(parentFactory.getInitialContext(environment));
    }
}

