/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.resource.internal.pool.lib;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import javax.resource.ResourceException;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ValidatingManagedConnectionFactory;
import javax.transaction.Transaction;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.jonas.lib.util.Log;
import org.ow2.jonas.resource.internal.pool.Pool;
import org.ow2.jonas.resource.internal.pool.PoolItemStats;
import org.ow2.jonas.resource.internal.pool.PoolMatchFactory;
import org.ow2.jonas.resource.internal.pool.lib.HArrayPoolMonitor;

public class HArrayPool
implements Pool {
    private Logger logger = null;
    private Logger conLogger = null;
    private long timeout = 0L;
    private PoolMatchFactory matchFactory = null;
    private LinkedHashSet freeList = null;
    private HashSet activeList = null;
    private Hashtable infoList = null;
    private static final int NO_POOLING = -2;
    private static final int NO_LIMIT = -1;
    private static final long ONE_DAY = 86400000L;
    private static final int MAX_REMOVE_FREELIST = 10;
    private int busyMin = 0;
    private int busyMax = 0;
    private int initSize = -1;
    private int jdbcConnLevel = 0;
    private String jdbcTestStatement = "";
    private int maxAge = 0;
    private int maxOpentime = 0;
    private int maxSize = -1;
    private int maxWaiters = 1000;
    private long maxWaitTimeout = 10000L;
    private int minSize = 0;
    private HArrayPoolMonitor poolMonitor = null;
    private int samplingPeriod = 60;
    private int waiterCount = 0;
    private long waitingTime = 0L;
    private String jndiName = null;
    private boolean poolClosed = false;
    private boolean observable = false;
    private int busyMaxRecent = 0;
    private int busyMinRecent = 0;
    private int currentWaiters = 0;
    private int openedCount = 0;
    private int connectionFailures = 0;
    private int connectionLeaks = 0;
    private int servedOpen = 0;
    private int rejectedFull = 0;
    private int rejectedTimeout = 0;
    private int rejectedOther = 0;
    private int waitersHigh = 0;
    private int waitersHighRecent = 0;
    private int totalWaiterCount = 0;
    private long totalWaitingTime = 0L;
    private long waitingHigh = 0L;
    private long waitingHighRecent = 0L;

    public HArrayPool(Logger logger, String jndiname) {
        this.logger = logger;
        if (this.conLogger == null) {
            this.conLogger = Log.getLogger((String)"org.ow2.jonas.jca.connection");
        }
        this.freeList = new LinkedHashSet();
        this.activeList = new HashSet();
        this.infoList = new Hashtable();
        this.jndiName = jndiname;
    }

    @Override
    public void setObservable(boolean obs) {
        this.observable = obs;
    }

    @Override
    public synchronized int getCurrentBusy() {
        return this.activeList.size();
    }

    @Override
    public int getCurrentOpened() {
        return this.getSize();
    }

    @Override
    public int getInitSize() {
        return this.initSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void setInitSize(int v) throws Exception {
        if (this.initSize >= 0) {
            this.logger.log(BasicLevel.WARN, (Object)"Already set");
            return;
        }
        this.initSize = v;
        if (this.initSize == 0 || this.maxSize == -2) {
            return;
        }
        if (this.maxSize > 0 && this.initSize > this.maxSize) {
            this.logger.log(BasicLevel.ERROR, (Object)("initSize=" + this.initSize + " should be less than maxSize=" + this.maxSize));
            this.initSize = this.maxSize;
        }
        for (int i = 0; i < this.initSize; ++i) {
            ManagedConnection res = this.createResource(null);
            HArrayPool hArrayPool = this;
            synchronized (hArrayPool) {
                this.freeList.add(res);
                this.infoList.put(res, new PoolItemStats());
            }
            this.setItemStats(res);
        }
    }

    @Override
    public int getJdbcConnLevel() {
        return this.jdbcConnLevel;
    }

    @Override
    public void setJdbcConnLevel(int jdbcConnLevel) {
        this.jdbcConnLevel = jdbcConnLevel;
    }

    @Override
    public String getJdbcTestStatement() {
        return this.jdbcTestStatement;
    }

    @Override
    public void setJdbcTestStatement(String jdbcTestStatement) {
        this.jdbcTestStatement = jdbcTestStatement;
    }

    @Override
    public int getMaxAge() {
        return this.maxAge;
    }

    @Override
    public void setMaxAge(int maxAge) {
        this.maxAge = maxAge;
    }

    @Override
    public int getMaxOpentime() {
        return this.maxOpentime;
    }

    @Override
    public void setMaxOpentime(int mx) {
        this.maxOpentime = mx;
    }

    @Override
    public int getMaxSize() {
        return this.maxSize;
    }

    @Override
    public void setMaxSize(int val) throws Exception {
        if (val == this.maxSize) {
            return;
        }
        if (val < this.minSize) {
            this.logger.log(BasicLevel.WARN, (Object)("Bad arg maxsize:" + val));
            return;
        }
        boolean shrink = val < this.getSize();
        this.maxSize = val;
        if (shrink) {
            this.shrinkPool();
        }
    }

    @Override
    public int getMaxWaiters() {
        return this.maxWaiters;
    }

    @Override
    public void setMaxWaiters(int nb) {
        this.maxWaiters = nb;
    }

    @Override
    public int getMaxWaitTime() {
        return (int)(this.maxWaitTimeout / 1000L);
    }

    @Override
    public void setMaxWaitTime(int sec) {
        this.maxWaitTimeout = (long)sec * 1000L;
    }

    @Override
    public int getMinSize() {
        return this.minSize;
    }

    @Override
    public void setMinSize(int val) throws Exception {
        if (val == this.minSize) {
            return;
        }
        if (val < 0 || val > this.maxSize && this.maxSize > 0) {
            this.logger.log(BasicLevel.WARN, (Object)("Bad arg minsize:" + val));
            return;
        }
        boolean feed = val > this.freeList.size();
        this.minSize = val;
        if (feed) {
            this.feedFreeList();
        }
    }

    @Override
    public int getSamplingPeriod() {
        return this.samplingPeriod;
    }

    @Override
    public void setSamplingPeriod(int sec) {
        if (sec > 0) {
            this.samplingPeriod = sec;
            this.poolMonitor.setSamplingPeriod(sec);
        }
    }

    @Override
    public synchronized int getSize() {
        return this.activeList.size() + this.freeList.size();
    }

    @Override
    public long getTimeout() {
        return this.timeout;
    }

    @Override
    public void setTimeout(long crto) {
    }

    @Override
    public int getBusyMaxRecent() {
        return this.busyMaxRecent;
    }

    @Override
    public int getBusyMinRecent() {
        return this.busyMinRecent;
    }

    @Override
    public int getCurrentWaiters() {
        return this.currentWaiters;
    }

    @Override
    public int getOpenedCount() {
        return this.openedCount;
    }

    @Override
    public int getConnectionFailures() {
        return this.connectionFailures;
    }

    @Override
    public int getConnectionLeaks() {
        return this.connectionLeaks;
    }

    @Override
    public int getServedOpen() {
        return this.servedOpen;
    }

    @Override
    public int getRejectedFull() {
        return this.rejectedFull;
    }

    @Override
    public int getRejectedTimeout() {
        return this.rejectedTimeout;
    }

    @Override
    public int getRejectedOther() {
        return this.rejectedOther;
    }

    @Override
    public int getRejectedOpen() {
        return this.rejectedFull + this.rejectedTimeout + this.rejectedOther;
    }

    @Override
    public int getWaitersHigh() {
        return this.waitersHigh;
    }

    @Override
    public int getWaitersHighRecent() {
        return this.waitersHighRecent;
    }

    @Override
    public int getWaiterCount() {
        return this.totalWaiterCount;
    }

    @Override
    public long getWaitingTime() {
        return this.totalWaitingTime;
    }

    @Override
    public long getWaitingHigh() {
        return this.waitingHigh;
    }

    @Override
    public long getWaitingHighRecent() {
        return this.waitingHighRecent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getResource(Object hints) throws Exception {
        if (this.matchFactory == null) {
            throw new Exception("The matchFactory is mandatory!!");
        }
        ManagedConnection res = null;
        long timetowait = this.maxWaitTimeout;
        long starttime = 0L;
        HArrayPool hArrayPool = this;
        synchronized (hArrayPool) {
            while (res == null) {
                if (!this.freeList.isEmpty()) {
                    try {
                        if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                            this.logger.log(BasicLevel.DEBUG, (Object)"Free entries available");
                        }
                        if ((res = (ManagedConnection)this.matchFactory.matchResource(this.freeList, hints)) != null) {
                            this.freeList.remove(res);
                            this.activeList.add(res);
                            break;
                        }
                    }
                    catch (Exception ex) {
                        this.logger.log(BasicLevel.WARN, (Object)"Error from matchResource", (Throwable)ex);
                    }
                }
                int curSize = this.activeList.size() + this.freeList.size();
                if (this.maxSize < 0 || curSize < this.maxSize) {
                    res = this.createResource(hints);
                    this.activeList.add(res);
                    continue;
                }
                if (this.freeList.size() > 0) {
                    res = (ManagedConnection)this.freeList.iterator().next();
                    this.matchFactory.releaseResource(res);
                    res.destroy();
                    this.freeList.remove(res);
                    this.infoList.remove(res);
                    res = this.createResource(hints);
                    this.activeList.add(res);
                    continue;
                }
                boolean stoplooping = true;
                if (timetowait > 0L && this.currentWaiters < this.maxWaiters) {
                    ++this.currentWaiters;
                    if (this.waiterCount < this.currentWaiters) {
                        this.waiterCount = this.currentWaiters;
                    }
                    if (starttime == 0L) {
                        starttime = System.currentTimeMillis();
                        if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                            this.logger.log(BasicLevel.DEBUG, (Object)"Wait for a free Connection");
                        }
                    }
                    try {
                        this.wait(timetowait);
                    }
                    catch (InterruptedException ign) {
                        this.logger.log(BasicLevel.WARN, (Object)"Interrupted");
                    }
                    finally {
                        --this.currentWaiters;
                    }
                    long stoptime = System.currentTimeMillis();
                    long stillwaited = stoptime - starttime;
                    timetowait = this.maxWaitTimeout - stillwaited;
                    boolean bl = stoplooping = timetowait <= 0L;
                    if (stoplooping) {
                        ++this.totalWaiterCount;
                        this.totalWaitingTime += stillwaited;
                        if (this.waitingTime < stillwaited) {
                            this.waitingTime = stillwaited;
                        }
                    } else {
                        if (this.freeList.isEmpty()) continue;
                        if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                            this.logger.log(BasicLevel.DEBUG, (Object)("Notified after " + stillwaited));
                        }
                        ++this.totalWaiterCount;
                        this.totalWaitingTime += stillwaited;
                        if (this.waitingTime >= stillwaited) continue;
                        this.waitingTime = stillwaited;
                        continue;
                    }
                }
                if (!stoplooping || !this.freeList.isEmpty()) continue;
                if (starttime > 0L) {
                    ++this.rejectedTimeout;
                    this.logger.log(BasicLevel.WARN, (Object)"Cannot create a Connection - timeout");
                } else {
                    ++this.rejectedFull;
                    this.logger.log(BasicLevel.WARN, (Object)"Cannot create a Connection");
                }
                throw new Exception("No more connections");
            }
            if (this.infoList.get(res) == null) {
                this.infoList.put(res, new PoolItemStats());
            }
            this.printLists();
        }
        this.setItemStats(res);
        this.recomputeBusy();
        if (this.conLogger.isLoggable(BasicLevel.DEBUG)) {
            this.conLogger.log(BasicLevel.DEBUG, (Object)("Returned Resource: " + res));
        }
        return res;
    }

    private ManagedConnection createResource(Object hints) throws Exception {
        if (this.matchFactory == null) {
            throw new Exception("The matchFactory is mandatory!!");
        }
        ManagedConnection res = null;
        try {
            res = (ManagedConnection)this.matchFactory.createResource(hints);
            if (res == null) {
                Exception exc = new Exception("A null ManagedConnection was returned.");
                throw exc;
            }
            ++this.openedCount;
        }
        catch (Exception ex) {
            ++this.connectionFailures;
            ++this.rejectedOther;
            if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                this.logger.log(BasicLevel.DEBUG, (Object)"Cannot create new Connection", (Throwable)ex);
            }
            throw ex;
        }
        if (this.conLogger.isLoggable(BasicLevel.DEBUG)) {
            this.conLogger.log(BasicLevel.DEBUG, (Object)("Created Resource: " + res));
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseResource(Object resource, boolean destroy) throws Exception {
        ManagedConnection res = (ManagedConnection)resource;
        HArrayPool hArrayPool = this;
        synchronized (hArrayPool) {
            if (!this.activeList.contains(res)) {
                this.conLogger.log(BasicLevel.WARN, (Object)"Attempt to release inactive resource");
                return;
            }
            this.activeList.remove(res);
            if (this.maxSize == -2 || destroy) {
                try {
                    res.destroy();
                    if (this.conLogger.isLoggable(BasicLevel.DEBUG)) {
                        this.conLogger.log(BasicLevel.DEBUG, (Object)("Destroyed Resource: " + res));
                    }
                    this.infoList.remove(res);
                }
                catch (IllegalStateException e) {
                    this.activeList.add(res);
                    this.conLogger.log(BasicLevel.WARN, (Object)("Attempt to release resource being used:" + e));
                    throw e;
                }
                catch (ResourceException e) {
                    this.activeList.add(res);
                    this.conLogger.log(BasicLevel.WARN, (Object)("Could not release resource:" + (Object)((Object)e)));
                    throw e;
                }
            } else {
                this.freeList.add(res);
                PoolItemStats pis = (PoolItemStats)this.infoList.get(res);
                if (pis != null) {
                    pis.setTotalConnectionTime(System.currentTimeMillis() - pis.getStartTime());
                }
            }
            if (this.currentWaiters > 0) {
                this.notifyAll();
            }
        }
        this.shrinkPool();
        this.recomputeBusy();
    }

    @Override
    public synchronized void closeAllConnections() {
        this.logger.log(BasicLevel.DEBUG, (Object)"");
        this.poolMonitor.stopit();
        for (ManagedConnection res : this.freeList) {
            try {
                res.destroy();
            }
            catch (Exception e) {
                this.logger.log(BasicLevel.ERROR, (Object)"Error while closing a Connection:", (Throwable)e);
            }
        }
        this.freeList.clear();
        for (ManagedConnection res : this.activeList) {
            try {
                res.destroy();
            }
            catch (Exception e) {
                this.logger.log(BasicLevel.ERROR, (Object)"Error while closing a Connection:", (Throwable)e);
            }
        }
        this.activeList.clear();
        this.poolClosed = true;
    }

    @Override
    public PoolMatchFactory getMatchFactory() {
        return this.matchFactory;
    }

    @Override
    public synchronized void setMatchFactory(PoolMatchFactory pmf) {
        this.matchFactory = pmf;
    }

    @Override
    public void startMonitor() {
        this.logger.log(BasicLevel.DEBUG, (Object)this.jndiName);
        this.poolMonitor = new HArrayPoolMonitor(this, this.jndiName);
        this.poolMonitor.start();
    }

    @Override
    public synchronized int[] getOpenedConnections(long usedTimeMs) {
        ArrayList<Integer> connections = new ArrayList<Integer>();
        for (ManagedConnection res : this.activeList) {
            PoolItemStats pis = (PoolItemStats)this.infoList.get(res);
            if (pis == null) continue;
            long duration = System.currentTimeMillis() - pis.getStartTime();
            if (pis.getUses() <= 0 || duration < usedTimeMs) continue;
            connections.add(new Integer(pis.getIdent()));
        }
        int[] ids = new int[connections.size()];
        int idx = 0;
        for (Integer id : connections) {
            ids[idx++] = id;
        }
        return ids;
    }

    @Override
    public synchronized void forceCloseConnection(int connectionId) {
        ManagedConnection res = null;
        for (ManagedConnection res1 : this.activeList) {
            PoolItemStats pis = (PoolItemStats)this.infoList.get(res1);
            if (pis == null || pis.getIdent() != connectionId) continue;
            res = res1;
            break;
        }
        if (res != null) {
            try {
                this.releaseResource(res, true);
                this.logger.log(BasicLevel.WARN, (Object)"Force close of active connection");
                this.logger.log(BasicLevel.WARN, (Object)("MC = " + res));
            }
            catch (Exception e) {
                this.logger.log(BasicLevel.WARN, (Object)("Could not close of active connection: " + e));
                this.logger.log(BasicLevel.WARN, (Object)("MC = " + res));
            }
        } else {
            this.logger.log(BasicLevel.WARN, (Object)("Could not find this Connection " + connectionId));
        }
    }

    @Override
    public synchronized ManagedConnection getConnectionById(int connectionId) {
        for (ManagedConnection res : this.activeList) {
            PoolItemStats pis = (PoolItemStats)this.infoList.get(res);
            if (pis == null || pis.getIdent() != connectionId) continue;
            return res;
        }
        return null;
    }

    @Override
    public Map getConnectionDetails(ManagedConnection res, Transaction tx) {
        PoolItemStats pis = (PoolItemStats)this.infoList.get(res);
        HashMap<String, Object> details = new HashMap<String, Object>();
        long curTime = System.currentTimeMillis();
        details.put("id", new Integer(pis.getIdent()));
        details.put("open-count", new Integer(pis.getUses()));
        boolean inactive = false;
        if (pis.getMaxOpenTimeout() > 0L && curTime > pis.getMaxOpenTimeout()) {
            inactive = true;
        }
        details.put("inactive", inactive);
        long duration = curTime - pis.getStartTime();
        details.put("duration", new Long(duration));
        String xid = "null";
        if (tx != null) {
            xid = tx.toString();
        }
        details.put("transaction-id", xid);
        long age = curTime - pis.getCreationTime();
        details.put("age", new Long(age));
        details.put("openers", pis.getOpenerThreadInfos());
        details.put("closers", pis.getCloserThreadInfos());
        return details;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void validateMCs() throws Exception {
        if (this.poolClosed) {
            return;
        }
        if (this.matchFactory == null) {
            throw new Exception("The matchFactory is mandatory!!");
        }
        ValidatingManagedConnectionFactory vmcf = this.matchFactory.getValidatingMCFactory();
        if (vmcf == null) {
            return;
        }
        this.conLogger.log(BasicLevel.DEBUG, (Object)"");
        int count = 0;
        HashSet<ManagedConnection> checkList = new HashSet<ManagedConnection>();
        HArrayPool hArrayPool = this;
        synchronized (hArrayPool) {
            Iterator it = this.freeList.iterator();
            while (it.hasNext()) {
                ManagedConnection res = (ManagedConnection)it.next();
                it.remove();
                checkList.add(res);
                if (++count < 10) continue;
                break;
            }
        }
        Set invMcs = vmcf.getInvalidConnections(checkList);
        for (ManagedConnection res : invMcs) {
            checkList.remove(res);
            HArrayPool hArrayPool2 = this;
            synchronized (hArrayPool2) {
                this.infoList.remove(res);
            }
            res.destroy();
            this.matchFactory.releaseResource(res);
        }
        HArrayPool hArrayPool3 = this;
        synchronized (hArrayPool3) {
            for (ManagedConnection res : checkList) {
                this.freeList.add(res);
            }
        }
        this.feedFreeList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean pruneMaxAged() throws Exception {
        if (this.poolClosed) {
            return false;
        }
        if (this.matchFactory == null) {
            throw new Exception("The matchFactory is mandatory!!");
        }
        boolean ret = false;
        long curTime = System.currentTimeMillis();
        int count = 0;
        LinkedList<ManagedConnection> removeList = new LinkedList<ManagedConnection>();
        HArrayPool hArrayPool = this;
        synchronized (hArrayPool) {
            Iterator it = this.freeList.iterator();
            while (it.hasNext()) {
                ManagedConnection res = (ManagedConnection)it.next();
                PoolItemStats pis = (PoolItemStats)this.infoList.get(res);
                if (this.maxAge <= 0 || pis == null || pis.getMaxAgeTimeout() <= 0L || curTime <= pis.getMaxAgeTimeout()) continue;
                if (this.conLogger.isLoggable(BasicLevel.DEBUG)) {
                    this.conLogger.log(BasicLevel.DEBUG, (Object)("remove a timed out connection " + res));
                }
                it.remove();
                this.infoList.remove(res);
                removeList.add(res);
                if (++count < 10) continue;
                break;
            }
        }
        for (ManagedConnection res : removeList) {
            try {
                ret = true;
                this.matchFactory.releaseResource(res);
                res.destroy();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean pruneLostConnections() throws Exception {
        if (this.poolClosed) {
            return false;
        }
        if (this.matchFactory == null) {
            throw new Exception("The matchFactory is mandatory!!");
        }
        boolean ret = false;
        long curTime = System.currentTimeMillis();
        LinkedList<ManagedConnection> removeList = new LinkedList<ManagedConnection>();
        HArrayPool hArrayPool = this;
        synchronized (hArrayPool) {
            for (ManagedConnection res : this.activeList) {
                PoolItemStats pis = (PoolItemStats)this.infoList.get(res);
                if (this.maxOpentime <= 0 || pis == null || pis.getMaxOpenTimeout() <= 0L || curTime <= pis.getMaxOpenTimeout()) continue;
                removeList.add(res);
            }
        }
        for (ManagedConnection item : removeList) {
            try {
                this.releaseResource(item, true);
                this.matchFactory.releaseResource(item);
                this.logger.log(BasicLevel.WARN, (Object)"close a timed out active connection");
                this.logger.log(BasicLevel.WARN, (Object)("MC = " + item));
                ++this.connectionLeaks;
                ret = true;
            }
            catch (Exception e) {
                this.logger.log(BasicLevel.WARN, (Object)("Cannot destroy resource being used:" + e));
                this.logger.log(BasicLevel.WARN, (Object)("MC = " + item));
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean shrinkPool() throws Exception {
        int curSize = this.getSize();
        boolean ret = false;
        if (this.maxSize > 0 && this.maxSize < curSize || this.maxSize == -2) {
            int nbRemove = curSize;
            if (this.maxSize > 0) {
                nbRemove -= this.maxSize;
            }
            if (this.freeList != null) {
                ManagedConnection res;
                LinkedList<ManagedConnection> removeList = new LinkedList<ManagedConnection>();
                HArrayPool hArrayPool = this;
                synchronized (hArrayPool) {
                    while (!this.freeList.isEmpty() && nbRemove > 0) {
                        res = (ManagedConnection)this.freeList.iterator().next();
                        this.freeList.remove(res);
                        removeList.add(res);
                        --nbRemove;
                        --curSize;
                    }
                }
                Iterator i = removeList.iterator();
                while (i.hasNext()) {
                    res = (ManagedConnection)i.next();
                    i.remove();
                    this.matchFactory.releaseResource(res);
                    res.destroy();
                    this.infoList.remove(res);
                    ret = true;
                }
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean feedFreeList() throws Exception {
        boolean ret = false;
        if (this.maxSize != -2) {
            HArrayPool hArrayPool = this;
            synchronized (hArrayPool) {
                while (this.minSize > this.getSize()) {
                    ManagedConnection res = this.createResource(null);
                    if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                        this.logger.log(BasicLevel.DEBUG, (Object)("recreate connection " + res));
                    }
                    this.freeList.add(res);
                    this.infoList.put(res, new PoolItemStats());
                    this.setItemStats(res);
                    ret = true;
                }
            }
        }
        return ret;
    }

    @Override
    public void adjust() throws Exception {
        if (this.conLogger.isLoggable(BasicLevel.DEBUG)) {
            this.conLogger.log(BasicLevel.DEBUG, (Object)(this.jndiName + " active= " + this.activeList.size() + " min= " + this.minSize));
            this.printLists();
        }
        boolean pma = this.pruneMaxAged();
        boolean plc = this.pruneLostConnections();
        this.shrinkPool();
        if (pma || plc) {
            this.feedFreeList();
        }
        this.recomputeBusy();
    }

    public synchronized void recomputeBusy() {
        int busy = this.getCurrentBusy();
        if (this.busyMax < busy) {
            this.busyMax = busy;
        }
        if (this.busyMin > busy) {
            this.busyMin = busy;
        }
    }

    @Override
    public synchronized void sampling() throws Exception {
        if (this.poolClosed) {
            return;
        }
        this.waitingHighRecent = this.waitingTime;
        if (this.waitingHigh < this.waitingTime) {
            this.waitingHigh = this.waitingTime;
        }
        this.waitingTime = 0L;
        this.waitersHighRecent = this.waiterCount;
        if (this.waitersHigh < this.waiterCount) {
            this.waitersHigh = this.waiterCount;
        }
        this.waiterCount = 0;
        this.busyMaxRecent = this.busyMax;
        this.busyMax = this.getCurrentBusy();
        this.busyMinRecent = this.busyMin;
        this.busyMin = this.getCurrentBusy();
    }

    private void setItemStats(Object res) {
        PoolItemStats pis = (PoolItemStats)this.infoList.get(res);
        if (pis != null) {
            pis.incrementUses();
            long sTime = System.currentTimeMillis();
            pis.setStartTime(sTime);
            if (this.maxAge > 0 && pis.getMaxAgeTimeout() == 0L) {
                pis.setMaxAgeTimeout(sTime + (long)this.maxAge * 60L * 1000L);
            }
            if (this.maxOpentime > 0) {
                pis.setMaxOpenTimeout(sTime + (long)this.maxOpentime * 60L * 1000L);
            }
            if (this.observable) {
                pis.addOpenerThreadInfos();
            }
        }
        ++this.servedOpen;
    }

    void printLists() {
        if (this.logger.isLoggable(BasicLevel.DEBUG)) {
            PoolItemStats pis;
            ManagedConnection mc;
            Iterator it;
            int count = 0;
            this.logger.log(BasicLevel.DEBUG, (Object)("minSize=" + this.minSize + ", maxSize=" + this.maxSize + ",  freeSize=" + this.freeList.size()));
            this.logger.log(BasicLevel.DEBUG, (Object)"activeList:");
            if (this.activeList == null) {
                this.logger.log(BasicLevel.DEBUG, (Object)" null");
            } else {
                it = this.activeList.iterator();
                while (it.hasNext() && ++count < 40) {
                    mc = (ManagedConnection)it.next();
                    pis = (PoolItemStats)this.infoList.get(mc);
                    this.logger.log(BasicLevel.DEBUG, (Object)(" " + mc));
                    this.logger.log(BasicLevel.DEBUG, (Object)(" " + pis.toString()));
                }
            }
            this.logger.log(BasicLevel.DEBUG, (Object)"freeList:");
            if (this.freeList == null) {
                this.logger.log(BasicLevel.DEBUG, (Object)" null");
            } else {
                count = 0;
                it = this.freeList.iterator();
                while (it.hasNext() && ++count < 40) {
                    mc = (ManagedConnection)it.next();
                    pis = (PoolItemStats)this.infoList.get(mc);
                    this.logger.log(BasicLevel.DEBUG, (Object)(" " + mc));
                    this.logger.log(BasicLevel.DEBUG, (Object)(" " + pis.toString()));
                }
            }
        }
    }
}

