/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.mail.internal.osgi.configadmin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Properties;
import java.util.Set;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.apache.felix.ipojo.annotations.Component;
import org.apache.felix.ipojo.annotations.Invalidate;
import org.apache.felix.ipojo.annotations.Property;
import org.apache.felix.ipojo.annotations.Requires;
import org.apache.felix.ipojo.annotations.Updated;
import org.apache.felix.ipojo.annotations.Validate;
import org.ow2.jonas.mail.MailService;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

@Component(name="MailMimePartDSFactory", propagation=true)
public class MailMimePartDSFactory
implements Pojo {
    private InstanceManager __IM;
    private static Log logger = LogFactory.getLog(MailMimePartDSFactory.class);
    private boolean __Fname;
    @Property(name="name", mandatory=true)
    private String name;
    private boolean __Fprops;
    Properties props;
    private boolean __FmailService;
    @Requires
    private MailService mailService;
    private boolean __Mupdated$java_util_Dictionary;
    private boolean __Mstart;
    private boolean __Mstop;

    String __getname() {
        if (!this.__Fname) {
            return this.name;
        }
        return (String)this.__IM.onGet((Object)this, "name");
    }

    void __setname(String string) {
        if (!this.__Fname) {
            this.name = string;
            return;
        }
        this.__IM.onSet((Object)this, "name", (Object)string);
    }

    Properties __getprops() {
        if (!this.__Fprops) {
            return this.props;
        }
        return (Properties)this.__IM.onGet((Object)this, "props");
    }

    void __setprops(Properties properties) {
        if (!this.__Fprops) {
            this.props = properties;
            return;
        }
        this.__IM.onSet((Object)this, "props", (Object)properties);
    }

    MailService __getmailService() {
        if (!this.__FmailService) {
            return this.mailService;
        }
        return (MailService)this.__IM.onGet((Object)this, "mailService");
    }

    void __setmailService(MailService mailService) {
        if (!this.__FmailService) {
            this.mailService = mailService;
            return;
        }
        this.__IM.onSet((Object)this, "mailService", (Object)mailService);
    }

    public MailMimePartDSFactory() {
        this(null);
    }

    private MailMimePartDSFactory(InstanceManager _manager) {
        this._setInstanceManager(_manager);
    }

    public void updated(Dictionary conf) {
        if (!this.__Mupdated$java_util_Dictionary) {
            this.__M_updated(conf);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "updated$java_util_Dictionary", new Object[]{conf});
            this.__M_updated(conf);
            this.__IM.onExit((Object)this, "updated$java_util_Dictionary", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "updated$java_util_Dictionary", throwable);
            throw throwable;
        }
    }

    @Updated
    private void __M_updated(Dictionary conf) {
        this.__setprops(new Properties());
        logger.debug((Object)"{0} properties were injected", new Object[]{conf.size()});
        ArrayList<String> keys = Collections.list(conf.keys());
        for (String key : keys) {
            String value = conf.get(key).toString();
            logger.debug((Object)"{0}={1}", new Object[]{key, value});
            if (key.equals("name")) continue;
            this.__getprops().setProperty(key, value);
        }
    }

    public void start() {
        if (!this.__Mstart) {
            this.__M_start();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "start", new Object[0]);
            this.__M_start();
            this.__IM.onExit((Object)this, "start", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "start", throwable);
            throw throwable;
        }
    }

    @Validate
    private void __M_start() {
        try {
            this.__getprops().setProperty("mail.factory.type", "javax.mail.internet.MimePartDataSource");
            this.__getprops().setProperty("mail.factory.name", this.__getname());
            this.__getmailService().createMailFactory(this.__getname(), this.__getprops());
            logger.debug((Object)"Mail Mime Part DS Factory created {0}", new Object[]{this.__getname()});
        }
        catch (Exception e) {
            logger.error((Object)"Error when creating the mail mime part ds factory {0} - exception={1}", new Object[]{this.__getname(), e});
        }
    }

    public void stop() {
        if (!this.__Mstop) {
            this.__M_stop();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "stop", new Object[0]);
            this.__M_stop();
            this.__IM.onExit((Object)this, "stop", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "stop", throwable);
            throw throwable;
        }
    }

    @Invalidate
    private void __M_stop() {
        try {
            this.__getmailService().unbindMailFactory(this.__getname());
            logger.debug((Object)"Mail Mime Part DS Factory unbound {0}", new Object[]{this.__getname()});
        }
        catch (Exception e) {
            logger.error((Object)"Error when removing the mail mime part ds factory {0} - exception={1}", new Object[]{this.__getname(), e});
        }
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("mailService")) {
                this.__FmailService = true;
            }
            if (set.contains("name")) {
                this.__Fname = true;
            }
            if (set.contains("props")) {
                this.__Fprops = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("updated$java_util_Dictionary")) {
                this.__Mupdated$java_util_Dictionary = true;
            }
            if (set.contains("start")) {
                this.__Mstart = true;
            }
            if (set.contains("stop")) {
                this.__Mstop = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

