/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.ejb21;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import javax.ejb.EJBException;
import javax.ejb.MessageDrivenBean;
import javax.ejb.MessageDrivenContext;
import javax.ejb.Timer;
import javax.ejb.TimerService;
import javax.naming.Context;
import javax.resource.spi.ActivationSpec;
import javax.resource.spi.ResourceAdapter;
import javax.resource.spi.UnavailableException;
import javax.resource.spi.endpoint.MessageEndpoint;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.xa.XAResource;
import org.objectweb.util.monolog.api.BasicLevel;
import org.ow2.jonas.deployment.ejb.ActivationConfigPropertyDesc;
import org.ow2.jonas.deployment.ejb.BeanDesc;
import org.ow2.jonas.deployment.ejb.MessageDrivenDesc;
import org.ow2.jonas.lib.ejb21.JContainer;
import org.ow2.jonas.lib.ejb21.JFactory;
import org.ow2.jonas.lib.ejb21.JHome;
import org.ow2.jonas.lib.ejb21.JLocalHome;
import org.ow2.jonas.lib.ejb21.JMessageEndpoint;
import org.ow2.jonas.lib.ejb21.JMessageEndpointProxy;
import org.ow2.jonas.lib.ejb21.JTimerService;
import org.ow2.jonas.lib.ejb21.RequestCtx;
import org.ow2.jonas.lib.ejb21.TraceEjb;
import org.ow2.jonas.lib.execution.ExecutionResult;
import org.ow2.jonas.lib.execution.IExecution;
import org.ow2.jonas.lib.execution.RunnableHelper;
import org.ow2.jonas.resource.Rar;
import org.ow2.jonas.resource.ResourceService;

public class JMdbEndpointFactory
extends JFactory
implements MessageEndpointFactory {
    private List endpool = new ArrayList();
    private int instanceCount = 0;
    private int minPoolSize = 0;
    private int maxCacheSize = 0;
    private ActivationSpec as = null;
    private String msglistenType = null;
    private boolean activated = false;
    ResourceAdapter resadp = null;

    public JMdbEndpointFactory(MessageDrivenDesc dd, JContainer cont, ActivationSpec as, ResourceService rserv) {
        super((BeanDesc)dd, cont);
        String dest = dd.getDestinationJndiName();
        List acpl = null;
        if (dd.getMdActivationConfigDesc() != null) {
            acpl = dd.getMdActivationConfigDesc().getActivationConfigPropertyList();
        }
        List jAcpl = null;
        if (dd.getJonasMdActivationConfigDesc() != null) {
            jAcpl = dd.getJonasMdActivationConfigDesc().getActivationConfigPropertyList();
        }
        this.mdbEFInit(dd, dest, acpl, jAcpl, as, rserv);
    }

    public JMdbEndpointFactory(MessageDrivenDesc dd, String destination, JContainer cont, ActivationSpec as, ResourceService rserv) {
        super((BeanDesc)dd, cont);
        LinkedList jAcpl = new LinkedList();
        List acpl = null;
        if (dd.getMdActivationConfigDesc() != null) {
            acpl = dd.getMdActivationConfigDesc().getActivationConfigPropertyList();
        }
        this.buildACL(dd, jAcpl);
        this.mdbEFInit(dd, destination, acpl, jAcpl, as, rserv);
    }

    private void buildACL(MessageDrivenDesc dd, List jacl) {
        String[] aclNames = new String[]{"destination", "destinationType", "messageSelector", "acknowledgeMode", "subscriptionDurability"};
        ActivationConfigPropertyDesc acp = null;
        acp = new ActivationConfigPropertyDesc();
        acp.setActivationConfigPropertyName("destination");
        acp.setActivationConfigPropertyValue(dd.getDestinationJndiName());
        jacl.add(acp);
        acp = new ActivationConfigPropertyDesc();
        acp.setActivationConfigPropertyName("destinationType");
        if (dd.isTopicDestination()) {
            acp.setActivationConfigPropertyValue("javax.jms.Topic");
        } else {
            acp.setActivationConfigPropertyValue("javax.jms.Queue");
        }
        jacl.add(acp);
        acp = new ActivationConfigPropertyDesc();
        acp.setActivationConfigPropertyName("messageSelector");
        acp.setActivationConfigPropertyValue(dd.getSelector());
        jacl.add(acp);
        acp = new ActivationConfigPropertyDesc();
        acp.setActivationConfigPropertyName("acknowledgeMode");
        if (dd.getAcknowledgeMode() == 1) {
            acp.setActivationConfigPropertyValue("Auto-acknowledge");
        } else {
            acp.setActivationConfigPropertyValue("Dups-ok-acknowledge");
        }
        jacl.add(acp);
        acp = new ActivationConfigPropertyDesc();
        acp.setActivationConfigPropertyName("subscriptionDurability");
        if (dd.getSubscriptionDurability() == 1) {
            acp.setActivationConfigPropertyValue("Durable");
        } else {
            acp.setActivationConfigPropertyValue("NonDurable");
        }
        jacl.add(acp);
        if (dd.getSubscriptionDurability() == 1) {
            acp = new ActivationConfigPropertyDesc();
            acp.setActivationConfigPropertyName("subscriptionName");
            acp.setActivationConfigPropertyValue(dd.getEjbName());
            jacl.add(acp);
        }
        List acpl = null;
        if (dd.getJonasMdActivationConfigDesc() != null) {
            acpl = dd.getJonasMdActivationConfigDesc().getActivationConfigPropertyList();
            String acpName = null;
            boolean found = false;
            for (int i = 0; i < acpl.size(); ++i) {
                acp = (ActivationConfigPropertyDesc)acpl.get(i);
                acpName = acp.getActivationConfigPropertyName();
                found = false;
                for (int j = 0; j < aclNames.length; ++j) {
                    if (!acpName.equals(aclNames[j])) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                jacl.add(acp);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mdbEFInit(MessageDrivenDesc dd, String dest, List acpl, List jAcpl, ActivationSpec aSpec, ResourceService ressv) {
        String methName = "mdbEFInit: ";
        String ejbName = dd.getEjbName();
        this.txbeanmanaged = dd.isBeanManagedTransaction();
        this.as = aSpec;
        this.minPoolSize = dd.getPoolMin();
        this.maxCacheSize = dd.getCacheMax();
        if (TraceEjb.isDebugJms()) {
            TraceEjb.mdb.log(BasicLevel.DEBUG, (Object)(methName + "maxCacheSize = " + this.maxCacheSize + " minPoolSize = " + this.minPoolSize));
        }
        Rar rar = null;
        if (ressv == null) {
            TraceEjb.mdb.log(BasicLevel.ERROR, (Object)"ResourceService ref missing");
            throw new EJBException("No resource service");
        }
        rar = ressv.getRar(dest);
        this.msglistenType = rar.getInterface(dest);
        try {
            rar.configureAS(this.as, acpl, jAcpl, dest, ejbName);
        }
        catch (Exception ex) {
            TraceEjb.mdb.log(BasicLevel.ERROR, (Object)(methName + "cannot configure activationspec " + ex));
            ex.printStackTrace();
            throw new EJBException("cannot configure activationspec ", ex);
        }
        this.resadp = rar.getResourceAdapter();
        List ex = this.endpool;
        synchronized (ex) {
            for (int i = 0; i < this.minPoolSize; ++i) {
                JMessageEndpoint ep = null;
                ep = this.createNewInstance();
                this.endpool.add(ep);
            }
        }
        if (this.minPoolSize != 0) {
            TraceEjb.mdb.log(BasicLevel.INFO, (Object)(methName + "pre-allocate a set of " + this.minPoolSize + " message driven bean  instances"));
        }
        try {
            ActivationSpec[] asArray = new ActivationSpec[]{this.as};
            XAResource[] xar = this.resadp.getXAResources(asArray);
            if (xar != null && xar.length > 0) {
                this.tm.registerResourceManager(ejbName + this.msglistenType, xar[0], "", null, null);
            }
        }
        catch (Exception ex2) {
            TraceEjb.mdb.log(BasicLevel.ERROR, (Object)ex2.getMessage(), (Throwable)ex2);
        }
        final JMdbEndpointFactory fact = this;
        IExecution<Void> activator = new IExecution<Void>(){

            public Void execute() throws Exception {
                JMdbEndpointFactory.this.resadp.endpointActivation((MessageEndpointFactory)fact, JMdbEndpointFactory.this.as);
                return null;
            }
        };
        ExecutionResult result = RunnableHelper.execute((ClassLoader)this.getClass().getClassLoader(), (IExecution)activator);
        if (result.hasException()) {
            this.activated = false;
            TraceEjb.mdb.log(BasicLevel.ERROR, (Object)(methName + "cannot activate endpoint "));
            throw new EJBException("cannot activate endpoint ", result.getException());
        }
        this.activated = true;
    }

    @Override
    public void initInstancePool() {
    }

    @Override
    public int getPoolSize() {
        return this.endpool.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        String methName = "stop: ";
        if (TraceEjb.isDebugJms()) {
            TraceEjb.mdb.log(BasicLevel.DEBUG, (Object)methName);
        }
        try {
            this.resadp.endpointDeactivation((MessageEndpointFactory)this, this.as);
            List list = this.endpool;
            synchronized (list) {
                if (TraceEjb.isDebugJms()) {
                    TraceEjb.mdb.log(BasicLevel.DEBUG, (Object)(methName + "stopping " + this));
                }
                JMessageEndpoint ep = null;
                while (this.endpool.size() > 0) {
                    ep = (JMessageEndpoint)this.endpool.remove(0);
                    --this.instanceCount;
                    try {
                        ep.mdb.ejbRemove();
                    }
                    catch (Exception e) {
                        TraceEjb.mdb.log(BasicLevel.ERROR, (Object)(methName + "Cannot remove mdb: " + ep.mdb), (Throwable)e);
                    }
                }
            }
        }
        catch (Exception e) {
            TraceEjb.mdb.log(BasicLevel.WARN, (Object)(methName + "Cannot deactivate the endpoint"), (Throwable)e);
        }
        this.stopContainer();
    }

    @Override
    public void syncDirty(boolean notused) {
    }

    @Override
    public JHome getHome() {
        return null;
    }

    @Override
    public JLocalHome getLocalHome() {
        return null;
    }

    public MessageEndpoint createEndpoint(XAResource xaResource) throws UnavailableException {
        String methName = "createEndpoint: ";
        if (TraceEjb.isDebugJms()) {
            TraceEjb.mdb.log(BasicLevel.DEBUG, (Object)methName);
        }
        if (!this.activated) {
            TraceEjb.mdb.log(BasicLevel.ERROR, (Object)(methName + "mdb is not usuable either initial deployment or undeployment "));
            throw new UnavailableException("mdb is not usuable either initial deployment or undeployment ");
        }
        JMessageEndpoint ep = null;
        try {
            ep = this.getNewInstance(xaResource);
        }
        catch (Exception ex) {
            TraceEjb.mdb.log(BasicLevel.ERROR, (Object)(methName + "cannot create an endpoint "));
            throw new UnavailableException("cannot create an endpoint ", (Throwable)ex);
        }
        return ep.mep;
    }

    public boolean isDeliveryTransacted(Method method) throws NoSuchMethodException {
        int txAttribute = 0;
        try {
            txAttribute = this.dd.getMethodDesc(method).getTxAttribute();
        }
        catch (Exception ex) {
            TraceEjb.mdb.log(BasicLevel.ERROR, (Object)("isDeliveryTransacted: No such method exists. " + method.getName()), (Throwable)ex);
            throw new NoSuchMethodException("No such method exists. " + method.getName());
        }
        return txAttribute == 2;
    }

    public JMessageEndpoint getMessageEndpoint() throws Exception {
        if (TraceEjb.isDebugJms()) {
            TraceEjb.mdb.log(BasicLevel.DEBUG, (Object)"getMessageEndpoint: ");
        }
        return this.getNewInstance(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseEndpoint(JMessageEndpoint ep) {
        String methName = "releaseEndpoint: ";
        if (TraceEjb.isDebugJms()) {
            TraceEjb.mdb.log(BasicLevel.DEBUG, (Object)(methName + ep));
        }
        ep.setReleasedState(true);
        List list = this.endpool;
        synchronized (list) {
            this.endpool.add(ep);
            if (TraceEjb.isDebugJms()) {
                TraceEjb.mdb.log(BasicLevel.DEBUG, (Object)(methName + "notifyAll "));
            }
            this.endpool.notifyAll();
        }
        if (TraceEjb.isDebugJms()) {
            TraceEjb.mdb.log(BasicLevel.DEBUG, (Object)(methName + "nb instances " + this.getCacheSize()));
            TraceEjb.mdb.log(BasicLevel.DEBUG, (Object)(methName + "nb free cached instances " + this.getPoolSize()));
        }
    }

    @Override
    public TimerService getTimerService() {
        if (this.myTimerService == null) {
            this.myTimerService = new JTimerService(this);
        }
        return this.myTimerService;
    }

    @Override
    public int getMinPoolSize() {
        return this.minPoolSize;
    }

    @Override
    public int getMaxCacheSize() {
        return this.maxCacheSize;
    }

    @Override
    public int getCacheSize() {
        return this.instanceCount;
    }

    public int getTransactionAttribute() {
        return ((MessageDrivenDesc)this.dd).getTxAttribute();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void checkTransaction(RequestCtx rctx) {
        String methName = "checkTransaction: ";
        if (rctx.txAttr == 2) {
            try {
                if (this.txbeanmanaged) {
                    if (this.tm.getTransaction() == null) {
                        TraceEjb.mdb.log(BasicLevel.ERROR, (Object)(methName + "No transaction and need one"));
                        return;
                    }
                } else if (this.tm.getTransaction() == null) {
                    this.tm.begin();
                }
                rctx.mustCommit = true;
                rctx.currTx = this.tm.getTransaction();
                if (!TraceEjb.isDebugTx()) return;
                TraceEjb.tx.log(BasicLevel.DEBUG, (Object)("Transaction started: " + rctx.currTx));
                return;
            }
            catch (Exception e) {
                TraceEjb.mdb.log(BasicLevel.ERROR, (Object)(methName + "cannot start tx:"), (Throwable)e);
                return;
            }
        }
        if (rctx.txAttr != 1) {
            TraceEjb.mdb.log(BasicLevel.ERROR, (Object)(methName + "Bad transaction attribute: " + rctx.txAttr));
        }
        try {
            rctx.currTx = this.tm.getTransaction();
            if (rctx.currTx == null) return;
            if (TraceEjb.isDebugJms()) {
                TraceEjb.mdb.log(BasicLevel.DEBUG, (Object)(methName + "Suspending client tx"));
            }
            rctx.clientTx = this.tm.suspend();
            rctx.currTx = null;
            return;
        }
        catch (SystemException e) {
            TraceEjb.mdb.log(BasicLevel.ERROR, (Object)(methName + "cannot suspend transaction"), (Throwable)e);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reduceCache() {
        String methName = "reduceCache: ";
        if (TraceEjb.isDebugJms()) {
            TraceEjb.mdb.log(BasicLevel.DEBUG, (Object)methName);
        }
        int poolsz = this.minPoolSize;
        List list = this.endpool;
        synchronized (list) {
            if (TraceEjb.isDebugJms()) {
                TraceEjb.mdb.log(BasicLevel.DEBUG, (Object)(methName + "try to reduce " + this.endpool.size() + " to " + poolsz));
            }
            while (this.endpool.size() > poolsz) {
                ListIterator i = this.endpool.listIterator();
                if (!i.hasNext()) continue;
                i.next();
                i.remove();
                --this.instanceCount;
            }
        }
        if (TraceEjb.isDebugJms()) {
            TraceEjb.mdb.log(BasicLevel.DEBUG, (Object)(methName + "cacheSize= " + this.getCacheSize()));
        }
    }

    public void notifyTimeout(Timer timer) {
        if (this.stopped) {
            TraceEjb.mdb.log(BasicLevel.WARN, (Object)"Container stopped");
            return;
        }
        String methName = "notifyTimeout: ";
        if (TraceEjb.isDebugJms()) {
            TraceEjb.mdb.log(BasicLevel.DEBUG, (Object)methName);
        }
        JMessageEndpoint ep = null;
        try {
            ep = this.getNewInstance(null);
        }
        catch (Exception e) {
            TraceEjb.mdb.log(BasicLevel.ERROR, (Object)(methName + "exception:" + e));
            throw new EJBException("Cannot deliver the timeout", e);
        }
        ep.deliverTimeout(timer);
        this.releaseEndpoint(ep);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JMessageEndpoint getNewInstance(XAResource xaResource) throws Exception {
        String methName = "getNewInstance: ";
        if (TraceEjb.isDebugJms()) {
            TraceEjb.mdb.log(BasicLevel.DEBUG, (Object)(methName + "Factory: " + this + " XAResource: " + xaResource));
        }
        JMessageEndpoint ep = null;
        List list = this.endpool;
        synchronized (list) {
            if (!this.endpool.isEmpty()) {
                try {
                    ep = (JMessageEndpoint)this.endpool.remove(0);
                }
                catch (Exception ex) {
                    TraceEjb.mdb.log(BasicLevel.ERROR, (Object)(methName + "Exception:" + ex));
                    throw new EJBException("Cannot get an instance from the pool", ex);
                }
            }
            if (TraceEjb.isDebugJms()) {
                TraceEjb.mdb.log(BasicLevel.DEBUG, (Object)(methName + "pool is empty"));
            }
            if (this.maxCacheSize == 0 || this.instanceCount < this.maxCacheSize) {
                ep = this.createNewInstance();
            } else {
                while (this.endpool.isEmpty()) {
                    if (TraceEjb.isDebugJms()) {
                        TraceEjb.mdb.log(BasicLevel.DEBUG, (Object)(methName + "endpool.isEmpty() = true --> wait()"));
                    }
                    try {
                        this.endpool.wait();
                        if (!TraceEjb.isDebugJms()) continue;
                        TraceEjb.mdb.log(BasicLevel.DEBUG, (Object)(methName + "endpool notified"));
                    }
                    catch (InterruptedException e) {
                        if (!TraceEjb.isDebugJms()) continue;
                        TraceEjb.mdb.log(BasicLevel.DEBUG, (Object)(methName + "endpool waiting interrupted"), (Throwable)e);
                    }
                    catch (Exception e) {
                        throw new EJBException("synchronization pb", e);
                    }
                }
                try {
                    ep = (JMessageEndpoint)this.endpool.remove(0);
                }
                catch (Exception ex) {
                    TraceEjb.mdb.log(BasicLevel.ERROR, (Object)(methName + "Exception:" + ex));
                    throw new EJBException("Cannot get an instance from the pool", ex);
                }
            }
            if (TraceEjb.isDebugJms()) {
                TraceEjb.mdb.log(BasicLevel.DEBUG, (Object)(methName + "nb instances " + this.getCacheSize()));
            }
            ep.setXAResource(xaResource);
            ep.setReleasedState(false);
            if (TraceEjb.isDebugJms()) {
                TraceEjb.mdb.log(BasicLevel.DEBUG, (Object)(methName + "Returning " + ep));
            }
            return ep;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JMessageEndpoint createNewInstance() {
        String methName = "createNewInstance: ";
        if (TraceEjb.isDebugJms()) {
            TraceEjb.mdb.log(BasicLevel.DEBUG, (Object)methName);
        }
        JMessageEndpointProxy epProxy = null;
        MessageEndpoint ep = null;
        JMessageEndpoint jep = null;
        ClassLoader cls = this.myClassLoader();
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(cls);
        MessageDrivenBean mdb = null;
        try {
            mdb = (MessageDrivenBean)this.beanclass.newInstance();
        }
        catch (Exception e) {
            TraceEjb.mdb.log(BasicLevel.ERROR, (Object)(methName + "failed to create instance:"), (Throwable)e);
            this.resetToOldClassLoader(old);
            throw new EJBException("Container failed to create instance of Message Driven Bean", e);
        }
        jep = new JMessageEndpoint(this, mdb);
        epProxy = new JMessageEndpointProxy(this, mdb, jep);
        Class<?> msgListenerClass = null;
        try {
            msgListenerClass = cls.loadClass(this.msglistenType);
        }
        catch (ClassNotFoundException e) {
            String error = "Container failed to load class of Message Driven Bean '" + this.msglistenType + "'";
            TraceEjb.mdb.log(BasicLevel.ERROR, (Object)error, (Throwable)e);
            this.resetToOldClassLoader(old);
            throw new EJBException(error, (Exception)e);
        }
        ep = (MessageEndpoint)Proxy.newProxyInstance(cls, new Class[]{MessageEndpoint.class, msgListenerClass}, (InvocationHandler)epProxy);
        jep.setProxy(ep);
        Context ctxsave = this.setComponentContext();
        mdb.setMessageDrivenContext((MessageDrivenContext)jep);
        try {
            Method m = this.beanclass.getMethod("ejbCreate", null);
            boolean bm = m.isAccessible();
            if (!bm) {
                m.setAccessible(true);
            }
            m.invoke((Object)mdb, (Object[])null);
            m.setAccessible(bm);
        }
        catch (Exception e) {
            TraceEjb.mdb.log(BasicLevel.ERROR, (Object)(methName + " cannot call ejbCreate on message driven bean instance "), (Throwable)e);
            throw new EJBException("Container fails to call ejbCreate on message driven bean instance", e);
        }
        finally {
            this.resetToOldClassLoader(old);
            this.resetComponentContext(ctxsave);
        }
        List list = this.endpool;
        synchronized (list) {
            ++this.instanceCount;
        }
        return jep;
    }

    private void resetToOldClassLoader(ClassLoader old) {
        if (old != null) {
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    @Override
    public void storeInstances(Transaction tx) {
    }
}

