/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.ejb21;

import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import javax.transaction.Transaction;
import javax.xml.rpc.handler.MessageContext;
import org.objectweb.util.monolog.api.BasicLevel;
import org.ow2.jonas.lib.ejb21.JServiceEndpoint;
import org.ow2.jonas.lib.ejb21.JSessionContext;
import org.ow2.jonas.lib.ejb21.JSessionSwitch;
import org.ow2.jonas.lib.ejb21.JStatelessContext;
import org.ow2.jonas.lib.ejb21.JStatelessFactory;
import org.ow2.jonas.lib.ejb21.RequestCtx;
import org.ow2.jonas.lib.ejb21.TraceEjb;
import org.ow2.jonas.lib.timer.TraceTimer;

public class JStatelessSwitch
extends JSessionSwitch {
    private JServiceEndpoint se = null;
    private boolean keepalive;

    public JStatelessSwitch(JStatelessFactory bf) throws RemoteException {
        super(bf);
        if (TraceEjb.isDebugIc()) {
            TraceEjb.interp.log(BasicLevel.DEBUG, (Object)"");
        }
        if (bf.getSEHome() != null) {
            this.se = bf.getSEHome().createServiceEndpointObject();
            this.se.setSessionSwitch(this);
        }
        this.keepalive = bf.singleSwitchOn();
    }

    public synchronized void timeoutExpired(Object arg) {
        if (TraceTimer.logger.isLoggable(BasicLevel.DEBUG)) {
            TraceTimer.logger.log(BasicLevel.DEBUG, (Object)("stateless session '" + this.bf.getEJBName() + "' : timeout expired"));
        }
        this.mytimer = null;
        this.noLongerUsed();
    }

    public JServiceEndpoint getServiceEndpoint() {
        return this.se;
    }

    public MessageContext getMsgContext() {
        if (this.se == null) {
            TraceEjb.logger.log(BasicLevel.ERROR, (Object)"No ServiceEndpoint for this bean");
            return null;
        }
        return this.se.getMessageContext();
    }

    @Override
    public JSessionContext getICtx(Transaction tx) throws RemoteException {
        if (TraceEjb.isDebugIc()) {
            TraceEjb.interp.log(BasicLevel.DEBUG, (Object)"");
        }
        return (JStatelessContext)((JStatelessFactory)this.bf).getJContext(this);
    }

    @Override
    public void releaseICtx(RequestCtx req, boolean discard) {
        JStatelessContext bctx;
        if (TraceEjb.isDebugIc()) {
            TraceEjb.interp.log(BasicLevel.DEBUG, (Object)"");
        }
        if ((bctx = (JStatelessContext)req.ejbContext) == null) {
            TraceEjb.interp.log(BasicLevel.WARN, (Object)"No ejbContext");
            return;
        }
        if ((bctx.isMarkedRemoved() || discard) && !this.keepalive) {
            this.stopTimer();
            this.noLongerUsed();
        }
        ((JStatelessFactory)this.bf).releaseJContext(bctx);
    }

    @Override
    public void noLongerUsed() {
        if (TraceEjb.isDebugIc()) {
            TraceEjb.interp.log(BasicLevel.DEBUG, (Object)"");
        }
        if (this.myremote != null) {
            try {
                this.myremote.unexportObject();
            }
            catch (NoSuchObjectException e) {
                TraceEjb.logger.log(BasicLevel.ERROR, (Object)"exception", (Throwable)e);
            }
        }
        this.bf.removeEJB(this);
    }

    @Override
    public void setMustCommit(boolean mc) {
    }

    @Override
    public void enlistConnections(Transaction tx) {
    }

    @Override
    public void delistConnections(Transaction tx) {
    }

    @Override
    public void saveBeanTx() {
    }
}

