/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.persistence.eclipselink.deployment;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.eclipse.persistence.internal.jpa.deployment.ArchiveBase;
import org.eclipse.persistence.jpa.Archive;
import org.osgi.framework.BundleContext;
import org.ow2.easybeans.util.osgi.BCMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BundleArchive
extends ArchiveBase
implements Archive {
    private Enumeration<URL> urlEntries = null;
    private List<String> entries = new ArrayList<String>();

    public BundleArchive(URL url, String descriptorLocation) {
        super(url, descriptorLocation);
        BCMapper mapper = BCMapper.getInstance();
        BundleContext bc = (BundleContext)mapper.get((Object)this.getRootURL());
        this.urlEntries = bc.getBundle().findEntries("", "*", true);
        while (this.urlEntries.hasMoreElements()) {
            URL urlEntry = this.urlEntries.nextElement();
            String entryName = urlEntry.toString().substring(this.getRootURL().toString().length());
            this.entries.add(entryName);
        }
    }

    @Override
    public Iterator<String> getEntries() {
        return this.entries.iterator();
    }

    @Override
    public InputStream getEntry(String entryPath) throws IOException {
        URL subEntry = new URL(this.getRootURL(), entryPath);
        InputStream is = null;
        try {
            is = subEntry.openStream();
        }
        catch (IOException ioe) {
            // empty catch block
        }
        return is;
    }

    @Override
    public URL getEntryAsURL(String entryPath) throws IOException {
        URL subEntry = new URL(this.getRootURL(), entryPath);
        try {
            InputStream is = subEntry.openStream();
            if (is == null) {
                return null;
            }
            is.close();
        }
        catch (IOException ioe) {
            return null;
        }
        return subEntry;
    }

    @Override
    public void close() {
    }
}

