/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.persistence.eclipselink.deployment;

import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Logger;
import org.eclipse.persistence.internal.jpa.deployment.JarFileArchive;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EasyBeansJarFileArchive
extends JarFileArchive {
    private static final String WAR_SUFFIX = ".war";
    private static final String CLASS_SUFFIX = ".class";
    private static final String WEB_PREFIX = "WEB-INF/classes";
    private static final int WEb_PREFIX_AFTER_INDEX = "WEB-INF/classes".length();
    private JarFile jarFile = null;

    public EasyBeansJarFileArchive(JarFile jarFile, String descriptorLocation) throws MalformedURLException {
        this(jarFile, descriptorLocation, Logger.global);
    }

    public EasyBeansJarFileArchive(JarFile jarFile, String descriptorLocation, Logger logger) throws MalformedURLException {
        super(jarFile, descriptorLocation, logger);
        this.jarFile = jarFile;
    }

    @Override
    public Iterator<String> getEntries() {
        Enumeration<JarEntry> jarEntries = this.jarFile.entries();
        ArrayList<String> result = new ArrayList<String>();
        while (jarEntries.hasMoreElements()) {
            JarEntry jarEntry = jarEntries.nextElement();
            if (jarEntry.isDirectory()) continue;
            String entryName = jarEntry.getName();
            if (this.isWar()) {
                entryName = this.treat(entryName);
            }
            result.add(entryName);
        }
        return result.iterator();
    }

    private boolean isWar() {
        String rootPath = this.getRootURL().getPath();
        return rootPath.endsWith(WAR_SUFFIX);
    }

    private String treat(String name) {
        if (name.endsWith(CLASS_SUFFIX) && name.startsWith(WEB_PREFIX)) {
            return name.substring(WEb_PREFIX_AFTER_INDEX + 1);
        }
        return name;
    }
}

