/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.client.osgi;

import fr.dyade.aaa.common.Debug;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public class JndiHelper {
    public static final Logger logmon = Debug.getLogger((String)JndiHelper.class.getName());

    private final boolean isSet(String value) {
        return value != null && value.length() > 0;
    }

    private Context getInitialContext() throws IOException, NamingException {
        if (logmon.isLoggable(BasicLevel.DEBUG)) {
            logmon.log(BasicLevel.DEBUG, (Object)"getInitialContext() - Load jndi.properties file");
        }
        Properties props = new Properties();
        InputStream in = Class.class.getResourceAsStream("/jndi.properties");
        if (in == null) {
            if (logmon.isLoggable(BasicLevel.DEBUG)) {
                logmon.log(BasicLevel.DEBUG, (Object)"jndi.properties not found.");
            }
        } else {
            props.load(in);
        }
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        InitialContext jndiCtx = new InitialContext(props);
        return jndiCtx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rebind(String jndiName, Object obj) throws NamingException {
        if (logmon.isLoggable(BasicLevel.DEBUG)) {
            logmon.log(BasicLevel.DEBUG, (Object)("bind(" + jndiName + ", " + obj + ')'));
        }
        if (this.isSet(jndiName)) {
            Context ctx = null;
            ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                try {
                    ctx = this.getInitialContext();
                    ctx.rebind(jndiName, obj);
                }
                catch (Exception e) {
                    if (logmon.isLoggable(BasicLevel.WARN)) {
                        logmon.log(BasicLevel.WARN, (Object)("EXCEPTION:: rebind: " + jndiName), (Throwable)e);
                    }
                    throw new NamingException(e.getMessage());
                }
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldClassLoader);
                try {
                    if (ctx != null) {
                        ctx.close();
                    }
                }
                catch (Exception exc) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbind(String jndiName) {
        if (logmon.isLoggable(BasicLevel.DEBUG)) {
            logmon.log(BasicLevel.DEBUG, (Object)("unbind(" + jndiName + ')'));
        }
        if (this.isSet(jndiName)) {
            Context ctx = null;
            ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                try {
                    ctx = this.getInitialContext();
                    ctx.unbind(jndiName);
                }
                catch (Exception e) {
                    if (logmon.isLoggable(BasicLevel.WARN)) {
                        logmon.log(BasicLevel.WARN, (Object)("EXCEPTION:: unbind: " + jndiName), (Throwable)e);
                    }
                }
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldClassLoader);
                try {
                    if (ctx != null) {
                        ctx.close();
                    }
                }
                catch (Exception exc) {}
            }
        }
    }

    public Object lookup(String jndiName) throws NamingException {
        if (logmon.isLoggable(BasicLevel.DEBUG)) {
            logmon.log(BasicLevel.DEBUG, (Object)("lookup(" + jndiName + ')'));
        }
        Context ctx = null;
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            ctx = this.getInitialContext();
            Object object = ctx.lookup(jndiName);
            return object;
        }
        catch (IOException e) {
            if (logmon.isLoggable(BasicLevel.WARN)) {
                logmon.log(BasicLevel.WARN, (Object)("EXCEPTION:: lookup: " + jndiName), (Throwable)e);
            }
            throw new NamingException(e.getMessage());
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
            try {
                if (ctx != null) {
                    ctx.close();
                }
            }
            catch (Exception exc) {}
        }
    }
}

