/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.container.info;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.ejb.TransactionManagementType;
import org.ow2.easybeans.api.bean.info.IApplicationExceptionInfo;
import org.ow2.easybeans.api.bean.info.IBeanInfo;
import org.ow2.easybeans.api.bean.info.IMethodInfo;
import org.ow2.easybeans.api.bean.info.ISecurityInfo;
import org.ow2.easybeans.api.bean.info.ITimerInfo;
import org.ow2.easybeans.api.bean.info.IWebServiceInfo;
import org.ow2.easybeans.container.info.ApplicationExceptionInfo;
import org.ow2.util.ee.metadata.common.api.struct.IJAnnotationSqlDataSourceDefinition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanInfo
implements IBeanInfo {
    private String name;
    private ISecurityInfo securityInfo = null;
    private TransactionManagementType transactionManagementType = TransactionManagementType.CONTAINER;
    private Map<String, IApplicationExceptionInfo> applicationExceptions = null;
    private Object cluster;
    private List<String> localInterfaces = null;
    private List<String> remoteInterfaces = null;
    private String noInterfaceViewInterface = null;
    private IWebServiceInfo webserviceInfo;
    private List<IMethodInfo> businessMethodsInfo = null;
    private List<IMethodInfo> sessionSynchronizationMethodsInfo = null;
    private List<ITimerInfo> timersInfo = null;
    private List<String> dependsOn = null;
    private boolean startup = false;
    private List<IJAnnotationSqlDataSourceDefinition> dataSourceDefinitions = new ArrayList<IJAnnotationSqlDataSourceDefinition>();

    public BeanInfo() {
        this.localInterfaces = new ArrayList<String>();
        this.remoteInterfaces = new ArrayList<String>();
        this.businessMethodsInfo = new ArrayList<IMethodInfo>();
        this.sessionSynchronizationMethodsInfo = new ArrayList<IMethodInfo>();
        this.dependsOn = new ArrayList<String>();
    }

    public Map<String, IApplicationExceptionInfo> getApplicationExceptions() {
        return this.applicationExceptions;
    }

    public void setApplicationExceptions(Map<String, IApplicationExceptionInfo> applicationExceptions) {
        this.applicationExceptions = applicationExceptions;
    }

    public TransactionManagementType getTransactionManagementType() {
        return this.transactionManagementType;
    }

    public void setTransactionManagementType(TransactionManagementType transactionManagementType) {
        this.transactionManagementType = transactionManagementType;
    }

    public void setSecurityInfo(ISecurityInfo securityInfo) {
        this.securityInfo = securityInfo;
    }

    public ISecurityInfo getSecurityInfo() {
        return this.securityInfo;
    }

    public List<IMethodInfo> getBusinessMethodsInfo() {
        return this.businessMethodsInfo;
    }

    public void setBusinessMethodsInfo(List<IMethodInfo> businessMethodsInfo) {
        this.businessMethodsInfo = businessMethodsInfo;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Object getCluster() {
        return this.cluster;
    }

    public void setCluster(Object cluster) {
        this.cluster = cluster;
    }

    public List<String> getLocalInterfaces() {
        return this.localInterfaces;
    }

    public void setLocalInterfaces(List<String> localInterfaces) {
        this.localInterfaces = this.fix(localInterfaces);
    }

    public List<String> getRemoteInterfaces() {
        return this.remoteInterfaces;
    }

    public void setRemoteInterfaces(List<String> remoteInterfaces) {
        this.remoteInterfaces = this.fix(remoteInterfaces);
    }

    public String getNoInterfaceViewInterface() {
        return this.noInterfaceViewInterface;
    }

    public void setNoInterfaceViewInterface(String noInterfaceViewInterface) {
        this.noInterfaceViewInterface = this.fix(noInterfaceViewInterface);
    }

    public IWebServiceInfo getWebServiceInfo() {
        return this.webserviceInfo;
    }

    public void setWebServiceInfo(IWebServiceInfo info) {
        this.webserviceInfo = info;
    }

    protected List<String> fix(List<String> list) {
        if (list == null) {
            return null;
        }
        ArrayList<String> newList = new ArrayList<String>();
        for (String item : list) {
            newList.add(this.fix(item));
        }
        return newList;
    }

    protected String fix(String name) {
        if (name == null) {
            return null;
        }
        return name.replace('/', '.');
    }

    public IApplicationExceptionInfo getDefaultCheckedException() {
        return new ApplicationExceptionInfo(false, true);
    }

    public IApplicationExceptionInfo getApplicationException(Throwable throwable) {
        IApplicationExceptionInfo appException = this.applicationExceptions.get(throwable.getClass().getName());
        if (appException != null) {
            return appException;
        }
        List<String> superClasses = this.getSuperClass(throwable.getClass());
        for (int i = 0; appException == null && i < superClasses.size(); ++i) {
            String superClass = superClasses.get(i);
            appException = this.applicationExceptions.get(superClass);
            if (appException == null || appException.inherited()) continue;
            return null;
        }
        return appException;
    }

    protected List<String> getSuperClass(Class<?> clazz) {
        Class<?> superClass = clazz.getSuperclass();
        ArrayList<String> list = new ArrayList<String>();
        if (Throwable.class.equals(superClass) || Object.class.equals(superClass)) {
            return list;
        }
        list.add(superClass.getName());
        list.addAll(this.getSuperClass(superClass));
        return list;
    }

    public void setDependsOn(List<String> dependsOn) {
        this.dependsOn = dependsOn;
    }

    public List<String> getDependsOn() {
        return this.dependsOn;
    }

    public boolean isStartup() {
        return this.startup;
    }

    public void setStartup(boolean startup) {
        this.startup = startup;
    }

    public List<IJAnnotationSqlDataSourceDefinition> getDataSourceDefinitions() {
        return this.dataSourceDefinitions;
    }

    public List<IMethodInfo> getSessionSynchronizationMethodsInfo() {
        return this.sessionSynchronizationMethodsInfo;
    }

    public void setSessionSynchronizationMethodsInfo(List<IMethodInfo> sessionSynchronizationMethodsInfo) {
        this.sessionSynchronizationMethodsInfo = sessionSynchronizationMethodsInfo;
    }

    public List<ITimerInfo> getTimersInfo() {
        return this.timersInfo;
    }

    public void setTimersInfo(List<ITimerInfo> timersInfo) {
        this.timersInfo = timersInfo;
    }
}

