/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.jmx;

import java.net.URL;
import javax.management.ObjectName;
import org.apache.commons.modeler.Registry;
import org.ow2.easybeans.jmx.CommonsModelerException;
import org.ow2.easybeans.jmx.CommonsModelerExtension;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public final class CommonsModelerHelper {
    private static Registry registry = null;
    private static Log logger = LogFactory.getLog(CommonsModelerHelper.class);

    private CommonsModelerHelper() {
    }

    public static synchronized void initRegistry() throws CommonsModelerException {
        if (registry == null) {
            registry = Registry.getRegistry(null, null);
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            try {
                registry.loadDescriptors("org.ow2.easybeans.component.statistic.management", classLoader);
                registry.loadDescriptors("org.ow2.easybeans.deployer.management", classLoader);
                registry.loadDescriptors("org.ow2.easybeans.jsr77", classLoader);
                CommonsModelerHelper.extendsManagedBeansDescription("org.ow2.easybeans.container.management", classLoader);
                CommonsModelerHelper.extendsManagedBeansDescription("org.ow2.easybeans.container.session.stateful.management", classLoader);
                CommonsModelerHelper.extendsManagedBeansDescription("org.ow2.easybeans.container.session.stateless.management", classLoader);
                CommonsModelerHelper.extendsManagedBeansDescription("org.ow2.easybeans.server.management", classLoader);
            }
            catch (Exception e) {
                throw new CommonsModelerException("Cannot load descriptors of commons modeler", e);
            }
            if (logger.isDebugEnabled()) {
                String[] managedBeans = registry.findManagedBeans();
                logger.debug((Object)"List of all MBeans descriptors", new Object[0]);
                for (String managedBean : managedBeans) {
                    logger.debug((Object)"Found managedBean {0}.", new Object[]{managedBean});
                }
                logger.debug((Object)"End of list of all MBeans descriptors", new Object[0]);
            }
        }
    }

    private static void extendsManagedBeansDescription(String packageLoc, ClassLoader classLoader) throws Exception {
        String resource = packageLoc.replace('.', '/');
        URL url = classLoader.getResource(resource + "/mbeans-descriptors-ext.xml");
        CommonsModelerExtension.updateDescriptors(registry, url.openStream());
    }

    public static Registry getRegistry() throws CommonsModelerException {
        CommonsModelerHelper.initRegistry();
        return registry;
    }

    public static void registerModelerMBean(Object bean, String objectName) throws CommonsModelerException {
        CommonsModelerHelper.initRegistry();
        try {
            registry.registerComponent(bean, objectName, null);
        }
        catch (Exception e) {
            throw new CommonsModelerException("Cannot register MBean with name '" + objectName + "'.", e);
        }
    }

    public static void unregisterModelerMBean(ObjectName on) {
        if (registry != null) {
            registry.unregisterComponent(on);
        }
    }
}

