/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.proxy.client;

import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.rmi.Remote;
import java.util.HashMap;
import java.util.Map;
import javax.ejb.EJBException;
import org.ow2.easybeans.rpc.api.RPCException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbsInvocationHandler
implements InvocationHandler,
Serializable {
    private static final long serialVersionUID = -8177576962615463120L;
    private boolean removed = false;
    private String containerId = null;
    private String factoryName = null;
    private Long beanId = null;
    private transient Map<Method, Long> hashedMethods = null;
    private String interfaceClassName = null;
    private boolean isItfExtendingRmiRemote = false;
    private boolean useID = false;
    private boolean businessObjectMode = false;

    public AbsInvocationHandler(String containerId, String factoryName, boolean useID) {
        this.containerId = containerId;
        this.factoryName = factoryName;
        this.useID = useID;
        this.hashedMethods = new HashMap<Method, Long>();
    }

    protected Object handleObjectMethods(Object proxy, Method method, Object[] args) {
        String methodName = method.getName();
        if (methodName.equals("equals")) {
            if (args != null && args.length > 0) {
                if (args[0] == null) {
                    return Boolean.FALSE;
                }
                String localValue = proxy.toString();
                String otherValue = args[0].toString();
                return localValue.equals(otherValue);
            }
            return Boolean.FALSE;
        }
        if (methodName.equals("toString")) {
            return this.toString();
        }
        if (methodName.equals("hashCode")) {
            return this.toString().hashCode();
        }
        throw new IllegalStateException("Method '" + methodName + "' is not present on Object.class.");
    }

    protected void handleThrowable(Throwable originalThrowable, boolean isApplicationException, Method method, RPCException rpcException) throws Exception {
        Class<?>[] exceptions = method.getExceptionTypes();
        if (exceptions != null) {
            for (Class<?> clazz : exceptions) {
                if (!clazz.isInstance(originalThrowable) || !(originalThrowable instanceof Exception) || originalThrowable instanceof RuntimeException) continue;
                throw (Exception)originalThrowable;
            }
        }
        if (originalThrowable instanceof EJBException) {
            throw (EJBException)originalThrowable;
        }
        if (originalThrowable instanceof RuntimeException) {
            if (isApplicationException) {
                throw (RuntimeException)originalThrowable;
            }
            throw new EJBException((Exception)((RuntimeException)originalThrowable));
        }
        if (originalThrowable instanceof Exception) {
            throw new EJBException((Exception)originalThrowable);
        }
        if (rpcException != null) {
            throw new EJBException((Exception)rpcException);
        }
        throw new EJBException(new Exception("Unexpected Exception", originalThrowable));
    }

    public void setBeanId(Long beanId) {
        this.beanId = beanId;
    }

    protected void setHashedMethods(Map<Method, Long> hashedMethods) {
        this.hashedMethods = hashedMethods;
    }

    public Long getBeanId() {
        return this.beanId;
    }

    protected String getContainerId() {
        return this.containerId;
    }

    public String getFactoryName() {
        return this.factoryName;
    }

    protected Map<Method, Long> getHashedMethods() {
        return this.hashedMethods;
    }

    protected void setContainerId(String containerId) {
        this.containerId = containerId;
    }

    protected void setFactoryName(String factoryName) {
        this.factoryName = factoryName;
    }

    public String getInterfaceClassName() {
        return this.interfaceClassName;
    }

    protected void setInterfaceClassName(String interfaceClassName) {
        this.interfaceClassName = interfaceClassName;
    }

    public void setInterfaceClass(Class<?> clz) {
        if (Remote.class.isAssignableFrom(clz)) {
            this.isItfExtendingRmiRemote = true;
        }
        this.setInterfaceClassName(clz.getName());
    }

    public void setExtendingRmiRemote(boolean isItfExtendingRmiRemote) {
        this.isItfExtendingRmiRemote = isItfExtendingRmiRemote;
    }

    public boolean isExtendingRmiRemote() {
        return this.isItfExtendingRmiRemote;
    }

    public void setUseID(boolean useID) {
        this.useID = useID;
    }

    public boolean isUsingID() {
        return this.useID;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.factoryName);
        sb.append("_");
        sb.append(this.interfaceClassName);
        sb.append("/");
        sb.append(this.containerId);
        if (this.useID) {
            sb.append("@");
            if (this.beanId != null) {
                sb.append(this.beanId);
            } else {
                sb.append(System.identityHashCode(this));
            }
        }
        return sb.toString();
    }

    public boolean isRemoved() {
        return this.removed;
    }

    public void setRemoved(boolean removed) {
        this.removed = removed;
    }

    public void setBusinessObjectMode(boolean businessObjectMode) {
        this.businessObjectMode = businessObjectMode;
    }

    public boolean isBusinessObjectMode() {
        return this.businessObjectMode;
    }
}

