/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.ws.jaxws.base;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.ow2.jonas.ws.jaxws.IWebServiceEndpoint;
import org.ow2.jonas.ws.jaxws.IWebservicesContainer;
import org.ow2.jonas.ws.jaxws.PortIdentifier;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public abstract class JAXWSWebservicesContainer<T extends IWebServiceEndpoint>
implements IWebservicesContainer<T> {
    private static final Log logger = LogFactory.getLog(JAXWSWebservicesContainer.class);
    private String name;
    private Map<PortIdentifier, T> endpoints;
    private String wsdlPublicationDirectory;

    public JAXWSWebservicesContainer(String name) {
        this.name = name;
        this.endpoints = new HashMap<PortIdentifier, T>();
    }

    public void addEndpoint(T endpoint) {
        this.endpoints.put(endpoint.getIdentifier(), endpoint);
    }

    public void removeEndpoint(T endpoint) {
        this.endpoints.remove(endpoint.getIdentifier());
    }

    public String findUpdatedURL(PortIdentifier identifier) {
        IWebServiceEndpoint matching = (IWebServiceEndpoint)this.endpoints.get(identifier);
        if (matching != null) {
            return matching.getPortMetaData().getEndpointURL();
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public Collection<T> getEndpoints() {
        return this.endpoints.values();
    }

    public void start() {
        logger.debug((Object)"Start WebservicesContainer[{0}]", new Object[]{this.name});
        for (IWebServiceEndpoint endpoint : this.endpoints.values()) {
            endpoint.start();
        }
    }

    public void stop() {
        logger.debug((Object)"Stop WebservicesContainer[{0}]", new Object[]{this.name});
        for (IWebServiceEndpoint endpoint : this.endpoints.values()) {
            endpoint.stop();
        }
    }

    public void setWsdlPublicationDirectory(String wsdlPublicationDirectory) {
        this.wsdlPublicationDirectory = wsdlPublicationDirectory;
    }

    public String getWsdlPublicationDirectory() {
        return this.wsdlPublicationDirectory;
    }
}

