/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.pool.impl.enhanced;

import java.util.concurrent.Executor;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.pool.api.IPoolConfiguration;
import org.ow2.util.pool.api.IPoolState;
import org.ow2.util.pool.impl.enhanced.PoolConfiguration;
import org.ow2.util.pool.impl.enhanced.ResizerType;
import org.ow2.util.pool.impl.enhanced.api.IPool;
import org.ow2.util.pool.impl.enhanced.api.IWaitControl;
import org.ow2.util.pool.impl.enhanced.api.NotABusyPoolItemException;
import org.ow2.util.pool.impl.enhanced.api.PoolException;
import org.ow2.util.pool.impl.enhanced.api.TimeoutPoolException;
import org.ow2.util.pool.impl.enhanced.api.basic.IBasicPool;
import org.ow2.util.pool.impl.enhanced.api.basic.PoolFactoryBroken;
import org.ow2.util.pool.impl.enhanced.api.keepbusy.ShareMethod;
import org.ow2.util.pool.impl.enhanced.callback.CreateCB;
import org.ow2.util.pool.impl.enhanced.callback.RemoveCB;
import org.ow2.util.pool.impl.enhanced.impl.basic.BasicPool;
import org.ow2.util.pool.impl.enhanced.impl.basic.BasicPoolState;
import org.ow2.util.pool.impl.enhanced.impl.basic.accessmanager.LastUsedAccessManager;
import org.ow2.util.pool.impl.enhanced.impl.keepbusy.KeepBusyPool;
import org.ow2.util.pool.impl.enhanced.impl.limited.LimitedWaiterPool;
import org.ow2.util.pool.impl.enhanced.impl.limited.TooManyWaiterException;
import org.ow2.util.pool.impl.enhanced.impl.listener.resizer.StatsResizerPool;
import org.ow2.util.pool.impl.enhanced.impl.listener.statistics.BasicPoolStats;
import org.ow2.util.pool.impl.enhanced.impl.listener.statistics.BasicPoolStatsFillerPoolListener;
import org.ow2.util.pool.impl.enhanced.impl.util.ExecutorProvider;
import org.ow2.util.pool.impl.enhanced.impl.validator.ValidatorPool;
import org.ow2.util.pool.impl.enhanced.impl.waitcontrol.ExpireWaitControl;
import org.ow2.util.pool.impl.enhanced.impl.waitcontrol.InfiniteWaitControl;
import org.ow2.util.pool.impl.enhanced.impl.waitcontrol.WaitAuthorization;
import org.ow2.util.pool.impl.enhanced.internal.resizer.api.IResizer;
import org.ow2.util.pool.impl.enhanced.internal.resizer.api.shared.ISharedManager;
import org.ow2.util.pool.impl.enhanced.internal.resizer.impl.AsynchronousResizer;
import org.ow2.util.pool.impl.enhanced.internal.resizer.impl.shared.SharedResizer;
import org.ow2.util.pool.impl.enhanced.internal.resizer.impl.stocker.MinMaxExpectedSpareStockerResizer;
import org.ow2.util.pool.impl.enhanced.manager.IPoolManager;
import org.ow2.util.pool.impl.enhanced.manager.optional.IPoolItemRemoveManager;
import org.ow2.util.pool.impl.enhanced.manager.optional.IValidatorPoolManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnhancedPool<E> {
    private static final Log LOG = LogFactory.getLog(EnhancedPool.class);
    private IBasicPool<E> basicPool;
    private IPool<E> lastPool;
    private LimitedWaiterPool<E> limitedWaiterPool;
    private StatsResizerPool<E, BasicPoolStats> statsResizerPool;
    private KeepBusyPool<E> keepBusyPool;
    private MinMaxExpectedSpareStockerResizer<BasicPoolStats> minMaxExpectedSparePoolResizer;
    private long timeout;
    private int maxWaiter = -1;
    private boolean started = true;
    private Object mutex = new Object();
    private RemoveCB<E> removeCB;
    private CreateCB<E> createCB;
    private volatile WaitAuthorization waitAuthorization = new WaitAuthorization();
    private Object sleepMutex = new Object();

    public EnhancedPool(IPoolManager<E> poolManager) {
        this(poolManager, ResizerType.SIMPLE, null, ExecutorProvider.NEW_THREAD_EXECUTOR);
    }

    public EnhancedPool(IPoolManager<E> poolManager, ResizerType resizerType, ISharedManager sharedManager, Executor createAndRemoveItemExecutor) {
        this.createCB = new CreateCB<E>(poolManager);
        if (IPoolItemRemoveManager.class.isInstance(poolManager)) {
            this.removeCB = new RemoveCB((IPoolItemRemoveManager)poolManager);
        }
        IBasicPool<E> pool = this.basicPool = new BasicPool<E>(this.createCB, 0, new LastUsedAccessManager(), createAndRemoveItemExecutor, this.removeCB, createAndRemoveItemExecutor);
        IResizer<BasicPoolStats> resizer = this.minMaxExpectedSparePoolResizer = new MinMaxExpectedSpareStockerResizer(0, 0, 15, true);
        switch (resizerType) {
            case ASYNCHRONOUS: {
                resizer = new AsynchronousResizer<BasicPoolStats>(this.minMaxExpectedSparePoolResizer);
                break;
            }
            default: {
                resizer = new SharedResizer<BasicPoolStats>(sharedManager, this.minMaxExpectedSparePoolResizer);
            }
            case SIMPLE: 
        }
        resizer.setResizable(pool);
        IPool<E> currentPool = pool;
        if (IValidatorPoolManager.class.isInstance(poolManager)) {
            IValidatorPoolManager validatorCluePoolManager = (IValidatorPoolManager)poolManager;
            ValidatorPool<E> validatorPool = new ValidatorPool<E>(currentPool, validatorCluePoolManager, false);
            currentPool = validatorPool;
        }
        this.statsResizerPool = new StatsResizerPool<E, BasicPoolStats>(currentPool, new BasicPoolStatsFillerPoolListener(), new BasicPoolStats(), resizer);
        currentPool = this.statsResizerPool;
        KeepBusyPool<E> keepBusyPool = new KeepBusyPool<E>(currentPool);
        currentPool = keepBusyPool;
        LimitedWaiterPool<E> limitedWaiterPool = new LimitedWaiterPool<E>(currentPool);
        currentPool = limitedWaiterPool;
        this.limitedWaiterPool = limitedWaiterPool;
        this.keepBusyPool = keepBusyPool;
        this.lastPool = currentPool;
        keepBusyPool.setShareMethod(ShareMethod.NEVER_SHARE);
        PoolConfiguration poolConfiguration = new PoolConfiguration();
        int maxPool = poolConfiguration.getMax();
        this.timeout = poolConfiguration.getTimeout();
        this.maxWaiter = poolConfiguration.getMaxWaiters();
        limitedWaiterPool.setMaxWaiter(this.maxWaiter);
        this.minMaxExpectedSparePoolResizer.setMaxPool(maxPool);
        this.statsResizerPool.prepareUpdate();
    }

    protected IWaitControl createWaitControl() {
        if (this.timeout < 0L) {
            throw new IllegalStateException();
        }
        if (this.timeout == 0L) {
            return new InfiniteWaitControl();
        }
        return new ExpireWaitControl(System.currentTimeMillis() + this.timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public E get() throws org.ow2.util.pool.api.PoolException {
        while (true) {
            try {
                LOG.debug((Object)"START GET {1} try to get with timeout {0}", new Object[]{this.timeout});
                E e = this.lastPool.get(this.createWaitControl());
                LOG.debug((Object)"OK FOR GET {1} try to get with timeout {0}", new Object[]{this.timeout});
                return e;
            }
            catch (TimeoutPoolException e) {
                throw new org.ow2.util.pool.api.PoolException("No more instances available", e);
            }
            catch (TooManyWaiterException e) {
                throw new org.ow2.util.pool.api.PoolException("No more instances available", e);
            }
            catch (PoolFactoryBroken e) {
                Long deadLine = e.getExpireBrokenDeadline();
                if (deadLine == null) {
                    throw new org.ow2.util.pool.api.PoolException("Factory broken", e);
                }
                Object object = this.sleepMutex;
                synchronized (object) {
                    long timeToWait = deadLine - System.currentTimeMillis();
                    while (timeToWait > 0L) {
                        try {
                            this.sleepMutex.wait(timeToWait);
                        }
                        catch (InterruptedException e1) {
                            throw new org.ow2.util.pool.api.PoolException("Interrupted exception", e);
                        }
                        timeToWait = deadLine - System.currentTimeMillis();
                    }
                }
                continue;
            }
            catch (PoolException e) {
                throw new org.ow2.util.pool.api.PoolException("Unknow exception", e);
            }
            break;
        }
        catch (InterruptedException e) {
            throw new org.ow2.util.pool.api.PoolException("Interrupted exception", e);
        }
    }

    public void discard(E instance) throws org.ow2.util.pool.api.PoolException {
        LOG.debug((Object)"discard {0} ", new Object[]{instance});
        try {
            this.lastPool.remove(instance);
            this.basicPool.waitAllRemoveListenerCompleted();
        }
        catch (PoolException e) {
            throw new org.ow2.util.pool.api.PoolException("Unknow exception", e);
        }
        catch (InterruptedException e) {
            throw new org.ow2.util.pool.api.PoolException("Interrupted exception", e);
        }
    }

    public void release(E instance) throws org.ow2.util.pool.api.PoolException {
        LOG.debug((Object)"release {0} ", new Object[]{instance});
        try {
            this.lastPool.put(instance);
        }
        catch (NotABusyPoolItemException e) {
            LOG.debug((Object)"try to release a removed instance, ignore this request", new Object[0]);
        }
        catch (PoolException e) {
            throw new org.ow2.util.pool.api.PoolException("Unknow exception", e);
        }
    }

    public void updatePoolSize() {
        this.statsResizerPool.update();
    }

    public void setPoolConfiguration(IPoolConfiguration poolConfiguration) {
        int maxPool = poolConfiguration.getMax();
        this.timeout = poolConfiguration.getTimeout();
        this.maxWaiter = poolConfiguration.getMaxWaiters();
        this.limitedWaiterPool.setMaxWaiter(this.maxWaiter);
        this.minMaxExpectedSparePoolResizer.setExpectedSparePool(poolConfiguration.getSpare());
        this.minMaxExpectedSparePoolResizer.setMinPool(poolConfiguration.getMin());
        this.minMaxExpectedSparePoolResizer.setMaxPool(maxPool);
        this.statsResizerPool.prepareUpdate();
        LOG.debug((Object)"{3} new conf Setted (timeout : {0}, maxwaiter: {1}, max: {2})", new Object[]{this.timeout, this.maxWaiter, maxPool, this});
    }

    public void setAllowSharedInstance(boolean allowSharedInstance) {
        if (allowSharedInstance) {
            this.keepBusyPool.setShareMethod(ShareMethod.SHARE_AS_LAST_SOLUTION);
        } else {
            this.keepBusyPool.setShareMethod(ShareMethod.NEVER_SHARE);
        }
    }

    public boolean isAllowSharedInstance() {
        return this.keepBusyPool.getShareMethod() != ShareMethod.NEVER_SHARE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws org.ow2.util.pool.api.PoolException {
        Object object = this.mutex;
        synchronized (object) {
            if (this.started) {
                throw new org.ow2.util.pool.api.PoolException("Pool already started");
            }
            this.limitedWaiterPool.setMaxWaiter(this.maxWaiter);
            this.basicPool.unlockSizeToZero();
            this.started = true;
        }
    }

    public void forceStop() throws InterruptedException {
        this.createCB.forceStop(null);
        this.removeCB.forceStop(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws org.ow2.util.pool.api.PoolException {
        Object object = this.mutex;
        synchronized (object) {
            if (!this.started) {
                throw new org.ow2.util.pool.api.PoolException("Pool already stopped");
            }
            this.basicPool.lockSizeToZero();
            this.limitedWaiterPool.setMaxWaiter(0);
            this.waitAuthorization.forbidWait();
            this.lastPool.signalAllWaiters();
            this.waitAuthorization = new WaitAuthorization();
            try {
                this.limitedWaiterPool.waitEmptyWaiterInPool();
            }
            catch (InterruptedException e) {
                this.basicPool.unlockSizeToZero();
                this.limitedWaiterPool.setMaxWaiter(this.maxWaiter);
                throw new org.ow2.util.pool.api.PoolException("Interrupted exception", e);
            }
            this.keepBusyPool.removeAll();
            try {
                this.basicPool.clearPool();
                this.basicPool.waitAllRemoveListenerCompleted();
            }
            catch (InterruptedException e) {
                this.basicPool.unlockSizeToZero();
                this.limitedWaiterPool.setMaxWaiter(this.maxWaiter);
                throw new org.ow2.util.pool.api.PoolException("Interrupted exception", e);
            }
            this.started = false;
        }
    }

    public IPoolState getState() {
        BasicPoolState state = new BasicPoolState();
        this.basicPool.fillState(state);
        return state;
    }

    public IPoolConfiguration getPoolConfiguration() {
        PoolConfiguration poolConfiguration = new PoolConfiguration();
        poolConfiguration.setMin(this.minMaxExpectedSparePoolResizer.getMinPool());
        poolConfiguration.setMax(this.minMaxExpectedSparePoolResizer.getMaxPool());
        poolConfiguration.setSpare(this.minMaxExpectedSparePoolResizer.getExpectedSparePool());
        poolConfiguration.setMaxWaiters(this.limitedWaiterPool.getMaxWaiter());
        return poolConfiguration;
    }
}

