/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.shelbie.commands.config.internal;

import java.util.Dictionary;
import java.util.List;
import java.util.Set;
import org.apache.felix.gogo.commands.Action;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.apache.felix.ipojo.annotations.Component;
import org.apache.felix.ipojo.annotations.HandlerDeclaration;
import org.apache.felix.ipojo.annotations.Requires;
import org.apache.felix.service.command.CommandSession;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;

@Command(name="set", scope="config", description="Update a given Configuration with given properties")
@Component
@HandlerDeclaration(value="<sh:command xmlns:sh='org.ow2.shelbie'/>")
public class PropertySetAction
implements Action,
Pojo {
    private InstanceManager __IM;
    private boolean __Fpid;
    @Argument(name="pid", required=true, index=0, description="Service PID of the Configuration to update.")
    private String pid;
    private boolean __Fproperties;
    @Argument(name="properties", index=1, multiValued=true, description="Properties that will be placed (and override if existing) in the updated Configuration.")
    private List<String> properties;
    private boolean __Fca;
    @Requires
    private ConfigurationAdmin ca;
    private boolean __Mexecute$org_apache_felix_service_command_CommandSession;
    private boolean __MgetProperties$org_osgi_service_cm_Configuration;

    String __getpid() {
        if (!this.__Fpid) {
            return this.pid;
        }
        return (String)this.__IM.onGet((Object)this, "pid");
    }

    void __setpid(String string) {
        if (!this.__Fpid) {
            this.pid = string;
            return;
        }
        this.__IM.onSet((Object)this, "pid", (Object)string);
    }

    List __getproperties() {
        if (!this.__Fproperties) {
            return this.properties;
        }
        return (List)this.__IM.onGet((Object)this, "properties");
    }

    void __setproperties(List list) {
        if (!this.__Fproperties) {
            this.properties = list;
            return;
        }
        this.__IM.onSet((Object)this, "properties", (Object)list);
    }

    ConfigurationAdmin __getca() {
        if (!this.__Fca) {
            return this.ca;
        }
        return (ConfigurationAdmin)this.__IM.onGet((Object)this, "ca");
    }

    void __setca(ConfigurationAdmin configurationAdmin) {
        if (!this.__Fca) {
            this.ca = configurationAdmin;
            return;
        }
        this.__IM.onSet((Object)this, "ca", (Object)configurationAdmin);
    }

    public PropertySetAction() {
        this(null);
    }

    private PropertySetAction(InstanceManager _manager) {
        this._setInstanceManager(_manager);
    }

    public Object execute(CommandSession commandSession) throws Exception {
        Object object;
        if (!this.__Mexecute$org_apache_felix_service_command_CommandSession) {
            return this.__M_execute(commandSession);
        }
        try {
            this.__IM.onEntry((Object)this, "execute$org_apache_felix_service_command_CommandSession", new Object[]{commandSession});
            object = this.__M_execute(commandSession);
            this.__IM.onExit((Object)this, "execute$org_apache_felix_service_command_CommandSession", object);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "execute$org_apache_felix_service_command_CommandSession", throwable);
            throw throwable;
        }
        return object;
    }

    private Object __M_execute(CommandSession session) throws Exception {
        Dictionary p;
        Configuration config = this.__getca().getConfiguration(this.__getpid(), null);
        if (config != null && (p = this.getProperties(config)) != null) {
            config.update(p);
        }
        return null;
    }

    private Dictionary getProperties(Configuration configuration) {
        Dictionary dictionary;
        if (!this.__MgetProperties$org_osgi_service_cm_Configuration) {
            return this.__M_getProperties(configuration);
        }
        try {
            this.__IM.onEntry((Object)this, "getProperties$org_osgi_service_cm_Configuration", new Object[]{configuration});
            dictionary = this.__M_getProperties(configuration);
            this.__IM.onExit((Object)this, "getProperties$org_osgi_service_cm_Configuration", (Object)dictionary);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getProperties$org_osgi_service_cm_Configuration", throwable);
            throw throwable;
        }
        return dictionary;
    }

    private Dictionary __M_getProperties(Configuration config) {
        Dictionary p = null;
        boolean changed = false;
        if (this.__getproperties() != null) {
            p = config.getProperties();
            for (String property : this.__getproperties()) {
                String[] sections = property.split("=");
                if (sections.length == 2) {
                    Object old = p.get(sections[0]);
                    if (sections[1].equals(old)) continue;
                    p.put(sections[0], sections[1]);
                    changed = true;
                    continue;
                }
                return null;
            }
            if (!changed) {
                p = null;
            }
        }
        return p;
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("ca")) {
                this.__Fca = true;
            }
            if (set.contains("pid")) {
                this.__Fpid = true;
            }
            if (set.contains("properties")) {
                this.__Fproperties = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("execute$org_apache_felix_service_command_CommandSession")) {
                this.__Mexecute$org_apache_felix_service_command_CommandSession = true;
            }
            if (set.contains("getProperties$org_osgi_service_cm_Configuration")) {
                this.__MgetProperties$org_osgi_service_cm_Configuration = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

