/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.auditreport.impl.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.ow2.util.auditreport.api.IDisplayableType;
import org.ow2.util.auditreport.api.IEncodableType;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ObjectEncoder {
    private static Map<String, FieldInfos> classInfos = new HashMap<String, FieldInfos>();
    private static final String GET_PREFIX = "get";
    private static final String SET_PREFIX = "set";
    private static final String SEPARATOR_1 = ";,";
    private static final String SEPARATOR_2 = ";#:";
    private static final String DATA_LINK = ";#:";
    private static final String EQUALS = "=";
    private static final String NULL = ";#[#:";
    private static final String NULL_TEXT = "null";
    private static Log logger = LogFactory.getLog(ObjectEncoder.class);

    private ObjectEncoder() {
    }

    private static FieldInfos loadClass(Class<?> objectClass) {
        FieldInfos fieldInfos = classInfos.get(objectClass.getName());
        if (fieldInfos == null) {
            fieldInfos = new FieldInfos();
            String fieldName = null;
            if (!ObjectEncoder.haveDefaultConstructor(objectClass)) {
                logger.error((Object)("Error while loading class : " + objectClass.getName()), new Object[0]);
                logger.error((Object)"    No default constructor found.", new Object[0]);
                return null;
            }
            for (Field field : objectClass.getDeclaredFields()) {
                try {
                    FieldInfo fieldInfo;
                    fieldName = field.getName();
                    Class fieldType = field.getType();
                    Method getMethod = objectClass.getMethod(ObjectEncoder.getFieldMethodName(fieldName, GET_PREFIX), new Class[0]);
                    Method setMethod = objectClass.getMethod(ObjectEncoder.getFieldMethodName(fieldName, SET_PREFIX), fieldType);
                    if (fieldType.isArray()) continue;
                    if (fieldType.isPrimitive()) {
                        fieldType = ObjectEncoder.checkType(fieldType);
                        fieldInfo = new FieldInfo(fieldName, fieldType, null, getMethod, setMethod);
                        fieldInfos.put(fieldName, fieldInfo);
                        continue;
                    }
                    if (!ObjectEncoder.haveStringConstructor(fieldType)) continue;
                    fieldInfo = new FieldInfo(fieldName, fieldType, null, getMethod, setMethod);
                    fieldInfos.put(fieldName, fieldInfo);
                }
                catch (NoSuchMethodException ex) {
                    logger.debug((Object)("Field " + fieldName + " will not be parsed."), new Object[0]);
                }
                catch (Exception ex) {
                    logger.error((Object)("Error while analyzing the class: " + objectClass.getName() + "."), new Object[0]);
                    ex.printStackTrace();
                }
            }
            for (Class<?> currentClass = objectClass.getSuperclass(); currentClass != null; currentClass = currentClass.getSuperclass()) {
                FieldInfos currentFieldInfos = ObjectEncoder.loadClass(currentClass);
                for (FieldInfo info : currentFieldInfos.order) {
                    fieldInfos.put(info.fieldName, info);
                }
            }
            classInfos.put(objectClass.getName(), fieldInfos);
        }
        return fieldInfos;
    }

    public static String encode(Object object) {
        Class<?> objectClass = object.getClass();
        FieldInfos fieldInfos = ObjectEncoder.loadClass(objectClass);
        if (fieldInfos != null) {
            List<FieldInfo> listInfos = fieldInfos.values();
            StringBuilder build = new StringBuilder();
            StringBuilder endStr = new StringBuilder();
            for (FieldInfo fieldInfo : listInfos) {
                try {
                    String fieldString;
                    Object fieldData = fieldInfo.getMethod.invoke(object, new Object[0]);
                    if (fieldData == null) {
                        fieldString = NULL;
                    } else if (fieldInfo.conversion == null) {
                        fieldString = fieldInfo.fieldType == String.class ? (String)fieldData : fieldData.toString();
                    } else {
                        fieldString = ";#:";
                        endStr.append(fieldInfo.conversion.toString(fieldData));
                        endStr.append(";#:");
                    }
                    build.append(fieldInfo.fieldName);
                    build.append(EQUALS);
                    build.append(fieldString);
                    build.append(SEPARATOR_1);
                }
                catch (Exception ex) {
                    logger.error((Object)("Error while encoding the object" + object.getClass().getName() + " @ " + fieldInfo.fieldName + " : " + ex), new Object[0]);
                    ex.printStackTrace();
                }
            }
            if (listInfos.size() != 0) {
                build.setLength(build.length() - SEPARATOR_1.length());
            }
            if (endStr.length() != 0) {
                endStr.setLength(endStr.length() - ";#:".length());
            }
            String encodedObject = build.toString();
            build.setLength(0);
            build.append(encodedObject.length());
            build.append(SEPARATOR_1);
            build.append(objectClass.getName());
            build.append(SEPARATOR_1);
            build.append(encodedObject);
            build.append((CharSequence)endStr);
            return build.toString();
        }
        return null;
    }

    public static Object decode(String encodedObject) {
        FieldInfos fieldInfos;
        Object decodedObject;
        String[] objValues;
        EncodedObjectReader reader = null;
        String[] property = null;
        try {
            reader = new EncodedObjectReader(encodedObject);
            objValues = reader.fieldSpecialValues;
            Class<?> classObject = Class.forName(reader.className);
            decodedObject = classObject.newInstance();
            fieldInfos = ObjectEncoder.loadClass(classObject);
        }
        catch (Exception ex) {
            logger.error((Object)"Error while decoding the object : \n", new Object[0]);
            logger.error((Object)("    " + ex.getClass().getName() + " : " + ex.getMessage()), new Object[0]);
            return null;
        }
        if (fieldInfos != null) {
            int nbRegistredObj = 0;
            for (String param : reader.fieldProperties) {
                try {
                    property = ObjectEncoder.createProperty(param);
                    FieldInfo fieldInfo = fieldInfos.get(property[0]);
                    if (fieldInfo == null) continue;
                    if (NULL.equals(property[1])) {
                        fieldInfo.setMethod.invoke(decodedObject, new Object[]{null});
                        continue;
                    }
                    if (fieldInfo.conversion == null) {
                        if (fieldInfo.fieldType == String.class) {
                            fieldInfo.setMethod.invoke(decodedObject, property[1]);
                            continue;
                        }
                        Constructor c = fieldInfo.fieldType.getConstructor(String.class);
                        fieldInfo.setMethod.invoke(decodedObject, c.newInstance(property[1]));
                        continue;
                    }
                    if (!";#:".equals(property[1]) || nbRegistredObj >= objValues.length) continue;
                    Object fieldValue = fieldInfo.conversion.fromString(objValues[nbRegistredObj]);
                    ++nbRegistredObj;
                    fieldInfo.setMethod.invoke(decodedObject, fieldValue);
                }
                catch (Exception ex) {
                    logger.error((Object)("Error : Can not set the value of the field " + property[0] + "."), new Object[0]);
                }
            }
            return decodedObject;
        }
        return null;
    }

    public static <T> T decode(String encodedObject, Class<T> objectClass) {
        return ObjectEncoder.decode(encodedObject, objectClass, null, null);
    }

    public static <T> T decode(String encodedObject, Class<T> objectClass, List<String> fieldNames, List<String> fieldValues) {
        String[] objValues;
        EncodedObjectReader reader = null;
        String[] property = null;
        FieldInfos fieldInfos = null;
        T decodedObject = null;
        try {
            reader = new EncodedObjectReader(encodedObject);
            objValues = reader.fieldSpecialValues;
            if (objectClass != null) {
                decodedObject = objectClass.newInstance();
                fieldInfos = ObjectEncoder.loadClass(objectClass);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Error while decoding the object : \n", new Object[0]);
            logger.error((Object)("    " + ex.getClass().getName() + " : " + ex.getMessage()), new Object[0]);
            return null;
        }
        FieldInfo fieldInfo = null;
        int nbRegistredObj = 0;
        boolean storeInList = fieldNames != null && fieldValues != null;
        for (String param : reader.fieldProperties) {
            try {
                property = ObjectEncoder.createProperty(param);
                if (fieldInfos != null) {
                    fieldInfo = fieldInfos.get(property[0]);
                }
                if (fieldInfo != null) {
                    if (NULL.equals(property[1])) {
                        fieldInfo.setMethod.invoke(decodedObject, new Object[]{null});
                        continue;
                    }
                    if (fieldInfo.conversion == null) {
                        if (fieldInfo.fieldType == String.class) {
                            fieldInfo.setMethod.invoke(decodedObject, property[1]);
                            continue;
                        }
                        Constructor c = fieldInfo.fieldType.getConstructor(String.class);
                        fieldInfo.setMethod.invoke(decodedObject, c.newInstance(property[1]));
                        continue;
                    }
                    if (!";#:".equals(property[1]) || nbRegistredObj >= objValues.length) continue;
                    Object fieldValue = fieldInfo.conversion.fromString(objValues[nbRegistredObj]);
                    ++nbRegistredObj;
                    fieldInfo.setMethod.invoke(decodedObject, fieldValue);
                    continue;
                }
                if (!storeInList) continue;
                fieldNames.add(property[0]);
                if (NULL.equals(property[1])) {
                    fieldValues.add(NULL_TEXT);
                    continue;
                }
                if (";#:".equals(property[1]) && nbRegistredObj < objValues.length) {
                    fieldValues.add(objValues[nbRegistredObj]);
                    ++nbRegistredObj;
                    continue;
                }
                fieldValues.add(property[1]);
            }
            catch (Exception ex) {
                logger.error((Object)("Error : Can not set the value of the field " + property[0] + "."), new Object[0]);
            }
        }
        return decodedObject;
    }

    public static <T> T decodeToDisplayable(String encodedObject, Class<T> objectClass, List<String> fieldNames, List fieldValues) {
        FieldInfos realFieldInfos;
        String[] objValues;
        EncodedObjectReader reader = null;
        String[] property = null;
        FieldInfos fieldInfos = null;
        T decodedObject = null;
        try {
            reader = new EncodedObjectReader(encodedObject);
            objValues = reader.fieldSpecialValues;
            Class<?> classObject = null;
            try {
                classObject = Class.forName(reader.className);
            }
            catch (ClassNotFoundException e) {
                classObject = objectClass.getClassLoader().loadClass(reader.className);
            }
            realFieldInfos = ObjectEncoder.loadClass(classObject);
            if (objectClass != null) {
                decodedObject = objectClass.newInstance();
                fieldInfos = ObjectEncoder.loadClass(objectClass);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Error while decoding the object : \n", new Object[0]);
            logger.error((Object)("    " + ex.getClass().getName() + " : " + ex.getMessage()), new Object[0]);
            return null;
        }
        FieldInfo fieldInfo = null;
        int nbRegistredObj = 0;
        for (String param : reader.fieldProperties) {
            try {
                Object displayable;
                IDisplayableType dt;
                property = ObjectEncoder.createProperty(param);
                FieldInfo realFieldInfo = realFieldInfos.get(property[0]);
                fieldNames.add(property[0]);
                if (fieldInfos != null) {
                    fieldInfo = fieldInfos.get(property[0]);
                }
                if (NULL.equals(property[1])) {
                    fieldValues.add(NULL_TEXT);
                    if (fieldInfo == null) continue;
                    fieldInfo.setMethod.invoke(decodedObject, new Object[]{null});
                    continue;
                }
                if (fieldInfo != null) {
                    if (fieldInfo.conversion == null) {
                        fieldValues.add(property[1]);
                        if (fieldInfo.fieldType == String.class) {
                            fieldInfo.setMethod.invoke(decodedObject, property[1]);
                            continue;
                        }
                        Constructor c = fieldInfo.fieldType.getConstructor(String.class);
                        fieldInfo.setMethod.invoke(decodedObject, c.newInstance(property[1]));
                        continue;
                    }
                    if (!";#:".equals(property[1]) || nbRegistredObj >= objValues.length) continue;
                    if (realFieldInfo.conversion instanceof IDisplayableType) {
                        dt = (IDisplayableType)realFieldInfo.conversion;
                        displayable = dt.encodedToDisplayable(objValues[nbRegistredObj]);
                        fieldValues.add(displayable);
                    } else {
                        fieldValues.add(objValues[nbRegistredObj]);
                    }
                    Object fieldValue = fieldInfo.conversion.fromString(objValues[nbRegistredObj]);
                    ++nbRegistredObj;
                    fieldInfo.setMethod.invoke(decodedObject, fieldValue);
                    continue;
                }
                if (";#:".equals(property[1]) && nbRegistredObj < objValues.length) {
                    if (realFieldInfo.conversion instanceof IDisplayableType) {
                        dt = (IDisplayableType)realFieldInfo.conversion;
                        displayable = dt.encodedToDisplayable(objValues[nbRegistredObj]);
                        fieldValues.add(displayable);
                    } else {
                        fieldValues.add(objValues[nbRegistredObj]);
                    }
                    ++nbRegistredObj;
                    continue;
                }
                fieldValues.add(property[1]);
            }
            catch (Exception ex) {
                logger.error((Object)("Error : Can not set the value of the field " + property[0] + "."), new Object[0]);
            }
        }
        return decodedObject;
    }

    public static String encodeFromDisplayable(Class<?> objectClass, List<String> fieldNames, List fieldValues) {
        if (fieldNames.size() != fieldValues.size()) {
            return null;
        }
        FieldInfos fieldInfos = ObjectEncoder.loadClass(objectClass);
        if (fieldInfos != null) {
            StringBuilder build = new StringBuilder();
            StringBuilder endStr = new StringBuilder();
            Iterator it = fieldValues.iterator();
            for (String fieldName : fieldNames) {
                String fieldString;
                FieldInfo fieldInfo = fieldInfos.get(fieldName);
                Object fieldData = it.next();
                if (fieldInfo == null) continue;
                if (fieldData.equals(NULL_TEXT)) {
                    fieldString = NULL;
                } else if (fieldInfo.conversion != null) {
                    fieldString = ";#:";
                    if (fieldInfo.conversion instanceof IDisplayableType) {
                        endStr.append(((IDisplayableType)fieldInfo.conversion).displayableToEncoded(fieldData));
                    } else {
                        endStr.append((String)fieldData);
                    }
                    endStr.append(";#:");
                } else {
                    fieldString = fieldData instanceof String ? (String)fieldData : fieldData.toString();
                }
                build.append(fieldName);
                build.append(EQUALS);
                build.append(fieldString);
                build.append(SEPARATOR_1);
            }
            if (fieldNames.size() != 0) {
                build.setLength(build.length() - SEPARATOR_1.length());
            }
            if (endStr.length() != 0) {
                endStr.setLength(endStr.length() - ";#:".length());
            }
            String encodedObject = build.toString();
            build.setLength(0);
            build.append(encodedObject.length());
            build.append(SEPARATOR_1);
            build.append(objectClass.getName());
            build.append(SEPARATOR_1);
            build.append(encodedObject);
            build.append((CharSequence)endStr);
            return build.toString();
        }
        return null;
    }

    public static void registerField(Class typeClass, String fieldName, IEncodableType action) {
        FieldInfos fieldInfos = ObjectEncoder.loadClass(typeClass);
        if (action != null && fieldInfos != null) {
            FieldInfo fieldInfo = fieldInfos.get(fieldName);
            if (fieldInfo == null) {
                String getterName = ObjectEncoder.getFieldMethodName(fieldName, GET_PREFIX);
                String setterName = ObjectEncoder.getFieldMethodName(fieldName, SET_PREFIX);
                try {
                    Class<?> fieldType = typeClass.getDeclaredField(fieldName).getType();
                    Method getMethod = typeClass.getMethod(getterName, new Class[0]);
                    Method setMethod = typeClass.getMethod(setterName, fieldType);
                    fieldInfo = new FieldInfo(fieldName, fieldType, action, getMethod, setMethod);
                    fieldInfos.put(fieldName, fieldInfo);
                }
                catch (NoSuchFieldException ex) {
                    logger.error((Object)("Error while registring the field " + fieldName + ". This field does not exist."), new Object[0]);
                }
                catch (NoSuchMethodException ex) {
                    logger.error((Object)("Error while registring the field " + fieldName + ". This field must have a getter and a setter: " + getterName + "() and " + setterName + "()."), new Object[0]);
                }
            } else if (action != null) {
                fieldInfo.conversion = action;
            }
        }
    }

    public static void unregisterField(Class typeClass, String fieldName) {
        FieldInfos fieldInfos = ObjectEncoder.loadClass(typeClass);
        if (fieldInfos != null) {
            fieldInfos.remove(fieldName);
        }
    }

    public static String getClassName(String encodedObject) {
        int index = encodedObject.indexOf(SEPARATOR_1) + SEPARATOR_1.length();
        int index2 = encodedObject.indexOf(SEPARATOR_1, index);
        return encodedObject.substring(index, index2);
    }

    public static IEncodableType getEncodableType(String className, String fieldName) {
        FieldInfo fieldInfo;
        FieldInfos fieldInfos = classInfos.get(className);
        if (fieldInfos != null && (fieldInfo = fieldInfos.get(fieldName)) != null) {
            return fieldInfo.conversion;
        }
        return null;
    }

    private static String getFieldMethodName(String fieldName, String prefix) {
        StringBuilder builder = new StringBuilder(prefix);
        builder.append(String.valueOf(fieldName.charAt(0)).toUpperCase());
        builder.append(fieldName.substring(1));
        return builder.toString();
    }

    private static boolean haveStringConstructor(Class typeClass) {
        try {
            typeClass.getConstructor(String.class);
        }
        catch (Exception ex) {
            return false;
        }
        return true;
    }

    private static boolean haveDefaultConstructor(Class typeClass) {
        try {
            typeClass.getConstructor(new Class[0]);
        }
        catch (Exception ex) {
            return false;
        }
        return true;
    }

    private static String[] createProperty(String param) {
        int index = param.indexOf(EQUALS);
        String[] tab = new String[]{param.substring(0, index), param.substring(index + EQUALS.length())};
        return tab;
    }

    private static Class checkType(Class typeClass) {
        if (typeClass == Integer.TYPE) {
            return Integer.class;
        }
        if (typeClass == Boolean.TYPE) {
            return Boolean.class;
        }
        if (typeClass == Long.TYPE) {
            return Long.class;
        }
        if (typeClass == Double.TYPE) {
            return Double.class;
        }
        if (typeClass == Byte.TYPE) {
            return Byte.class;
        }
        if (typeClass == Float.TYPE) {
            return Float.class;
        }
        if (typeClass == Short.TYPE) {
            return Short.class;
        }
        return typeClass;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class FieldInfos {
        private List<FieldInfo> order;
        private HashMap<String, FieldInfo> map = new HashMap();

        public FieldInfos() {
            this.order = new ArrayList<FieldInfo>();
        }

        public void put(String fieldName, FieldInfo fieldInfo) {
            if (!this.map.containsKey(fieldName)) {
                this.order.add(fieldInfo);
                this.map.put(fieldName, fieldInfo);
            }
        }

        public FieldInfo get(String fieldName) {
            return this.map.get(fieldName);
        }

        public FieldInfo remove(String fieldName) {
            FieldInfo removed = this.map.remove(fieldName);
            if (removed != null) {
                Iterator<FieldInfo> it = this.order.iterator();
                FieldInfo fieldInfo = null;
                while (it.hasNext()) {
                    fieldInfo = it.next();
                    if (!fieldInfo.fieldName.equals(fieldName)) continue;
                    it.remove();
                    return removed;
                }
            }
            return null;
        }

        public List<FieldInfo> values() {
            return this.order;
        }
    }

    static class FieldInfo {
        private String fieldName;
        private Class fieldType;
        private IEncodableType conversion;
        private Method getMethod;
        private Method setMethod;

        public FieldInfo(String fieldName, Class fieldType, IEncodableType conversion, Method getMethod, Method setMethod) {
            this.fieldName = fieldName;
            this.fieldType = fieldType;
            this.conversion = conversion;
            this.getMethod = getMethod;
            this.setMethod = setMethod;
        }

        public String toString() {
            return this.fieldName + " : " + this.fieldType;
        }
    }

    static class EncodedObjectReader {
        private String className;
        private String[] fieldProperties;
        private String[] fieldSpecialValues;

        public EncodedObjectReader(String encodedObject) {
            int index = encodedObject.indexOf(ObjectEncoder.SEPARATOR_1);
            int lengthMessage = Integer.parseInt(encodedObject.substring(0, index));
            int index2 = encodedObject.indexOf(ObjectEncoder.SEPARATOR_1, index += ObjectEncoder.SEPARATOR_1.length());
            this.className = encodedObject.substring(index, index2);
            index = index2 + ObjectEncoder.SEPARATOR_1.length();
            index2 = index + lengthMessage;
            this.fieldProperties = encodedObject.substring(index, index2).split(ObjectEncoder.SEPARATOR_1);
            this.fieldSpecialValues = encodedObject.substring(index2).split(";#:");
        }

        public String getClassName() {
            return this.className;
        }

        public String[] getFieldProperties() {
            return this.fieldProperties;
        }

        public String[] getFieldSpecialValues() {
            return this.fieldSpecialValues;
        }
    }
}

