/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.shelbie.core.internal;

import java.util.Set;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.apache.felix.ipojo.annotations.Component;
import org.apache.felix.ipojo.annotations.Provides;
import org.apache.felix.service.command.CommandSession;
import org.codehaus.plexus.interpolation.InterpolationException;
import org.codehaus.plexus.interpolation.PropertiesBasedValueSource;
import org.codehaus.plexus.interpolation.RegexBasedInterpolator;
import org.fusesource.jansi.Ansi;
import org.ow2.shelbie.core.IPromptProvider;
import org.ow2.shelbie.core.console.SessionValueSource;

@Component
@Provides
public class DefaultPromptProvider
implements IPromptProvider,
Pojo {
    private InstanceManager __IM;
    private static final String DEFAULT_PROMPT = "${user.name}@${application.name}$ ";
    private boolean __MgetPrompt$org_apache_felix_service_command_CommandSession;
    private boolean __MprintDebug$org_apache_felix_service_command_CommandSession$java_lang_String;

    public DefaultPromptProvider() {
        this(null);
    }

    private DefaultPromptProvider(InstanceManager _manager) {
        this._setInstanceManager(_manager);
    }

    public String getPrompt(CommandSession commandSession) {
        String string;
        if (!this.__MgetPrompt$org_apache_felix_service_command_CommandSession) {
            return this.__M_getPrompt(commandSession);
        }
        try {
            this.__IM.onEntry((Object)this, "getPrompt$org_apache_felix_service_command_CommandSession", new Object[]{commandSession});
            string = this.__M_getPrompt(commandSession);
            this.__IM.onExit((Object)this, "getPrompt$org_apache_felix_service_command_CommandSession", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getPrompt$org_apache_felix_service_command_CommandSession", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_getPrompt(CommandSession session) {
        String prompt = (String)session.get("prompt");
        if (prompt == null) {
            prompt = DEFAULT_PROMPT;
        }
        RegexBasedInterpolator interpolator = new RegexBasedInterpolator();
        interpolator.addValueSource(new PropertiesBasedValueSource(System.getProperties()));
        interpolator.addValueSource(new SessionValueSource(session));
        try {
            return interpolator.interpolate(prompt);
        }
        catch (InterpolationException e) {
            this.printDebug(session, "Cannot interpolate prompt '" + prompt + "'. Error: " + e.getMessage());
            return DEFAULT_PROMPT;
        }
    }

    private void printDebug(CommandSession commandSession, String string) {
        if (!this.__MprintDebug$org_apache_felix_service_command_CommandSession$java_lang_String) {
            this.__M_printDebug(commandSession, string);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "printDebug$org_apache_felix_service_command_CommandSession$java_lang_String", new Object[]{commandSession, string});
            this.__M_printDebug(commandSession, string);
            this.__IM.onExit((Object)this, "printDebug$org_apache_felix_service_command_CommandSession$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "printDebug$org_apache_felix_service_command_CommandSession$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __M_printDebug(CommandSession session, String message) {
        String error = Ansi.ansi().fg(Ansi.Color.GREEN).a("Debug: ").reset().toString();
        session.getConsole().println(error + message);
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            // empty if block
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("getPrompt$org_apache_felix_service_command_CommandSession")) {
                this.__MgetPrompt$org_apache_felix_service_command_CommandSession = true;
            }
            if (set.contains("printDebug$org_apache_felix_service_command_CommandSession$java_lang_String")) {
                this.__MprintDebug$org_apache_felix_service_command_CommandSession$java_lang_String = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

