/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.plan.deployer.impl;

import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ow2.util.archive.api.ArchiveException;
import org.ow2.util.archive.api.IArchive;
import org.ow2.util.archive.impl.ArchiveManager;
import org.ow2.util.ee.deploy.api.deployable.IDeployable;
import org.ow2.util.ee.deploy.api.deployable.OSGiDeployable;
import org.ow2.util.ee.deploy.api.deployer.DeployerException;
import org.ow2.util.ee.deploy.api.deployer.IDeployerManager;
import org.ow2.util.ee.deploy.api.deployer.UnsupportedDeployerException;
import org.ow2.util.ee.deploy.api.helper.DeployableHelperException;
import org.ow2.util.ee.deploy.impl.deployer.AbsDeployerList;
import org.ow2.util.ee.deploy.impl.helper.DeployableHelper;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.plan.bindings.deploymentplan.Condition;
import org.ow2.util.plan.bindings.deploymentplan.Deployment;
import org.ow2.util.plan.bindings.deploymentplan.DeploymentHelper;
import org.ow2.util.plan.bindings.deploymentplan.DeploymentPlan;
import org.ow2.util.plan.bindings.deploymentplan.DeploymentPlanFragment;
import org.ow2.util.plan.bindings.exceptions.InvalidDeploymentException;
import org.ow2.util.plan.deploy.deployable.api.DeploymentPlanDeployable;
import org.ow2.util.plan.deploy.deployable.api.profile.IDeploymentProfileManager;
import org.ow2.util.plan.deploy.deployable.impl.DeploymentPlanDeployableImpl;
import org.ow2.util.plan.deployer.api.DeploymentPlanDeploymentException;
import org.ow2.util.plan.deployer.api.DeploymentPlanUndeploymentException;
import org.ow2.util.plan.deployer.api.FragmentDeploymentException;
import org.ow2.util.plan.deployer.api.FragmentUndeploymentException;
import org.ow2.util.plan.deployer.api.IDeploymentPlanDeployer;
import org.ow2.util.plan.fetcher.api.IResourceFetcher;
import org.ow2.util.plan.fetcher.api.IResourceFetcherFactoryManager;
import org.ow2.util.plan.monitor.api.IResourceMonitor;
import org.ow2.util.plan.reader.plan.IPlanReader;
import org.ow2.util.url.URLUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeploymentPlanDeployer
extends AbsDeployerList<DeploymentPlanDeployable>
implements IDeploymentPlanDeployer {
    private IDeployerManager deployerManager = null;
    private Map<Deployment, IDeployable<?>> deploymentToDeployableMap = new HashMap();
    private Map<Deployment, IResourceFetcher> deploymentToFetcherMap = new HashMap<Deployment, IResourceFetcher>();
    private IResourceMonitor resourceMonitor = null;
    private static Log logger = LogFactory.getLog(DeploymentPlanDeployer.class);
    private Collection<DeploymentPlanDeployable> deploymentPlans = new ArrayList<DeploymentPlanDeployable>();
    private IPlanReader planReader;
    private IResourceFetcherFactoryManager fetcherFactoryManager = null;
    private IDeploymentProfileManager profileManager;

    public void deploy(IDeployable<DeploymentPlanDeployable> deployable) throws DeployerException, UnsupportedDeployerException {
        if (deployable == null) {
            throw new DeployerException("Null deployable");
        }
        if (!DeploymentPlanDeployable.class.isInstance(deployable)) {
            throw new DeployerException("Bad deployable type " + deployable.getClass());
        }
        DeploymentPlanDeployable deploymentPlanDeployable = (DeploymentPlanDeployable)DeploymentPlanDeployable.class.cast(deployable);
        DeploymentPlan deploymentPlan = null;
        if (this.planReader == null) {
            throw new DeployerException("Deployment aborted - The PlanReader is null");
        }
        URL archiveUrl = null;
        try {
            archiveUrl = deploymentPlanDeployable.getArchive().getURL();
        }
        catch (ArchiveException e) {
            throw new DeployerException("Error while getting URL for archive " + deploymentPlanDeployable.getArchive() + " - Deployment aborted", (Throwable)e);
        }
        try {
            File archiveFile = URLUtils.urlToFile((URL)archiveUrl);
            deploymentPlan = this.planReader.readPlan(archiveFile);
        }
        catch (Exception e) {
            throw new DeployerException("Error while parsing archive " + archiveUrl + " - Deployment aborted", (Throwable)e);
        }
        if (deploymentPlan == null) {
            throw new DeployerException("The deployable " + deployable + " resolved in null deployment plan - Deployment aborted");
        }
        deploymentPlanDeployable.setAttachedData(deploymentPlan);
        try {
            this.deployDeploymentPlan(deploymentPlan);
        }
        catch (DeploymentPlanDeploymentException e) {
            throw new DeployerException("Deployment plan deployment failed", (Throwable)e);
        }
        logger.debug((Object)"Deployable {0} deployed", new Object[]{deployable});
        this.deploymentPlans.add(deploymentPlanDeployable);
    }

    public boolean isDeployed(IDeployable<DeploymentPlanDeployable> deployable) throws DeployerException {
        return this.deploymentPlans.contains(deployable);
    }

    public boolean supports(IDeployable<?> deployable) {
        return DeploymentPlanDeployableImpl.class.isInstance(deployable);
    }

    public void undeploy(IDeployable<DeploymentPlanDeployable> deployable) throws DeployerException {
        DeploymentPlanDeployable deploymentPlanDeployableToUndeployReally;
        if (deployable == null) {
            throw new DeployerException("Null deployable");
        }
        if (!DeploymentPlanDeployable.class.isInstance(deployable)) {
            throw new DeployerException("Bad deployable type " + deployable.getClass());
        }
        if (this.isDeployed(deployable)) {
            DeploymentPlanDeployable deploymentPlanDeployableToUndeploy = (DeploymentPlanDeployable)DeploymentPlanDeployable.class.cast(deployable);
            deploymentPlanDeployableToUndeployReally = null;
            for (DeploymentPlanDeployable deploymentPlanDeployable : this.deploymentPlans) {
                if (!deploymentPlanDeployable.equals(deploymentPlanDeployableToUndeploy)) continue;
                deploymentPlanDeployableToUndeployReally = deploymentPlanDeployable;
                break;
            }
            if (deploymentPlanDeployableToUndeployReally == null) {
                throw new DeployerException("Didn't found deployable to undeploy" + deployable);
            }
        } else {
            throw new DeployerException("Cannot undeploy deployable " + deployable + " that is not deployed");
        }
        this.undeployRealDeployable(deploymentPlanDeployableToUndeployReally);
    }

    private void undeployRealDeployable(DeploymentPlanDeployable deploymentPlanDeployableToUndeployReally) throws DeployerException {
        this.deploymentPlans.remove(deploymentPlanDeployableToUndeployReally);
        DeploymentPlan deploymentPlan = deploymentPlanDeployableToUndeployReally.getAttachedData();
        try {
            this.undeployDeploymentPlan(deploymentPlan);
        }
        catch (DeploymentPlanUndeploymentException e) {
            throw new DeployerException("Deployment plan undeployment failed", (Throwable)e);
        }
        logger.debug((Object)"deployable {0} undeployed", new Object[]{deploymentPlanDeployableToUndeployReally});
    }

    @Override
    public void setPlanReader(IPlanReader planReader) {
        this.planReader = planReader;
    }

    @Override
    public IPlanReader getPlanReader() {
        return this.planReader;
    }

    private void deployDeploymentPlan(DeploymentPlan deploymentPlan) throws DeploymentPlanDeploymentException, UnsupportedDeployerException {
        this.deployDeploymentPlan(deploymentPlan.getDeployments(), deploymentPlan);
    }

    private void deployDeploymentPlan(List<?> deployments, DeploymentPlan deploymentPlan) throws DeploymentPlanDeploymentException, UnsupportedDeployerException {
        for (Object deployment : deployments) {
            if (deployment instanceof Deployment) {
                DeploymentPlanFragment fragment = (DeploymentPlanFragment)deployment;
                try {
                    this.deployDeployment((Deployment)fragment);
                    fragment.setDeployed(true);
                }
                catch (Exception deployException) {
                    if (deploymentPlan.isAtomic()) {
                        logger.error((Object)"The deployment plan {0} failed and is atomic; it must be undeployed", new Object[]{deploymentPlan});
                        try {
                            this.undeployDeploymentPlan(deploymentPlan);
                        }
                        catch (DeploymentPlanUndeploymentException undeployException) {
                            logger.error((Object)"The deployment plan was not correctly undeployed.", new Object[0]);
                        }
                        throw new DeploymentPlanDeploymentException("Error while deploying part " + fragment + " of deployment plan " + deploymentPlan, deployException);
                    }
                    logger.error((Object)"Error while trying to deployed fragement ''{0}'' of deployment plan ''{1}''. Not atomic, so continue...", new Object[]{fragment, deploymentPlan, deployException});
                }
                continue;
            }
            if (deployment instanceof Condition) {
                Condition condition = (Condition)deployment;
                if (!this.profileManager.isProfileEnabled(condition.getProfile())) continue;
                this.deployDeploymentPlan(condition.getDeploymentOrIf(), deploymentPlan);
                continue;
            }
            throw new DeploymentPlanDeploymentException("Unsupported element: " + deployment);
        }
    }

    private void undeployDeploymentPlan(DeploymentPlan deploymentPlan) throws DeploymentPlanUndeploymentException {
        this.undeployDeploymentPlan(deploymentPlan.getDeployments(), deploymentPlan);
    }

    private void undeployDeploymentPlan(List<?> deployments, DeploymentPlan deploymentPlan) throws DeploymentPlanUndeploymentException {
        for (Serializable deployment : deploymentPlan.getDeployments()) {
            if (deployment instanceof DeploymentPlanFragment) {
                DeploymentPlanFragment fragment = (DeploymentPlanFragment)deployment;
                boolean partialFail = false;
                if (fragment.isDeployed()) {
                    try {
                        this.undeployDeployment((Deployment)fragment);
                        fragment.setDeployed(false);
                    }
                    catch (FragmentUndeploymentException e) {
                        logger.error((Object)"Error undeploying deployment {0} of deployment plan {1}", new Object[]{fragment, deploymentPlan});
                        partialFail = true;
                    }
                }
                if (!partialFail) continue;
                throw new DeploymentPlanUndeploymentException();
            }
            if (deployment instanceof Condition) {
                Condition condition = (Condition)deployment;
                if (!this.profileManager.isProfileEnabled(condition.getProfile())) continue;
                this.undeployDeploymentPlan(condition.getDeploymentOrIf(), deploymentPlan);
                continue;
            }
            throw new DeploymentPlanUndeploymentException("Unsupported element: " + deployment);
        }
    }

    @Override
    public void deployDeployment(Deployment deployment) throws FragmentDeploymentException, UnsupportedDeployerException {
        boolean isDeployed;
        if (deployment == null) {
            throw new FragmentDeploymentException("Null deployment fragment.");
        }
        if (!(deployment instanceof DeploymentPlanFragment)) {
            throw new FragmentDeploymentException("Bad deployment instance : " + deployment);
        }
        DeploymentPlanFragment fragment = (DeploymentPlanFragment)deployment;
        Boolean reloadable = null;
        try {
            reloadable = DeploymentHelper.isReloadable((Deployment)fragment);
        }
        catch (InvalidDeploymentException e) {
            throw new FragmentDeploymentException("Invalid deployment found : " + fragment, e);
        }
        File file = null;
        IResourceFetcher fetcher = null;
        try {
            fetcher = this.fetcherFactoryManager.getResourceFetcher(fragment);
            fetcher.resolve();
            file = fetcher.getResource();
        }
        catch (Exception e) {
            throw new FragmentDeploymentException(e);
        }
        if (file == null) {
            throw new FragmentDeploymentException("Null file");
        }
        IArchive archive = ArchiveManager.getInstance().getArchive((Object)file);
        if (archive == null) {
            throw new FragmentDeploymentException("Null archive for file " + file);
        }
        IDeployable deployable = null;
        try {
            deployable = DeployableHelper.getDeployable((IArchive)archive);
        }
        catch (DeployableHelperException e) {
            throw new FragmentDeploymentException(e);
        }
        if (deployable == null) {
            throw new FragmentDeploymentException("Null deployable for archive" + archive);
        }
        if (OSGiDeployable.class.isInstance(deployable)) {
            try {
                Boolean start = DeploymentHelper.isStart((Deployment)fragment);
                ((OSGiDeployable)OSGiDeployable.class.cast(deployable)).setStart(start);
                Boolean reference = DeploymentHelper.isReference((Deployment)fragment);
                ((OSGiDeployable)OSGiDeployable.class.cast(deployable)).setReference(reference);
                Integer startLevel = DeploymentHelper.getStartLevel((Deployment)fragment);
                ((OSGiDeployable)OSGiDeployable.class.cast(deployable)).setStartLevel(startLevel);
                Boolean startTransient = DeploymentHelper.isStartTransient((Deployment)fragment);
                ((OSGiDeployable)OSGiDeployable.class.cast(deployable)).setStartTransient(startTransient);
            }
            catch (InvalidDeploymentException e) {
                throw new FragmentDeploymentException("Invalid deployment found : " + fragment, e);
            }
        }
        try {
            isDeployed = this.deployerManager.isDeployed(deployable);
        }
        catch (DeployerException e) {
            throw new FragmentDeploymentException("Cannot check if deployable " + deployable + " is already deployed", e);
        }
        if (!isDeployed) {
            try {
                this.deployerManager.deploy(deployable);
            }
            catch (DeployerException e) {
                throw new FragmentDeploymentException("Exception while deploying deployable " + deployable, e);
            }
            catch (UnsupportedDeployerException e) {
                throw new UnsupportedDeployerException("No deployer found for deployable " + deployable, (Throwable)e);
            }
            catch (Exception e) {
                throw new FragmentDeploymentException("No deployer found for deployable " + deployable, e);
            }
        }
        this.deploymentToDeployableMap.put((Deployment)fragment, deployable);
        if (reloadable.booleanValue()) {
            if (!this.deploymentToFetcherMap.containsValue(fetcher)) {
                this.resourceMonitor.addMonitoredResource(fetcher);
            }
            this.deploymentToFetcherMap.put((Deployment)fragment, fetcher);
        }
    }

    @Override
    public void undeployDeployment(Deployment deployment) throws FragmentUndeploymentException {
        if (deployment == null) {
            throw new FragmentUndeploymentException("Null deployment fragment.");
        }
        IDeployable<?> deployable = this.deploymentToDeployableMap.get(deployment);
        if (deployable == null) {
            throw new FragmentUndeploymentException("Cannot undeploy resource " + deployment.toString() + " - Trying to finish undeployment");
        }
        IResourceFetcher fetcher = this.deploymentToFetcherMap.get(deployment);
        this.cleanDeploymentMaps(deployment, null);
        if (fetcher != null) {
            if (!this.deploymentToFetcherMap.containsValue(fetcher)) {
                try {
                    this.resourceMonitor.removeMonitoredResource(fetcher);
                }
                catch (Exception e) {
                    logger.error((Object)"Cannot stop monitoring the resource ''{0}'':", new Object[]{deployment.toString()});
                }
            } else {
                logger.debug((Object)"Do not stop monitoring resource ''{0}'': another deployment plan makes reference to it.", new Object[]{deployment.toString()});
            }
        }
        if (!this.deploymentToDeployableMap.containsValue(deployable)) {
            try {
                if (DeploymentPlanDeployable.class.isInstance(deployable)) {
                    this.undeployRealDeployable((DeploymentPlanDeployable)DeploymentPlanDeployable.class.cast(deployable));
                }
                this.deployerManager.undeploy(deployable);
            }
            catch (Exception e) {
                throw new FragmentUndeploymentException("Could not undeploy resource " + deployable.getArchive() + " - Trying to finish undeployment");
            }
        } else {
            this.cleanDeploymentMaps(deployment, deployable);
            logger.debug((Object)"Do not undeploy archive ''{0}'': another deployment plan makes reference to it.", new Object[]{deployable.getArchive()});
        }
    }

    private void cleanDeploymentMaps(Deployment deployment, IDeployable<?> deployable) {
        this.deploymentToDeployableMap.remove(deployment);
        this.deploymentToFetcherMap.remove(deployment);
        if (deployable != null && DeploymentPlanDeployable.class.isInstance(deployable)) {
            DeploymentPlanDeployable deploymentPlanDeployable = (DeploymentPlanDeployable)DeploymentPlanDeployable.class.cast(deployable);
            DeploymentPlan deploymentPlan = deploymentPlanDeployable.getAttachedData();
            this.cleanDeploymentMaps(deploymentPlan.getDeployments());
        }
    }

    private void cleanDeploymentMaps(List<?> deployments) {
        for (Object subDeployment : deployments) {
            if (subDeployment instanceof Deployment) {
                this.cleanDeploymentMaps((Deployment)subDeployment, this.deploymentToDeployableMap.get((Deployment)subDeployment));
                continue;
            }
            if (subDeployment instanceof Condition) {
                if (!this.profileManager.isProfileEnabled(((Condition)subDeployment).getProfile())) continue;
                this.cleanDeploymentMaps(((Condition)subDeployment).getDeploymentOrIf());
                continue;
            }
            logger.warn((Object)("Unsupported element: " + subDeployment), new Object[0]);
        }
    }

    @Override
    public void setFetcherFactoryManager(IResourceFetcherFactoryManager factoryManager) {
        this.fetcherFactoryManager = factoryManager;
    }

    @Override
    public IResourceFetcherFactoryManager getFetcherFactoryManager() {
        return this.fetcherFactoryManager;
    }

    @Override
    public void setDeployerManager(IDeployerManager deployerManager) {
        this.deployerManager = deployerManager;
    }

    @Override
    public IDeployerManager getDeployerManager() {
        return this.deployerManager;
    }

    @Override
    public Integer getDeploymentPlansCount() {
        return this.deploymentPlans.size();
    }

    @Override
    public List<String> getDeploymentPlansIds() {
        ArrayList<String> result = new ArrayList<String>();
        for (DeploymentPlanDeployable deploymentPlanDeployable : this.deploymentPlans) {
            DeploymentPlan deploymentPlan = deploymentPlanDeployable.getAttachedData();
            if (deploymentPlan.getId() == null) {
                result.add("<unnamed deployment>");
                continue;
            }
            result.add(deploymentPlan.getId());
        }
        return result;
    }

    @Override
    public List<String> getDeploymentPlansUrls() {
        ArrayList<String> result = new ArrayList<String>();
        for (DeploymentPlanDeployable deploymentPlanDeployable : this.deploymentPlans) {
            try {
                URL url = deploymentPlanDeployable.getArchive().getURL();
                result.add(URLUtils.urlToFile((URL)url).getPath());
            }
            catch (ArchiveException e) {
                logger.error((Object)"Error in deployable archive.", new Object[]{e});
            }
        }
        return result;
    }

    @Override
    public IResourceMonitor getResourceMonitor() {
        return this.resourceMonitor;
    }

    @Override
    public void setResourceMonitor(IResourceMonitor resourceMonitor) {
        this.resourceMonitor = resourceMonitor;
    }

    @Override
    public DeploymentPlanDeployable getOwnerDeploymentPlanDeployable(Deployment deployment) {
        for (DeploymentPlanDeployable deploymentPlanDeployable : this.deploymentPlans) {
            DeploymentPlan deploymentPlan = deploymentPlanDeployable.getAttachedData();
            if (!deploymentPlan.getDeployments().contains(deployment)) continue;
            return deploymentPlanDeployable;
        }
        return null;
    }

    public IDeploymentProfileManager getProfileManager() {
        return this.profileManager;
    }

    @Override
    public void setProfileManager(IDeploymentProfileManager profileManager) {
        this.profileManager = profileManager;
    }
}

