/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.configadmin.internal;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.ow2.jonas.configadmin.ConfigurationInfo;
import org.ow2.jonas.configadmin.XmlConfigurationAdapterRegistry;
import org.ow2.jonas.configadmin.internal.AdapterRegistryEvent;
import org.ow2.jonas.configadmin.internal.AdapterRegistryListener;
import org.ow2.jonas.configadmin.internal.ConfigAdminDeployable;
import org.ow2.jonas.configadmin.internal.ConfigurationAssociationEvent;
import org.ow2.jonas.configadmin.internal.ConfigurationAssociationListener;
import org.ow2.jonas.configadmin.internal.ConfigurationItem;
import org.ow2.util.archive.api.ArchiveException;
import org.ow2.util.ee.deploy.api.deployable.IDeployable;
import org.ow2.util.ee.deploy.api.deployer.DeployerException;
import org.ow2.util.ee.deploy.api.deployer.IDeployer;
import org.ow2.util.ee.deploy.api.deployer.IDeployerManager;
import org.ow2.util.ee.deploy.api.deployer.UnsupportedDeployerException;
import org.ow2.util.ee.deploy.impl.deployer.AbsDeployerList;
import org.ow2.util.file.FileUtils;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.xml.DocumentParser;
import org.ow2.util.xml.DocumentParserException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigAdminDeployer
extends AbsDeployerList<ConfigAdminDeployable>
implements ConfigurationAssociationListener {
    private InstanceManager __IM;
    private static final String CONFIG_ADMIN_DEPLOYABLE = "jonas.configadmin.deployable";
    private static final Log logger = LogFactory.getLog(ConfigAdminDeployer.class);
    private boolean __FconfigAdmin;
    private ConfigurationAdmin configAdmin;
    private boolean __Fregistries;
    private Map<String, Map<ServiceReference, XmlConfigurationAdapterRegistry>> registries;
    private boolean __Flisteners;
    private List<AdapterRegistryListener> listeners;
    private boolean __Fdeployed;
    private Map<String, IDeployable<ConfigAdminDeployable>> deployed;
    private boolean __Mvalidate;
    private boolean __Minvalidate;
    private boolean __MregisterDeployerManager$org_ow2_util_ee_deploy_api_deployer_IDeployerManager;
    private boolean __MunregisterDeployerManager$org_ow2_util_ee_deploy_api_deployer_IDeployerManager;
    private boolean __MbindConfigurationAdmin$org_osgi_service_cm_ConfigurationAdmin;
    private boolean __MbindXmlConfigurationAdapterRegistry$org_ow2_jonas_configadmin_XmlConfigurationAdapterRegistry$org_osgi_framework_ServiceReference;
    private boolean __MunbindXmlConfigurationAdapterRegistry$org_osgi_framework_ServiceReference;
    private boolean __MfiresAdapterRegistryArrival$java_lang_String$org_ow2_jonas_configadmin_XmlConfigurationAdapterRegistry;
    private boolean __MfiresAdapterRegistryRemoval$java_lang_String$org_ow2_jonas_configadmin_XmlConfigurationAdapterRegistry;
    private boolean __Mdeploy$org_ow2_util_ee_deploy_api_deployable_IDeployable;
    private boolean __MgetUrl$org_ow2_util_ee_deploy_api_deployable_IDeployable;
    private boolean __Mundeploy$org_ow2_util_ee_deploy_api_deployable_IDeployable;
    private boolean __MisDeployed$org_ow2_util_ee_deploy_api_deployable_IDeployable;
    private boolean __Msupports$org_ow2_util_ee_deploy_api_deployable_IDeployable;
    private boolean __MprocessNewConfigurationItem$org_ow2_jonas_configadmin_internal_ConfigurationItem;
    private boolean __MonAssociation$org_ow2_jonas_configadmin_internal_ConfigurationAssociationEvent;
    private boolean __MonDissociation$org_ow2_jonas_configadmin_internal_ConfigurationAssociationEvent;
    private boolean __McreateFactoryConfiguration$org_ow2_jonas_configadmin_ConfigurationInfo;
    private boolean __McreateConfiguration$org_ow2_jonas_configadmin_ConfigurationInfo;

    ConfigurationAdmin __getconfigAdmin() {
        if (!this.__FconfigAdmin) {
            return this.configAdmin;
        }
        return (ConfigurationAdmin)this.__IM.onGet((Object)this, "configAdmin");
    }

    void __setconfigAdmin(ConfigurationAdmin configurationAdmin) {
        if (!this.__FconfigAdmin) {
            this.configAdmin = configurationAdmin;
            return;
        }
        this.__IM.onSet((Object)this, "configAdmin", (Object)configurationAdmin);
    }

    Map __getregistries() {
        if (!this.__Fregistries) {
            return this.registries;
        }
        return (Map)this.__IM.onGet((Object)this, "registries");
    }

    void __setregistries(Map map) {
        if (!this.__Fregistries) {
            this.registries = map;
            return;
        }
        this.__IM.onSet((Object)this, "registries", (Object)map);
    }

    List __getlisteners() {
        if (!this.__Flisteners) {
            return this.listeners;
        }
        return (List)this.__IM.onGet((Object)this, "listeners");
    }

    void __setlisteners(List list) {
        if (!this.__Flisteners) {
            this.listeners = list;
            return;
        }
        this.__IM.onSet((Object)this, "listeners", (Object)list);
    }

    Map __getdeployed() {
        if (!this.__Fdeployed) {
            return this.deployed;
        }
        return (Map)this.__IM.onGet((Object)this, "deployed");
    }

    void __setdeployed(Map map) {
        if (!this.__Fdeployed) {
            this.deployed = map;
            return;
        }
        this.__IM.onSet((Object)this, "deployed", (Object)map);
    }

    public ConfigAdminDeployer() {
        this(null);
    }

    private ConfigAdminDeployer(InstanceManager _manager) {
        this._setInstanceManager(_manager);
    }

    public void validate() throws Exception {
        if (!this.__Mvalidate) {
            this.__validate();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "validate", new Object[0]);
            this.__validate();
            this.__IM.onExit((Object)this, "validate", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "validate", throwable);
            throw throwable;
        }
    }

    private void __validate() throws Exception {
        this.__setregistries(new Hashtable());
        this.__setlisteners(new ArrayList());
        this.__setdeployed(new HashMap());
        Configuration[] configurations = this.__getconfigAdmin().listConfigurations("(jonas.configadmin.deployable=true)");
        if (configurations != null) {
            for (Configuration configuration : configurations) {
                configuration.delete();
            }
        }
    }

    public void invalidate() throws Exception {
        if (!this.__Minvalidate) {
            this.__invalidate();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "invalidate", new Object[0]);
            this.__invalidate();
            this.__IM.onExit((Object)this, "invalidate", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "invalidate", throwable);
            throw throwable;
        }
    }

    private void __invalidate() throws Exception {
        ArrayList deployables = new ArrayList(this.__getdeployed().values());
        for (IDeployable deployable : deployables) {
            this.undeploy((IDeployable<ConfigAdminDeployable>)deployable);
        }
    }

    public void registerDeployerManager(IDeployerManager iDeployerManager) {
        if (!this.__MregisterDeployerManager$org_ow2_util_ee_deploy_api_deployer_IDeployerManager) {
            this.__registerDeployerManager(iDeployerManager);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "registerDeployerManager$org_ow2_util_ee_deploy_api_deployer_IDeployerManager", new Object[]{iDeployerManager});
            this.__registerDeployerManager(iDeployerManager);
            this.__IM.onExit((Object)this, "registerDeployerManager$org_ow2_util_ee_deploy_api_deployer_IDeployerManager", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "registerDeployerManager$org_ow2_util_ee_deploy_api_deployer_IDeployerManager", throwable);
            throw throwable;
        }
    }

    private void __registerDeployerManager(IDeployerManager deployerManager) {
        deployerManager.register((IDeployer)this);
    }

    public void unregisterDeployerManager(IDeployerManager iDeployerManager) {
        if (!this.__MunregisterDeployerManager$org_ow2_util_ee_deploy_api_deployer_IDeployerManager) {
            this.__unregisterDeployerManager(iDeployerManager);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "unregisterDeployerManager$org_ow2_util_ee_deploy_api_deployer_IDeployerManager", new Object[]{iDeployerManager});
            this.__unregisterDeployerManager(iDeployerManager);
            this.__IM.onExit((Object)this, "unregisterDeployerManager$org_ow2_util_ee_deploy_api_deployer_IDeployerManager", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "unregisterDeployerManager$org_ow2_util_ee_deploy_api_deployer_IDeployerManager", throwable);
            throw throwable;
        }
    }

    private void __unregisterDeployerManager(IDeployerManager deployerManager) {
        deployerManager.unregister((IDeployer)this);
    }

    public void bindConfigurationAdmin(ConfigurationAdmin configurationAdmin) {
        if (!this.__MbindConfigurationAdmin$org_osgi_service_cm_ConfigurationAdmin) {
            this.__bindConfigurationAdmin(configurationAdmin);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "bindConfigurationAdmin$org_osgi_service_cm_ConfigurationAdmin", new Object[]{configurationAdmin});
            this.__bindConfigurationAdmin(configurationAdmin);
            this.__IM.onExit((Object)this, "bindConfigurationAdmin$org_osgi_service_cm_ConfigurationAdmin", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "bindConfigurationAdmin$org_osgi_service_cm_ConfigurationAdmin", throwable);
            throw throwable;
        }
    }

    private void __bindConfigurationAdmin(ConfigurationAdmin admin) {
        this.__setconfigAdmin(admin);
    }

    public void bindXmlConfigurationAdapterRegistry(XmlConfigurationAdapterRegistry xmlConfigurationAdapterRegistry, ServiceReference serviceReference) {
        if (!this.__MbindXmlConfigurationAdapterRegistry$org_ow2_jonas_configadmin_XmlConfigurationAdapterRegistry$org_osgi_framework_ServiceReference) {
            this.__bindXmlConfigurationAdapterRegistry(xmlConfigurationAdapterRegistry, serviceReference);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "bindXmlConfigurationAdapterRegistry$org_ow2_jonas_configadmin_XmlConfigurationAdapterRegistry$org_osgi_framework_ServiceReference", new Object[]{xmlConfigurationAdapterRegistry, serviceReference});
            this.__bindXmlConfigurationAdapterRegistry(xmlConfigurationAdapterRegistry, serviceReference);
            this.__IM.onExit((Object)this, "bindXmlConfigurationAdapterRegistry$org_ow2_jonas_configadmin_XmlConfigurationAdapterRegistry$org_osgi_framework_ServiceReference", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "bindXmlConfigurationAdapterRegistry$org_ow2_jonas_configadmin_XmlConfigurationAdapterRegistry$org_osgi_framework_ServiceReference", throwable);
            throw throwable;
        }
    }

    private void __bindXmlConfigurationAdapterRegistry(XmlConfigurationAdapterRegistry registry, ServiceReference reference) {
        String namespace = (String)reference.getProperty("namespace");
        Hashtable<ServiceReference, XmlConfigurationAdapterRegistry> scoped = (Hashtable<ServiceReference, XmlConfigurationAdapterRegistry>)this.__getregistries().get(namespace);
        if (scoped == null) {
            scoped = new Hashtable<ServiceReference, XmlConfigurationAdapterRegistry>();
            this.__getregistries().put(namespace, scoped);
        }
        scoped.put(reference, registry);
        this.firesAdapterRegistryArrival(namespace, registry);
    }

    public void unbindXmlConfigurationAdapterRegistry(ServiceReference serviceReference) {
        if (!this.__MunbindXmlConfigurationAdapterRegistry$org_osgi_framework_ServiceReference) {
            this.__unbindXmlConfigurationAdapterRegistry(serviceReference);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "unbindXmlConfigurationAdapterRegistry$org_osgi_framework_ServiceReference", new Object[]{serviceReference});
            this.__unbindXmlConfigurationAdapterRegistry(serviceReference);
            this.__IM.onExit((Object)this, "unbindXmlConfigurationAdapterRegistry$org_osgi_framework_ServiceReference", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "unbindXmlConfigurationAdapterRegistry$org_osgi_framework_ServiceReference", throwable);
            throw throwable;
        }
    }

    private void __unbindXmlConfigurationAdapterRegistry(ServiceReference reference) {
        String namespace = (String)reference.getProperty("namespace");
        Map scoped = (Map)this.__getregistries().get(namespace);
        if (scoped != null) {
            XmlConfigurationAdapterRegistry registry = (XmlConfigurationAdapterRegistry)scoped.remove(reference);
            this.firesAdapterRegistryRemoval(namespace, registry);
        }
    }

    private void firesAdapterRegistryArrival(String string, XmlConfigurationAdapterRegistry xmlConfigurationAdapterRegistry) {
        if (!this.__MfiresAdapterRegistryArrival$java_lang_String$org_ow2_jonas_configadmin_XmlConfigurationAdapterRegistry) {
            this.__firesAdapterRegistryArrival(string, xmlConfigurationAdapterRegistry);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "firesAdapterRegistryArrival$java_lang_String$org_ow2_jonas_configadmin_XmlConfigurationAdapterRegistry", new Object[]{string, xmlConfigurationAdapterRegistry});
            this.__firesAdapterRegistryArrival(string, xmlConfigurationAdapterRegistry);
            this.__IM.onExit((Object)this, "firesAdapterRegistryArrival$java_lang_String$org_ow2_jonas_configadmin_XmlConfigurationAdapterRegistry", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "firesAdapterRegistryArrival$java_lang_String$org_ow2_jonas_configadmin_XmlConfigurationAdapterRegistry", throwable);
            throw throwable;
        }
    }

    private void __firesAdapterRegistryArrival(String namespace, XmlConfigurationAdapterRegistry registry) {
        AdapterRegistryEvent event = new AdapterRegistryEvent(registry, namespace);
        for (AdapterRegistryListener listener : this.__getlisteners()) {
            listener.onAdapterRegistryArrival(event);
        }
    }

    private void firesAdapterRegistryRemoval(String string, XmlConfigurationAdapterRegistry xmlConfigurationAdapterRegistry) {
        if (!this.__MfiresAdapterRegistryRemoval$java_lang_String$org_ow2_jonas_configadmin_XmlConfigurationAdapterRegistry) {
            this.__firesAdapterRegistryRemoval(string, xmlConfigurationAdapterRegistry);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "firesAdapterRegistryRemoval$java_lang_String$org_ow2_jonas_configadmin_XmlConfigurationAdapterRegistry", new Object[]{string, xmlConfigurationAdapterRegistry});
            this.__firesAdapterRegistryRemoval(string, xmlConfigurationAdapterRegistry);
            this.__IM.onExit((Object)this, "firesAdapterRegistryRemoval$java_lang_String$org_ow2_jonas_configadmin_XmlConfigurationAdapterRegistry", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "firesAdapterRegistryRemoval$java_lang_String$org_ow2_jonas_configadmin_XmlConfigurationAdapterRegistry", throwable);
            throw throwable;
        }
    }

    private void __firesAdapterRegistryRemoval(String namespace, XmlConfigurationAdapterRegistry registry) {
        AdapterRegistryEvent event = new AdapterRegistryEvent(registry, namespace);
        for (AdapterRegistryListener listener : this.__getlisteners()) {
            listener.onAdapterRegistryRemoval(event);
        }
    }

    public void deploy(IDeployable<ConfigAdminDeployable> iDeployable) throws DeployerException, UnsupportedDeployerException {
        if (!this.__Mdeploy$org_ow2_util_ee_deploy_api_deployable_IDeployable) {
            this.__deploy(iDeployable);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "deploy$org_ow2_util_ee_deploy_api_deployable_IDeployable", new Object[]{iDeployable});
            this.__deploy(iDeployable);
            this.__IM.onExit((Object)this, "deploy$org_ow2_util_ee_deploy_api_deployable_IDeployable", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "deploy$org_ow2_util_ee_deploy_api_deployable_IDeployable", throwable);
            throw throwable;
        }
    }

    private void __deploy(IDeployable<ConfigAdminDeployable> untyped) throws DeployerException, UnsupportedDeployerException {
        ConfigAdminDeployable deployable = (ConfigAdminDeployable)((Object)ConfigAdminDeployable.class.cast(untyped));
        URL url = this.getUrl((IDeployable<?>)deployable);
        ArrayList<ConfigurationItem> items = new ArrayList<ConfigurationItem>();
        InputStream is = null;
        try {
            is = url.openStream();
            Document doc = null;
            try {
                doc = DocumentParser.getDocument((InputStream)is, (boolean)false, null);
            }
            catch (DocumentParserException e) {
                throw new DeployerException("Cannot parse XML " + url, (Throwable)e);
            }
            Element rootElement = doc.getDocumentElement();
            NodeList children = rootElement.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Node node = children.item(i);
                if (1 != node.getNodeType()) continue;
                items.add(new ConfigurationItem((Element)node));
            }
        }
        catch (IOException e) {
            try {
                throw new DeployerException("Cannot open " + (Object)((Object)deployable), (Throwable)e);
            }
            catch (Throwable throwable) {
                FileUtils.close((Closeable[])new Closeable[]{is});
                throw throwable;
            }
        }
        FileUtils.close((Closeable[])new Closeable[]{is});
        deployable.setAttachedData(items);
        int bound = 0;
        int failed = 0;
        for (ConfigurationItem item : items) {
            this.processNewConfigurationItem(item);
            if (item.getConfigurations() != null) {
                ++bound;
            }
            if (!item.isFailed()) continue;
            ++failed;
        }
        logger.info((Object)"Deployed {0} Configuration(s) [{1} bound, {2} unbound, {3} failed] for ''{4}''", new Object[]{items.size(), bound, items.size() - bound, failed, deployable.getShortName()});
        this.__getdeployed().put(url.toExternalForm(), untyped);
    }

    private URL getUrl(IDeployable<?> iDeployable) throws DeployerException {
        URL uRL;
        if (!this.__MgetUrl$org_ow2_util_ee_deploy_api_deployable_IDeployable) {
            return this.__getUrl(iDeployable);
        }
        try {
            this.__IM.onEntry((Object)this, "getUrl$org_ow2_util_ee_deploy_api_deployable_IDeployable", new Object[]{iDeployable});
            uRL = this.__getUrl(iDeployable);
            this.__IM.onExit((Object)this, "getUrl$org_ow2_util_ee_deploy_api_deployable_IDeployable", (Object)uRL);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getUrl$org_ow2_util_ee_deploy_api_deployable_IDeployable", throwable);
            throw throwable;
        }
        return uRL;
    }

    private URL __getUrl(IDeployable<?> deployable) throws DeployerException {
        URL url;
        try {
            url = deployable.getArchive().getURL();
        }
        catch (ArchiveException e) {
            throw new DeployerException("Cannot get URL of " + deployable, (Throwable)e);
        }
        return url;
    }

    public void undeploy(IDeployable<ConfigAdminDeployable> iDeployable) throws DeployerException {
        if (!this.__Mundeploy$org_ow2_util_ee_deploy_api_deployable_IDeployable) {
            this.__undeploy(iDeployable);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "undeploy$org_ow2_util_ee_deploy_api_deployable_IDeployable", new Object[]{iDeployable});
            this.__undeploy(iDeployable);
            this.__IM.onExit((Object)this, "undeploy$org_ow2_util_ee_deploy_api_deployable_IDeployable", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "undeploy$org_ow2_util_ee_deploy_api_deployable_IDeployable", throwable);
            throw throwable;
        }
    }

    private void __undeploy(IDeployable<ConfigAdminDeployable> deployable) throws DeployerException {
        URL url = this.getUrl(deployable);
        logger.info((Object)"Undeploying Configurations for ''{0}''", new Object[]{deployable.getShortName()});
        ConfigAdminDeployable cad = (ConfigAdminDeployable)deployable;
        Iterator i$ = cad.getAttachedData().iterator();
        while (i$.hasNext()) {
            ConfigurationItem item = (ConfigurationItem)i$.next();
            this.__getlisteners().remove(item);
            item.close();
        }
        this.__getdeployed().remove(url.toExternalForm());
    }

    public boolean isDeployed(IDeployable<ConfigAdminDeployable> iDeployable) throws DeployerException {
        boolean bl;
        if (!this.__MisDeployed$org_ow2_util_ee_deploy_api_deployable_IDeployable) {
            return this.__isDeployed(iDeployable);
        }
        try {
            this.__IM.onEntry((Object)this, "isDeployed$org_ow2_util_ee_deploy_api_deployable_IDeployable", new Object[]{iDeployable});
            bl = this.__isDeployed(iDeployable);
            this.__IM.onExit((Object)this, "isDeployed$org_ow2_util_ee_deploy_api_deployable_IDeployable", (Object)new Boolean(bl));
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "isDeployed$org_ow2_util_ee_deploy_api_deployable_IDeployable", throwable);
            throw throwable;
        }
        return bl;
    }

    private boolean __isDeployed(IDeployable<ConfigAdminDeployable> deployable) throws DeployerException {
        String url = this.getUrl(deployable).toExternalForm();
        return this.__getdeployed().containsKey(url);
    }

    public boolean supports(IDeployable<?> iDeployable) {
        boolean bl;
        if (!this.__Msupports$org_ow2_util_ee_deploy_api_deployable_IDeployable) {
            return this.__supports(iDeployable);
        }
        try {
            this.__IM.onEntry((Object)this, "supports$org_ow2_util_ee_deploy_api_deployable_IDeployable", new Object[]{iDeployable});
            bl = this.__supports(iDeployable);
            this.__IM.onExit((Object)this, "supports$org_ow2_util_ee_deploy_api_deployable_IDeployable", (Object)new Boolean(bl));
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "supports$org_ow2_util_ee_deploy_api_deployable_IDeployable", throwable);
            throw throwable;
        }
        return bl;
    }

    private boolean __supports(IDeployable<?> deployable) {
        return ConfigAdminDeployable.class.isAssignableFrom(deployable.getClass());
    }

    private void processNewConfigurationItem(ConfigurationItem configurationItem) {
        if (!this.__MprocessNewConfigurationItem$org_ow2_jonas_configadmin_internal_ConfigurationItem) {
            this.__processNewConfigurationItem(configurationItem);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "processNewConfigurationItem$org_ow2_jonas_configadmin_internal_ConfigurationItem", new Object[]{configurationItem});
            this.__processNewConfigurationItem(configurationItem);
            this.__IM.onExit((Object)this, "processNewConfigurationItem$org_ow2_jonas_configadmin_internal_ConfigurationItem", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "processNewConfigurationItem$org_ow2_jonas_configadmin_internal_ConfigurationItem", throwable);
            throw throwable;
        }
    }

    private void __processNewConfigurationItem(ConfigurationItem item) {
        item.addAssociationListener(this);
        this.__getlisteners().add(item);
        for (Map.Entry entry : this.__getregistries().entrySet()) {
            String namespace = (String)entry.getKey();
            for (XmlConfigurationAdapterRegistry registry : ((Map)entry.getValue()).values()) {
                this.firesAdapterRegistryArrival(namespace, registry);
            }
        }
    }

    @Override
    public void onAssociation(ConfigurationAssociationEvent configurationAssociationEvent) {
        if (!this.__MonAssociation$org_ow2_jonas_configadmin_internal_ConfigurationAssociationEvent) {
            this.__onAssociation(configurationAssociationEvent);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "onAssociation$org_ow2_jonas_configadmin_internal_ConfigurationAssociationEvent", new Object[]{configurationAssociationEvent});
            this.__onAssociation(configurationAssociationEvent);
            this.__IM.onExit((Object)this, "onAssociation$org_ow2_jonas_configadmin_internal_ConfigurationAssociationEvent", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "onAssociation$org_ow2_jonas_configadmin_internal_ConfigurationAssociationEvent", throwable);
            throw throwable;
        }
    }

    private void __onAssociation(ConfigurationAssociationEvent event) {
        HashSet<Configuration> configurations = new HashSet<Configuration>();
        Set<ConfigurationInfo> info = event.getInfo();
        for (ConfigurationInfo ci : info) {
            if (ci.isFactory()) {
                configurations.add(this.createFactoryConfiguration(ci));
                continue;
            }
            configurations.add(this.createConfiguration(ci));
        }
        event.getSource().getConfigurations().addAll(configurations);
    }

    @Override
    public void onDissociation(ConfigurationAssociationEvent configurationAssociationEvent) {
        if (!this.__MonDissociation$org_ow2_jonas_configadmin_internal_ConfigurationAssociationEvent) {
            this.__onDissociation(configurationAssociationEvent);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "onDissociation$org_ow2_jonas_configadmin_internal_ConfigurationAssociationEvent", new Object[]{configurationAssociationEvent});
            this.__onDissociation(configurationAssociationEvent);
            this.__IM.onExit((Object)this, "onDissociation$org_ow2_jonas_configadmin_internal_ConfigurationAssociationEvent", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "onDissociation$org_ow2_jonas_configadmin_internal_ConfigurationAssociationEvent", throwable);
            throw throwable;
        }
    }

    private void __onDissociation(ConfigurationAssociationEvent event) {
        ConfigurationItem item = event.getSource();
        for (Configuration configuration : item.getConfigurations()) {
            try {
                configuration.delete();
            }
            catch (IOException e) {}
        }
        item.getConfigurations().clear();
        for (Map.Entry entry : this.__getregistries().entrySet()) {
            String namespace = (String)entry.getKey();
            for (XmlConfigurationAdapterRegistry registry : ((Map)entry.getValue()).values()) {
                AdapterRegistryEvent are = new AdapterRegistryEvent(registry, namespace);
                item.onAdapterRegistryArrival(are);
            }
        }
    }

    private Configuration createFactoryConfiguration(ConfigurationInfo configurationInfo) {
        Configuration configuration;
        if (!this.__McreateFactoryConfiguration$org_ow2_jonas_configadmin_ConfigurationInfo) {
            return this.__createFactoryConfiguration(configurationInfo);
        }
        try {
            this.__IM.onEntry((Object)this, "createFactoryConfiguration$org_ow2_jonas_configadmin_ConfigurationInfo", new Object[]{configurationInfo});
            configuration = this.__createFactoryConfiguration(configurationInfo);
            this.__IM.onExit((Object)this, "createFactoryConfiguration$org_ow2_jonas_configadmin_ConfigurationInfo", (Object)configuration);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "createFactoryConfiguration$org_ow2_jonas_configadmin_ConfigurationInfo", throwable);
            throw throwable;
        }
        return configuration;
    }

    private Configuration __createFactoryConfiguration(ConfigurationInfo configuration) {
        try {
            String servicePid = configuration.getPid();
            logger.debug((Object)"Create FactoryConfiguration for {0}", new Object[]{servicePid});
            Configuration c = this.__getconfigAdmin().createFactoryConfiguration(servicePid, null);
            Hashtable<String, Object> properties = new Hashtable<String, Object>();
            for (Map.Entry<String, Object> entry : configuration.getProperties().entrySet()) {
                ((Dictionary)properties).put(entry.getKey(), entry.getValue());
            }
            ((Dictionary)properties).put(CONFIG_ADMIN_DEPLOYABLE, "true");
            c.update(properties);
            logger.debug((Object)"Updated Factory {0}", new Object[]{c});
            return c;
        }
        catch (IOException e) {
            logger.warn((Object)"Cannot push Factory Configuration {0}", new Object[]{configuration.getPid(), e});
            return null;
        }
    }

    private Configuration createConfiguration(ConfigurationInfo configurationInfo) {
        Configuration configuration;
        if (!this.__McreateConfiguration$org_ow2_jonas_configadmin_ConfigurationInfo) {
            return this.__createConfiguration(configurationInfo);
        }
        try {
            this.__IM.onEntry((Object)this, "createConfiguration$org_ow2_jonas_configadmin_ConfigurationInfo", new Object[]{configurationInfo});
            configuration = this.__createConfiguration(configurationInfo);
            this.__IM.onExit((Object)this, "createConfiguration$org_ow2_jonas_configadmin_ConfigurationInfo", (Object)configuration);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "createConfiguration$org_ow2_jonas_configadmin_ConfigurationInfo", throwable);
            throw throwable;
        }
        return configuration;
    }

    private Configuration __createConfiguration(ConfigurationInfo configuration) {
        try {
            String servicePid = configuration.getPid();
            logger.debug((Object)"Create Configuration for {0}", new Object[]{servicePid});
            Configuration c = this.__getconfigAdmin().getConfiguration(servicePid, null);
            Hashtable<String, Object> properties = c.getProperties();
            if (properties == null) {
                properties = new Hashtable<String, Object>();
            }
            for (Map.Entry<String, Object> entry : configuration.getProperties().entrySet()) {
                ((Dictionary)properties).put(entry.getKey(), entry.getValue());
            }
            ((Dictionary)properties).put(CONFIG_ADMIN_DEPLOYABLE, "true");
            if (c.getBundleLocation() != null) {
                c.setBundleLocation(null);
            }
            c.update(properties);
            logger.debug((Object)"Updated {0}", new Object[]{c});
            return c;
        }
        catch (IOException e) {
            logger.warn((Object)"Cannot push Configuration {0}", new Object[]{configuration.getPid(), e});
            return null;
        }
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("listeners")) {
                this.__Flisteners = true;
            }
            if (set.contains("deployed")) {
                this.__Fdeployed = true;
            }
            if (set.contains("configAdmin")) {
                this.__FconfigAdmin = true;
            }
            if (set.contains("registries")) {
                this.__Fregistries = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("validate")) {
                this.__Mvalidate = true;
            }
            if (set.contains("invalidate")) {
                this.__Minvalidate = true;
            }
            if (set.contains("registerDeployerManager$org_ow2_util_ee_deploy_api_deployer_IDeployerManager")) {
                this.__MregisterDeployerManager$org_ow2_util_ee_deploy_api_deployer_IDeployerManager = true;
            }
            if (set.contains("unregisterDeployerManager$org_ow2_util_ee_deploy_api_deployer_IDeployerManager")) {
                this.__MunregisterDeployerManager$org_ow2_util_ee_deploy_api_deployer_IDeployerManager = true;
            }
            if (set.contains("bindConfigurationAdmin$org_osgi_service_cm_ConfigurationAdmin")) {
                this.__MbindConfigurationAdmin$org_osgi_service_cm_ConfigurationAdmin = true;
            }
            if (set.contains("bindXmlConfigurationAdapterRegistry$org_ow2_jonas_configadmin_XmlConfigurationAdapterRegistry$org_osgi_framework_ServiceReference")) {
                this.__MbindXmlConfigurationAdapterRegistry$org_ow2_jonas_configadmin_XmlConfigurationAdapterRegistry$org_osgi_framework_ServiceReference = true;
            }
            if (set.contains("unbindXmlConfigurationAdapterRegistry$org_osgi_framework_ServiceReference")) {
                this.__MunbindXmlConfigurationAdapterRegistry$org_osgi_framework_ServiceReference = true;
            }
            if (set.contains("firesAdapterRegistryArrival$java_lang_String$org_ow2_jonas_configadmin_XmlConfigurationAdapterRegistry")) {
                this.__MfiresAdapterRegistryArrival$java_lang_String$org_ow2_jonas_configadmin_XmlConfigurationAdapterRegistry = true;
            }
            if (set.contains("firesAdapterRegistryRemoval$java_lang_String$org_ow2_jonas_configadmin_XmlConfigurationAdapterRegistry")) {
                this.__MfiresAdapterRegistryRemoval$java_lang_String$org_ow2_jonas_configadmin_XmlConfigurationAdapterRegistry = true;
            }
            if (set.contains("deploy$org_ow2_util_ee_deploy_api_deployable_IDeployable")) {
                this.__Mdeploy$org_ow2_util_ee_deploy_api_deployable_IDeployable = true;
            }
            if (set.contains("getUrl$org_ow2_util_ee_deploy_api_deployable_IDeployable")) {
                this.__MgetUrl$org_ow2_util_ee_deploy_api_deployable_IDeployable = true;
            }
            if (set.contains("undeploy$org_ow2_util_ee_deploy_api_deployable_IDeployable")) {
                this.__Mundeploy$org_ow2_util_ee_deploy_api_deployable_IDeployable = true;
            }
            if (set.contains("isDeployed$org_ow2_util_ee_deploy_api_deployable_IDeployable")) {
                this.__MisDeployed$org_ow2_util_ee_deploy_api_deployable_IDeployable = true;
            }
            if (set.contains("supports$org_ow2_util_ee_deploy_api_deployable_IDeployable")) {
                this.__Msupports$org_ow2_util_ee_deploy_api_deployable_IDeployable = true;
            }
            if (set.contains("processNewConfigurationItem$org_ow2_jonas_configadmin_internal_ConfigurationItem")) {
                this.__MprocessNewConfigurationItem$org_ow2_jonas_configadmin_internal_ConfigurationItem = true;
            }
            if (set.contains("onAssociation$org_ow2_jonas_configadmin_internal_ConfigurationAssociationEvent")) {
                this.__MonAssociation$org_ow2_jonas_configadmin_internal_ConfigurationAssociationEvent = true;
            }
            if (set.contains("onDissociation$org_ow2_jonas_configadmin_internal_ConfigurationAssociationEvent")) {
                this.__MonDissociation$org_ow2_jonas_configadmin_internal_ConfigurationAssociationEvent = true;
            }
            if (set.contains("createFactoryConfiguration$org_ow2_jonas_configadmin_ConfigurationInfo")) {
                this.__McreateFactoryConfiguration$org_ow2_jonas_configadmin_ConfigurationInfo = true;
            }
            if (set.contains("createConfiguration$org_ow2_jonas_configadmin_ConfigurationInfo")) {
                this.__McreateConfiguration$org_ow2_jonas_configadmin_ConfigurationInfo = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

