/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.web.base.osgi.httpservice;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.service.http.HttpContext;

public class OSGIResourcesServlet
extends HttpServlet {
    private static final long serialVersionUID = 63252674986896592L;
    private final HttpContext httpContext;
    private final String baseName;

    public OSGIResourcesServlet(HttpContext httpContext, String baseName) {
        this.httpContext = httpContext;
        this.baseName = baseName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String resourceName;
        URL resourceUrl;
        String relativeName = req.getPathInfo();
        if (relativeName == null) {
            relativeName = "";
        }
        if (relativeName.startsWith("/")) {
            relativeName = relativeName.substring(1);
        }
        if ((resourceUrl = this.httpContext.getResource(resourceName = this.baseName + "/" + relativeName)) == null) {
            resp.sendError(404);
            return;
        }
        URLConnection connection = resourceUrl.openConnection();
        String mimeType = connection.getContentType();
        resp.setContentType(mimeType);
        String encoding = connection.getContentEncoding();
        resp.setCharacterEncoding(encoding);
        InputStream inStream = connection.getInputStream();
        ServletOutputStream outStream = resp.getOutputStream();
        try {
            byte[] buffer = new byte[1024];
            int length = 0;
            int readSize = 0;
            while ((readSize = inStream.read(buffer)) != -1) {
                outStream.write(buffer, 0, readSize);
                length += readSize;
            }
            resp.setContentLength(length);
        }
        finally {
            if (inStream != null) {
                inStream.close();
            }
            if (outStream != null) {
                outStream.close();
            }
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        this.doGet(req, resp);
    }
}

