/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.authenticator;

import java.io.IOException;
import java.security.Principal;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Session;
import org.apache.catalina.authenticator.AuthenticatorBase;
import org.apache.catalina.connector.Request;
import org.apache.catalina.deploy.LoginConfig;

public final class NonLoginAuthenticator
extends AuthenticatorBase {
    private static final String info = "org.apache.catalina.authenticator.NonLoginAuthenticator/1.0";

    @Override
    public String getInfo() {
        return info;
    }

    @Override
    public boolean authenticate(Request request, HttpServletResponse response, LoginConfig config) throws IOException {
        Principal principal = request.getUserPrincipal();
        if (principal != null) {
            if (this.containerLog.isDebugEnabled()) {
                this.containerLog.debug("Already authenticated as '" + principal.getName() + "'");
            }
            if (this.cache) {
                Session session = request.getSessionInternal(true);
                session.setPrincipal(principal);
                String ssoId = (String)request.getNote("org.apache.catalina.request.SSOID");
                if (ssoId != null) {
                    if (this.containerLog.isDebugEnabled()) {
                        this.containerLog.debug("User authenticated by existing SSO");
                    }
                    this.associate(ssoId, session);
                }
            }
            return true;
        }
        if (this.containerLog.isDebugEnabled()) {
            this.containerLog.debug("User authenticated without any roles");
        }
        return true;
    }

    @Override
    protected String getAuthMethod() {
        return "NONE";
    }
}

