/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net;

import java.io.EOFException;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.MutableInteger;
import org.apache.tomcat.util.net.NioBlockingSelector;
import org.apache.tomcat.util.net.NioChannel;

public class NioSelectorPool {
    private static final Log log = LogFactory.getLog(NioSelectorPool.class);
    protected static final boolean SHARED = Boolean.valueOf(System.getProperty("org.apache.tomcat.util.net.NioSelectorShared", "true"));
    protected NioBlockingSelector blockingSelector;
    protected volatile Selector SHARED_SELECTOR;
    protected int maxSelectors = 200;
    protected long sharedSelectorTimeout = 30000L;
    protected int maxSpareSelectors = -1;
    protected boolean enabled = true;
    protected AtomicInteger active = new AtomicInteger(0);
    protected AtomicInteger spare = new AtomicInteger(0);
    protected ConcurrentLinkedQueue<Selector> selectors = new ConcurrentLinkedQueue();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Selector getSharedSelector() throws IOException {
        if (!SHARED || this.SHARED_SELECTOR != null) return this.SHARED_SELECTOR;
        Class<NioSelectorPool> clazz = NioSelectorPool.class;
        synchronized (NioSelectorPool.class) {
            if (this.SHARED_SELECTOR != null) return this.SHARED_SELECTOR;
            Class<Selector> clazz2 = Selector.class;
            synchronized (Selector.class) {
                this.SHARED_SELECTOR = Selector.open();
                // ** MonitorExit[var2_2] (shouldn't be in output)
                log.info("Using a shared selector for servlet write/read");
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return this.SHARED_SELECTOR;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Selector get() throws IOException {
        if (SHARED) {
            return this.getSharedSelector();
        }
        if (!this.enabled || this.active.incrementAndGet() >= this.maxSelectors) {
            if (!this.enabled) return null;
            this.active.decrementAndGet();
            return null;
        }
        Selector s = null;
        try {
            Selector selector = s = this.selectors.size() > 0 ? this.selectors.poll() : null;
            if (s == null) {
                Class<Selector> clazz = Selector.class;
                synchronized (Selector.class) {
                    s = Selector.open();
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return s;
                }
            }
            this.spare.decrementAndGet();
            return s;
        }
        catch (NoSuchElementException x) {
            try {
                Class<Selector> clazz = Selector.class;
                synchronized (Selector.class) {
                    s = Selector.open();
                    // ** MonitorExit[var3_5] (shouldn't be in output)
                    return s;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return s;
        }
        finally {
            if (s == null) {
                this.active.decrementAndGet();
            }
        }
    }

    public void put(Selector s) throws IOException {
        if (SHARED) {
            return;
        }
        if (this.enabled) {
            this.active.decrementAndGet();
        }
        if (this.enabled && (this.maxSpareSelectors == -1 || this.spare.get() < Math.min(this.maxSpareSelectors, this.maxSelectors))) {
            this.spare.incrementAndGet();
            this.selectors.offer(s);
        } else {
            s.close();
        }
    }

    public void close() throws IOException {
        Selector s;
        this.enabled = false;
        while ((s = this.selectors.poll()) != null) {
            s.close();
        }
        this.spare.set(0);
        this.active.set(0);
        if (this.blockingSelector != null) {
            this.blockingSelector.close();
        }
        if (SHARED && this.getSharedSelector() != null) {
            this.getSharedSelector().close();
            this.SHARED_SELECTOR = null;
        }
    }

    public void open() throws IOException {
        this.enabled = true;
        this.getSharedSelector();
        if (SHARED) {
            this.blockingSelector = new NioBlockingSelector();
            this.blockingSelector.open(this.getSharedSelector());
        }
    }

    public int write(ByteBuffer buf, NioChannel socket, Selector selector, long writeTimeout) throws IOException {
        return this.write(buf, socket, selector, writeTimeout, true, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int write(ByteBuffer buf, NioChannel socket, Selector selector, long writeTimeout, boolean block, MutableInteger lastWrite) throws IOException {
        if (SHARED && block) {
            return this.blockingSelector.write(buf, socket, writeTimeout, lastWrite);
        }
        SelectionKey key = null;
        int written = 0;
        boolean timedout = false;
        int keycount = 1;
        long time = System.currentTimeMillis();
        try {
            while (!timedout && buf.hasRemaining()) {
                int cnt = 0;
                if (keycount > 0) {
                    cnt = socket.write(buf);
                    if (lastWrite != null) {
                        lastWrite.set(cnt);
                    }
                    if (cnt == -1) {
                        throw new EOFException();
                    }
                    written += cnt;
                    if (cnt > 0) {
                        time = System.currentTimeMillis();
                        continue;
                    }
                    if (cnt == 0 && !block) break;
                }
                if (selector != null) {
                    if (key == null) {
                        key = socket.getIOChannel().register(selector, 4);
                    } else {
                        key.interestOps(4);
                    }
                    keycount = selector.select(writeTimeout);
                }
                if (writeTimeout <= 0L || selector != null && keycount != 0) continue;
                timedout = System.currentTimeMillis() - time >= writeTimeout;
            }
            if (timedout) {
                throw new SocketTimeoutException();
            }
        }
        finally {
            if (key != null) {
                key.cancel();
                if (selector != null) {
                    selector.selectNow();
                }
            }
        }
        return written;
    }

    public int read(ByteBuffer buf, NioChannel socket, Selector selector, long readTimeout) throws IOException {
        return this.read(buf, socket, selector, readTimeout, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(ByteBuffer buf, NioChannel socket, Selector selector, long readTimeout, boolean block) throws IOException {
        if (SHARED && block) {
            return this.blockingSelector.read(buf, socket, readTimeout);
        }
        SelectionKey key = null;
        int read = 0;
        boolean timedout = false;
        int keycount = 1;
        long time = System.currentTimeMillis();
        try {
            while (!timedout) {
                int cnt = 0;
                if (keycount > 0) {
                    cnt = socket.read(buf);
                    if (cnt == -1) {
                        throw new EOFException();
                    }
                    read += cnt;
                    if (cnt > 0) continue;
                    if (cnt == 0 && (read > 0 || !block)) break;
                }
                if (selector != null) {
                    if (key == null) {
                        key = socket.getIOChannel().register(selector, 1);
                    } else {
                        key.interestOps(1);
                    }
                    keycount = selector.select(readTimeout);
                }
                if (readTimeout <= 0L || selector != null && keycount != 0) continue;
                timedout = System.currentTimeMillis() - time >= readTimeout;
            }
            if (timedout) {
                throw new SocketTimeoutException();
            }
        }
        finally {
            if (key != null) {
                key.cancel();
                if (selector != null) {
                    selector.selectNow();
                }
            }
        }
        return read;
    }

    public void setMaxSelectors(int maxSelectors) {
        this.maxSelectors = maxSelectors;
    }

    public void setMaxSpareSelectors(int maxSpareSelectors) {
        this.maxSpareSelectors = maxSpareSelectors;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setSharedSelectorTimeout(long sharedSelectorTimeout) {
        this.sharedSelectorTimeout = sharedSelectorTimeout;
    }

    public int getMaxSelectors() {
        return this.maxSelectors;
    }

    public int getMaxSpareSelectors() {
        return this.maxSpareSelectors;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public long getSharedSelectorTimeout() {
        return this.sharedSelectorTimeout;
    }

    public ConcurrentLinkedQueue<Selector> getSelectors() {
        return this.selectors;
    }

    public AtomicInteger getSpare() {
        return this.spare;
    }
}

