/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.ee.deploy.impl.deployer;

import java.util.ArrayList;
import java.util.List;
import org.ow2.util.ee.deploy.api.deployable.IDeployable;
import org.ow2.util.ee.deploy.api.deployer.DeployerException;
import org.ow2.util.ee.deploy.api.deployer.IDeployer;
import org.ow2.util.ee.deploy.api.deployer.UnsupportedDeployerException;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbsDeployerList<T extends IDeployable<T>>
implements IDeployer<T> {
    private Log logger = LogFactory.getLog(AbsDeployerList.class);

    public abstract void deploy(IDeployable<T> var1) throws DeployerException, UnsupportedDeployerException;

    public abstract void undeploy(IDeployable<T> var1) throws DeployerException;

    public abstract boolean isDeployed(IDeployable<T> var1) throws DeployerException;

    public abstract boolean supports(IDeployable<?> var1);

    public List<IDeployable<T>> deploy(List<IDeployable<T>> deployables) throws UnsupportedDeployerException {
        ArrayList<IDeployable<T>> failed = new ArrayList<IDeployable<T>>();
        for (IDeployable<T> deployable : deployables) {
            try {
                this.deploy(deployable);
            }
            catch (DeployerException e) {
                this.logger.error((Object)("Cannot deploy the deployable " + deployable.getArchive().getName() + "."), new Object[]{e});
                failed.add(deployable);
            }
        }
        return failed;
    }

    public List<IDeployable<T>> undeploy(List<IDeployable<T>> deployables) {
        ArrayList<IDeployable<T>> failed = new ArrayList<IDeployable<T>>();
        for (IDeployable<T> deployable : deployables) {
            try {
                this.undeploy(deployable);
            }
            catch (DeployerException e) {
                this.logger.error((Object)("Cannot undeploy the deployable " + deployable.getArchive().getName() + "."), new Object[]{e});
                failed.add(deployable);
            }
        }
        return failed;
    }

    public boolean supports(List<IDeployable<?>> deployables) {
        for (IDeployable<?> deployable : deployables) {
            if (this.supports(deployable)) continue;
            return false;
        }
        return true;
    }
}

