/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.deployment.ejb.ejbql;

import java.util.ArrayList;
import java.util.Iterator;
import org.ow2.jonas.deployment.ejb.ejbql.EJBQL;
import org.ow2.jonas.deployment.ejb.ejbql.EJBQLConstants;
import org.ow2.jonas.deployment.ejb.ejbql.EJBQLTreeConstants;
import org.ow2.jonas.deployment.ejb.ejbql.EJBQLVisitor;
import org.ow2.jonas.deployment.ejb.ejbql.Node;

public class SimpleNode
implements Node {
    protected Node parent;
    protected Node[] children;
    protected int id;
    protected EJBQL parser;
    public ArrayList ops = new ArrayList();
    public Object value = null;
    public boolean distinct = false;
    public boolean not = false;
    public boolean third = false;
    public int eltnum = 0;
    public boolean asc = true;

    public SimpleNode(int i) {
        this.id = i;
    }

    public SimpleNode(EJBQL p, int i) {
        this(i);
        this.parser = p;
    }

    public void jjtOpen() {
    }

    public void jjtClose() {
    }

    public void jjtSetParent(Node n) {
        this.parent = n;
    }

    public Node jjtGetParent() {
        return this.parent;
    }

    public void jjtAddChild(Node n, int i) {
        if (this.children == null) {
            this.children = new Node[i + 1];
        } else if (i >= this.children.length) {
            Node[] c = new Node[i + 1];
            System.arraycopy(this.children, 0, c, 0, this.children.length);
            this.children = c;
        }
        this.children[i] = n;
    }

    public Node jjtGetChild(int i) {
        return this.children[i];
    }

    public int jjtGetNumChildren() {
        return this.children == null ? 0 : this.children.length;
    }

    public Object jjtAccept(EJBQLVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public Object childrenAccept(EJBQLVisitor visitor, Object data) {
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                this.children[i].jjtAccept(visitor, data);
            }
        }
        return data;
    }

    public String toString() {
        String ret = "";
        if (this.not) {
            ret = ret + "NOT ";
        }
        if (this.distinct) {
            ret = ret + "DISTINCT ";
        }
        ret = this.asc ? ret + "ASC " : ret + "DESC ";
        if (this.ops.size() != 0) {
            ret = ret + "(";
            Iterator i = this.ops.iterator();
            while (i.hasNext()) {
                String token = EJBQLConstants.tokenImage[(Integer)i.next()];
                ret = ret + token.substring(1, token.length() - 1) + ",";
            }
            ret = ret.substring(0, ret.length() - 1);
        }
        if (this.value != null) {
            ret = ret + this.value;
        }
        if (this.ops.size() != 0) {
            ret = ret + ")";
        }
        return EJBQLTreeConstants.jjtNodeName[this.id] + " " + ret;
    }

    public String toString(String prefix) {
        return prefix + this.toString();
    }

    public void dump(String prefix) {
        System.out.println(this.toString(prefix));
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                SimpleNode n = (SimpleNode)this.children[i];
                if (n == null) continue;
                n.dump(prefix + " ");
            }
        }
    }
}

