/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jorm.mapper.rdb.xml2mi;

import java.util.Iterator;
import org.objectweb.jorm.api.PException;
import org.objectweb.jorm.mapper.rdb.metainfo.RdbClassMultiMapping;
import org.objectweb.jorm.mapper.rdb.metainfo.RdbExternalTable;
import org.objectweb.jorm.mapper.rdb.metainfo.RdbFilter;
import org.objectweb.jorm.mapper.rdb.metainfo.RdbFilterParameterTypeProvider;
import org.objectweb.jorm.mapper.rdb.metainfo.RdbGenClassMapping;
import org.objectweb.jorm.mapper.rdb.metainfo.RdbJoin;
import org.objectweb.jorm.mapper.rdb.metainfo.RdbMapping;
import org.objectweb.jorm.mapper.rdb.metainfo.RdbTable;
import org.objectweb.jorm.metainfo.api.Class;
import org.objectweb.jorm.metainfo.api.GenClassRef;
import org.objectweb.jorm.metainfo.api.Mapping;
import org.objectweb.jorm.metainfo.api.MetaObject;
import org.objectweb.jorm.metainfo.api.NameDef;
import org.objectweb.jorm.metainfo.api.PrimitiveElement;
import org.objectweb.jorm.xml2mi.lib.BasicMappingParser;
import org.objectweb.medor.expression.api.Expression;
import org.objectweb.medor.expression.api.ExpressionException;
import org.objectweb.medor.expression.lib.ExpressionPrinter;
import org.objectweb.medor.expression.parser.string.ExpressionParser;
import org.objectweb.util.monolog.api.BasicLevel;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RdbParser
extends BasicMappingParser {
    public static final String IDVALUE_SEP = ".";
    public static final ExpressionParser expParser = new ExpressionParser();

    private void parseClassMapping(Element classMappingElem, Mapping mapping) throws PException {
        RdbClassMultiMapping rdbClassMapping = null;
        rdbClassMapping = ((RdbMapping)mapping).createClassMultiMapping("");
        rdbClassMapping.setLogger(this.logger);
        NodeList children = classMappingElem.getChildNodes();
        rdbClassMapping.createRdbInheritanceQuery();
        this.logger.log(BasicLevel.DEBUG, (Object)"link rdbInheritanceQuery to the rdbClassMapping");
        for (int i = 0; i < children.getLength(); ++i) {
            String ruleName;
            NameDef nd;
            String linkend;
            RdbTable table;
            String tableName;
            Node child = children.item(i);
            String childName = child.getNodeName();
            if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                this.logger.log(BasicLevel.DEBUG, (Object)("begin =<" + childName + ">"));
            }
            if (childName.equals("colocated-class")) {
                String str = ((Element)child).getAttribute("class-name");
                if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                    this.logger.log(BasicLevel.DEBUG, (Object)("add dependency: " + str));
                }
                rdbClassMapping.addDependency(str);
            } else if (childName.equals("rdb-table-spec")) {
                tableName = ((Element)child).getAttribute("table-name");
                if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                    this.logger.log(BasicLevel.DEBUG, (Object)("Main table: " + tableName));
                }
                table = rdbClassMapping.createRdbTable(tableName);
                this.parseTableSpec((Element)child, table, this.currentClass);
            } else if (childName.equals("rdb-external-table-spec")) {
                tableName = ((Element)child).getAttribute("table-name");
                if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                    this.logger.log(BasicLevel.DEBUG, (Object)("External table: " + tableName));
                }
                table = rdbClassMapping.createRdbExternalTable(tableName);
                this.parseExternalTableSpec((Element)child, (RdbExternalTable)table, this.currentClass);
            } else if (childName.equals("rdb-filter-spec")) {
                this.parseFilter((Element)child, rdbClassMapping.createRdbFilter(), (Class)rdbClassMapping.getLinkedMO());
            } else if (childName.equals("id-mapping")) {
                linkend = ((Element)child).getAttribute("link-end");
                nd = this.getIdNameDef(rdbClassMapping, linkend);
                if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                    this.logger.log(BasicLevel.DEBUG, (Object)("link-end=<  \"" + linkend + "\">"));
                    this.logger.log(BasicLevel.DEBUG, (Object)("nd=<  " + nd + ">"));
                }
                rdbClassMapping.createIdentifierMapping(nd);
            } else if (childName.equals("rdb-class-ref-mapping") || childName.equals("rdb-gen-class-ref-mapping")) {
                linkend = ((Element)child).getAttribute("link-end");
                nd = this.getRefNameDef(linkend, childName);
                ruleName = ((Element)child).getAttribute("rule-name");
                rdbClassMapping.createReferenceMapping(ruleName, nd);
            } else if (childName.equals("rdb-extension-ref-mapping")) {
                linkend = ((Element)child).getAttribute("link-end");
                nd = this.getNameDefFromSuper(linkend);
                ruleName = ((Element)child).getAttribute("rule-name");
                rdbClassMapping.createReferenceMapping(ruleName, nd);
            } else if (childName.equals("parent-class-mapping")) {
                String fqcn;
                Class superClass;
                if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                    this.logger.log(BasicLevel.DEBUG, (Object)"parent-class-mapping");
                }
                if ((superClass = this.currentClass.getSuperClass(fqcn = ((Element)child).getAttribute("link-end"))) == null) {
                    throw new PException("Cannot find superclass " + fqcn + " for class " + this.currentClass.getFQName());
                }
                ruleName = ((Element)child).getAttribute("rule-name");
                if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                    this.logger.log(BasicLevel.DEBUG, (Object)("fqcn = " + fqcn + " / rule-name=" + ruleName));
                }
                rdbClassMapping.createParentClassMapping(ruleName, superClass);
            } else if (!childName.equals("#text") && !childName.equals("#comment")) {
                this.logger.log(BasicLevel.WARN, (Object)("element <" + childName + "> unknown !"));
            }
            if (!this.logger.isLoggable(BasicLevel.DEBUG)) continue;
            this.logger.log(BasicLevel.DEBUG, (Object)("end   =<" + childName + ">"));
        }
    }

    private void parseGenClassMapping(Element genClassMappingElem, Mapping mapping) throws PException {
        GenClassRef genClassRef;
        String linkend = genClassMappingElem.getAttribute("link-end");
        if (this.getLogger().isLoggable(BasicLevel.DEBUG)) {
            this.getLogger().log(BasicLevel.DEBUG, (Object)("linkend of rdb-gen-class-mapping <" + linkend + ">"));
        }
        if ((genClassRef = (GenClassRef)this.idvalue2genclassref.get(linkend)) != null && this.getLogger().isLoggable(BasicLevel.DEBUG)) {
            this.getLogger().log(BasicLevel.DEBUG, (Object)("GenClassRef name " + genClassRef.getName()));
        }
        if (this.getLogger().isLoggable(BasicLevel.DEBUG)) {
            this.getLogger().log(BasicLevel.DEBUG, (Object)("create a new BasicRdbGenClassMapping for the current Class (" + this.currentClass.getName() + ")"));
        }
        RdbGenClassMapping rdbGenClassMapping = ((RdbMapping)mapping).createGenClassMapping("", genClassRef);
        rdbGenClassMapping.setLogger(this.logger);
        NodeList children = genClassMappingElem.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            NameDef nd;
            String namedefName;
            RdbTable table;
            String tableName;
            Node child = children.item(i);
            String childName = child.getNodeName();
            if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                this.logger.log(BasicLevel.DEBUG, (Object)("begin =<" + childName + ">"));
            }
            if (childName.equals("rdb-table-spec")) {
                tableName = ((Element)child).getAttribute("table-name");
                table = rdbGenClassMapping.createRdbTable(tableName);
                this.parseTableSpec((Element)child, table, genClassRef);
            } else if (childName.equals("id-mapping")) {
                namedefName = ((Element)child).getAttribute("link-end");
                nd = genClassRef.getIdNameDef(namedefName);
                if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                    this.logger.log(BasicLevel.DEBUG, (Object)("Fetching the ID name def of the GenClassRef " + namedefName));
                    if (nd.isFieldName()) {
                        this.logger.log(BasicLevel.DEBUG, (Object)("fieldName: " + nd.getFieldName()));
                    } else if (nd.isNameRef()) {
                        this.logger.log(BasicLevel.DEBUG, (Object)("NameRef: " + nd.getNameRef()));
                    }
                }
                rdbGenClassMapping.createIdentifierMapping(nd);
            } else if (childName.equals("rdb-external-table-spec")) {
                tableName = ((Element)child).getAttribute("table-name");
                if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                    this.logger.log(BasicLevel.DEBUG, (Object)("External table: " + tableName));
                }
                table = rdbGenClassMapping.createRdbExternalTable(tableName);
                this.parseExternalTableSpec((Element)child, (RdbExternalTable)table, genClassRef);
            } else if (childName.equals("rdb-ref-mapping")) {
                namedefName = ((Element)child).getAttribute("link-end");
                nd = null;
                if (genClassRef.isPrimitive()) {
                    this.logger.log(BasicLevel.WARN, (Object)("You define a generic class of primitive and a useless name-def for the elements: generic class id=" + genClassRef.getGenClassId()));
                    continue;
                }
                if (genClassRef.isClassRef()) {
                    if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                        this.logger.log(BasicLevel.DEBUG, (Object)("Get the ref name def of the GenClassRef " + namedefName));
                    }
                    nd = genClassRef.getClassRef().getRefNameDef(namedefName);
                } else if (genClassRef.isGenClassRef()) {
                    if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                        this.logger.log(BasicLevel.DEBUG, (Object)("Get the ref name def of the ClassRef " + namedefName));
                    }
                    nd = genClassRef.getGenClassRef().getRefNameDef(namedefName);
                }
                String ruleName = ((Element)child).getAttribute("rule-name");
                rdbGenClassMapping.createReferenceMapping(ruleName, nd);
            } else if (!childName.equals("#text")) {
                this.logger.log(BasicLevel.WARN, (Object)("element <" + childName + "> unknown !"));
            }
            if (!this.logger.isLoggable(BasicLevel.DEBUG)) continue;
            this.logger.log(BasicLevel.DEBUG, (Object)("end   =<" + childName + ">"));
        }
    }

    private void parseTableSpec(Element tableSpecElem, RdbTable table, MetaObject mo) throws PException {
        String str = tableSpecElem.getAttribute("colocated");
        table.setColocated(new Boolean(str));
        str = tableSpecElem.getAttribute("colocated-master");
        table.setColocatedMaster(new Boolean(str));
        str = tableSpecElem.getAttribute("read-only");
        table.setReadOnly(new Boolean(str));
        NodeList children = tableSpecElem.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            String childName = child.getNodeName();
            if (!childName.equals("rdb-column-spec")) continue;
            this.parseColumn(child, table, mo);
        }
    }

    private void parseExternalTableSpec(Element tableSpecElem, RdbExternalTable table, MetaObject mo) throws PException {
        String str = tableSpecElem.getAttribute("colocated");
        table.setColocated(new Boolean(str));
        str = tableSpecElem.getAttribute("colocated-master");
        table.setColocatedMaster(new Boolean(str));
        str = tableSpecElem.getAttribute("read-only");
        table.setReadOnly(new Boolean(str));
        NodeList children = tableSpecElem.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            String childName = child.getNodeName();
            if (childName.equals("rdb-column-spec")) {
                this.parseColumn(child, table, mo);
                continue;
            }
            if (!childName.equals("rdb-join")) continue;
            str = ((Element)child).getAttribute("name");
            this.parseJoin((Element)child, table.createRdbJoin(str));
        }
    }

    private void parseColumn(Node child, RdbTable table, MetaObject mo) throws PException {
        if (this.logger.isLoggable(BasicLevel.DEBUG)) {
            this.logger.log(BasicLevel.DEBUG, (Object)("begin =<" + child.getNodeName() + ">"));
        }
        String linkend = ((Element)child).getAttribute("link-end");
        PrimitiveElement pe = null;
        if (mo instanceof Class) {
            pe = this.getPrimitiveElement(linkend);
            if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                this.logger.log(BasicLevel.DEBUG, (Object)("Class field name: " + linkend));
            }
        } else if (mo instanceof GenClassRef) {
            pe = ((GenClassRef)mo).getHiddenField(linkend);
            if (pe == null) {
                pe = ((GenClassRef)mo).getPrimitiveElement();
            }
            if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                this.logger.log(BasicLevel.DEBUG, (Object)("GenClass name: " + linkend));
            }
        }
        String columnName = ((Element)child).getAttribute("column-name");
        if (this.logger.isLoggable(BasicLevel.DEBUG)) {
            this.logger.log(BasicLevel.DEBUG, (Object)("column name: " + columnName));
        }
        String sqlType = ((Element)child).getAttribute("sql-type");
        boolean notNull = new Boolean(((Element)child).getAttribute("not-null"));
        if (table instanceof RdbExternalTable) {
            String str = ((Element)child).getAttribute("join-name");
            RdbJoin join = null;
            if (str == null) {
                Iterator it = ((RdbExternalTable)table).getRdbJoins().iterator();
                if (!it.hasNext()) {
                    throw new PException("No join defined in the external table ");
                }
                join = (RdbJoin)it.next();
                if (it.hasNext()) {
                    throw new PException("Several joins defined in the external table " + table.getName() + ", you must specify" + " a join-name attribute for the column " + columnName);
                }
            } else {
                join = ((RdbExternalTable)table).getRdbJoin(str);
                if (join == null) {
                    throw new PException("Impossible to define the column " + columnName + " of the external table " + table.getName() + ": The join '" + str + "' was not defined");
                }
            }
            ((RdbExternalTable)table).createPrimitiveElementMapping(pe, columnName, sqlType, notNull, join);
        } else {
            table.createPrimitiveElementMapping(pe, columnName, sqlType, notNull);
        }
        if (this.logger.isLoggable(BasicLevel.DEBUG)) {
            this.logger.log(BasicLevel.DEBUG, (Object)("end   =<" + child.getNodeName() + ">"));
        }
    }

    private void parseJoin(Element rdbJoinElem, RdbJoin rdbJoin) {
        NodeList children = rdbJoinElem.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            String childName = child.getNodeName();
            if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                this.logger.log(BasicLevel.DEBUG, (Object)("begin =<" + childName + ">"));
            }
            if (childName.equals("rdb-column-match")) {
                String ptColumn = ((Element)child).getAttribute("column1");
                String etColumn = ((Element)child).getAttribute("column2");
                rdbJoin.addJoinColumnNames(ptColumn, etColumn);
            }
            if (!this.logger.isLoggable(BasicLevel.DEBUG)) continue;
            this.logger.log(BasicLevel.DEBUG, (Object)("end   =<" + childName + ">"));
        }
    }

    private void parseFilter(Element rdbFilterElem, RdbFilter rdbFilter, Class theClass) throws PException {
        NodeList children = rdbFilterElem.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            String childName = child.getNodeName();
            if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                this.logger.log(BasicLevel.DEBUG, (Object)("begin =<" + childName + ">"));
            }
            if (!childName.equals("rdb-filter")) continue;
            String filterStr = ((Element)child).getAttribute("value");
            rdbFilter.setStringExpression(filterStr);
            try {
                if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                    this.logger.log(BasicLevel.DEBUG, (Object)("Parsing filter for " + filterStr));
                }
                Expression e = expParser.parse(filterStr, new RdbFilterParameterTypeProvider(theClass));
                if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                    this.logger.log(BasicLevel.DEBUG, (Object)("Parsed filter for " + filterStr + " is: " + ExpressionPrinter.e2str(e)));
                }
                rdbFilter.setExpression(e);
            }
            catch (ExpressionException e) {
                throw new PException(e);
            }
            if (!this.logger.isLoggable(BasicLevel.DEBUG)) continue;
            this.logger.log(BasicLevel.DEBUG, (Object)("end   =<" + childName + ">"));
        }
    }

    public void parseMapping(Element mappingElem, Mapping mapping) throws PException {
        if (mappingElem.getNodeName().equals("rdb-class-mapping")) {
            this.parseClassMapping(mappingElem, mapping);
        } else if (mappingElem.getNodeName().equals("rdb-gen-class-mapping")) {
            this.parseGenClassMapping(mappingElem, mapping);
        } else {
            throw new PException("Mapping element not supported by RDB: " + mappingElem.getNodeName());
        }
    }
}

