/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.manipulator;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import org.apache.felix.ipojo.manipulation.InnerClassManipulator;
import org.apache.felix.ipojo.manipulation.Manipulator;
import org.apache.felix.ipojo.manipulation.annotations.MetadataCollector;
import org.apache.felix.ipojo.manipulator.ManifestAttributeFilter;
import org.apache.felix.ipojo.manipulator.QuotedTokenizer;
import org.apache.felix.ipojo.metadata.Attribute;
import org.apache.felix.ipojo.metadata.Element;
import org.apache.felix.ipojo.xml.parser.ParseException;
import org.apache.felix.ipojo.xml.parser.SchemaResolver;
import org.apache.felix.ipojo.xml.parser.XMLMetadataParser;
import org.objectweb.asm.ClassReader;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class Pojoization {
    public static final String IPOJO_PACKAGE_VERSION = " 1.8.0";
    private List m_components;
    private List m_metadata = new ArrayList();
    private List m_errors = new ArrayList();
    private List m_warnings = new ArrayList();
    private Map m_classes = new HashMap();
    private List m_referredPackages;
    private boolean m_ignoreAnnotations;
    private boolean m_ignoreLocalXSD;
    private JarFile m_inputJar;
    private File m_dir;
    private File m_manifest;
    private List m_manifestAttributeFilters = new ArrayList();

    protected void error(String mes) {
        System.err.println(mes);
        this.m_errors.add(mes);
    }

    public void warn(String mes) {
        this.m_warnings.add(mes);
    }

    public List getErrors() {
        return this.m_errors;
    }

    public void disableAnnotationProcessing() {
        this.m_ignoreAnnotations = true;
    }

    public void setUseLocalXSD() {
        this.m_ignoreLocalXSD = false;
    }

    public void pojoization(File in, File out, InputStream metadata) {
        this.parseXMLMetadata(metadata);
        if (this.m_metadata == null) {
            return;
        }
        try {
            this.m_inputJar = new JarFile(in);
        }
        catch (IOException e) {
            this.error("The input file " + in.getAbsolutePath() + " is not a Jar file");
            return;
        }
        this.computeDeclaredComponents();
        this.manipulateJarFile(out);
        for (int i = 0; i < this.m_components.size(); ++i) {
            ComponentInfo ci = (ComponentInfo)this.m_components.get(i);
            if (ci.m_isManipulated) continue;
            this.error("The component " + ci.m_classname + " is declared but not in the bundle");
        }
    }

    public void pojoization(File in, File out, File metadataFile) {
        if (metadataFile != null) {
            this.parseXMLMetadata(metadataFile);
        }
        try {
            this.m_inputJar = new JarFile(in);
        }
        catch (IOException e) {
            this.error("The input file " + in.getAbsolutePath() + " is not a Jar file");
            return;
        }
        this.computeDeclaredComponents();
        this.manipulateJarFile(out);
        for (int i = 0; i < this.m_components.size(); ++i) {
            ComponentInfo ci = (ComponentInfo)this.m_components.get(i);
            if (ci.m_isManipulated) continue;
            this.error("The component " + ci.m_classname + " is declared but not in the bundle");
        }
    }

    public void directoryPojoization(File directory, File metadataFile, File manifestFile) {
        if (metadataFile != null) {
            this.parseXMLMetadata(metadataFile);
        }
        if (directory.exists() && directory.isDirectory()) {
            this.m_dir = directory;
        } else {
            this.error("The directory " + directory.getAbsolutePath() + " does not exist or is not a directory.");
        }
        if (manifestFile != null) {
            if (manifestFile.exists()) {
                this.m_manifest = manifestFile;
            } else {
                this.error("The manifest file " + manifestFile.getAbsolutePath() + " does not exist");
            }
        }
        this.computeDeclaredComponents();
        this.manipulateDirectory();
        for (int i = 0; i < this.m_components.size(); ++i) {
            ComponentInfo ci = (ComponentInfo)this.m_components.get(i);
            if (ci.m_isManipulated) continue;
            this.error("The component " + ci.m_classname + " is declared but not in the bundle");
        }
    }

    private void computeAnnotations(byte[] inC) {
        ClassReader cr = new ClassReader(inC);
        MetadataCollector collector = new MetadataCollector();
        cr.accept(collector, 0);
        if (!collector.isIgnoredBecauseOfMissingComponent() && collector.isComponentType()) {
            boolean toskip = false;
            for (int i = 0; !toskip && i < this.m_metadata.size(); ++i) {
                Element meta = (Element)this.m_metadata.get(i);
                if (meta.getName().equals("instance") || !meta.containsAttribute("name") || !meta.getAttribute("name").equalsIgnoreCase(collector.getComponentTypeDeclaration().getAttribute("name"))) continue;
                toskip = true;
                this.warn("The component type " + collector.getComponentTypeDeclaration().getAttribute("name") + " is overriden by the metadata file");
            }
            if (!toskip) {
                Element elem = collector.getComponentTypeDeclaration();
                this.m_metadata.add(elem);
                String name = elem.getAttribute("classname");
                name = name.replace('.', '/');
                name = name + ".class";
                ComponentInfo info = new ComponentInfo(name, elem);
                info.m_bytecode = inC;
                this.m_components.add(info);
                if (collector.getInstanceDeclaration() != null) {
                    this.m_metadata.add(collector.getInstanceDeclaration());
                }
            }
        }
    }

    private static void copyStreamWithoutClosing(InputStream in, OutputStream out) throws IOException {
        int n;
        byte[] b = new byte[4096];
        while ((n = in.read(b)) != -1) {
            out.write(b, 0, n);
        }
    }

    private void manipulateJarFile(File out) {
        this.manipulateComponents();
        this.m_referredPackages = this.getReferredPackages();
        Manifest mf = this.doManifest();
        FileOutputStream fos = null;
        JarOutputStream jos = null;
        try {
            fos = new FileOutputStream(out);
            jos = new JarOutputStream((OutputStream)fos, mf);
        }
        catch (FileNotFoundException e1) {
            this.error("Cannot manipulate the Jar file : the output file " + out.getAbsolutePath() + " is not found");
            return;
        }
        catch (IOException e) {
            this.error("Cannot manipulate the Jar file : cannot access to " + out.getAbsolutePath());
            return;
        }
        try {
            Enumeration<JarEntry> entries = this.m_inputJar.entries();
            while (entries.hasMoreElements()) {
                JarEntry curEntry = entries.nextElement();
                if (this.m_classes.containsKey(curEntry.getName())) {
                    JarEntry je = new JarEntry(curEntry.getName());
                    byte[] outClazz = (byte[])this.m_classes.get(curEntry.getName());
                    if (outClazz != null && outClazz.length != 0) {
                        jos.putNextEntry(je);
                        jos.write(outClazz);
                        jos.closeEntry();
                        continue;
                    }
                    jos.putNextEntry(curEntry);
                    InputStream currIn = this.m_inputJar.getInputStream(curEntry);
                    Pojoization.copyStreamWithoutClosing(currIn, jos);
                    currIn.close();
                    jos.closeEntry();
                    continue;
                }
                if (curEntry.getName().equals("META-INF/MANIFEST.MF")) continue;
                jos.putNextEntry(curEntry);
                InputStream currIn = this.m_inputJar.getInputStream(curEntry);
                Pojoization.copyStreamWithoutClosing(currIn, jos);
                currIn.close();
                jos.closeEntry();
            }
        }
        catch (IOException e) {
            this.error("Cannot manipulate the Jar file : " + e.getMessage());
            return;
        }
        try {
            this.m_inputJar.close();
            jos.close();
            fos.close();
            jos = null;
            fos = null;
        }
        catch (IOException e) {
            this.error("Cannot close the new Jar file : " + e.getMessage());
            return;
        }
    }

    private void manipulateDirectory() {
        this.manipulateComponents();
        this.m_referredPackages = this.getReferredPackages();
        Manifest mf = this.doManifest();
        if (mf == null) {
            this.error("Cannot found input manifest");
            return;
        }
        for (Map.Entry entry : this.m_classes.entrySet()) {
            String classname = (String)entry.getKey();
            byte[] clazz = (byte[])entry.getValue();
            File classFile = new File(this.m_dir, classname);
            try {
                this.setBytecode(classFile, clazz);
            }
            catch (IOException e) {
                this.error("Cannot manipulate the file : the output file " + classname + " is not found");
                return;
            }
        }
        try {
            this.writeManifest(mf);
        }
        catch (IOException e) {
            this.error("Cannot write the manifest file : " + e.getMessage());
        }
    }

    private void manipulateComponents() {
        if (!this.m_ignoreAnnotations) {
            Enumeration entries = this.getClassFiles();
            while (entries.hasMoreElements()) {
                String curName = (String)entries.nextElement();
                try {
                    byte[] in = this.getBytecode(curName);
                    if (in != null || in.length > 0) {
                        this.computeAnnotations(in);
                        continue;
                    }
                    this.error("Cannot compute annotations from " + curName + " : Empty file");
                }
                catch (IOException e) {
                    this.error("Cannot read the class : " + curName);
                    return;
                }
            }
        }
        for (int i = 0; i < this.m_components.size(); ++i) {
            ComponentInfo info = (ComponentInfo)this.m_components.get(i);
            if (info.m_bytecode == null) {
                try {
                    info.m_bytecode = this.getBytecode(info.m_classname);
                }
                catch (IOException e) {
                    this.error("Cannot extract bytecode for component '" + info.m_classname + "'");
                    return;
                }
            }
            byte[] outClazz = this.manipulateComponent(info.m_bytecode, info);
            this.m_classes.put(info.m_classname, outClazz);
            if (info.m_inners.isEmpty()) continue;
            for (int k = 0; k < info.m_inners.size(); ++k) {
                String innerCN = (String)info.m_inners.get(k) + ".class";
                try {
                    byte[] innerClassBytecode = this.getBytecode(innerCN);
                    this.manipulateInnerClass(innerClassBytecode, innerCN, info);
                    continue;
                }
                catch (IOException e) {
                    this.error("Cannot manipulate inner class '" + innerCN + "'");
                    return;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] getBytecode(String classname) throws IOException {
        InputStream currIn = null;
        byte[] in = new byte[]{};
        try {
            int c;
            currIn = this.getInputStream(classname);
            while ((c = currIn.read()) >= 0) {
                byte[] in2 = new byte[in.length + 1];
                System.arraycopy(in, 0, in2, 0, in.length);
                in2[in.length] = (byte)c;
                in = in2;
            }
        }
        finally {
            if (currIn != null) {
                try {
                    currIn.close();
                }
                catch (IOException e) {}
            }
        }
        return in;
    }

    protected InputStream getInputStream(String classname) throws IOException {
        if (this.m_inputJar != null) {
            JarEntry je;
            if (!classname.endsWith(".class")) {
                classname = classname + ".class";
            }
            if ((je = this.m_inputJar.getJarEntry(classname)) == null && (je = this.m_inputJar.getJarEntry("WEB-INF/classes/" + classname)) == null) {
                throw new IOException("The class " + classname + " connot be found in the input Jar file");
            }
            return this.m_inputJar.getInputStream(je);
        }
        File file = new File(this.m_dir, classname);
        return new FileInputStream(file);
    }

    private Enumeration getClassFiles() {
        Vector<String> files = new Vector<String>();
        if (this.m_inputJar != null) {
            Enumeration<JarEntry> enumeration = this.m_inputJar.entries();
            while (enumeration.hasMoreElements()) {
                JarEntry je = enumeration.nextElement();
                if (!je.getName().endsWith(".class")) continue;
                files.add(je.getName());
            }
        } else {
            this.searchClassFiles(this.m_dir, files);
        }
        return files.elements();
    }

    protected void searchClassFiles(File dir, List classes) {
        File[] files = dir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                this.searchClassFiles(files[i], classes);
                continue;
            }
            if (!files[i].getName().endsWith(".class")) continue;
            classes.add(this.computeRelativePath(files[i].getAbsolutePath()));
        }
    }

    private String computeRelativePath(String absolutePath) {
        String root = this.m_dir.getAbsolutePath();
        String path = absolutePath.substring(root.length() + 1);
        return path.replace('\\', '/');
    }

    private void manipulateInnerClass(byte[] in, String cn, ComponentInfo ci) throws IOException {
        String name = ci.m_classname.substring(0, ci.m_classname.length() - 6);
        InnerClassManipulator man = new InnerClassManipulator(name, ci.m_fields);
        byte[] out = man.manipulate(in);
        this.m_classes.put(cn, out);
    }

    private Manifest getManifest() throws IOException {
        if (this.m_inputJar != null) {
            return this.m_inputJar.getManifest();
        }
        return new Manifest(this.getManifestInputStream());
    }

    private Manifest doManifest() {
        Manifest mf = null;
        try {
            mf = this.getManifest();
        }
        catch (IOException e) {
            this.error("Cannot get the manifest : " + e.getMessage());
            return null;
        }
        Attributes att = mf.getMainAttributes();
        this.setImports(att);
        this.setPOJOMetadata(att);
        this.setCreatedBy(att);
        return mf;
    }

    private byte[] manipulateComponent(byte[] in, ComponentInfo ci) {
        Manipulator man = new Manipulator();
        try {
            byte[] out = man.manipulate(in);
            ci.detectMissingFields(man.getFields());
            ci.m_componentMetadata.addElement(man.getManipulationMetadata());
            ci.m_isManipulated = true;
            ci.m_inners = man.getInnerClasses();
            ci.m_fields = man.getFields().keySet();
            return out;
        }
        catch (IOException e) {
            this.error("Cannot manipulate the class " + ci.m_classname + " : " + e.getMessage());
            return null;
        }
    }

    private void computeDeclaredComponents() {
        ArrayList<ComponentInfo> componentClazzes = new ArrayList<ComponentInfo>();
        for (int i = 0; i < this.m_metadata.size(); ++i) {
            Element meta = (Element)this.m_metadata.get(i);
            String name = meta.getAttribute("classname");
            if (name == null) continue;
            name = name.replace('.', '/');
            name = name + ".class";
            componentClazzes.add(new ComponentInfo(name, meta));
        }
        this.m_components = componentClazzes;
    }

    private void setCreatedBy(Attributes att) {
        String prev = att.getValue("Created-By");
        if (prev == null) {
            att.putValue("Created-By", "iPOJO  1.8.0");
        } else if (prev.indexOf("iPOJO") == -1) {
            att.putValue("Created-By", prev + " & iPOJO " + IPOJO_PACKAGE_VERSION);
        }
    }

    private void setImports(Attributes att) {
        TreeMap<String, String> verCM;
        Map imports = this.parseHeader(att.getValue("Import-Package"));
        TreeMap<String, String> ver = new TreeMap<String, String>();
        ver.put("version", IPOJO_PACKAGE_VERSION);
        if (!imports.containsKey("org.apache.felix.ipojo")) {
            imports.put("org.apache.felix.ipojo", ver);
        }
        if (!imports.containsKey("org.apache.felix.ipojo.architecture")) {
            imports.put("org.apache.felix.ipojo.architecture", ver);
        }
        if (!imports.containsKey("org.osgi.service.cm")) {
            verCM = new TreeMap<String, String>();
            verCM.put("version", "1.2");
            imports.put("org.osgi.service.cm", verCM);
        }
        if (!imports.containsKey("org.osgi.service.log")) {
            verCM = new TreeMap();
            verCM.put("version", "1.3");
            imports.put("org.osgi.service.log", verCM);
        }
        for (int i = 0; i < this.m_referredPackages.size(); ++i) {
            String pack = (String)this.m_referredPackages.get(i);
            imports.put(pack, new TreeMap());
        }
        att.putValue("Import-Package", this.printClauses(imports, "resolution:"));
    }

    private void setPOJOMetadata(Attributes att) {
        StringBuffer meta = new StringBuffer();
        for (int i = 0; i < this.m_metadata.size(); ++i) {
            Element metadata = (Element)this.m_metadata.get(i);
            meta.append(this.buildManifestMetadata(metadata, new StringBuffer()));
        }
        if (meta.length() != 0) {
            att.putValue("iPOJO-Components", meta.toString());
        }
    }

    public Map parseHeader(String value) {
        char del;
        if (value == null || value.trim().length() == 0) {
            return new HashMap();
        }
        HashMap result = new HashMap();
        QuotedTokenizer qt = new QuotedTokenizer(value, ";=,");
        do {
            boolean hadAttribute = false;
            HashMap<String, String> clause = new HashMap<String, String>();
            ArrayList<String> aliases = new ArrayList<String>();
            aliases.add(qt.nextToken());
            del = qt.getSeparator();
            while (del == ';') {
                String adname = qt.nextToken();
                del = qt.getSeparator();
                if (del != '=') {
                    if (hadAttribute) {
                        throw new IllegalArgumentException("Header contains name field after attribute or directive: " + adname + " from " + value);
                    }
                    aliases.add(adname);
                    continue;
                }
                String advalue = qt.nextToken();
                clause.put(adname, advalue);
                del = qt.getSeparator();
                hadAttribute = true;
            }
            Iterator i = aliases.iterator();
            while (i.hasNext()) {
                result.put(i.next(), clause);
            }
        } while (del == ',');
        return result;
    }

    public String printClauses(Map exports, String allowedDirectives) {
        StringBuffer sb = new StringBuffer();
        String del = "";
        for (Map.Entry entry : exports.entrySet()) {
            String name = (String)entry.getKey();
            Map map = (Map)entry.getValue();
            sb.append(del);
            sb.append(name);
            for (Map.Entry entry2 : map.entrySet()) {
                boolean dirty;
                String key = (String)entry2.getKey();
                if (key.endsWith(":") && allowedDirectives.indexOf(key) < 0) continue;
                String value = (String)entry2.getValue();
                sb.append(";");
                sb.append(key);
                sb.append("=");
                boolean bl = dirty = value.indexOf(44) >= 0 || value.indexOf(59) >= 0;
                if (dirty) {
                    sb.append("\"");
                }
                sb.append(value);
                if (!dirty) continue;
                sb.append("\"");
            }
            del = ", ";
        }
        return sb.toString();
    }

    private void parseXMLMetadata(File metadataFile) {
        block6: {
            block5: {
                if (!metadataFile.isDirectory()) break block5;
                File[] files = metadataFile.listFiles();
                for (int i = 0; i < files.length; ++i) {
                    this.parseXMLMetadata(files[i]);
                }
                break block6;
            }
            if (!metadataFile.getName().endsWith(".xml")) break block6;
            try {
                InputStream stream = null;
                URL url = metadataFile.toURI().toURL();
                if (url == null) {
                    this.warn("Cannot find the metadata file : " + metadataFile.getAbsolutePath());
                    this.m_metadata = new ArrayList();
                }
                stream = url.openStream();
                this.parseXMLMetadata(stream);
            }
            catch (MalformedURLException e) {
                this.error("Cannot open the metadata input stream from " + metadataFile.getAbsolutePath() + ": " + e.getMessage());
                this.m_metadata = null;
            }
            catch (IOException e) {
                this.error("Cannot open the metadata input stream: " + metadataFile.getAbsolutePath() + ": " + e.getMessage());
                this.m_metadata = null;
            }
        }
    }

    private void parseXMLMetadata(InputStream stream) {
        Element[] meta = null;
        try {
            XMLReader parser = XMLReaderFactory.createXMLReader();
            XMLMetadataParser handler = new XMLMetadataParser();
            parser.setContentHandler(handler);
            parser.setFeature("http://xml.org/sax/features/validation", true);
            parser.setFeature("http://apache.org/xml/features/validation/schema", true);
            parser.setErrorHandler(handler);
            if (!this.m_ignoreLocalXSD) {
                parser.setEntityResolver(new SchemaResolver());
            }
            InputSource is = new InputSource(stream);
            parser.parse(is);
            meta = handler.getMetadata();
            stream.close();
        }
        catch (IOException e) {
            this.error("Cannot open the metadata input stream: " + e.getMessage());
        }
        catch (ParseException e) {
            this.error("Parsing error when parsing the XML file: " + e.getMessage());
        }
        catch (SAXParseException e) {
            this.error("Error during metadata parsing at line " + e.getLineNumber() + " : " + e.getMessage());
        }
        catch (SAXException e) {
            this.error("Parsing error when parsing (Sax Error) the XML file: " + e.getMessage());
        }
        if (meta == null || meta.length == 0) {
            this.warn("Neither component types, nor instances in the metadata");
        }
        this.m_metadata.addAll(Arrays.asList(meta));
    }

    private List getReferredPackages() {
        ArrayList<String> referred = new ArrayList<String>();
        for (int i = 0; i < this.m_metadata.size(); ++i) {
            Element[] elems = ((Element)this.m_metadata.get(i)).getElements();
            for (int j = 0; j < elems.length; ++j) {
                int last;
                String att = elems[j].getAttribute("specification");
                if (att == null || (last = att.lastIndexOf(46)) == -1) continue;
                referred.add(att.substring(0, last));
            }
        }
        return referred;
    }

    private StringBuffer buildManifestMetadata(Element element, StringBuffer actual) {
        if (this.isInjectedElement(element)) {
            return actual;
        }
        StringBuffer result = new StringBuffer();
        if (element.getNameSpace() == null) {
            result.append(actual + element.getName() + " { ");
        } else {
            result.append(actual + element.getNameSpace() + ":" + element.getName() + " { ");
        }
        Attribute[] atts = element.getAttributes();
        for (int i = 0; i < atts.length; ++i) {
            Attribute current = atts[i];
            if (current.getNameSpace() == null) {
                result.append("$" + current.getName() + "=\"" + current.getValue() + "\" ");
                continue;
            }
            result.append("$" + current.getNameSpace() + ":" + current.getName() + "=\"" + current.getValue() + "\" ");
        }
        Element[] elems = element.getElements();
        for (int i = 0; i < elems.length; ++i) {
            result = this.buildManifestMetadata(elems[i], result);
        }
        result.append("}");
        return result;
    }

    private boolean isInjectedElement(Element element) {
        Attribute[] atts = element.getAttributes();
        if (this.m_manifestAttributeFilters == null) {
            return false;
        }
        for (int i = 0; i < atts.length; ++i) {
            String value = atts[i].getValue();
            if (value.startsWith("__") || value.contains("org.apache.felix.ipojo.InstanceManager") || value.contains("_setInstanceManager")) {
                return true;
            }
            for (ManifestAttributeFilter filter : this.m_manifestAttributeFilters) {
                if (!filter.accept(atts[i])) continue;
                return true;
            }
        }
        return false;
    }

    public void addManifestAttributeFilters(ManifestAttributeFilter filter) {
        if (filter != null) {
            this.m_manifestAttributeFilters.add(filter);
        }
    }

    protected void writeManifest(Manifest mf) throws IOException {
        if (this.m_manifest == null) {
            this.m_manifest = new File(this.m_dir, "META-INF/MANIFEST.MF");
            if (!this.m_manifest.exists()) {
                throw new IOException("Cannot find the manifest file : " + this.m_manifest.getAbsolutePath());
            }
        } else if (!this.m_manifest.exists()) {
            throw new IOException("Cannot find the manifest file : " + this.m_manifest.getAbsolutePath());
        }
        mf.write(new FileOutputStream(this.m_manifest));
    }

    protected InputStream getManifestInputStream() throws IOException {
        if (this.m_manifest == null) {
            File manFile = new File(this.m_dir, "META-INF/MANIFEST.MF");
            if (manFile.exists()) {
                return new FileInputStream(manFile);
            }
            throw new IOException("Cannot find the manifest file : " + manFile.getAbsolutePath());
        }
        if (this.m_manifest.exists()) {
            return new FileInputStream(this.m_manifest);
        }
        throw new IOException("Cannot find the manifest file : " + this.m_manifest.getAbsolutePath());
    }

    protected void setBytecode(File classFile, byte[] rawClass) throws IOException {
        FileOutputStream os = new FileOutputStream(classFile);
        ((OutputStream)os).write(rawClass);
        ((OutputStream)os).close();
    }

    public List getWarnings() {
        return this.m_warnings;
    }

    private class ComponentInfo {
        Element m_componentMetadata;
        String m_classname;
        boolean m_isManipulated;
        List m_inners;
        Set m_fields;
        byte[] m_bytecode;

        ComponentInfo(String cn, Element met) {
            this.m_classname = cn;
            this.m_componentMetadata = met;
            this.m_isManipulated = false;
        }

        void detectMissingFields(Map fields) {
            ArrayList list = new ArrayList();
            this.computeReferredFields(list, this.m_componentMetadata);
            for (int i = 0; i < list.size(); ++i) {
                if (fields.containsKey(list.get(i))) continue;
                Pojoization.this.error("The field " + list.get(i) + " is referenced in the " + "metadata but does not exist in the " + this.m_classname + " class");
            }
        }

        private void computeReferredFields(List list, Element metadata) {
            String field = metadata.getAttribute("field");
            if (field != null && !list.contains(field)) {
                list.add(field);
            }
            for (int i = 0; i < metadata.getElements().length; ++i) {
                this.computeReferredFields(list, metadata.getElements()[i]);
            }
        }
    }
}

