/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.ajp;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.security.NoSuchProviderException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.coyote.AbstractProcessor;
import org.apache.coyote.ActionCode;
import org.apache.coyote.AsyncContextCallback;
import org.apache.coyote.Constants;
import org.apache.coyote.InputBuffer;
import org.apache.coyote.OutputBuffer;
import org.apache.coyote.Request;
import org.apache.coyote.RequestInfo;
import org.apache.coyote.Response;
import org.apache.coyote.ajp.AjpMessage;
import org.apache.coyote.http11.upgrade.UpgradeInbound;
import org.apache.juli.logging.Log;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.buf.HexUtils;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.http.HttpMessages;
import org.apache.tomcat.util.http.MimeHeaders;
import org.apache.tomcat.util.net.AbstractEndpoint;
import org.apache.tomcat.util.net.SSLSupport;
import org.apache.tomcat.util.net.SocketStatus;
import org.apache.tomcat.util.res.StringManager;

public abstract class AbstractAjpProcessor<S>
extends AbstractProcessor<S> {
    protected static final StringManager sm = StringManager.getManager("org.apache.coyote.ajp");
    protected static final byte[] endMessageArray;
    protected static final byte[] endAndCloseMessageArray;
    protected static final byte[] flushMessageArray;
    protected static final byte[] pongMessageArray;
    protected final byte[] getBodyMessageArray;
    protected int packetSize;
    protected AjpMessage requestHeaderMessage = null;
    protected AjpMessage responseMessage = null;
    protected AjpMessage bodyMessage = null;
    protected MessageBytes bodyBytes = MessageBytes.newInstance();
    protected boolean error = false;
    protected char[] hostNameC = new char[0];
    protected MessageBytes tmpMB = MessageBytes.newInstance();
    protected MessageBytes certificates = MessageBytes.newInstance();
    protected boolean endOfStream = false;
    protected boolean empty = true;
    protected boolean first = true;
    protected boolean replay = false;
    protected boolean finished = false;
    protected long bytesWritten = 0L;
    protected int keepAliveTimeout = -1;
    protected boolean tomcatAuthentication = true;
    protected String requiredSecret = null;
    protected String clientCertProvider = null;

    protected abstract Log getLog();

    public AbstractAjpProcessor(int packetSize, AbstractEndpoint endpoint) {
        super(endpoint);
        this.packetSize = packetSize;
        this.request.setInputBuffer(new SocketInputBuffer());
        this.requestHeaderMessage = new AjpMessage(packetSize);
        this.responseMessage = new AjpMessage(packetSize);
        this.bodyMessage = new AjpMessage(packetSize);
        AjpMessage getBodyMessage = new AjpMessage(16);
        getBodyMessage.reset();
        getBodyMessage.appendByte(6);
        getBodyMessage.appendInt(8186 + packetSize - 8192);
        getBodyMessage.end();
        this.getBodyMessageArray = new byte[getBodyMessage.getLen()];
        System.arraycopy(getBodyMessage.getBuffer(), 0, this.getBodyMessageArray, 0, getBodyMessage.getLen());
    }

    public int getKeepAliveTimeout() {
        return this.keepAliveTimeout;
    }

    public void setKeepAliveTimeout(int timeout) {
        this.keepAliveTimeout = timeout;
    }

    public boolean getTomcatAuthentication() {
        return this.tomcatAuthentication;
    }

    public void setTomcatAuthentication(boolean tomcatAuthentication) {
        this.tomcatAuthentication = tomcatAuthentication;
    }

    public void setRequiredSecret(String requiredSecret) {
        this.requiredSecret = requiredSecret;
    }

    public String getClientCertProvider() {
        return this.clientCertProvider;
    }

    public void setClientCertProvider(String s) {
        this.clientCertProvider = s;
    }

    @Override
    public final void action(ActionCode actionCode, Object param) {
        if (actionCode == ActionCode.COMMIT) {
            if (this.response.isCommitted()) {
                return;
            }
            try {
                this.prepareResponse();
            }
            catch (IOException e) {
                this.error = true;
            }
            try {
                this.flush(false);
            }
            catch (IOException e) {
                this.error = true;
            }
        } else if (actionCode == ActionCode.CLIENT_FLUSH) {
            if (!this.response.isCommitted()) {
                try {
                    this.prepareResponse();
                }
                catch (IOException e) {
                    this.error = true;
                    return;
                }
            }
            try {
                this.flush(true);
            }
            catch (IOException e) {
                this.error = true;
            }
        } else if (actionCode == ActionCode.DISABLE_SWALLOW_INPUT) {
            this.error = true;
        } else if (actionCode == ActionCode.CLOSE) {
            try {
                this.finish();
            }
            catch (IOException e) {
                this.error = true;
            }
        } else if (actionCode == ActionCode.REQ_SSL_ATTRIBUTE) {
            if (!this.certificates.isNull()) {
                ByteChunk certData = this.certificates.getByteChunk();
                X509Certificate[] jsseCerts = null;
                ByteArrayInputStream bais = new ByteArrayInputStream(certData.getBytes(), certData.getStart(), certData.getLength());
                try {
                    CertificateFactory cf = this.clientCertProvider == null ? CertificateFactory.getInstance("X.509") : CertificateFactory.getInstance("X.509", this.clientCertProvider);
                    while (bais.available() > 0) {
                        X509Certificate cert = (X509Certificate)cf.generateCertificate(bais);
                        if (jsseCerts == null) {
                            jsseCerts = new X509Certificate[]{cert};
                            continue;
                        }
                        X509Certificate[] temp = new X509Certificate[jsseCerts.length + 1];
                        System.arraycopy(jsseCerts, 0, temp, 0, jsseCerts.length);
                        temp[jsseCerts.length] = cert;
                        jsseCerts = temp;
                    }
                }
                catch (CertificateException e) {
                    this.getLog().error(sm.getString("ajpprocessor.certs.fail"), e);
                    return;
                }
                catch (NoSuchProviderException e) {
                    this.getLog().error(sm.getString("ajpprocessor.certs.fail"), e);
                    return;
                }
                this.request.setAttribute("javax.servlet.request.X509Certificate", jsseCerts);
            }
        } else if (actionCode == ActionCode.REQ_HOST_ATTRIBUTE) {
            if (this.request.remoteHost().isNull()) {
                try {
                    this.request.remoteHost().setString(InetAddress.getByName(this.request.remoteAddr().toString()).getHostName());
                }
                catch (IOException iex) {}
            }
        } else if (actionCode == ActionCode.REQ_LOCAL_ADDR_ATTRIBUTE) {
            this.request.localAddr().setString(this.request.localName().toString());
        } else if (actionCode == ActionCode.REQ_SET_BODY_REPLAY) {
            ByteChunk bc = (ByteChunk)param;
            int length = bc.getLength();
            this.bodyBytes.setBytes(bc.getBytes(), bc.getStart(), length);
            this.request.setContentLength(length);
            this.first = false;
            this.empty = false;
            this.replay = true;
            this.endOfStream = false;
        } else if (actionCode == ActionCode.ASYNC_START) {
            this.asyncStateMachine.asyncStart((AsyncContextCallback)param);
        } else if (actionCode == ActionCode.ASYNC_DISPATCHED) {
            this.asyncStateMachine.asyncDispatched();
        } else if (actionCode == ActionCode.ASYNC_TIMEOUT) {
            AtomicBoolean result = (AtomicBoolean)param;
            result.set(this.asyncStateMachine.asyncTimeout());
        } else if (actionCode == ActionCode.ASYNC_RUN) {
            this.asyncStateMachine.asyncRun((Runnable)param);
        } else if (actionCode == ActionCode.ASYNC_ERROR) {
            this.asyncStateMachine.asyncError();
        } else if (actionCode == ActionCode.ASYNC_IS_STARTED) {
            ((AtomicBoolean)param).set(this.asyncStateMachine.isAsyncStarted());
        } else if (actionCode == ActionCode.ASYNC_IS_DISPATCHING) {
            ((AtomicBoolean)param).set(this.asyncStateMachine.isAsyncDispatching());
        } else if (actionCode == ActionCode.ASYNC_IS_ASYNC) {
            ((AtomicBoolean)param).set(this.asyncStateMachine.isAsync());
        } else if (actionCode == ActionCode.ASYNC_IS_TIMINGOUT) {
            ((AtomicBoolean)param).set(this.asyncStateMachine.isAsyncTimingOut());
        } else if (actionCode != ActionCode.UPGRADE) {
            this.actionInternal(actionCode, param);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AbstractEndpoint.Handler.SocketState asyncDispatch(SocketStatus status) {
        RequestInfo rp = this.request.getRequestProcessor();
        try {
            rp.setStage(3);
            this.error = !this.adapter.asyncDispatch(this.request, this.response, status);
        }
        catch (InterruptedIOException e) {
            this.error = true;
        }
        catch (Throwable t) {
            ExceptionUtils.handleThrowable(t);
            this.getLog().error(sm.getString("http11processor.request.process"), t);
            this.error = true;
        }
        finally {
            if (this.error) {
                this.response.setStatus(500);
                this.adapter.log(this.request, this.response, 0L);
            }
        }
        rp.setStage(7);
        if (this.isAsync()) {
            if (this.error) {
                this.request.updateCounters();
                return AbstractEndpoint.Handler.SocketState.CLOSED;
            }
            return AbstractEndpoint.Handler.SocketState.LONG;
        }
        this.request.updateCounters();
        if (this.error) {
            return AbstractEndpoint.Handler.SocketState.CLOSED;
        }
        return AbstractEndpoint.Handler.SocketState.OPEN;
    }

    @Override
    public void setSslSupport(SSLSupport sslSupport) {
        throw new IllegalStateException(sm.getString("ajpprocessor.ssl.notsupported"));
    }

    @Override
    public AbstractEndpoint.Handler.SocketState event(SocketStatus status) throws IOException {
        throw new IOException(sm.getString("ajpprocessor.comet.notsupported"));
    }

    @Override
    public AbstractEndpoint.Handler.SocketState upgradeDispatch() throws IOException {
        throw new IOException(sm.getString("ajpprocessor.httpupgrade.notsupported"));
    }

    @Override
    public UpgradeInbound getUpgradeInbound() {
        throw new IllegalStateException(sm.getString("ajpprocessor.httpupgrade.notsupported"));
    }

    @Override
    public void recycle(boolean socketClosing) {
        this.asyncStateMachine.recycle();
        this.first = true;
        this.endOfStream = false;
        this.empty = true;
        this.replay = false;
        this.finished = false;
        this.request.recycle();
        this.response.recycle();
        this.certificates.recycle();
        this.bytesWritten = 0L;
    }

    protected abstract void actionInternal(ActionCode var1, Object var2);

    protected abstract void output(byte[] var1, int var2, int var3) throws IOException;

    protected abstract boolean receive() throws IOException;

    @Override
    public final boolean isComet() {
        return false;
    }

    @Override
    public final boolean isUpgrade() {
        return false;
    }

    protected boolean refillReadBuffer() throws IOException {
        if (this.replay) {
            this.endOfStream = true;
        }
        if (this.endOfStream) {
            return false;
        }
        this.output(this.getBodyMessageArray, 0, this.getBodyMessageArray.length);
        boolean moreData = this.receive();
        if (!moreData) {
            this.endOfStream = true;
        }
        return moreData;
    }

    protected void prepareRequest() {
        ByteChunk uriBC;
        byte attributeCode;
        boolean isSSL;
        byte methodCode = this.requestHeaderMessage.getByte();
        if (methodCode != -1) {
            String methodName = org.apache.coyote.ajp.Constants.getMethodForCode(methodCode - 1);
            this.request.method().setString(methodName);
        }
        this.requestHeaderMessage.getBytes(this.request.protocol());
        this.requestHeaderMessage.getBytes(this.request.requestURI());
        this.requestHeaderMessage.getBytes(this.request.remoteAddr());
        this.requestHeaderMessage.getBytes(this.request.remoteHost());
        this.requestHeaderMessage.getBytes(this.request.localName());
        this.request.setLocalPort(this.requestHeaderMessage.getInt());
        boolean bl = isSSL = this.requestHeaderMessage.getByte() != 0;
        if (isSSL) {
            this.request.scheme().setString("https");
        }
        MimeHeaders headers = this.request.getMimeHeaders();
        int hCount = this.requestHeaderMessage.getInt();
        for (int i = 0; i < hCount; ++i) {
            String hName = null;
            int isc = this.requestHeaderMessage.peekInt();
            int hId = isc & 0xFF;
            MessageBytes vMB = null;
            if (40960 == (isc &= 0xFF00)) {
                this.requestHeaderMessage.getInt();
                hName = org.apache.coyote.ajp.Constants.getHeaderForCode(hId - 1);
                vMB = headers.addValue(hName);
            } else {
                hId = -1;
                this.requestHeaderMessage.getBytes(this.tmpMB);
                ByteChunk bc = this.tmpMB.getByteChunk();
                vMB = headers.addValue(bc.getBuffer(), bc.getStart(), bc.getLength());
            }
            this.requestHeaderMessage.getBytes(vMB);
            if (hId == 8 || hId == -1 && this.tmpMB.equalsIgnoreCase("Content-Length")) {
                long cl = vMB.getLong();
                if (cl >= Integer.MAX_VALUE) continue;
                this.request.setContentLength((int)cl);
                continue;
            }
            if (hId != 7 && (hId != -1 || !this.tmpMB.equalsIgnoreCase("Content-Type"))) continue;
            ByteChunk bchunk = vMB.getByteChunk();
            this.request.contentType().setBytes(bchunk.getBytes(), bchunk.getOffset(), bchunk.getLength());
        }
        boolean secret = false;
        while ((attributeCode = this.requestHeaderMessage.getByte()) != -1) {
            switch (attributeCode) {
                case 10: {
                    this.requestHeaderMessage.getBytes(this.tmpMB);
                    String n = this.tmpMB.toString();
                    this.requestHeaderMessage.getBytes(this.tmpMB);
                    String v = this.tmpMB.toString();
                    if (n.equals("AJP_REMOTE_PORT")) {
                        try {
                            this.request.setRemotePort(Integer.parseInt(v));
                        }
                        catch (NumberFormatException nfe) {}
                        break;
                    }
                    this.request.setAttribute(n, v);
                    break;
                }
                case 1: {
                    this.requestHeaderMessage.getBytes(this.tmpMB);
                    break;
                }
                case 2: {
                    this.requestHeaderMessage.getBytes(this.tmpMB);
                    break;
                }
                case 3: {
                    if (this.tomcatAuthentication) {
                        this.requestHeaderMessage.getBytes(this.tmpMB);
                        break;
                    }
                    this.requestHeaderMessage.getBytes(this.request.getRemoteUser());
                    break;
                }
                case 4: {
                    if (this.tomcatAuthentication) {
                        this.requestHeaderMessage.getBytes(this.tmpMB);
                        break;
                    }
                    this.requestHeaderMessage.getBytes(this.request.getAuthType());
                    break;
                }
                case 5: {
                    this.requestHeaderMessage.getBytes(this.request.queryString());
                    break;
                }
                case 6: {
                    this.requestHeaderMessage.getBytes(this.request.instanceId());
                    break;
                }
                case 7: {
                    this.request.scheme().setString("https");
                    this.requestHeaderMessage.getBytes(this.certificates);
                    break;
                }
                case 8: {
                    this.request.scheme().setString("https");
                    this.requestHeaderMessage.getBytes(this.tmpMB);
                    this.request.setAttribute("javax.servlet.request.cipher_suite", this.tmpMB.toString());
                    break;
                }
                case 9: {
                    this.request.scheme().setString("https");
                    this.requestHeaderMessage.getBytes(this.tmpMB);
                    this.request.setAttribute("javax.servlet.request.ssl_session_id", this.tmpMB.toString());
                    break;
                }
                case 11: {
                    this.request.setAttribute("javax.servlet.request.key_size", this.requestHeaderMessage.getInt());
                    break;
                }
                case 13: {
                    this.requestHeaderMessage.getBytes(this.request.method());
                    break;
                }
                case 12: {
                    this.requestHeaderMessage.getBytes(this.tmpMB);
                    if (this.requiredSecret == null) break;
                    secret = true;
                    if (this.tmpMB.equals(this.requiredSecret)) break;
                    this.response.setStatus(403);
                    this.error = true;
                    break;
                }
            }
        }
        if (this.requiredSecret != null && !secret) {
            this.response.setStatus(403);
            this.error = true;
        }
        if ((uriBC = this.request.requestURI().getByteChunk()).startsWithIgnoreCase("http", 0)) {
            int pos = uriBC.indexOf("://", 0, 3, 4);
            int uriBCStart = uriBC.getStart();
            int slashPos = -1;
            if (pos != -1) {
                byte[] uriB = uriBC.getBytes();
                slashPos = uriBC.indexOf('/', pos + 3);
                if (slashPos == -1) {
                    slashPos = uriBC.getLength();
                    this.request.requestURI().setBytes(uriB, uriBCStart + pos + 1, 1);
                } else {
                    this.request.requestURI().setBytes(uriB, uriBCStart + slashPos, uriBC.getLength() - slashPos);
                }
                MessageBytes hostMB = headers.setValue("host");
                hostMB.setBytes(uriB, uriBCStart + pos + 3, slashPos - pos - 3);
            }
        }
        MessageBytes valueMB = this.request.getMimeHeaders().getValue("host");
        this.parseHost(valueMB);
        if (this.error) {
            this.adapter.log(this.request, this.response, 0L);
        }
    }

    protected void parseHost(MessageBytes valueMB) {
        if (valueMB == null || valueMB.isNull()) {
            this.request.setServerPort(this.request.getLocalPort());
            try {
                this.request.serverName().duplicate(this.request.localName());
            }
            catch (IOException e) {
                this.response.setStatus(400);
                this.error = true;
            }
            return;
        }
        ByteChunk valueBC = valueMB.getByteChunk();
        byte[] valueB = valueBC.getBytes();
        int valueL = valueBC.getLength();
        int valueS = valueBC.getStart();
        int colonPos = -1;
        if (this.hostNameC.length < valueL) {
            this.hostNameC = new char[valueL];
        }
        boolean ipv6 = valueB[valueS] == 91;
        boolean bracketClosed = false;
        for (int i = 0; i < valueL; ++i) {
            char b;
            this.hostNameC[i] = b = (char)valueB[i + valueS];
            if (b == ']') {
                bracketClosed = true;
                continue;
            }
            if (b != ':' || ipv6 && !bracketClosed) continue;
            colonPos = i;
            break;
        }
        if (colonPos < 0) {
            if (this.request.scheme().equalsIgnoreCase("https")) {
                this.request.setServerPort(443);
            } else {
                this.request.setServerPort(80);
            }
            this.request.serverName().setChars(this.hostNameC, 0, valueL);
        } else {
            this.request.serverName().setChars(this.hostNameC, 0, colonPos);
            int port = 0;
            int mult = 1;
            for (int i = valueL - 1; i > colonPos; --i) {
                int charValue = HexUtils.getDec(valueB[i + valueS]);
                if (charValue == -1) {
                    this.error = true;
                    this.response.setStatus(400);
                    break;
                }
                port += charValue * mult;
                mult = 10 * mult;
            }
            this.request.setServerPort(port);
        }
    }

    protected void prepareResponse() throws IOException {
        long contentLength;
        String contentLanguage;
        this.response.setCommitted(true);
        this.responseMessage.reset();
        this.responseMessage.appendByte(4);
        this.responseMessage.appendInt(this.response.getStatus());
        String message = null;
        if (Constants.USE_CUSTOM_STATUS_MSG_IN_HEADER && HttpMessages.isSafeInHttpHeader(this.response.getMessage())) {
            message = this.response.getMessage();
        }
        if (message == null) {
            message = HttpMessages.getMessage(this.response.getStatus());
        }
        if (message == null) {
            message = Integer.toString(this.response.getStatus());
        }
        this.tmpMB.setString(message);
        this.responseMessage.appendBytes(this.tmpMB);
        MimeHeaders headers = this.response.getMimeHeaders();
        String contentType = this.response.getContentType();
        if (contentType != null) {
            headers.setValue("Content-Type").setString(contentType);
        }
        if ((contentLanguage = this.response.getContentLanguage()) != null) {
            headers.setValue("Content-Language").setString(contentLanguage);
        }
        if ((contentLength = this.response.getContentLengthLong()) >= 0L) {
            headers.setValue("Content-Length").setLong(contentLength);
        }
        int numHeaders = headers.size();
        this.responseMessage.appendInt(numHeaders);
        for (int i = 0; i < numHeaders; ++i) {
            MessageBytes hN = headers.getName(i);
            int hC = org.apache.coyote.ajp.Constants.getResponseAjpIndex(hN.toString());
            if (hC > 0) {
                this.responseMessage.appendInt(hC);
            } else {
                this.responseMessage.appendBytes(hN);
            }
            MessageBytes hV = headers.getValue(i);
            this.responseMessage.appendBytes(hV);
        }
        this.responseMessage.end();
        this.output(this.responseMessage.getBuffer(), 0, this.responseMessage.getLen());
    }

    protected void flush(boolean explicit) throws IOException {
        if (explicit && !this.finished) {
            this.output(flushMessageArray, 0, flushMessageArray.length);
        }
    }

    protected void finish() throws IOException {
        if (!this.response.isCommitted()) {
            try {
                this.prepareResponse();
            }
            catch (IOException e) {
                this.error = true;
            }
        }
        if (this.finished) {
            return;
        }
        this.finished = true;
        if (this.first && this.request.getContentLengthLong() > 0L) {
            this.receive();
        }
        if (this.error) {
            this.output(endAndCloseMessageArray, 0, endAndCloseMessageArray.length);
        } else {
            this.output(endMessageArray, 0, endMessageArray.length);
        }
    }

    static {
        AjpMessage endMessage = new AjpMessage(16);
        endMessage.reset();
        endMessage.appendByte(5);
        endMessage.appendByte(1);
        endMessage.end();
        endMessageArray = new byte[endMessage.getLen()];
        System.arraycopy(endMessage.getBuffer(), 0, endMessageArray, 0, endMessage.getLen());
        AjpMessage endAndCloseMessage = new AjpMessage(16);
        endAndCloseMessage.reset();
        endAndCloseMessage.appendByte(5);
        endAndCloseMessage.appendByte(0);
        endAndCloseMessage.end();
        endAndCloseMessageArray = new byte[endAndCloseMessage.getLen()];
        System.arraycopy(endAndCloseMessage.getBuffer(), 0, endAndCloseMessageArray, 0, endAndCloseMessage.getLen());
        AjpMessage flushMessage = new AjpMessage(16);
        flushMessage.reset();
        flushMessage.appendByte(3);
        flushMessage.appendInt(0);
        flushMessage.appendByte(0);
        flushMessage.end();
        flushMessageArray = new byte[flushMessage.getLen()];
        System.arraycopy(flushMessage.getBuffer(), 0, flushMessageArray, 0, flushMessage.getLen());
        AjpMessage pongMessage = new AjpMessage(16);
        pongMessage.reset();
        pongMessage.appendByte(9);
        pongMessage.end();
        pongMessageArray = new byte[pongMessage.getLen()];
        System.arraycopy(pongMessage.getBuffer(), 0, pongMessageArray, 0, pongMessage.getLen());
    }

    protected class SocketOutputBuffer
    implements OutputBuffer {
        protected SocketOutputBuffer() {
        }

        @Override
        public int doWrite(ByteChunk chunk, Response res) throws IOException {
            if (!AbstractAjpProcessor.this.response.isCommitted()) {
                try {
                    AbstractAjpProcessor.this.prepareResponse();
                }
                catch (IOException e) {
                    AbstractAjpProcessor.this.error = true;
                }
            }
            int len = chunk.getLength();
            int chunkSize = 8184 + AbstractAjpProcessor.this.packetSize - 8192;
            int off = 0;
            while (len > 0) {
                int thisTime = len;
                if (thisTime > chunkSize) {
                    thisTime = chunkSize;
                }
                len -= thisTime;
                AbstractAjpProcessor.this.responseMessage.reset();
                AbstractAjpProcessor.this.responseMessage.appendByte(3);
                AbstractAjpProcessor.this.responseMessage.appendBytes(chunk.getBytes(), chunk.getOffset() + off, thisTime);
                AbstractAjpProcessor.this.responseMessage.end();
                AbstractAjpProcessor.this.output(AbstractAjpProcessor.this.responseMessage.getBuffer(), 0, AbstractAjpProcessor.this.responseMessage.getLen());
                off += thisTime;
            }
            AbstractAjpProcessor.this.bytesWritten += (long)chunk.getLength();
            return chunk.getLength();
        }

        @Override
        public long getBytesWritten() {
            return AbstractAjpProcessor.this.bytesWritten;
        }
    }

    protected class SocketInputBuffer
    implements InputBuffer {
        protected SocketInputBuffer() {
        }

        @Override
        public int doRead(ByteChunk chunk, Request req) throws IOException {
            if (AbstractAjpProcessor.this.endOfStream) {
                return -1;
            }
            if (AbstractAjpProcessor.this.first && req.getContentLengthLong() > 0L) {
                if (!AbstractAjpProcessor.this.receive()) {
                    return 0;
                }
            } else if (AbstractAjpProcessor.this.empty && !AbstractAjpProcessor.this.refillReadBuffer()) {
                return -1;
            }
            ByteChunk bc = AbstractAjpProcessor.this.bodyBytes.getByteChunk();
            chunk.setBytes(bc.getBuffer(), bc.getStart(), bc.getLength());
            AbstractAjpProcessor.this.empty = true;
            return chunk.getLength();
        }
    }
}

